<?php

class StatusRemappingService
{

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['DeliveryDocumentModel','order_details']);
    }

    public function getCustomStatusesByCarrierName(string $carrierName, string $companyCode): array
    {
        $customStatuses = $this->ci->DeliveryDocumentModel->getCustomStatuses($carrierName, 'Edi name level', $companyCode);
        foreach ($customStatuses as $eachStatusRow) {
            $statuses[$eachStatusRow['status_code']] = $eachStatusRow['status_name'];
        }
        return $statuses ?? [];
    }

    public function remapStatuses(array $actualStatuses, array $customStatuses): array
    {
        for ($i = 0; $i < count($actualStatuses); $i++) {
            if (isset($customStatuses[$actualStatuses[$i]['status_code']])) {
                $actualStatuses[$i]['status_name'] = $customStatuses[$actualStatuses[$i]['status_code']];
            }
        }
        return $actualStatuses;
    }

    public function getOrderStatuses(array $orderData): array
    {
        $orderRowId = $orderData['orderRowId'] ?? "0";
        $actualStatuses = $this->ci->order_details->getOrderStatuses($orderData['timeZone'],$orderData['bookingId'],$orderData['shiftId'],$orderRowId,$orderData['companyCode']);
        $actualStatuses = $this->getCompanySpecificOrderStatuses($actualStatuses, $orderData['companyCode']);
        if($orderData['carrierName'] != "" && !empty($actualStatuses)){
            $customStatusesByCarrierName = $this->getCustomStatusesByCarrierName($orderData['carrierName'], $orderData['companyCode']);
            if(!empty($customStatusesByCarrierName)){
                $remappedStatuses = $this->remapStatuses($actualStatuses,$customStatusesByCarrierName);
            }
        }
        return $remappedStatuses ?? $actualStatuses;
    }

    public function getCompanySpecificOrderStatuses(array $actualStatuses, string $companyCode): array
    {
        if(empty($actualStatuses)){
            return [];
        }
        if (checkAccessConditions('RELATED_2_NZPG', $companyCode)) {
            foreach ($actualStatuses as $eachRow){
                if(in_array($eachRow['status_code'],['0100','0212','0500','0191','1550','0192','2300','3000'])){
                    $newActualStatuses[] = $eachRow;
                }
            }
        }
        return $newActualStatuses ?? $actualStatuses;
    }
    public function getnewOrderStatuses(array $orderData): array
    {
        $orderRowId = $orderData['orderRowId'] ?? "0";
        $actualStatuses = $this->ci->CustomerOrder->getOrderStatuses($orderData['timeZone'],$orderData['bookingId'],$orderData['shiftId'],$orderRowId,$orderData['companyCode']);
        $actualStatuses = $this->getCompanySpecificOrderStatuses($actualStatuses, $orderData['companyCode']);
        if($orderData['carrierName'] != "" && !empty($actualStatuses)){
            $customStatusesByCarrierName = $this->getCustomStatusesByCarrierName($orderData['carrierName'], $orderData['companyCode']);
            if(!empty($customStatusesByCarrierName)){
                $remappedStatuses = $this->remapStatuses($actualStatuses,$customStatusesByCarrierName);
            }
        }
        return $remappedStatuses ?? $actualStatuses;
    }

}
