<?php

use phpseclib\Net\SFTP;

class Tollcarrieredi
{
    private $knownPackageTypes = [];
    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper("cleanstr_helper");
    }

    public function shipmentdata(int $id): string
    {
        if (!$id) {
            return "Wrong ID";
        }
        $ordersdetails = $this->getOrdersDetails($id);
        foreach ($ordersdetails as $orders) {
            $sender_xml = $this->generatorTollXML($orders);
            if (empty($sender_xml)) {
                self::throwException('TOLL xml generation is failed, with following information' . json_encode($sender_xml));
            }
            $this->publishCronjobxml($sender_xml, $orders['order_id']);
            //$this->publishxml($sender_xml, $orders['order_id']);
        }
        return "Toll EDI Successfully Triggered";
    }

    private function getOrdersDetails(int $id): array
    {
        $ci = &get_instance();

        $whereCondition = ["o.shift_id" => $id];
        $whereon = "o.id=tod.order_row_id";
        $orderData = [];
        $ordersdetails = $ci->common->getjointbldata("tb_orders o", "tb_order_details tod", $whereon, $whereCondition, "o.id as orderno,o.*,tod.*", 0, 0);
        foreach ($ordersdetails as $orders) {
            $orderinfo = [];
            $orderinfo['order_id'] = "SVK" . $orders['order_id'];
            $transport_mode = $orders['transport_mode'];
            if ($transport_mode === "LTL" || $transport_mode == "") {
                $transport_mode = "LCL";
            }
            $orderinfo['transport_mode'] = $transport_mode;
            $customer_id = $orders['customer_id'];
            $whereCustomerCondition = ["tc.id" => $customer_id];
            $whereCustomeron = "tc.code=ttcp.customer_cid";
            $customer_info = $ci->common->getjointbldata("tb_customers tc", "tb_toll_customer_payercodes ttcp", $whereCustomeron, $whereCustomerCondition, "tc.code,ttcp.`payer_code`", 0, 0);
            if (count($customer_info) > 0) {
                $orderinfo['customer_id'] = $customer_info[0]['code'];
                $orderinfo['customer_payer_code'] = $customer_info[0]['payer_code'];
            }
            $orderinfo['source'] = $this->getSourceInfo($orders);
            $orderinfo['destination'] = $this->getDestinationInfo($orders);
            $orderinfo['cargos'] = $this->getOrderCargoDetails($orders['orderno']);
            $orderinfo['pickup_ins'] = $this->getOrderReferences($orders['orderno'],"ORD_PIKINST");
            $orderinfo['delivery_ins'] = $this->getOrderReferences($orders['orderno'],"ORD_DLVINST");
            $orderinfo['deliveryNote'] = $this->getOrderReferences($orders['orderno'],"DQ");
            $orderData[] = $orderinfo;
        }
        return $orderData;
    }

    private function getDestinationInfo(array $orders): array
    {
        $ci = &get_instance();
        $zonecode = $ci->session->userdata("usr_tzone");
        $curtz = $zonecode['timezone'];
        $code = "";
        $drop_partyid = $orders['drop_partyid'];
        $edelivery = getdatetimebytimezone($curtz, $orders['delivery_datetime'], DFLT_TZ);
        $early_delivery = $edelivery['datetime'];
        $ldelivery = getdatetimebytimezone($curtz, $orders['drop_endtime'], DFLT_TZ);
        $late_delivery = $ldelivery['datetime'];
        $destination = [
            "CompanyName" => $orders['delivery_company'],
            "Address1" => cleanStr($orders['delivery_address1']),
            "Address2" => cleanStr($orders['delivery_address2']),
            "Street" => cleanStr($orders['delivery_address1']),
            "City" => cleanStr($orders['delivery_city']),
            "State" => cleanStr($orders['delivery_address2']),
            "Postal" => $orders['delivery_pincode'],
            "Country" => $orders['delivery_country'],
            "CountryCode" => $code,
            "delivery_datetime" => str_replace(" ", "T", $early_delivery),
            "drop_endtime" => str_replace(" ", "T", $late_delivery)
        ];
        $drop = $ci->common->gettblrowdata(["code" => $drop_partyid], "mobile,email", "tbl_party_master", 0, 0);
        $destination["ContactNo"] = $drop['mobile'];
        $destination["EmailAddress"] = $drop['email'];
        return $destination;
    }

    private function getSourceInfo(array $orders): array
    {
        $ci = &get_instance();
        $zonecode = $ci->session->userdata("usr_tzone");
        $curtz = $zonecode['timezone'];
        $code = "";
        $pickup_custid = $orders['pickup_custid'];
        $epickup = getdatetimebytimezone($curtz, $orders['pickup_datetime'], DFLT_TZ);
        $early_pickup = $epickup['datetime'];
        $lpickup = getdatetimebytimezone($curtz, $orders['pickup_endtime'], DFLT_TZ);
        $late_pickup = $lpickup['datetime'];
        $source = [
            "CompanyName" => $orders['pickup_company'],
            "Address1" => cleanStr($orders['pickup_address1']),
            "Address2" => cleanStr($orders['pickup_address2']),
            "Street" => cleanStr($orders['pickup_address1']),
            "City" => cleanStr($orders['pickup_city']),
            "State" => cleanStr($orders['pickup_address2']),
            "Postal" => $orders['pickup_pincode'],
            "Country" => $orders['pickup_country'],
            "CountryCode" => $code,
            "pickup_datetime" => str_replace(" ", "T", $early_pickup),
            "pickup_endtime" => str_replace(" ", "T", $late_pickup)
        ];
        $pickup = $ci->common->gettblrowdata(["code" => $pickup_custid], "mobile,email", "tbl_party_master", 0, 0);
        $source["ContactNo"] = $pickup['mobile'];
        $source["EmailAddress"] = $pickup['email'];
        return $source;
    }

    private function getLocationCodes(string $state): string
    {
        $ci = &get_instance();
        $order_pickup_state = $ci->common->gettblrowdata(["etn_location_code" => $state], "carrier_location_code", "tb_toll_customer_location_codes", 0, 0);
        return $order_pickup_state['carrier_location_code'] ?? "";
    }

    private function getOrderCargoDetails(int $id): array
    {
        $ci = &get_instance();
        $cargos = [];
        $getcargos = $ci->common->gettbldata(["order_id" => $id, "status" => 1], "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content", "tb_order_cargodetails", 0, 0);
        if (count($getcargos) > 0) {
            foreach ($getcargos as $res) {
                $volume = $res['volume'];
                $weight = $res['weight'];
                if ($volume == "") {
                    $volume = 1;
                }
                if ($weight == "") {
                    $weight = 1;
                }
                $weight_unit = "KG";
                $volume_unit = "CBM";
                $tollPackageType = "";
                if ($res['quantity_type'] != "") {
                    $quantity_type = strtoupper($res['quantity_type']);
                    $tollPackageType = $this->getPackageType($quantity_type);
                }

                if ($res['cargo_id'] != "") {
                    $chk = $ci->common->gettblrowdata(["id" => $res['cargo_id']], "cargo_type,handling_unit,weight_unit,volume_unit,length_unit,width_unit,height_unit", "tb_cargo_details", 0, 0);
                    if (count($chk) > 0) {
                        if ($chk['cargo_type'] != "") {
                            $cargo_type = strtoupper($chk['cargo_type']);
                            $tollPackageType = $this->getPackageType($cargo_type);
                        }
                        if ($chk['handling_unit'] != "") {
                            $cargo_type = $chk['handling_unit'];
                            $tollPackageType = $this->getPackageType($cargo_type);
                        }
                        $weight_unit = $chk['weight_unit'];
                        $volume_unit = $chk['volume_unit'];
                        $length_unit = $chk['length_unit'];
                        $width_unit = $chk['width_unit'];
                        $height_unit = $chk['height_unit'];
                    }
                }
                $content = $res['cargo_content'];
                if ($content == "") {
                    $content = "MISCELLANEOUS";
                }
                $cargos[] = ['cargo_type' => $tollPackageType, 'content' => $content, 'length' => $res['length'], 'width' => $res['width'], 'height' => $res['height'], 'weight' => $weight, 'volume' => $volume, 'quantity' => $res['quantity'], 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit, 'length_unit' => $length_unit, 'width_unit' => $width_unit, 'height_unit' => $height_unit];
            }
        }
        if ($tollPackageType == "") {
            $cargo_type = "PCS";
        }
        return $cargos;
    }

    public function getPackageType(string $quantity_type): string
    {
        if (isset($this->knownPackageTypes[$quantity_type])) {
            return $this->knownPackageTypes[$quantity_type];
        }
        $ci = &get_instance();
        $tollPackageType = "";
        $toll_cargo_type = $ci->db->query("SELECT toll_package_type FROM tb_toll_packages_list WHERE etn_package_type = ? Limit 1", [$quantity_type]);
        foreach ($toll_cargo_type->result() as $key => $value) {
            $tollPackageType = $value->toll_package_type;
        }
        $this->knownPackageTypes[$quantity_type] = $tollPackageType;
        return $tollPackageType;
    }
    private function getOrderReferences(int $id,string $reftype): string
    {
        $ci = &get_instance();
        $orderRefs = $ci->common->gettblrowdata(["order_id" => $id, "reference_id" => $reftype, "status" => 1], "ref_value", "tb_order_references", 0, 0);
        return $orderRefs['ref_value'] ?? 'no';
    }

    private function generatorTollXML(array $data): string
    {
        $prepared = Date("Y-m-d") . "T" . Date("h:i:s");
        $messageID = random_int(0000000001, 9999999999);
        $request = '';
        $request .= "<?xml version='1.0' encoding='UTF-8'?>";
        $request .= "<Message>";
        $request .= "<MessageHeader>";
        $request .= "<SenderID>" . $data['customer_id'] . "</SenderID>";
        $request .= "<RecipientID>TTLEDI</RecipientID>";
        $request .= "<Prepared>" . $prepared . "</Prepared>";
        $request .= "<MessageID>" . $messageID . "</MessageID>";
        $request .= "<MessageType>CONNOTE</MessageType>";
        $request .= "<MessageVersion>01</MessageVersion>";
        $request .= "<ErrEmail>knnz.pact@kuehne-nagel.com</ErrEmail>";
        $request .= "</MessageHeader>";
        $request .= "<MessageBody>";
        $request .= "<ConNotes>";
        $request .= "<ConNote>";
        $request .= "<NoteNumber>" . $data['order_id'] . "</NoteNumber>";
        $request .= "<PickUpDate>" . $data['source']['pickup_datetime'] . "</PickUpDate>";
        $request .= "<ConNoteType>S</ConNoteType>";
        $request .= "<PayerCode>" . $data['customer_payer_code'] . "</PayerCode>";
        $request .= "<Party Role='ORIGIN'>";
        $request .= "<Name>" . $data['source']['CompanyName'] . "</Name>";
        $request .= "<Address1>" . $data['source']['Address1'] . "</Address1>";
        $request .= "<Address2>" . $data['source']['Address2'] . "</Address2>";
        $request .= "<Location>" . $data['source']['State'] . "</Location>";
        $request .= "<Postalcode>" . $data['source']['Postal'] . "</Postalcode>";
        $request .= "</Party>";
        $request .= "<Party Role='DESTINATION'>";
        $request .= "<Name>" . $data['destination']['CompanyName'] . "</Name>";
        $request .= "<Address1>" . $data['destination']['Address1'] . "</Address1>";
        $request .= "<Address2>" . $data['destination']['Address2'] . "</Address2>";
        $request .= "<Location>" . $data['destination']['State'] . "</Location>";
        $request .= "<Postalcode>" . $data['destination']['Postal'] . "</Postalcode>";
        $request .= "</Party>";
        $request .= "<ContractNo />";
        $request .= "<ServiceType>DD</ServiceType>";
        $request .= "<BranchType>D</BranchType>";
        $request .= "<CartageType>" . $data['transport_mode'] . "</CartageType>";
        $request .= "<Insurance>LCR</Insurance>";
        $request .= "<DeclaredValue></DeclaredValue>";
        $request .= "<CustRef>".$data['deliveryNote']."</CustRef>";
        $request .= "<RecipientRef>".$data['deliveryNote']."</RecipientRef>";
        $request .= "<NotificationEmail>knnz.pact@kuehne-nagel.com</NotificationEmail>";
        $request .= "<SendConfirmation>True</SendConfirmation>";
        $request .= "<SpecialInstructions>";
        if($data['pickup_ins']!="no"){
            $request .= "Pickup Instructions: ".$data['pickup_ins'] ;
        }
        if($data['delivery_ins']!="no"){
            $request .= " , Delivery Instructions: ".$data['delivery_ins'] ;
        }
        $request .= "</SpecialInstructions>";
        $request .= "<NotificationWhenPickedUp/>";
        $request .= "<NotificationWhenReadyForDelivery></NotificationWhenReadyForDelivery>";
        $request .= "<NotificationPOD></NotificationPOD>";
        $request .= "<ContainerNo/>";
        $request .= "<ContainerSize/>";
        $request .= "<CarriageTemp />";
        foreach ($data['cargos'] as $cargo) {
            $request .= "<Line>";
            $request .= "<Quantity>" . round($cargo['quantity']) . "</Quantity>";
            $request .= "<Package>" . $cargo['cargo_type'] . "</Package>";
            $request .= "<Description>" . $cargo['content'] . "</Description>";
            $request .= "<DGClass />";
            $request .= "<DGUNNo />";
            $request .= "<Weight>" . $cargo['weight'] . "</Weight>";
            $request .= "<Volume>" . $cargo['volume'] . "</Volume>";
            $request .= "</Line>";
        }

        $request .= "<HireEquipment>";
        $request .= "<Quantity></Quantity>";
        $request .= "<EquipmentCode></EquipmentCode >";
        $request .= "<Description/>";
        $request .= "</HireEquipment>";
        $request .= "</ConNote>";
        $request .= "</ConNotes>";
        $request .= "<ControlTotal>";
        $request .= "<Total Units='CONNOTES'>1</Total>";
        $request .= "</ControlTotal>";
        $request .= "</MessageBody>";
        $request .= "</Message>";
        return str_replace("&", "AND", $request);
    }

    private  function  publishCronjobxml($sender_xml, $order_id){
        $ci = &get_instance();
        $filename = date('Ymd')."SVK".$order_id.".xml";
        $localfile = "./xml/tripoutbound/".$filename;
        if (!file_exists(dirname($localfile))) {
            if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($localfile, $sender_xml);
        $remotefile = basename($localfile);
        $folder_name = TOLL_FOLDER_NAME;
        $sftp_url = BOOMI_FTP;
        $username = BOOMI_FTP_USER;
        $password = BOOMI_FTP_PWD;

        // connect

        try{
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                log_message("error","Carriercommonedilib(760) >> sendxmlservice >> Cannot login into your MTF server!");
            }else{

                // store

                $sftp->chdir($folder_name);
                $sftp->put($folder_name."/".$remotefile,$localfile,SFTP::SOURCE_LOCAL_FILE);
                log_message("error","Carriercommonedilib(764) >> sendxmlservice >> EDI file sent");

            }

            // confirm
            unset($sftp);
        } catch (Exception $ex) {
            log_message("error","Carriercommonedilib(768) >> sendxmlservice >> Some Problem occured in EDI MTF server!, Please Try Again Later.");
        }

    }
    private function publishxml($sender_xml, $order_id)
    {
        $ci = &get_instance();
        $filename = "TOLL_" . date('Ymd') . "SVK" . $order_id . ".xml";
        $localfile = "/home/efs/xml/tripoutbound/" . $filename;
        if (!file_exists(dirname($localfile))) {
            if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($localfile, $sender_xml);
        $folder_name = TOLL_FOLDER;
        if (SYS_TYPE == 'TMS') {
            $username = TOLL_PROD_USERNAME;
            $password = TOLL_PROD_PWD;
        } else {
            $username = TOLL_TEST_USERNAME;
            $password = TOLL_TEST_PWD;
        }

        $sftpDestination = $folder_name . "/" . $filename;
        $ci->load->library("SftpProxyClient");
        $SFTP = $ci->sftpproxyclient->proxyConnection(TOLL_URL, "TOLL");
        if (!$SFTP) {
            return ['status' => 0, 'response' => "TOLL proxy Login failed"];
        }

        return $ci->sftpproxyclient->fileUpload([
            'sftp' => $SFTP,
            'sftpUsername' => $username,
            'sftpPassword' => $password,
            'sftpDestination' => $sftpDestination,
            'sftpSourceFile' => $localfile,
        ], "TOLL");

    }

    public function sftpTollSetup():array {

        if (SYS_TYPE === 'TMS') {
            return [
                TOLL_URL,
                TOLL_PROD_USERNAME,
                TOLL_PROD_PWD
            ];
        }

        return [
            TOLL_URL,
            TOLL_TEST_USERNAME,
            TOLL_TEST_PWD
        ];
    }

    public function sftpBoomiSetup():array {

        return [
            BOOMI_FTP,
            BOOMI_FTP_USER,
            BOOMI_FTP_PWD
        ];
    }

    /**
     * @throws Exception
     */
    public function connect(string $url, string $username, string $password):SFTP {
        $sftp = new SFTP($url);
        $sftp->login($username, $password);

        if (!$sftp) {
            unset($sftp);
            log_message('error', 'Toll SFTP Connection failed ');
            throw new RuntimeException('Toll SFTP connection failed');
        }
        return $sftp;
    }

    /**
     * @throws Exception
     */
    public function connectWithProxy(string $url, string $username, string $password):SFTP {
        $ci = &get_instance();
        $ci->load->library("SftpProxyClient");
        $sftp = $ci->sftpproxyclient->proxyConnection($url, "TOLL");
        $sftp->login($username, $password);

        if (!$sftp) {
            log_message('error', 'Toll SFTP proxy Connection failed ');
            throw new RuntimeException('Toll SFTP proxy connection failed');
        }
        return $sftp;
    }

    public function getFilesList(SFTP $sftp, string $folderName):array {
        $sftp->chdir($folderName);
        return array_filter($sftp->nlist(), function(string $value) {
            return $value !== "." && $value !== "..";
        }) ?: [];
    }

    public function storeFile(SFTP $sftp, string $directory, string $fileName, string $contents):void {
        try{
            $sftp->chdir($directory);
            $sftp->put($fileName,$contents);
            //log_message("error","TOLL EDI file sent: ". $fileName);
        } catch (Exception $ex) {
            log_message("error","TOLL Some Problem occured in EDI MTF server!, ".
                "Processing {$fileName} failed. ".
                "Please Try Again Later.");
        }
    }

}
