<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class TripChargesRecalculation
{
    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(['consolidationmodel']);
        $ci->load->library(['ratemanagement']);
    }

    /*
	 *  Recalculate new charges and delete old charges after trip update
	 *  @param: int (shift_id column from tb_orders table)
     *  $recalculationStatus = 0(filtered orders not found)
     *  $recalculationStatus = 1(filtered orders found)
     *  $recalculationStatus = 2(states found with given partyCodes)
     *  $recalculationStatus = 3(revenue charges added)
     *  $recalculationStatus = 4(cost charges added)
     *  $recalculationStatus = 5(deleted old revenues and costs)
	 *  return : int  (status)    
	 */
    public function recalculateCharges(int $shiftId): int
    {
        $recalculationStatus = 0;
        $ci = &get_instance();
        $userId = $ci->session->userdata('user_id');
        $companyCode = $ci->session->userdata('company_code');
        $orderDetails = $ci->consolidationmodel->getOrderDetails("o.id,pickup_country,delivery_country,
        pickup_city,delivery_city,pickup_pincode,delivery_pincode,customer_id,vendor_id,product,pickup_custid,
        drop_custid,r.order_id,c.revenue_id,c.source_created,IFNULL(b.status,1) as status,od.order_type,od.service,cu.code", [], 0, $shiftId);
        $selectedRevenueIds = $partyCodes = $selectedRevenues = [];
        if (!empty($orderDetails)) {
            for ($i = 0; $i < count($orderDetails); $i++) {
                if ("1" === $orderDetails[$i]['status']) {
                    $recalculationStatus = 1;
                    if (!in_array($orderDetails[$i]['revenue_id'], $selectedRevenueIds)) {
                        $selectedRevenueIds[] = $orderDetails[$i]['revenue_id'];
                    }
                    if (!in_array($orderDetails[$i]['pickup_custid'], $partyCodes)) {
                        $partyCodes[] = $orderDetails[$i]['pickup_custid'];
                    }
                    if (!in_array($orderDetails[$i]['drop_custid'], $partyCodes)) {
                        $partyCodes[] = $orderDetails[$i]['drop_custid'];
                    }
                    $index         = $orderDetails[$i]['id'];
                    $data['orders'][$index] =  [
                        'pickup' => strtoupper($orderDetails[$i]['pickup_country']),
                        'pickup_city' => strtoupper($orderDetails[$i]['pickup_city']),
                        'pickup_pincode' => $orderDetails[$i]['pickup_pincode'],
                        'pickup_custid' => $orderDetails[$i]['pickup_custid'],
                        'drop' => strtoupper($orderDetails[$i]['delivery_country']),
                        'drop_city' => strtoupper($orderDetails[$i]['delivery_city']),
                        'drop_pincode' => $orderDetails[$i]['delivery_pincode'],
                        'drop_custid' => $orderDetails[$i]['drop_custid'],
                        'customer_code' => $orderDetails[$i]['code'],
                        'service' => $orderDetails[$i]['service'],
                        'product' => $orderDetails[$i]['product'],
                        'user_id' => $userId,
                        'company_code' => $companyCode,
                        'order_type' => $orderDetails[$i]['order_type'],
                        'order_id' => $orderDetails[$i]['id'],
                        'customer_row_id' => $orderDetails[$i]['customer_id'],
                        'vendor_id' => $orderDetails[$i]['vendor_id']
                    ];
                }
            }
            foreach ($selectedRevenueIds as $id) {
                $selectedRevenues[] = ['id' => $id, 'status' => 0];
            }
            $partyStates = [];
            if (!empty($partyCodes)) {
                $getPartyStates = $ci->consolidationmodel->getPartyStates("customeridentifier,state", $partyCodes, $companyCode);
                if (!empty($getPartyStates)) {
                    $recalculationStatus = 2;
                    for ($i = 0; $i < count($getPartyStates); $i++) {
                        $index = $getPartyStates[$i]['customeridentifier'];
                        $partyStates[$index] = strtoupper($getPartyStates[$i]['state']);
                    }
                }
            }
            if (!empty($data['orders'])) {
                foreach ($data['orders'] as  $order) {
                    $pickupState = $partyStates[$order['pickup_custid']] ?? "";
                    $dropState = $partyStates[$order['drop_custid']] ?? "";
                    $orderDetails = [
                        'pickup' => $order['pickup'],
                        'pickup_state' => $pickupState,
                        'pickup_city' => $order['pickup_city'],
                        'pickup_pincode' => $order['pickup_pincode'],
                        'drop' => $order['drop'],
                        'drop_state' => $dropState,
                        'drop_city' => $order['drop_city'],
                        'drop_pincode' => $order['drop_pincode'],
                        'customer_id' => $order['customer_code'],
                        'service' => $order['service'],
                        'product' => $order['product'],
                        'user_id' => $order['user_id'],
                        'company_code' => $order['company_code'],
                        'order_type' => $order['order_type'],
                        'order_id' => $order['order_id'],
                        'customer_row_id' => $order['customer_row_id']
                    ];
                    $ci->ratemanagement->addrecodfororderinsertion($orderDetails);
                    $recalculationStatus = 3;
                }
                foreach ($data['orders'] as  $order) {
                    $orderInfo = ['ordid' => $order['order_id'], 'carrierid' => $order['vendor_id']];
                    $ci->ratemanagement->addrecodfortripinsertion($orderInfo);
                    $recalculationStatus = 4;
                }
                if (!empty($selectedRevenues)) {
                    $ci->db->update_batch('tb_reveneus', $selectedRevenues, 'id');
                    $recalculationStatus = 5;
                }
            }
        }
        return $recalculationStatus;
    }
}
