<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class TripCreateFromOrders
{
    public function __construct()
    {
        $ci =& get_instance();
        $ci->load->model(['common', 'triptemplatemodel','carriercommonmodel']);
        $ci->load->library(['carriercommonedilib', 'carrierstandardtripoutbound', 'knlogin', 'Notifytrigger']);
        $this->companyCode = $ci->session->userdata('company_code');
        $this->branchCode = $ci->session->userdata('branch_code');
        $this->userId = $ci->session->userdata('user_id');
        $this->currentTimeZone = $ci->session->userdata("usr_tzone")['timezone'];
        $this->countryCode = $ci->session->userdata("usr_tzone")['phone_code'];
        if ($this->countryCode == "") {
            $this->countryCode = $ci->session->userdata("usr_tzone")['country'];
        }
    }

    public function createTripFromOrdersPage(array $order, array $ordInput): int
    {
        $ci =& get_instance();
        $response = 0;
        if (!empty($order) && !empty($ordInput)) {
            $userId = $ordInput['user_id'];
            $year = date('y');
            $week = date('W');
            $countCode = substr($ordInput['company_code'], 0, 2);
            $orderNumber = $order['order_id'];
            $sequenceNumber = $countCode === 'UK' ? $orderNumber : substr($orderNumber, -6);
            $trip['shipmentId'] = "T" . $countCode . $week . $year . $sequenceNumber;
            $trip['vendorId'] = $ordInput['carrierid'];
            $noVendorTrip = $ordInput['noVendorTrip'] ?? 0;
            if(($trip['vendorId'] == 0) && ($noVendorTrip > 0)){
                $createTripIfNoVendor = 1;
            }
            if (in_array($order['company_code'], ['SGKN', 'MYKN'])) {
                $trip['vehicleId'] = $ordInput['tvehnum'] ?? "";
            } else {
                $trip['vehicleId'] = $ordInput['veh_typenum'] ?? "";
            }
            $trip['driverId'] = $ordInput['tdrivernum'] ?? "";
            $trip['vehicleType'] = $ordInput['vehicle_type'] ?? 0;
            $trip['carrierInstructions'] = $ordInput['carrier_instructions'] ?? "";
            $trip['weightCapacity'] = $ordInput['weight_capacity'] ?? "";
            $trip['volumeCapacity'] = $ordInput['volume_capacity'] ?? "";
            $trip['additionalConditions'] = $ordInput['additional_conditions'] ?? "";
            $trip['temperatureRegime'] = $ordInput['temperature_regime'] ?? "";
            $trip['timeForLoadingPenality_rate'] = $ordInput['time_for_loading_penality_rate'] ?? "";
            if (($trip['shipmentId'] != "")  && ($order['id'] > 0)) {
                if(($createTripIfNoVendor ?? 0 ) == 0){
                    if($trip['vendorId'] >0){
                        $createTrip = 1;
                    }else{
                        $createTrip = 0;
                    }
                }else{
                    $createTrip = 1;
                }
                if(($createTrip ?? 0) > 0){
                    $orderDetails = $this->getOrderDetailsForTrip($order);
                    $checkShipment = $ci->common->gettblrowdata(['shipmentid' => $trip['shipmentId'], 'status' => 1], "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type", "tb_shifts", 0, 0);
                    if (empty($checkShipment)) {
                        $orderDetails['userId'] = $userId;
                        $shiftRowId = $this->insertTripForOrders($order, $orderDetails, $trip);
                    } else {
                        $shiftRowId = $checkShipment['id'];

                        $ci->common->updatetbledata("tb_shifts", [
                            'status' => 1,
                            'vendor_id' => $trip['vendorId']
                        ], ['id' => $shiftRowId]);
                    }

                    $ci->common->updatetbledata("tb_orders", ['vendor_id' => $trip['vendorId'], 'shift_id' => $shiftRowId, "shipmentid" => $trip['shipmentId'], 'status' => 2], ["id" => $order['id']]);
                    $trip['shiftRowId'] = $shiftRowId;
                    $response = $this->insertTripRelatedTablesForOrder($trip, $order, $orderDetails, $ordInput);
                    if($trip['vendorId'] >0){
                        makeorderinvolvedpartiestype($trip['vendorId'], $order['id'], "CARRIER", $this->userId, $this->companyCode);
                        $ci->notifytrigger->sendNotificationToCarrier($shiftRowId,$order['company_code'],'CR');
                    }
                }
            }
        }
        return $response;
    }

    public function getOrderDetailsForTrip(array $order): array
    {
        $orderDetails = [];
        $orderDetails['pickup'] = $order['pickup_address1'];
        if ("" == $orderDetails['pickup']) {
            $orderDetails['pickup'] = $order['pickup_city'];
        }
        $orderDetails['delivery'] = $order['delivery_address1'];
        if ("" == $orderDetails['delivery']) {
            $orderDetails['delivery'] = $order['delivery_city'];
        }
        $orderDetails['address'] = $orderDetails['dropaddr'] = "";
        if ($order['pickup_address1'] != "") {
            $orderDetails['address'] .= $order['pickup_address1'];
            $orderDetails['dropaddr'] .= $order['delivery_address1'];
        }
        if ($order['pickup_company'] != "") {
            $orderDetails['address'] .= ", " . $order['pickup_company'];
            $orderDetails['dropaddr'] .= ", " . $order['delivery_company'];
        }
        if ($order['pickup_country'] != "") {
            $orderDetails['address'] .= ", " . $order['pickup_country'];
            $orderDetails['dropaddr'] .= ", " . $order['delivery_country'];
        }
        if ($order['pickup_city'] != "") {
            $orderDetails['address'] .= ", " . $order['pickup_city'];
            $orderDetails['dropaddr'] .= ", " . $order['delivery_city'];
        }
        if ($order['pickup_pincode'] != "") {
            $orderDetails['address'] .= ", " . $order['pickup_pincode'];
            $orderDetails['dropaddr'] .= ", " . $order['delivery_pincode'];
        }
        $orderDetails['plat'] = $order['plat'];
        $orderDetails['plng'] = $order['plng'];
        $orderDetails['dlat'] = $order['dlat'];
        $orderDetails['dlng'] = $order['dlng'];
        return $orderDetails;
    }

    private function insertTripForOrders(array $order, array $orderDetails, array $trip): int
    {
        $ci =& get_instance();
        if ($trip['vehicleType'] != '' && $trip['vehicleType'] != 0) {
            $getVehicleType = $ci->common->gettblrowdata(["id" => $trip['vehicleType']], "trucktype", "tb_trucktypes", 0, 0);
            if (!empty($getVehicleType)) {
                $vehicleType = $getVehicleType['trucktype'];
            } else {
                $vehicleType = $order['vehicle_type'];
            }
        } else {
            $vehicleType = $order['vehicle_type'];
        }
        $startDate = $order['pickup_datetime'];
        $startTime = date('H:i', strtotime($startDate));
        $endDate = $order['delivery_datetime'];
        $endTime = date('H:i', strtotime($endDate));
        $insarr = [
            'user_id' => $orderDetails['userId'],
            'stime' => $startTime,
            'etime' => $endTime,
            'splace' => $order['pickup_city'],
            'slat' => $orderDetails['plat'],
            'slng' => $orderDetails['plng'],
            'eplace' => $order['delivery_city'],
            'elat' => $orderDetails['dlat'],
            'elng' => $orderDetails['dlng'],
            'scity' => $order['pickup_city'],
            'dcity' => $order['delivery_city'],
            'zone_id' => 1,
            'empshift_start' => $startTime,
            'empshift_end' => $endTime,
            'trip_type' => 0,
            'startdate' => $startDate,
            'enddate' => $endDate,
            'shipment_name' => 'Boxes',
            'shipment_id' => 0,
            'transport_mode' => $order['transport_mode'],
            'customer_id' => $order['customer_id'],
            'vendor_id' => $trip['vendorId'],
            'carrier_type' => 0,
            'shipmentid' => $trip['shipmentId'],
            'txnid' => $trip['shipmentId'],
            'weight' => $order['total_weight'],
            'volume' => $order['volume'],
            'units' => $order['quantity'],
            'domainname' => 'INFD',
            'vehicle_type' => $vehicleType,
            'company_code' => $order['company_code'],
            'branch_code' => $order['branch_code'],
            'carrier_instructions' => $trip['carrierInstructions'],
            'weight_capacity' => $trip['weightCapacity'],
            'volume_capacity' => $trip['volumeCapacity'],
            'additional_conditions' => $trip['additionalConditions'],
            'temperature_regime' => $trip['temperatureRegime'],
            'time_for_loading_penality_rate' => $trip['timeForLoadingPenality_rate'],
            'status' => 1
        ];
        $shiftRowId = $ci->common->insertTableData("tb_shifts", $insarr);
        return $shiftRowId;
    }

    private function insertTripRelatedTablesForOrder(array $trip, array $order, array $orderDetails, array $ordInput): int
    {
        $ci =& get_instance();
        $capacity = $order['total_weight'] ?: 0;
        $checkStop = $ci->common->gettblrowdata(["shipment_id" => $trip['shiftRowId'], "stopcity" => $order['pickup_city'], "stoptype" => "P"], "id", "tb_shiporder_stops", 0, 0);
        if (empty($checkStop)) {
            $pickupStopId = $ci->common->insertTableData('tb_shiporder_stops',
                [
                    'stopname' => $order['pickup_city'],
                    'plat' => $orderDetails['plat'],
                    'plng' => $orderDetails['plng'],
                    'stopcity' => $order['pickup_city'],
                    'address' => $orderDetails['address'],
                    'stoptype' => 'P',
                    'stopstatus' => 0,
                    'shipment_id' => $trip['shiftRowId'],
                    'ordernumber' => 1,
                    'startdate' => $order['pickup_datetime'],
                    'enddate' => $order['pickup_endtime'],
                    'weight' => $order['total_weight'],
                    'volume' => $order['volume'],
                    'shipmentstopid' => 0,
                    'ship_units' => $order['quantity'],
                    'txncode' => 'NP',
                    'status' => 1,
                    'created_on' => $order['currentTime']
                ]
            );
        } else {
            $pickupStopId = $checkStop['id'];
            $updateShipOrderStops = $ci->common->updatetbledata("tb_shiporder_stops", ["status" => 1], ["id" => $pickupStopId]);
        }
        $checkStop = $ci->common->gettblrowdata(["shipment_id" => $trip['shiftRowId'], "stopcity" => $order['delivery_city'], "stoptype" => "D"], "id", "tb_shiporder_stops", 0, 0);
        if (empty($checkStop)) {
            $dropStopId = $ci->common->insertTableData(
                'tb_shiporder_stops',
                [
                    'stopname' => $order['delivery_city'],
                    'plat' => $orderDetails['dlat'],
                    'plng' => $orderDetails['dlng'],
                    'stopcity' => $order['delivery_city'],
                    'address' => $orderDetails['dropaddr'],
                    'stoptype' => 'D',
                    'stopstatus' => 0,
                    'shipment_id' => $trip['shiftRowId'],
                    'ordernumber' => 2,
                    'startdate' => $order['delivery_datetime'],
                    'enddate' => $order['drop_endtime'],
                    'weight' => $order['total_weight'],
                    'volume' => $order['volume'],
                    'shipmentstopid' => 0,
                    'ship_units' => $order['quantity'],
                    'txncode' => 'NP',
                    'status' => 1,
                    'created_on' => $order['currentTime']
                ]
            );
        } else {
            $dropStopId = $checkStop['id'];
            $updateShipOrderStops = $ci->common->updatetbledata("tb_shiporder_stops", ["status" => 1], ["id" => $dropStopId]);
        }
        $checkEmp = $ci->common->gettblrowdata(['stop_id' => $pickupStopId, 'drop_stopid' => $dropStopId, 'order_id' => $order['order_id'], 'shift_id' => $trip['shiftRowId']], "id", "tb_employee", 0, 0);
        if (empty($checkEmp)) {
            $detailId = $ci->common->insertTableData("tb_employee", [
                'assoc_id' => $trip['shipmentId'],
                'pickup' => $orderDetails['pickup'],
                'plat' => $orderDetails['plat'],
                'plng' => $orderDetails['plng'],
                'drop' => $orderDetails['delivery'],
                'dlat' => $orderDetails['dlat'],
                'dlng' => $orderDetails['dlng'],
                'pickup_city' => $order['pickup_city'],
                'drop_city' => $order['delivery_city'],
                'pickup_datetime' => $order['pickup_datetime'],
                'drop_datetime' => $order['delivery_datetime'],
                'name' => 'Boxes',
                'phone' => $order['customer_phone'],
                'address' => $orderDetails['address'],
                'emailid' => $order['customer_email'],
                'user_id' => $orderDetails['userId'],
                'status' => 1,
                'createdon' => $order['currentTime'],
                'material_id' => 0,
                'capacity' => $capacity,
                'information' => $order['customer_comments'],
                'shipment_weight' => $order['total_weight'],
                'shipment_volume' => $order['volume'],
                'ship_type' => 'P',
                'customer_id' => $order['customer_id'],
                'vendor_id' => $trip['vendorId'],
                'shipment_id' => 0,
                'startdate' => $order['pickup_datetime'],
                'enddate' => $order['delivery_datetime'],
                'shift_id' => $trip['shiftRowId'],
                'stop_order' => 1,
                'drop_order' => 0,
                'basic_stop' => 0,
                'stop_id' => $pickupStopId,
                'drop_stopid' => $dropStopId,
                'order_id' => $order['order_id'],
                'pkgitemid' => 'BOXES',
                'no_of_pkgs' => $order['quantity'],
                'domainname' => 'INFD'
            ]);
        } else {
            $detailId = $checkEmp['id'];
        }
        $stopsUnits = $ci->common->getjointbldata("tb_order_cargodetails oc", "tbl_shipunit_types im", "im.id = oc.handling_unit", ["oc.order_id" => $order['id'], "oc.status" => '1'], "oc.id", 0, 0);
        if (!empty($stopsUnits)) {
            $unitData = $stopsUnits[0];
            $updateOrder = $ci->common->updatetbledata("tb_order_cargodetails", ["stop_detail_id" => $detailId], ["id" => $unitData['id']]);
        }
        $orderDetails['detailId'] = $detailId;
        $response = $this->insertVehicleRelatedTablesForTrip($trip, $order, $orderDetails, $ordInput);
        $this->checkVendorForAutoAccept($order, $trip);
        return $response;
    }

    private function insertVehicleRelatedTablesForTrip(array $trip, array $order, array $orderDetails, array $ordInput): int
    {
        $ci =& get_instance();
        $response = 0;
        $checkShiftVehicle = $ci->common->gettblrowdata(["shft_id" => $trip['shiftRowId']], "id", "tb_shft_veh", 0, 0);
        if (empty($checkShiftVehicle)) {
            if ($trip['vehicleId'] != "") {
                $vehicleNumber = $ordInput['vehicle_id'] ?? "";
                $shiftVehicleId = $ci->common->insertTableData("tb_shft_veh", ['user_id' => $orderDetails['userId'], 'route_id' => 0, 'shft_id' => $trip['shiftRowId'], 'carrier_id' => $trip['vendorId'], 'vehicle_id' => $trip['vehicleId'], 'register_number' => $vehicleNumber, 'created_on' => $order['currentTime'], 'updated_on' => $order['currentTime'], 'status' => 1]);
                $getEmployee = $ci->common->gettbldata(["shift_id" => $trip['shiftRowId']], "id,pickup_datetime,drop_datetime", "tb_employee", 0, 0);
                if (!empty($getEmployee)) {
                    $priority = 1;
                    foreach ($getEmployee as $eachEmployee) {
                        $insertVehicleEmp = $ci->common->insertTableData("tb_shft_veh_emp", ["user_id" => $orderDetails['userId'], "shft_veh_id" => $shiftVehicleId, "emp_id" => $eachEmployee['id'], "priority" => $priority, "pickup_time" => $eachEmployee['pickup_datetime'], 'created_on' => $order['currentTime'], 'updated_on' => $order['currentTime'], "status" => 1, "drop_time" => $eachEmployee['drop_datetime']]);
                        $priority++;
                    }
                }
            }
        } else {
            $shiftVehicleId = $checkShiftVehicle['id'];
            $checkShiftVehicleEmployee = $ci->common->gettblrowdata(["shft_veh_id" => $shiftVehicleId, "status" => 1], "id", "tb_shft_veh_emp", 0, 0);
            if (empty($checkShiftVehicleEmployee)) {
                $getEmployee = $ci->common->gettbldata(["shift_id" => $trip['shiftRowId']], "id,pickup_datetime,drop_datetime", "tb_employee", 0, 0);
                if (!empty($getEmployee)) {
                    $priority = 1;
                    foreach ($getEmployee as $eachEmployee) {
                        $insertVehicleEmp = $ci->common->insertTableData("tb_shft_veh_emp", ["user_id" => $orderDetails['userId'], "shft_veh_id" => $shiftVehicleId, "emp_id" => $eachEmployee['id'], "priority" => $priority, "pickup_time" => $eachEmployee['pickup_datetime'], 'created_on' => $order['currentTime'], 'updated_on' => $order['currentTime'], "status" => 1, "drop_time" => $eachEmployee['drop_datetime']]);
                        $priority++;
                    }
                }
            } else {
                $checkEmployee = $ci->common->gettblrowdata(["shft_veh_id" => $shiftVehicleId, "emp_id" => $orderDetails['detailId'], "status" => 1], "id", "tb_shft_veh_emp", 0, 0);
                if (empty($checkEmployee)) {
                    $insertVehicleEmp = $ci->common->insertTableData("tb_shft_veh_emp", ["user_id" => $orderDetails['userId'], "shft_veh_id" => $shiftVehicleId, "emp_id" => $orderDetails['detailId'], "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $order['currentTime'], 'updated_on' => $order['currentTime'], "status" => 1, "drop_time" => $order['delivery_datetime']]);
                }
            }
        }
        if ($trip['vehicleId'] != "" && $trip['driverId'] != "") {
            $checkVehicleDrivers = $ci->common->gettbllastrowdata(["vehicle_id" => $trip['vehicleId']], "id,driver_id,status", "tb_vehicles_drivers", 0, 0);
            if (!empty($checkVehicleDrivers)) {
                if ($trip['driverId'] == $checkVehicleDrivers['driver_id']) {
                    $ci->common->updatetbledata("tb_vehicles_drivers", ["status" => 1], ["id" => $checkVehicleDrivers['id']]);
                } else {
                    $insertVehicleDrivers = $ci->common->insertTableData("tb_vehicles_drivers", ['vehicle_id' => $trip['vehicleId'], 'driver_id' => $trip['driverId'], 'imei' => "", 'status' => 1, 'createdon' => $order['currentTime'], 'updatedon' => $order['currentTime']]);
                }
            } else {
                $insertVehicleDrivers = $ci->common->insertTableData("tb_vehicles_drivers", ['vehicle_id' => $trip['vehicleId'], 'driver_id' => $trip['driverId'], 'imei' => "", 'status' => 1, 'createdon' => $order['currentTime'], 'updatedon' => $order['currentTime']]);
            }
            $checkAssignedDrivers1 = $ci->common->gettblrowdata(["driver_id" => $trip['driverId'], "vehicle_id" => $trip['vehicleId']], "id", "tbl_assigned_drivers", 0, 0);
            if (!empty($checkAssignedDrivers1)) {
                $updateAssignedDrivers = $ci->common->updatetbledata("tbl_assigned_drivers", ["status" => "1", 'updated_on' => $order['currentTime']], ["id" => $checkAssignedDrivers1['id']]);
            } else {
                $checkAssignedDrivers = $ci->common->gettblrowdata(["driver_id <>" => $trip['driverId'], "vehicle_id" => $trip['vehicleId'], "status" => 1], "id", "tbl_assigned_drivers", 0, 0);
                if (!empty($checkAssignedDrivers)) {
                    $insertAssignedDrivers = $ci->common->insertTableData("tbl_assigned_drivers", ["vehicle_id" => $trip['vehicleId'], "user_id" => $orderDetails['userId'], "driver_id" => $trip['driverId'], "mobile_no" => $trip['driverId'], "imei" => "", "from_time" => $order['currentTime'], "to_time" => $order['currentTime'], "status" => "1", 'created_on' => $order['currentTime']]);
                } else {
                    $updateAssignedDrivers = $ci->common->updatetbledata("tbl_assigned_drivers", ["driver_id" => $trip['driverId'], 'updated_on' => $order['currentTime']], ["id" => $checkAssignedDrivers['id']]);
                }
            }
        }
        $response = 1;
        $checkStopStatus = $ci->common->gettblrowdata(["order_id" => $order['id'], "shipment_id" => $trip['shiftRowId'], "status_id" => 9], "id", "tb_stop_status", 0, 0);
        if (empty($checkStopStatus)) {
            $insertStopStatus = $ci->common->insertTableData("tb_stop_status", ["shipment_id" => $trip['shiftRowId'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "order_id" => $order['id'], "reason" => "Coming from E-Booking", "createdon" => $order['currentTime']]);
        }
        $postdata = [
            "shipment_id" => $trip['shiftRowId'],
            "trip_id" => "",
            "driver_id" => "",
            "vehicle_id" => "",
            "order_id" => $order['order_id'],
            "user_id" => $orderDetails['userId'],
            "stop_id" => '',
            "curtz" => $ci->session->userdata("usr_tzone")['timezone'],
            "hrs" => $ci->session->userdata("usr_tzone")['hrs'],
            "ord_id" => $order['id']
        ];
        $checkEDIBookingStatus = $ci->triptemplatemodel->checkEDIBookingStatus($order['id']);
        if ($checkEDIBookingStatus == 1 && (checkAccessConditions('CHECK_KNLOGIN_STATUS_COUNTRIES', $order['company_code']))) {
            $ci->common->updatetbledata("tb_stop_status", ["sentknlogin" => 1], ["shipment_id" => $trip['shiftRowId'], "order_id" => $order['id']]);
            $postdata['latitude'] = $order['plat'];
            $postdata['latitude'] = $order['plng'];
            $postdata['web'] = $order['pickup_datetime'];
            $postdata['status_code'] = "0400";
            $insert0400Status = $ci->common->insertTableData("tb_order_status", ["order_id" => $order['id'], "status_id" => "83", "status" => 1, "status_code" => "0400", "latitude" => $order['plat'], "longitude" => $order['plng'], "status_date" => $order['pickup_datetime'], "shift_id" => $trip['shiftRowId'], "status_reason" => "From Admin"]);
            $sts = $ci->knlogin->knloginshipmentstatus($postdata);

            $postdata['latitude'] = $order['dlat'];
            $postdata['latitude'] = $order['dlng'];
            $postdata['web'] = $order['drop_endtime'];
            $postdata['status_code'] = "2400";
            $insert2400Status = $ci->common->insertTableData("tb_order_status", ["order_id" => $order['id'], "status_id" => "110", "status" => 1, "status_code" => "2400", "latitude" => $order['dlat'], "longitude" => $order['dlng'], "status_date" => $order['drop_endtime'], "shift_id" => $trip['shiftRowId'], "status_reason" => "From Admin"]);
            $sts = $ci->knlogin->knloginshipmentstatus($postdata);

            $postdata['status_code'] = "2500";
            $insert2500Status = $ci->common->insertTableData("tb_order_status", ["order_id" => $order['id'], "status_id" => "111", "status" => 1, "status_code" => "2500", "latitude" => $order['dlat'], "longitude" => $order['dlng'], "status_date" => $order['drop_endtime'], "shift_id" => $trip['shiftRowId'], "status_reason" => "From Admin"]);
            $sts = $ci->knlogin->knloginshipmentstatus($postdata);
        }

        return $response;
    }

    private function checkVendorForAutoAccept(array $order, array $trip): void
    {
        $ci =& get_instance();
        $userRole = $ci->session->userdata('user_role_id');
        if ($userRole === "5") {
            $statusReason = "From KNOps";
        } else {
            $statusReason = "From Admin";
        }
        $checkVendors = $ci->common->gettblrowdata(['id' => $trip['vendorId'], 'tms_auto_accept' => 1], "id", "tb_vendors", 0, 0);
        if (!empty($checkVendors)) {
            $checkDrivers = $ci->common->gettblrowdata(['vehicle_id' => $trip['vehicleId'], 'status' => 1], "driver_id", "tb_vehicles_drivers", 0, 0);
            if (!empty($checkDrivers)) {
                $driverId = $checkDrivers['driver_id'];
                $getDriverNumber = $ci->common->gettblrowdata(['id' => $driverId, 'status' => 1], "contact_num", "tb_truck_drivers", 0, 0);
                $contactNum = $getDriverNumber['contact_num'] ?? '';
                if ($trip['vehicleId'] != 0 && $trip['driverId'] != 0) {
                    $checkShifts =  $ci->common->gettblrowdata(['shift_id' => $trip['shiftRowId'], 'vehicle_id' => $trip['vehicleId'], 'driver_id' => $trip['driverId']], "id", "tb_trips", 0, 0);
                    if (empty($checkShifts)) {
                        $tripArr = @['shift_id' => $trip['shiftRowId'], 'vehicle_id' => $trip['vehicleId'], 'driver_id' => $trip['driverId'], 'stime' => $order['currentTime'], 'start_imei' => $contactNum, 'splace' => "", 'eplace' => "", 'start_reading' => 0, 'end_reading' => 0, 'created_on' => $order['currentTime'], 'updated_on' => $order['currentTime'], 'status' => 1, 'trip_type' => 0, 'transit_status' => 0];
                        $tripId = $trip['tripId'] = $ci->common->insertTableData("tb_trips", $tripArr);
                        $updateOrders = $ci->common->updatetbledata("tb_orders", ["trip_id" => $tripId], ["shift_id" => $trip['shiftRowId']]);
                        $insertStopStatus = $ci->common->insertTableData(
                            "tb_stop_status",
                            ['order_id' => $order['id'], "shipment_id" => $trip['shiftRowId'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => $tripId, "status_id" => 10, "latitude" => "", "longitude" => "", "status" => 1, "reason" => $statusReason, "vehicle_id" => $trip['vehicleId'], "driver_id" => $trip['driverId'], "status_code" => '0212', "createdon" => $order['currentTime'], "latitude" => $order['plat'], "longitude" => $order['plng']]
                        );
                        $companyCode = $ci->session->userdata('company_code');
                        $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                        if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, '0212')) {
                            $ci->notifytrigger->sendNotificationToConsignee($order['id'], '0212');
                        }
                        if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $companyCode)) {
                            $ins_ref = ['order_id' => $order['id'], 'reference_id' => 'STS'];
                            $checkSTSRef = $ci->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                            if (count($checkSTSRef) == 0) {
                                $ins_ref['ref_value'] = "Active";
                                $ci->common->insertTableData("tb_order_references", $ins_ref);
                            } else {
                                $ci->common->updatetbledata('tb_order_references', ['ref_value' => "Active"], $ins_ref);
                            }
                        }
                        if (!checkAccessConditions('WECHAT_COUNTRY', $ci->session->userdata('company_code'))) {
                            try {
                                $statusPayload = [
                                    "trip" => $trip['tripId'],
                                    "ship" => $trip['shiftRowId'],
                                    "ord_id" => $order['id'],
                                    "orderid" => $order['order_id'],
                                    "stop_id" => 0,
                                    "stop_detail_id" => 0,
                                    "vehicle_id" => $trip['vehicleId'],
                                    "driver_id" => $trip['driverId'],
                                    "stop_type" => "P",
                                    "timezone" => $ci->session->userdata("timezone"),
                                    "sts_date" => $order['currentTime'],
                                    "status_code" => "0212"
                                ];
                                $ci->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                            } catch (Exception $ex) {
                                log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                            }
                        }
                        if (checkAccessConditions('WECHAT_COUNTRY', $ci->session->userdata('company_code'))) {
                            $getCarrierEDIIfo = $ci->carriercommonmodel->getCarrierEDIDetails($trip['vendorId']);
                            if (empty($getCarrierEDIIfo)) {
                                $ci->load->library('Wechat');
                                $ci->wechat->orderId = $order['order_id'];
                                $ci->wechat->sendNotificationsToWeChat();
                            }
                        }
                    }
                }
            }
        }
    }

    public function createMultiTripFromOrdersPage(array $orders, array $ordInput): int
    {
        $ci =& get_instance();
        $response = $contactNum = 0;
        if (!empty($orders) && !empty($ordInput)) {
            $orderCount = count($orders);
            for ($k = 0; $k < $orderCount; $k++) {
                $orderNumbers[] = $orders[$k]['order_id'];
                $pickUpDates[] = $orders[$k]['pickup_datetime'];
                $customerIds[] = $orders[$k]['customer_id'];
                $createdSource[] = $orders[$k]['created_source'];
                $orderIds[] = $orders[$k]['id'];
            }
            $year = date('y');
            $week = date('W');
            $sessionCompanyCode = $ordInput['company_code'];
            $countryCode = substr($sessionCompanyCode, 0, 2);
            $orderNum = $orders[0]['order_id'];
            $sequenceNum = $countryCode === 'UK' ? $orderNum : substr($orderNum, -6);
            $trip['shipmentId'] = "T" . $countryCode . $week . $year . $sequenceNum;
            $trip['vendorId'] = $ordInput['carrierid'];
            if (in_array($ordInput['company_code'], ['SGKN', 'MYKN'])) {
                $trip['vehicleId'] = $ordInput['tvehnum'] ?? "";
            } else {
                $trip['vehicleId'] = $ordInput['veh_typenum'] ?? "";
            }
            $trip['driverId'] = $ordInput['tdrivernum'] ?? "";
            $trip['vehicleType'] = $ordInput['vehicle_type'] ?? 0;
            $trip['carrierInstructions'] = $ordInput['carrier_instructions'] ?? "";
            $trip['weightCapacity'] = $ordInput['weight_capacity'] ?? "";
            $trip['volumeCapacity'] = $ordInput['volume_capacity'] ?? "";
            $trip['additionalConditions'] = $ordInput['additional_conditions'] ?? "";
            $trip['temperatureRegime'] = $ordInput['temperature_regime'] ?? "";
            $trip['timeForLoadingPenality_rate'] = $ordInput['time_for_loading_penality_rate'] ?? "";
            $checkVendors = $ci->common->gettblrowdata(['id' => $trip['vendorId'], 'tms_auto_accept' => 1], "id", "tb_vendors", 0, 0);
            if ($trip['shipmentId'] != "" && $trip['vendorId'] > 0) {
                $i = $j =  $weight = $volume =$quantity = $contactNum = 0;
                if ($trip['driverId'] != "") {
                    $checkNum = $ci->common->gettblrowdata(['id' => $trip['driverId']], "contact_num", "tb_truck_drivers", 0, 0);
                    if (!empty($checkNum)) {
                        $contactNum = $checkNum['contact_num'];
                    }
                }
                foreach ($orders as $order) {
                    $j++;
                    $i++;
                    $orderId = $order['id'];
                    $orderDetails = $this->getOrderDetailsForTrip($order);
                    $weight += $order['total_weight'];
                    $volume += $order['volume'];
                    $quantity += $order['quantity'];
                    $order['total_weight'] = $weight;
                    $order['volume'] = $volume;
                    $order['quantity'] = $quantity;
                    $orderDetails['userId'] = $order['user_id'];
                    $checkShipment = $ci->common->gettblrowdata(['shipmentid' => $trip['shipmentId'], 'status' => 1], "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type", "tb_shifts", 0, 0);
                    if (empty($checkShipment)) {
                        $trip['shiftRowId'] = $this->insertTripForOrders($order, $orderDetails, $trip);
                    } else {
                        $trip['shiftRowId'] = $checkShipment['id'];
                        if ($orderCount == $j) {
                            $this->updateLastMultipleOrderToTrip($order, $orderDetails, $trip);
                        }
                    }
                    $trip['tripId'] = 0;
                    if (!empty($checkVendors)) {
                        $checkTrip = $ci->common->gettblrowdata(['shift_id' => $trip['shiftRowId'], 'vehicle_id' => $trip['vehicleId'], 'driver_id' => $trip['driverId']], "id", "tb_trips", 0, 0);
                        if (!empty($checkTrip)) {
                            $trip['tripId'] = $checkTrip['id'];
                        } else {
                            $tripArr = @['shift_id' => $trip['shiftRowId'], 'vehicle_id' => $trip['vehicleId'], 'driver_id' => $trip['driverId'], 'stime' => $ordInput['curdt'], 'start_imei' => $contactNum, 'splace' => "", 'eplace' => "", 'start_reading' => 0, 'end_reading' => 0, 'created_on' => $ordInput['curdt'], 'updated_on' => $ordInput['curdt'], 'status' => 1, 'trip_type' => 0, 'transit_status' => 0];
                            $trip['tripId'] = $ci->common->insertTableData("tb_trips", $tripArr);
                        }
                    }
                    $updateOrders = $ci->common->updatetbledata("tb_orders", ['vendor_id' => $trip['vendorId'], 'shift_id' => $trip['shiftRowId'], 'shipmentid' => $trip['shipmentId'], 'trip_id' => $trip['tripId'], 'status' => 2], ["id" => $orderId]);
                    $InsertCarrierInParties = makeorderinvolvedpartiestype($trip['vendorId'], $order['id'], "CARRIER", $this->userId, $this->companyCode);
                    $order['i'] = $i;
                    $order['j'] = $j;
                    $response = $this->multiTripVehiclesData($order, $orderDetails, $trip, $ordInput);
                }
                if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $ordInput['company_code'])) {
                    $ins_ref = ['order_id' => $orderId, 'reference_id' => 'STS'];
                    $checkSTSRef = $ci->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                    if (count($checkSTSRef) == 0) {
                        $ins_ref['ref_value'] = "Active";
                        $ci->common->insertTableData("tb_order_references", $ins_ref);
                    } else {
                        $ci->common->updatetbledata('tb_order_references', ['ref_value' => "Active"], $ins_ref);
                    }
                }
                if (checkAccessConditions('WECHAT_COUNTRY', $ordInput['company_code'])) {
                    $this->triggerWeChatNotification($orderIds[0],$trip['tripId'],$trip['shiftRowId'],$trip['vendorId']);
                }
                $ci->notifytrigger->sendNotificationToCarrier($trip['shiftRowId'],$ordInput['company_code'],'CR');
                /* Push notification to mobile using Firebase */
                $customerNames = $knTrackingNos=[];
                if (!empty($customerIds)) {
                    foreach ($customerIds as $customerId) {
                        $customerData = $ci->common->gettblrowdata("id = " . $customerId, "name", "tb_customers", 0, 0);
                        if (!empty($customerData['name'])) {
                            $customerNames[] = $customerData['name'];
                        }
                    }
                }
                if (!empty($createdSource)) {
                    foreach ($orderIds as $orderId) {
                        if (in_array(18, $createdSource)) {
                            $getTrackingNumber = $ci->common->gettblrowdata(['order_id' => $orderId, 'reference_id' => 'AWB', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                        } else {
                            $getTrackingNumber = $ci->common->gettblrowdata(['order_id' => $orderId, 'reference_id' => 'DQ', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                        }
                        $knTrackingNos[] = $getTrackingNumber['ref_value'] ?? "";
                    }
                }
                if ($trip['shipmentId'] != "" && $trip['driverId'] > 0) {
                    $checkStatus = "RELATED_2_" . $sessionCompanyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                    if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $sessionCompanyCode) && checkAccessConditions($checkStatus, '0212')) {
                        foreach ($orderIds as $orderId) {
                            $ci->notifytrigger->sendNotificationToConsignee($orderId, '0212');
                        }
                    }
                    $customerName = implode(", ", $customerNames);
                    $pickUpDate = implode(
                        ", ",
                        array_map(function ($date) {
                            return substr($date, 0, 10);
                        }, $pickUpDates)
                    );
                    $bookingID = implode(", ", $orderNumbers);
                    $knTrackingNo = implode(", ", $knTrackingNos);
                    $message = "New trip is assigned" . " "
                        . "Pickup Date: " . $pickUpDate . " "
                        . "Customer Name: " . $customerName . " "
                        . "Booking ID: " . $bookingID . " "
                        . "Trip No: " . $trip['shipmentId'] . " "
                        . "KN tracking No: " . $knTrackingNo;
                    $messageData = json_encode(["msg" => $message, "info" =>(object)[], "type"=>1],JSON_UNESCAPED_UNICODE);
                    $ci->load->library('sendfirebase');
                    $fire_ret = $ci->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" =>$messageData, "emp_id" => $trip['driverId'], 'type' => 'Driver']);
                }
                /* END Push notification to mobile using Firebase */
            }
        }
        return $response;
    }

    private function triggerWeChatNotification(string $orderId,int $tripId,int $shiftId,int $vendorId): void {
        $ci =& get_instance();
        $checkDriverAccept = $ci->common->gettblrowdata(['trip_id' => $tripId, 'shipment_id' => $shiftId, 'status' => '1'], "id", "tb_stop_status", 0, 0);
        if ($checkDriverAccept) {
            $getCarrierEDIIfo = $ci->carriercommonmodel->getCarrierEDIDetails($vendorId);
            if (empty($getCarrierEDIIfo)) {
                $orderInfo = $ci->common->gettblrowdata(['id' => $orderId], "order_id", "tb_orders", 0, 0);
                if ($orderInfo) {
                    $ci->load->library('Wechat');
                    $ci->wechat->orderId = $orderInfo['order_id'];
                    $ci->wechat->sendNotificationsToWeChat();
                }
            }
        }
    }
    private function multiTripVehiclesData(array $order, array $orderDetails, array $trip, array $ordInput): int
    {
        $ci =& get_instance();
        $response = 0;
        $userRole = $ci->session->userdata('user_role_id');
        if ($userRole === "5") {
            $statusReason = "From KNOps";
        } else {
            $statusReason = "From Admin";
        }
        $capacity = $order['total_weight'] ?: 0;
        $checkStop = $ci->common->gettblrowdata(['shipment_id' => $trip['shiftRowId'], 'plat' => $orderDetails['plat'], 'plng' => $orderDetails['plng'], 'stopcity' => $order['pickup_city'], 'stoptype' => "P"], "id", "tb_shiporder_stops", 0, 0);
        if (empty($checkStop)) {
            $pickupStopId = $ci->common->insertTableData("tb_shiporder_stops", [
                'stopname' => $order['pickup_city'],
                'plat' => $orderDetails['plat'],
                'plng' => $orderDetails['plng'],
                'stopcity' => $order['pickup_city'],
                'address' => $orderDetails['address'],
                'stoptype' => 'P',
                'stopstatus' => 0,
                'shipment_id' => $trip['shiftRowId'],
                'ordernumber' => $order['j'],
                'startdate' => $order['pickup_datetime'],
                'enddate' => $order['pickup_endtime'],
                'weight' => $order['total_weight'],
                'volume' => $order['volume'],
                'shipmentstopid' => 0,
                'ship_units' => $order['quantity'],
                'txncode' => 'NP',
                'status' => 1,
                'created_on' => $ordInput['curdt']
            ]);
        } else {
            $pickupStopId = $checkStop['id'];
            $updatePickupStops = $ci->common->updatetbledata("tb_shiporder_stops", ["status" => 1], ["id" => $pickupStopId]);
        }
        $checkStop = $ci->common->gettblrowdata(['shipment_id' => $trip['shiftRowId'], 'plat' => $orderDetails['dlat'], 'plng' => $orderDetails['dlng'], 'stopcity' => $order['delivery_city'], 'stoptype' => "D"], "id", "tb_shiporder_stops", 0, 0);
        if (empty($checkStop)) {
            $dropStopId = $ci->common->insertTableData("tb_shiporder_stops", [
                'stopname' => $order['delivery_city'],
                'plat' => $orderDetails['dlat'],
                'plng' => $orderDetails['dlng'],
                'stopcity' => $order['delivery_city'],
                'address' => $orderDetails['dropaddr'],
                'stoptype' => 'D',
                'stopstatus' => 0,
                'shipment_id' => $trip['shiftRowId'],
                'ordernumber' => $order['i'] + 1,
                'startdate' => $order['delivery_datetime'],
                'enddate' => $order['drop_endtime'],
                'weight' => $order['total_weight'],
                'volume' => $order['volume'],
                'shipmentstopid' => 0,
                'ship_units' => $order['quantity'],
                'txncode' => 'NP',
                'status' => 1,
                'created_on' => $ordInput['curdt']
            ]);
        } else {
            $dropStopId = $checkStop['id'];
            $updDropStops = $ci->common->updatetbledata("tb_shiporder_stops", ["status" => 1], ["id" => $dropStopId]);
        }
        $checkEmp = $ci->common->gettblrowdata(['stop_id' => $pickupStopId, 'drop_stopid' => $dropStopId, 'order_id' => $order['order_id'], 'shift_id' => $trip['shiftRowId']], "id", "tb_employee", 0, 0);
        if (empty($checkEmp)) {
            $insArr = [
                'assoc_id' => $trip['shipmentId'],
                'pickup' => $orderDetails['pickup'],
                'plat' => $orderDetails['plat'],
                'plng' => $orderDetails['plng'],
                'drop' => $orderDetails['delivery'],
                'dlat' => $orderDetails['dlat'],
                'dlng' => $orderDetails['dlng'],
                'pickup_city' => $order['pickup_city'],
                'drop_city' => $order['delivery_city'],
                'pickup_datetime' => $order['pickup_datetime'],
                'drop_datetime' => $order['delivery_datetime'],
                'name' => 'Boxes',
                'phone' => $order['customer_phone'],
                'address' => $orderDetails['address'],
                'emailid' => $order['customer_email'],
                'user_id' => $orderDetails['userId'],
                'status' => 1,
                'createdon' => $ordInput['curdt'],
                'material_id' => 0,
                'capacity' => $capacity,
                'information' => $order['customer_comments'],
                'shipment_weight' => $order['total_weight'],
                'shipment_volume' => $order['volume'],
                'ship_type' => 'P',
                'customer_id' => $order['customer_id'],
                'vendor_id' => $trip['vendorId'],
                'shipment_id' => 0,
                'startdate' => $order['pickup_datetime'],
                'enddate' => $order['delivery_datetime'],
                'shift_id' => $trip['shiftRowId'],
                'stop_order' => 1,
                'drop_order' => 0,
                'basic_stop' => 0,
                'stop_id' => $pickupStopId,
                'drop_stopid' => $dropStopId,
                'order_id' => $order['order_id'],
                'pkgitemid' => 'BOXES',
                'no_of_pkgs' => $order['quantity'],
                'domainname' => 'INFD'
            ];
            $detailId = $ci->common->insertTableData("tb_employee", $insArr);
        } else {
            $detailId = $checkEmp['id'];
        }
        $stopsUnits = $ci->common->getjointbldata("tb_order_cargodetails oc", "tbl_shipunit_types im", "im.id = oc.handling_unit", ["oc.order_id" => $order['id'], "oc.status" => '1'], "oc.id", 0, 0);
        if (!empty($stopsUnits)) {
            $unitData = $stopsUnits[0];
            $updateCargo = $ci->common->updatetbledata("tb_order_cargodetails", ["stop_detail_id" => $detailId], ["id" => $unitData['id']]);
        }
        $orderDetails['detailId'] = $detailId;
        $order['currentTime'] = $ordInput['curdt'];
        $response = $this->insertVehicleRelatedTablesForTrip($trip, $order, $orderDetails, $ordInput);
        $checkDriverAccept = $ci->common->gettblrowdata(['trip_id' => $trip['tripId'], 'shipment_id' => $trip['shiftRowId'], 'status' => '1'], "id", "tb_stop_status", 0, 0);
        if (empty($checkDriverAccept) && $response == "1") {
            $ins = $ci->common->insertTableData("tb_stop_status", [
                'order_id' => $order['id'],
                "shipment_id" => $trip['shiftRowId'],
                "stop_id" => 0,
                "stop_detail_id" => 0,
                "stop_type" => "",
                "trip_id" => $trip['tripId'],
                "status_id" => 10,
                "latitude" => "",
                "longitude" => "",
                "status" => 1,
                "reason" => $statusReason,
                "vehicle_id" => $trip['vehicleId'],
                "driver_id" => $trip['driverId'],
                "status_code" => '0212',
                "createdon" => $order['currentTime']
            ]);

            if (!checkAccessConditions('WECHAT_COUNTRY', $ci->session->userdata('company_code'))) {
                try {
                    $statusPayload = [
                        "trip" => $trip['tripId'],
                        "ship" => $trip['shiftRowId'],
                        "ord_id" => $order['id'],
                        "orderid" => $order['order_id'],
                        "stop_id" => 0,
                        "stop_detail_id" => 0,
                        "vehicle_id" => $trip['vehicleId'],
                        "driver_id" => $trip['driverId'],
                        "stop_type" => "P",
                        "timezone" => $ci->session->userdata("timezone"),
                        "sts_date" => $order['currentTime'],
                        "status_code" => "0212"
                    ];
                    $ci->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                }
            }
        }
        return $response;
    }

    private function updateLastMultipleOrderToTrip(array $order, array $orderDetails, array $trip): void
    {
        $ci =& get_instance();
        if ($trip['shiftRowId'] > 0) {
            $endDate = $order['delivery_datetime'];
            $endTime = date('H:i', strtotime($endDate));

            $ci->common->updatetbledata("tb_shifts", [
                'etime' => $endTime,
                'eplace' => $order['delivery_city'],
                'elat' => $orderDetails['dlat'],
                'elng' => $orderDetails['dlng'],
                'dcity' => $order['delivery_city'],
                'empshift_end' => $endTime,
                'enddate' => $endDate,
                'weight' => $order['total_weight'],
                'volume' => $order['volume'],
                'units' => $order['quantity'],
                'carrier_instructions' => $trip['carrierInstructions'],
                'weight_capacity' => $trip['weightCapacity'],
                'volume_capacity' => $trip['volumeCapacity'],
                'additional_conditions' => $trip['additionalConditions'],
                'temperature_regime' => $trip['temperatureRegime'],
                'time_for_loading_penality_rate' => $trip['timeForLoadingPenality_rate'],
                'status' => 1,
                'vendor_id' => $trip['vendorId']
            ], ["id" => $trip['shiftRowId']]);
        }
    }

    public function buildOrderStatusesSelect(int $orderId): array
    {
        $ci = &get_instance();
        $orderStatusCodes = $customStatuses = [];
        $companyCode = $ci->session->userdata('company_code');
        $customStatus = $loadVesselStatus = $unloadVesselStatus = $pickupStopId = $pickupStopDetailId = $dropStopId = $dropStopDetailId = $customCleared = $customStarted = 0;
        $allstatus=$ci->common->gettbldata(['id >'=>270],'status_name,status_code','tb_status_master',0,0);
        $select = '<select name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option value="">Select</option>';
        $checkOrder = $ci->common->gettblrowdata(['id' => $orderId], "order_id,shift_id,trip_id", "tb_orders", 0, 0);
        if (!empty($checkOrder)) {
            $bookingId = $checkOrder['order_id'];
            $shiftId = $checkOrder['shift_id'];
            $tripId = $checkOrder['trip_id'];
            $getOrderStatuses = $ci->common->getjointbldata("tb_order_status o", "tb_status_master s", "o.status_id = s.id", ['o.order_id' => $orderId, 'o.status' => '1'], "o.status_code", 0, 0);
            if ($shiftId > 0) {
                if ($tripId > 0) {
                    $vehicleId = $driverId = 1;
                } else {
                    $checkVehicle = $ci->common->gettblrowdata(['shft_id' => $shiftId, 'status' => '1'], "vehicle_id", "tb_shft_veh", 0, 0);
                    $vehicleId = $checkVehicle['vehicle_id'] ?? 0;
                    if ($vehicleId > 0) {
                        $checkDriverId = $ci->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => '1'], "driver_id", "tbl_assigned_drivers", 0, 0);
                    }
                    $driverId = $checkDriverId['driver_id'] ?? 0;
                }
                if (!in_array('0', [$driverId, $vehicleId])) {
                    $getPickupStopId = $ci->common->getjointbldata("tb_shiporder_stops s", "tb_employee e", "s.id = e.stop_id", "s.shipment_id='" . $shiftId . "' AND s.stoptype= 'P' AND s.status ='1' AND e.order_id ='" . $bookingId . "' AND e.status ='1'", "s.id,e.id as stopdetailsid", 0, 0);
                    $pickupStops = $getPickupStopId[0] ?? [];
                    $pickupStopId = $pickupStops['id'] ?? 0;
                    $pickupStopDetailId = $pickupStops['stopdetailsid'] ?? 0;
                    $getDropStopId = $ci->common->getjointbldata("tb_shiporder_stops s", "tb_employee e", "s.id = e.drop_stopid", "s.shipment_id='" . $shiftId . "' AND s.stoptype= 'D' AND s.status ='1' AND e.order_id ='" . $bookingId . "' AND e.status ='1'", "s.id,e.id as dropstopdetailsid", 0, 0);
                    $dropStops = $getDropStopId[0] ?? [];
                    $dropStopId = $dropStops['id'] ?? 0;
                    $dropStopDetailId = $dropStops['dropstopdetailsid'] ?? 0;
                    $getAlltripStatuses = $ci->common->gettbldata(['order_id' => $orderId, 'status' => '1'], "status_code", "tb_stop_status", 0, 0);
                    foreach ($getAlltripStatuses as $eachLine) {
                        $orderStatusCodes[] = $eachLine['status_code'];
                    }
                    if (!in_array('SV0120', $orderStatusCodes)) {
                        $getAcceptStatus = $ci->common->gettblrowdata(['shipment_id' => $shiftId, 'status' => '1', 'status_code' => 'SV0120'], "id", "tb_stop_status", 0, 0);
                        if (!empty($getAcceptStatus)) {
                            $orderStatusCodes[] = 'SV0120';
                        }
                    }

                    foreach ($allstatus as $eachCode) {
                        $optionType = in_array($eachCode['status_code'], $orderStatusCodes) ? "disabled" : "";
                        $optionValue = $eachCode['status_code'] . "_P_" . $eachCode['status_name'];
                        $optionName = $eachCode['status_name'];
                        $select .= '<option value="' . $optionValue . '" ' . $optionType . '>' . $optionName . '</option>';
                    }

                }
            }
        }
        $select .= "</select>";
        $response = ['select' => $select, 'pshipid' => $pickupStopId, 'dshipid' => $dropStopId, 'dstopdetailsid' => $dropStopDetailId, 'pstopdetailsid' => $pickupStopDetailId];
        return $response;
    }

    public function getCustomStatusForOrders(array $history, int $shiftId, string $userTimZone): array
    {
        $ci =& get_instance();
        $statusCodes = $orderIds = $orderDetails = $remainingStatuses = [];
        foreach ($history as $eachRow) {
            $statusCodes[] = $eachRow['status_code'];
        }
        if (!in_array('1500', $statusCodes)) {
            $remainingStatuses[] = '1500';
        }
        if (!in_array('1600', $statusCodes)) {
            $remainingStatuses[] = '1600';
        }
        if (empty($remainingStatuses)) {
            return $history;
        }
        $getOrderIds = $ci->common->gettbldata(['shift_id' => $shiftId, 'status >' => '0'], "id,order_id", "tb_orders", 0, 0);
        foreach ($getOrderIds as $eachRow) {
            $orderIds[] = $eachRow['id'];
            $orderDetails[$eachRow['id']] = $eachRow['order_id'];
        }
        if (empty($orderIds)) {
            return $history;
        }
        $getStatuses = $ci->common->gettbldata("order_id IN (" . implode(',', $orderIds) . ") AND status ='1' AND status_code IN (" . implode(',', $remainingStatuses) . ") ", "id,order_id,loc_name,status_code,comment,convertToClientTZ(createdon,,'" . $userTimZone . "') as createdon", "tb_stop_status", 0, 0);
        foreach ($getStatuses as $eachStatus) {
            $history[] = ['order_id' => $orderDetails[$eachStatus['order_id']] ?? $eachStatus['order_id'], 'status_code' => $eachStatus['status_code'], 'status_name' => $eachStatus['status_code'] == "1500" ? "Customs Clearance Strated" : "Customs Clearance Completed at Border", 'comment' => $eachStatus['comment'], 'loc_name' => $eachStatus['loc_name'], 'latitude' => '', 'longitude' => '', 'stop_id' => '', 'stop_type' => '', 'createdon' => $eachStatus['createdon']];
        }
        return $history;
    }

    public function createTripByTripTemplate(array $info)
    {
        $ci =& get_instance();
        $templateId = $info['templateId'] ?? "";
        $stringOrders = $info['orderId'] ?? "";
        $tripType = $info['trip_type'] ?? "multi";
        $orderIds = [];
        if ($stringOrders !== "") {
            $orderIds = explode(',', $stringOrders);
        }
        $orderIds = array_filter($orderIds);
        $ordersCount = count($orderIds);
        $shipmentOriginRowId = $shipmentDestinationRowId = $vendorId = $shiftId = 0;
        $transportMode = $vehicleType = $shipmentOrigin = $shipmentDestination = "";
        if ($templateId > 0) {
            $currentDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
            $shiftCreateDate = date('Y-m-d H:i:s', strtotime($currentDate['datetime']));
            $shiftTime = date('H:i', strtotime($currentDate['time']));
            $getTemplateLegsData = $ci->triptemplatemodel->getRouteTemplateLegsByWhereCondition($templateId);
            $getTemplateDetails = $ci->triptemplatemodel->getRouteTemplateById($templateId);
            $daysCount = count($getTemplateLegsData);
            $shiftEndDate = date('Y-m-d H:i:s', strtotime('+' . $daysCount . ' days', strtotime($shiftCreateDate)));
            $carrierType = $getTemplateDetails['carrier_type'];
            $shipmentType = $getTemplateDetails['shipment_type'];
            $customerId = $getTemplateDetails['customer_id'];
            for ($i = 0; $i < 6; $i++) {
                $legRowId = $getTemplateLegsData[$i]['id'] ?? 0;
                if ($legRowId > 0) {
                    if ($i === 0) {
                        $shipmentOrigin = $getTemplateLegsData[0]['origin_location'];
                        $shipmentOriginRowId = $getTemplateLegsData[0]['origin_id'];
                        $vendorId = $getTemplateLegsData[0]['carrier_id'];
                        $transportMode = $getTemplateLegsData[0]['transport_mode'];
                        $vehicleType = $getTemplateLegsData[0]['vehicle_type'];
                    }
                    $shipmentDestination = $getTemplateLegsData[$i]['destination_location'];
                    $shipmentDestinationRowId = $getTemplateLegsData[$i]['destination_id'];
                }
            }
            if (!in_array('0', [$shipmentOriginRowId, $shipmentDestinationRowId], true)) {
                $originData = $this->getPartyMasterDataById($shipmentOriginRowId);
                $destinationData = $this->getPartyMasterDataById($shipmentDestinationRowId);
            }
            $getVehicleTypes = $ci->triptemplatemodel->getVehicleTypesById([$vehicleType]);
            if (!empty($getVehicleTypes)) {
                $vehicleType = $getVehicleTypes[0]['trucktype'] ?? "";
            }
            $data = [
                'shiftTime' => $shiftTime,
                'shiftEndDate' => $shiftEndDate,
                'carrierType' => $carrierType,
                'shipmentType' => $shipmentType,
                'customerId' => $customerId,
                'shipmentOrigin' => $shipmentOrigin,
                'vendorId' => $vendorId,
                'transportMode' => $transportMode,
                'shipmentDestination' => $shipmentDestination,
                'originData' => $originData ?? [],
                'destinationData' => $destinationData ?? [],
                'vehicleType' => $vehicleType,
                'shiftCreateDate' => $shiftCreateDate,
                'templateId' => $templateId,
                'currentDate' => $currentDate,
                'daysCount' => $daysCount,
                'getTemplateLegsData' => $getTemplateLegsData
            ];
            if ($tripType === "multi") {
                $orderShiftIds[] = $shiftId = $this->createMainTripByTripTemplate($data);
            } else {
                for ($i = 0; $i < $ordersCount; $i++) {
                    $orderShiftIds[] = $this->createMainTripByTripTemplate($data);
                }
            }
        }
        return ['orderIds' => $orderIds ?? [], 'orderShiftIds' => $orderShiftIds ?? [], 'shiftId' => $shiftId ?? 0];
    }

    private function createMainTripByTripTemplate(array $data): int
    {
        $ci =& get_instance();
        $shiftId = 0;
        $originData = $data['originData'];
        $destinationData = $data['destinationData'];
        $currentDate = $data['currentDate'];
        $year = date('y');
        $week = date('W');
        $sequenceNumber = substr(mt_rand(10, 100000), 0, 5);
        $shipmentId = "T" . $this->countryCode . $week . $year . $sequenceNumber;
        if ($data['vendorId'] > 0) {
            $insertData = [
                'user_id' => $this->userId,
                'stime' => $data['shiftTime'],
                'etime' => $data['shiftTime'],
                'splace' => $data['shipmentOrigin'],
                'slat' => $originData['latitude'] ?? "",
                'slng' => $originData['longitude'] ?? "",
                'eplace' => $data['shipmentDestination'],
                'elat' => $destinationData['latitude'] ?? "",
                'elng' => $destinationData['longitude'] ?? "",
                'scity' => $data['shipmentOrigin'],
                'dcity' => $data['shipmentDestination'],
                'empshift_start' => $data['shiftTime'],
                'empshift_end' => $data['shiftTime'],
                'trip_type' => '0',
                'startdate' => $data['shiftCreateDate'],
                'enddate' => $data['shiftEndDate'],
                'shipment_name' => 'Boxes',
                'shipmentid' => $shipmentId,
                'shipment_id' => '0',
                'customer_id' => $data['customerId'],
                'transport_mode' => $data['transportMode'],
                'vendor_id' => $data['vendorId'],
                'carrier_type' => $data['carrierType'],
                'border_type' => $data['shipmentType'],
                'txnid' => $shipmentId,
                'vehicle_type' => $data['vehicleType'],
                'company_code' => $this->companyCode,
                'branch_code' => $this->branchCode,
                'status' => '1',
                'created_on' => $currentDate['date'],
                'origin_id' => $originData['code'] ?? "",
                'destination_id' => $destinationData['code'] ?? "",
                'routetemplate_id' => $data['templateId']
            ];
            $shiftId = $ci->triptemplatemodel->insertShiftData($insertData);
            $this->saveTripLegsForShiftId(['mainShiftId' => $shiftId, 'customerId' => $data['customerId'], 'shiftCreateDate' => $data['shiftCreateDate'], 'shipmentId' => $shipmentId, 'legsCount' => $data['daysCount'], 'carrierType' => $data['carrierType'], 'shipmentType' => $data['shipmentType'], 'date' => $currentDate['date']], $data['getTemplateLegsData'], $data['templateId']);
        }
        return $shiftId;
    }

    public function saveTripLegsForShiftId(array $shiftData, array $legs, int $templateId): void
    {
        $ci =& get_instance();
        $shipmentOriginRowIds = $shipmentDestinationRowIds = $originData = $destinationData = $vehicleTypes = $shiftLegsData = $shiftLegsDataMain = $driverIds = $vehicleIds = $vehicleMaster = $vehicleTypeMaster = $vendorIds = [];
        $shipmentId = $shiftData['shipmentId'];
        $shiftCreateDate = $shiftData['shiftCreateDate'];
        $legsCount = $shiftData['legsCount'];
        for ($i = 0; $i < $legsCount; $i++) {
            $shipmentOriginRowIds[] = $legs[$i]['origin_id'];
            $shipmentDestinationRowIds[] = $legs[$i]['destination_id'];
            $vehicleTypes[] = $legs[$i]['vehicle_type'];
            $vehicleIds[] = $legs[$i]['vehicle_id'];
            $vendorIds[] = $legs[$i]['carrier_id'];
        }
        $vendorCompanyCodes = [];
        if (!empty($vendorIds)) {
            $getCompanyCodes = $ci->common->gettbldata("id IN (" . implode(',', $vendorIds) . ")", "id,company_code,branch_code", "tb_vendors", 0, 0);
            foreach ($getCompanyCodes as $eachLine) {
                $vendorCompanyCodes[$eachLine['id']] = ['companyCode' => $eachLine['company_code'], 'branchCode' => $eachLine['branch_code']];
            }
        }
        $shipmentOriginRowIds = array_unique($shipmentOriginRowIds);
        $shipmentDestinationRowIds = array_unique($shipmentDestinationRowIds);
        $getOriginCode = $ci->triptemplatemodel->getPartyMasterCodeById($shipmentOriginRowIds);
        $getDestinationCode = $ci->triptemplatemodel->getPartyMasterCodeById($shipmentDestinationRowIds);
        foreach ($getDestinationCode as $eachLine) {
            $street = $eachLine['street'];
            $locationId = $eachLine['location_id'];
            $country = $eachLine['country'];
            $pincode = $eachLine['pincode'];
            $latitude = $eachLine['latitude'];
            $longitude = $eachLine['longitude'];
            if ($latitude == "") {
                $add1 = implode(",", [$street, $locationId, $country, $pincode]);
                $getLatLngs = getlatlngsbyplace($add1);
                $latitude = @$getLatLngs[0];
                $longitude = @$getLatLngs[1];
            }
            $destinationData[$eachLine['id']] = ['code' => $eachLine['code'], 'latitude' => $latitude, 'longitude' => $longitude, 'street' => $street, 'location_id' => $locationId, 'state' => $eachLine['state'], 'country' => $country, 'pincode' => $pincode];
        }
        foreach ($getOriginCode as $eachLine) {
            $street = $eachLine['street'];
            $locationId = $eachLine['location_id'];
            $country = $eachLine['country'];
            $pincode = $eachLine['pincode'];
            $latitude = $eachLine['latitude'];
            $longitude = $eachLine['longitude'];
            if ($latitude == "") {
                $add1 = implode(",", [$street, $locationId, $country, $pincode]);
                $getLatLngs = getlatlngsbyplace($add1);
                $latitude = @$getLatLngs[0];
                $longitude = @$getLatLngs[1];
            }
            $originData[$eachLine['id']] = ['code' => $eachLine['code'], 'latitude' => $latitude, 'longitude' => $longitude, 'street' => $street, 'location_id' => $locationId, 'state' => $eachLine['state'], 'country' => $country, 'pincode' => $pincode];
        }
        $getVehicleTypes = $ci->triptemplatemodel->getVehicleTypesById($vehicleTypes);
        foreach ($getVehicleTypes as $eachLine) {
            $vehicleTypeMaster[$eachLine['id']] = $eachLine['trucktype'];
        }
        if (!empty($vehicleIds)) {
            $getVehicles = $ci->triptemplatemodel->getVehiclesById($vehicleIds);
            foreach ($getVehicles as $eachLine) {
                $vehicleMaster[$eachLine['id']] = $eachLine['register_number'];
            }
        }
        for ($i = 0; $i < $legsCount; $i++) {
            $j = $i + 1;
            $legshipmentId = $shipmentId . '-' . $j;
            $shiftCreateDate = date('Y-m-d H:i:s', strtotime('+ 1 day + 2 hour', strtotime($shiftCreateDate)));
            $shiftTime = date('H:i', strtotime($shiftCreateDate));
            $shiftEndDate = date('Y-m-d H:i:s', strtotime('+ 1 day + 1 hour', strtotime($shiftCreateDate)));
            $originRowId = $legs[$i]['origin_id'];
            $destinationRowId = $legs[$i]['destination_id'];
            $legOriginCode = $originData[$originRowId]['code'] ?? "";
            $legOriginLatitude = $originData[$originRowId]['latitude'] ?? "";
            $legOriginLongitude = $originData[$originRowId]['longitude'] ?? "";
            if ($legOriginCode != "") {
                if (in_array('', [$legOriginLatitude, $legOriginLongitude], true)) {
                    $add1 = implode(",", [$originData[$originRowId]['street'], $originData[$originRowId]['location_id'], $originData[$originRowId]['country'], $originData[$originRowId]['pincode']]);
                    $data = getlatlngsbyplace($add1);
                    $legOriginLatitude = $data[0] ?? "";
                    $legOriginLongitude = $data[1] ?? "";
                }
            }
            $legDestinationCode = $destinationData[$destinationRowId]['code'] ?? "";
            $legDestinationLatitude = $destinationData[$destinationRowId]['latitude'] ?? "";
            $legDestinationlongitude = $destinationData[$destinationRowId]['longitude'] ?? "";
            if ($legDestinationCode != "") {
                if (in_array('', [$legDestinationLatitude, $legDestinationlongitude], true)) {
                    $add1 = implode(",", [$destinationData[$destinationRowId]['street'], $destinationData[$destinationRowId]['location_id'], $destinationData[$destinationRowId]['country'], $destinationData[$destinationRowId]['pincode']]);
                    $data = getlatlngsbyplace($add1);
                    $legDestinationLatitude = $data[0] ?? "";
                    $legDestinationlongitude = $data[1] ?? "";
                }
            }
            $legsData = [
                'user_id' => $this->userId,
                'stime' => $shiftTime,
                'etime' => $shiftTime,
                'splace' => $legs[$i]['origin_location'],
                'slat' => $legOriginLatitude,
                'slng' => $legOriginLongitude,
                'eplace' => $legs[$i]['destination_location'],
                'elat' => $legDestinationLatitude,
                'elng' => $legDestinationlongitude,
                'scity' => $legs[$i]['origin_location'],
                'dcity' => $legs[$i]['destination_location'],
                'empshift_start' => $shiftTime,
                'empshift_end' => $shiftTime,
                'trip_type' => '0',
                'startdate' => $shiftCreateDate,
                'enddate' => $shiftEndDate,
                'shipment_name' => 'Boxes',
                'shipmentid' => $legshipmentId,
                'shipment_id' => '0',
                'customer_id' => $shiftData['customerId'],
                'transport_mode' => $legs[$i]['transport_mode'],
                'vendor_id' => $legs[$i]['carrier_id'],
                'carrier_type' => $shiftData['carrierType'],
                'border_type' => $shiftData['shipmentType'],
                'txnid' => $legshipmentId,
                'vehicle_type' => $vehicleTypeMaster[$legs[$i]['vehicle_type']] ?? "",
                'company_code' => $vendorCompanyCodes[$legs[$i]['carrier_id']]['companyCode'] ?? $this->companyCode,
                'branch_code' => $vendorCompanyCodes[$legs[$i]['carrier_id']]['branchCode'] ?? $this->branchCode,
                'status' => '1',
                'shift_leg_id' => $shiftData['mainShiftId'],
                'created_on' => $shiftData['date'],
                'routetemplate_id' => $templateId
            ];
            $shiftId = $ci->triptemplatemodel->insertShiftData($legsData);
            $shiftLegsData[] = [
                'shiftId' => $shiftId,
                'driverId' => $legs[$i]['driver_id'],
                'vehicleId' => $legs[$i]['vehicle_id'],
                'fromCity' => $legs[$i]['origin_location'],
                'toCity' => $legs[$i]['destination_location'],
                'originId' => $originRowId,
                'destinationId' => $destinationRowId,
                'startDate' => $shiftCreateDate,
                'endDate' => $shiftEndDate,
                'date' => $shiftData['date'],
                'legshipmentId' => $legshipmentId,
                'legcount' => $j,
                'registerNumber' => $vehicleMaster[$legs[$i]['vehicle_id']] ?? "",
                'vendorId' => $legs[$i]['carrier_id'],
                'mainShiftId' => $shiftData['mainShiftId'],
                'pickupLatitude' => $originData[$originRowId]['latitude'] ?? "",
                'pickupLongitude' => $originData[$originRowId]['longitude'] ?? "",
                'destinationLatitude' => $destinationData[$destinationRowId]['latitude'] ?? "",
                'destinationLongitude' => $destinationData[$destinationRowId]['longitude'] ?? ""
            ];
            //log_message("error","id:".$i);
            $shiftLegsDataMain[] = [
                'shiftId'              => $shiftData['mainShiftId'],
                'driverId'             => $legs[$i]['driver_id'],
                'vehicleId'            => $legs[$i]['vehicle_id'],
                'fromCity'             => $legs[$i]['origin_location'],
                'toCity'               => $legs[$i]['destination_location'],
                'originId'             => $originRowId,
                'destinationId'        => $destinationRowId,
                'startDate'            => $shiftCreateDate,
                'endDate'              => $shiftEndDate,
                'date'                 => $shiftData['date'],
                'legshipmentId'        => $legshipmentId,
                'legcount'             => $j,
                'registerNumber'       => $vehicleMaster[$legs[$i]['vehicle_id']] ?? "",
                'vendorId'             => $legs[$i]['carrier_id'],
                'mainShiftId'          => $shiftData['mainShiftId'],
                'pickupLatitude'       => $originData[$originRowId]['latitude'] ?? "",
                'pickupLongitude'      => $originData[$originRowId]['longitude'] ?? "",
                'destinationLatitude'  => $destinationData[$destinationRowId]['latitude'] ?? "",
                'destinationLongitude' => $destinationData[$destinationRowId]['longitude'] ?? "",
            ];
        }
        if (!empty($shiftLegsData)) {
            $this->addStopsDataForTrips($shiftLegsData);
            if ($i == 1) {
                $this->addVehicleAndDriversDataForTrips($shiftLegsDataMain);
            }
            $this->addVehicleAndDriversDataForTrips($shiftLegsData);
        }
    }

    private function addStopsDataForTrips(array $legsData): void
    {
        $ci =& get_instance();
        foreach ($legsData as $eachLine) {
            $checkPickupStops = $ci->triptemplatemodel->checkLegsStop(['shipmentId' => $eachLine['shiftId'], 'stopCity' => $eachLine['fromCity'], 'stopType' => 'P']);
            $insertPickupArray = ['stopname' => $eachLine['fromCity'], 'plat' => $eachLine['pickupLatitude'], 'plng' => $eachLine['pickupLongitude'], 'stopcity' => $eachLine['fromCity'], 'address' => $eachLine['fromCity'], 'stoptype' => 'P', 'stopstatus' => 0, 'shipment_id' => $eachLine['shiftId'], 'ordernumber' => 1, 'startdate' => $eachLine['startDate'], 'enddate' => $eachLine['endDate'], 'shipmentstopid' => 0, 'txncode' => 'NP', 'status' => 1, 'created_on' => $eachLine['date'], 'stop_party_id' => $eachLine['originId']];
            if (empty($checkPickupStops)) {
                $pickupStopId = $ci->triptemplatemodel->insertShipOrderStops($insertPickupArray);
            } else {
                $pickupStopId = $checkPickupStops['id'];
                $ci->triptemplatemodel->updateShipOrderStopsdata($insertPickupArray, $pickupStopId);
            }
            $checkDropStops = $ci->triptemplatemodel->checkLegsStop(['shipmentId' => $eachLine['shiftId'], 'stopCity' => $eachLine['toCity'], 'stopType' => 'D']);
            $insertDropArray = ['stopname' => $eachLine['toCity'], 'plat' => $eachLine['destinationLatitude'], 'plng' => $eachLine['destinationLongitude'], 'stopcity' => $eachLine['toCity'], 'address' => $eachLine['toCity'], 'stoptype' => 'D', 'stopstatus' => 0, 'shipment_id' => $eachLine['shiftId'], 'ordernumber' => 1, 'startdate' => $eachLine['startDate'], 'enddate' => $eachLine['endDate'], 'shipmentstopid' => 0, 'txncode' => 'NP', 'status' => 1, 'created_on' => $eachLine['date'], 'stop_party_id' => $eachLine['destinationId']];
            if (empty($checkDropStops)) {
                $dropStopId = $ci->triptemplatemodel->insertShipOrderStops($insertDropArray);
            } else {
                $dropStopId = $checkDropStops['id'];
                $ci->triptemplatemodel->updateShipOrderStopsdata($insertDropArray, $dropStopId);
            }
        }
    }

    private function addVehicleAndDriversDataForTrips(array $legsData): void
    {
        $ci =& get_instance();
        foreach ($legsData as $eachLine) {
            if ($eachLine['vehicleId'] > 0) {
                $checkVehicleData = $ci->triptemplatemodel->checkShiftVehicleData($eachLine['shiftId']);
                $arr = ['user_id' => $this->userId, 'route_id' => 0, 'shft_id' => $eachLine['shiftId'], 'carrier_id' => $eachLine['vendorId'], 'vehicle_id' => $eachLine['vehicleId'], 'register_number' => $eachLine['registerNumber'], 'created_on' => $eachLine['date'], 'updated_on' => $eachLine['date'], 'status' => 1];
                if (empty($checkVehicleData)) {
                    $shiftVehicleId = $ci->triptemplatemodel->insertShiftVehTableData($arr);
                } else {
                    $shiftVehicleId = $checkVehicleData['id'];
                    $ci->triptemplatemodel->updateShiftVehicletbledata($arr, $shiftVehicleId);
                }
                if ($eachLine['driverId'] > 0) {
                    $checkShftDrivers = $ci->triptemplatemodel->checkShiftDrivers($eachLine['shiftId'], $eachLine['mainShiftId']);
                    if (empty($checkShftDrivers)) {
                        $ci->triptemplatemodel->insertShiftDriversData(["vehicle_id" => $eachLine['vehicleId'], "driver_id" => $eachLine['driverId'], "shift_id" => $eachLine['shiftId'], "main_shift_id" => $eachLine['mainShiftId'], "vendor_id" => $eachLine['vendorId'], "shift_priority" => $eachLine['legcount']]);
                    } else {
                        $shiftDriverId = $checkShftDrivers['tsd_id'];
                        $ci->triptemplatemodel->updateShiftDriversdata("tb_shift_drivers", ["vehicle_id" => $eachLine['vehicleId'], "driver_id" => $eachLine['driverId'], "shift_id" => $eachLine['shiftId'], "main_shift_id" => $eachLine['mainShiftId'], "vendor_id" => $eachLine['vendorId'], "shift_priority" => $eachLine['legcount']], $shiftDriverId);
                    }
                    $ci->triptemplatemodel->updateVehicleDriversData(['vehicleId' => $eachLine['vehicleId'], 'driverId' => $eachLine['driverId'], 'userId' => $this->userId, 'date' => $eachLine['date']]);
                }
            }
        }
    }

    public function getPartyMasterDataById(int $rowId): array
    {
        $ci =& get_instance();
        $getData = $ci->triptemplatemodel->getPartyMasterCodeById([$rowId]);
        $code = $getData[0]['code'] ?? "";
        $latitude = $getData[0]['latitude'] ?? "";
        $longitude = $getData[0]['longitude'] ?? "";
        if ($code != "") {
            if (in_array('', [$latitude, $longitude])) {
                $address = implode(",", [$getData[0]['street'], $getData[0]['location_id'], $getData[0]['country'], $getData[0]['pincode']]);
                $addressData = getlatlngsbyplace($address);
                $latitude = $addressData[0] ?? "";
                $longitude = $addressData[1] ?? "";
            }
        }
        return ['code' => $code, 'city' => $getData[0]['location_id'] ?? "", 'latitude' => $latitude, 'longitude' => $longitude];
    }

    public function assignOrdersForNewTrip(array $orderIds, array $mainTripIds, string $tripType): void
    {
        $ci =& get_instance();
        $getDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        $currentDate = date('Y-m-d H:i:s', strtotime($getDate['datetime']));
        $getTripDetails = $ci->triptemplatemodel->getTripDetailsByIds($mainTripIds);
        $shiftData = $getTripDetails['shiftData'];
        $legIds = $getTripDetails['legsIds'];
        $orderData = $ci->triptemplatemodel->getOrderDetailsByIds($orderIds);
        if ($tripType === "multi") {
            $mainShiftId = $mainTripIds[0] ?? 0;
            if ($mainShiftId > 0) {
                $this->assignMultiOrdersToSingleTrip($orderIds, $mainShiftId, $shiftData, $legIds[$mainShiftId] ?? [], $orderData);
            }
        } else {
            if (count($orderIds) === count($mainTripIds)) {
                for ($i = 0, $iMax = count($orderIds); $i < $iMax; $i++) {
                    $shipmentId = $shiftData[$mainTripIds[$i]]['shipmentid'] ?? "";
                    $vendorId = $shiftData[$mainTripIds[$i]]['vendor_id'] ?? 0;
                    $ci->triptemplatemodel->updateOrdersTabledata(['status' => '2', 'shift_id' => $mainTripIds[$i], 'vendor_id' => $vendorId, 'shipmentid' => $shipmentId], $orderIds[$i]);
                    $tripLegIds = $legIds[$mainTripIds[$i]] ?? [];
                    foreach ($tripLegIds as $eachLegId) {
                        if ($this->companyCode != $shiftData[$eachLegId]['company_code']) {
                            $ci->triptemplatemodel->addCrossBorderReference(['order_id' => $orderIds[$i], 'reference_id' => "XBRDR", 'ref_value' => $shiftData[$eachLegId]['company_code'] ?? $this->companyCode, 'status' => 1, 'createdon' => $currentDate], ['order_id' => $orderIds[$i], 'reference_id' => 'XBRDR', 'ref_value' => $shiftData[$eachLegId]['company_code'] ?? $this->companyCode]);
                            $orderReferenceValueInsert = xbdrNotificationInsert("XBRDR", $this->companyCode, $shiftData[$eachLegId]['company_code'] ?? $this->companyCode, $orderIds[$i], $shiftData[$eachLegId]['branch_code'] ?? $this->branchCode);
                        }
                        $this->addTableDataForMultiAndSingleTrips($eachLegId, $shiftData[$eachLegId], $orderData[$orderIds[$i]]);
                    }
                }
            }
        }
    }

    private function assignMultiOrdersToSingleTrip(array $orderIds, int $mainShiftId, array $shiftData, array $legIds, array $orderData): void
    {
        $ci =& get_instance();
        $getDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        $currentDate = date('Y-m-d H:i:s', strtotime($getDate['datetime']));
        if (!empty($shiftData)) {
            $shipmentId = $shiftData[$mainShiftId]['shipmentid'] ?? "";
            $vendorId = $shiftData[$mainShiftId]['vendor_id'] ?? 0;
            $ci->triptemplatemodel->updateOrdersTabledata(['status' => '2', 'shift_id' => $mainShiftId, 'vendor_id' => $vendorId, 'shipmentid' => $shipmentId], 0, $orderIds);
            for ($i = 0, $iMax = count($orderIds); $i < $iMax; $i++) {
                foreach ($legIds as $eachLegId) {
                    if ($this->companyCode != $shiftData[$eachLegId]['company_code']) {
                        $ci->triptemplatemodel->addCrossBorderReference(['order_id' => $orderIds[$i], 'reference_id' => "XBRDR", 'ref_value' => $shiftData[$eachLegId]['company_code'] ?? $this->companyCode, 'status' => 1, 'createdon' => $currentDate], ['order_id' => $orderIds[$i], 'reference_id' => 'XBRDR', 'ref_value' => $shiftData[$eachLegId]['company_code'] ?? $this->companyCode]);
                        $orderReferenceValueInsert = xbdrNotificationInsert("XBRDR", $this->companyCode, $shiftData[$eachLegId]['company_code'] ?? $this->companyCode, $orderIds[$i], $shiftData[$eachLegId]['branch_code'] ?? $this->branchCode);
                    }
                    $this->addTableDataForMultiAndSingleTrips($eachLegId, $shiftData[$eachLegId] ?? [], $orderData[$orderIds[$i]]);
                }
            }
        }
    }

    private function addTableDataForMultiAndSingleTrips(int $legId, array $shiftData, array $orderData): void
    {
        $ci =& get_instance();
        $getDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        $currentDate = date('Y-m-d H:i:s', strtotime($getDate['datetime']));
        $stopDetails = $ci->triptemplatemodel->checkStopsByShiftId($legId);
        foreach ($stopDetails as $eachStop) {
            $stopType = $eachStop['stoptype'];
            if (strtoupper($stopType) === "P") {
                $pickupStop = $eachStop['id'];
                $pickup = $eachStop['address'];
                $plat = $eachStop['plat'];
                $plng = $eachStop['plng'];
            } else {
                $dropStop = $eachStop['id'];
                $delivery = $eachStop['address'];
                $dlat = $eachStop['plat'];
                $dlng = $eachStop['plng'];
            }
        }
        $insertEmployee = [
            'assoc_id' => $shiftData['shipmentId'] ?? "",
            'pickup' => $pickup ?? "",
            'plat' => $plat ?? "",
            'plng' => $plng ?? "",
            'drop' => $delivery ?? "",
            'dlat' => $dlat ?? "",
            'dlng' => $dlng ?? "",
            'pickup_city' => $pickup ?? "",
            'drop_city' => $delivery ?? "",
            'pickup_datetime' => $shiftData['startdate'] ?? "",
            'drop_datetime' => $shiftData['enddate'] ?? "",
            'name' => 'Boxes',
            'address' => $pickup ?? "",
            'user_id' => $this->userId,
            'status' => 1,
            'createdon' => $currentDate,
            'material_id' => 0,
            'capacity' => $orderData['quantity'] ?? 0,
            'shipment_weight' => $orderData['weight'] ?? 0,
            'shipment_volume' => $orderData['volume'] ?? 0,
            'ship_type' => 'P',
            'customer_id' => $orderData['customerId'] ?? 0,
            'vendor_id' => $shiftData['vendor_id'],
            'shipment_id' => 0,
            'startdate' => $shiftData['startdate'] ?? "",
            'enddate' => $shiftData['enddate'] ?? "",
            'shift_id' => $legId,
            'stop_order' => 1,
            'drop_order' => 0,
            'basic_stop' => 0,
            'stop_id' => $pickupStop ?? 0,
            'drop_stopid' => $dropStop ?? 0,
            'order_id' => $orderData['bookingId'] ?? 0,
            'pkgitemid' => 'BOXES',
            'no_of_pkgs' => $orderData['quantity'] ?? 0,
            'domainname' => 'INFD'
        ];
        if (!in_array('0', [$pickupStop ?? 0, $dropStop ?? 0], true)) {
            $ci->triptemplatemodel->checkEmployeeWithTripsTable($insertEmployee, ['shiftId' => $legId, 'bookingId' => $orderData['bookingId'] ?? ""], $orderData);
        }
    }
}

?>
