<?php

/**
 * Uniqlo Trip data sending to delhivery/ecomexpress,expressbees
 *
 *
 *
 * @author          Developer Name external.ram.k@kuehne-nagel.com
 * @date            29-03-2021 11:00:00+05.30
 * @change          Asia
 * @copyright       2021 TMS
 * @version         Release: 1
 * @authentication  Required
 */

use phpseclib\Net\SFTP;

class Uniqloediservices
{
    /**
     * order creation in delhivery carrier
     *
     *
     *
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */

    private $forwardOrderTypeId = '15';
    private $returnOrderTypeId = '16';
    private $sftpConnection;

    public function getdelverywaybillnumber($shipmentid = null)
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');
        $postresponse = "no data";
        $status = 0;
        $respstatus = array("status" => $status, "data" => $postresponse);
        $shipdatres = $this->getshipformateddata($shipmentid);
        if (!empty($shipdatres)) {
            foreach ($shipdatres as $shipdata) {
                $orders = $shipdata['order_id'];
                $misc = $shipdata['misc'];
                unset($shipdata['misc']);
                unset($shipdata['order_id']);
                $ordtype = $shipdata['ordtype'];
                unset($shipdata['ordtype']);
                $reqdata = "format=json&data=" . json_encode($shipdata);
                $reqdata = str_replace('\"', '', $reqdata);
                $company_code = isset($misc['company_code']) ? $misc['company_code'] : "INKN";
                $branch_code = isset($misc['branch_code']) ? $misc['branch_code'] : "INCL";
                $user_id = isset($misc['user_id']) ? $misc['user_id'] : "244";
                $edi_request = $reqdata;
                $edi_response = "No pincodes availability";
                $edi_id = 8;
                $edi_name = "Delhivery";
                $params = [
                    'edi_type' => 1, /* 1->EDI Transport Order,2->EDI Status */
                    'transaction_id' => time(),
                    'edi_id' => $edi_id, /* edi id based on name take it from tb_edi_types */
                    'edi_name' => $edi_name,
                    'bounded_type' => 2, /* 1->Inbound(partner => kN),2->Outbound (KN => partner) */
                    'edi_format_type' => 'json',
                    'status' => $status,
                    'obj_type' => 1,
                    'txn_obj_id' => $orders[0],
                    'user_id' => $user_id,
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                    'edi_request' => $edi_request,
                    'edi_response' => $edi_response
                ];

                log_error(
                    UNIQLO_LOG_PREFIX .
                    "getdelverywaybillnumber inserted data in a tb_etn_edi_transactions: " . json_encode($params)
                );

                $edilogid = $ci->common->insertTableData('tb_etn_edi_transactions', $params);
                $pickup_pin = $shipdata['shipments'][0]['pin'];
                $drop_pin = isset($shipdata['pickup_location']) ? $shipdata['pickup_location']['pin'] : "";
                if ($drop_pin != "") {
                    $curdt = date("Y-m-d H:i:s");
                    $server_url = DELHIVERY_ORD_CREATE;
                    $api_token = "Token " . DELHIVERY_AUTH_TOKEN;
                    require_once './vendor/pear/http_request2/HTTP/Request2.php';
                    $request = new HTTP_Request2();
                    $request->setUrl($server_url);
                    $request->setMethod(HTTP_Request2::METHOD_POST);
                    $request->setConfig(getHttpRequestConfig());
                    $request->setHeader([
                                            'Authorization' => $api_token,
                                            'Content-Type' => 'application/json'
                                        ]);
                    $request->setBody($reqdata);

                    log_error(
                        UNIQLO_LOG_PREFIX .
                        'getdelverywaybillnumber connecting with API: ' . $server_url . ' with payload ' . $reqdata
                    );

                    try {
                        $response = $request->send();
                        $curdt = date("Y-m-d H:i:s");
                        if ($response->getStatus() == 200) {
                            $postresp1 = $response->getBody();

                            log_error(
                                UNIQLO_LOG_PREFIX . 'getdelverywaybillnumber API response payload: ' . $postresp1
                            );

                            $edi_response = $postresp1;
                            $postresp = json_decode($postresp1, true);
                            if (isset($postresp['success'])) {
                                if ($postresp['success']) {
                                    $curdt = date("Y-m-d H:i:s");
                                    $upload_wbn = $postresp['upload_wbn'];
                                    $ordid = isset($orders[0]) ? $orders[0] : "";
                                    $whr = [
                                        'order_id' => $ordid,
                                        'reference_id' => 'WBN',
                                        'ref_value' => $upload_wbn,
                                        'status' => 1
                                    ];
                                    $chk = $ci->common->gettblrowdata($whr, "id", "tb_order_references", 0, 0);
                                    if (count($chk) == 0) {
                                        $insarr = [
                                            'order_id' => $ordid,
                                            'reference_id' => 'WBN',
                                            'ref_value' => $upload_wbn,
                                            'createdon' => $curdt,
                                            'status' => 1
                                        ];

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "getdelverywaybillnumber inserted data in a tb_order_references: " .
                                            json_encode($insarr)
                                        );

                                        $ins = $ci->common->insertTableData("tb_order_references", $insarr);
                                    }
                                    $waybill = "";
                                    $packages = $postresp['packages'];
                                    if (!empty($packages)) {
                                        foreach ($packages as $pkg) {
                                            if ($pkg['status'] == "Success") {
                                                $waybill = $pkg['waybill'];
                                                $status = 1;
                                                $updwhr = array("order_row_id" => $ordid);
                                                $updset = array("delivery_note" => $waybill);

                                                log_error(
                                                    UNIQLO_LOG_PREFIX .
                                                    "getdelverywaybillnumber updated data in a tb_order_details: " .
                                                    json_encode($updset)
                                                );

                                                $upd = $ci->common->updatetbledata(
                                                    "tb_order_details",
                                                    $updset,
                                                    $updwhr
                                                );
                                                $whr = [
                                                    'order_id' => $ordid,
                                                    'reference_id' => 'AWB',
                                                    'ref_value' => $waybill,
                                                    'status' => 1
                                                ];
                                                $chk = $ci->common->gettblrowdata(
                                                    $whr,
                                                    "id",
                                                    "tb_order_references",
                                                    0,
                                                    0
                                                );
                                                if (count($chk) == 0) {
                                                    $insarr = [
                                                        'order_id' => $ordid,
                                                        'reference_id' => 'AWB',
                                                        'ref_value' => $waybill,
                                                        'createdon' => $curdt,
                                                        'status' => 1
                                                    ];

                                                    log_error(
                                                        UNIQLO_LOG_PREFIX .
                                                        "getdelverywaybillnumber inserted data in a tb_order_references: " .
                                                        json_encode($insarr)
                                                    );

                                                    $ins = $ci->common->insertTableData(
                                                        "tb_order_references",
                                                        $insarr
                                                    );
                                                }
                                                $updwhr = array("id" => $ordid);
                                                $updset = array("vendor_id" => 310);

                                                log_error(
                                                    UNIQLO_LOG_PREFIX .
                                                    "getdelverywaybillnumber updated data in a tb_orders: " .
                                                    json_encode($updset)
                                                );

                                                $upd = $ci->common->updatetbledata("tb_orders", $updset, $updwhr);
                                                /* update pickup/delivery expected date */
                                                $expectedinfo = [
                                                    'order_id' => $ordid,
                                                    'pickup_pin' => $pickup_pin,
                                                    'delivery_pin' => $drop_pin,
                                                    'order_type' => $ordtype
                                                ];
                                                $upd = $this->updateexpecteddate($expectedinfo);
                                            }
                                        }
                                    }
                                    $senddocket = $this->senddocketnumber($ordid);
                                    $postresponse = $waybill;
                                } else {
                                    /* get the remark to send in mail notify */
                                    $rmkresponse = "";
                                    $resp = isset($postresp['rmk']) ? $postresp['rmk'] : "";
                                    if (isset($postresp['packages'])) {
                                        if (!empty($postresp['packages'])) {
                                            $remark = isset($postresp['packages'][0]['remarks']) ? $postresp['packages'][0]['remarks'] : [];
                                            if (!empty($remark)) {
                                                $rmkresponse .= isset($remark[0]) ? trim($remark[0]) : "";
                                            }
                                        }
                                    }
                                    $postresponse = $rmkresponse . ", " . $resp;
                                }
                            }
                        } else {
                            $postresponse = 'Unexpected HTTP status: ' . $response->getStatus(
                                ) . ' ' . $response->getReasonPhrase();
                        }
                    } catch (HTTP_Request2_Exception $e) {
                        $postresponse = 'Error: ' . $e->getMessage();
                    }
                } else {
                    $postresponse = "No delivery pincode";
                }
                $set = [
                    'status' => $status,
                    'edi_response' => $edi_response
                ];
                $whr = ['id' => $edilogid];

                log_error(
                    UNIQLO_LOG_PREFIX .
                    "getdelverywaybillnumber updated data in a tb_etn_edi_transactions: " .
                    json_encode($set)
                );

                $upd = $ci->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
            }
        }
        $respstatus = [
            'status' => $status,
            'data' => $postresponse
        ];

        log_error(UNIQLO_LOG_PREFIX . "getdelverywaybillnumber outbound data: " . json_encode($respstatus));

        return $respstatus;
    }

    /**
     * get the expected delivery dates from carrier
     *
     *
     *
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30 modified for pincode reverse condition also
     * @change    Asia
     */
    public function updateexpecteddate($ordinfo)
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "updateexpecteddate inbound data: " . json_encode($ordinfo));

        $chkcount = 0;
        $whr = array(
            "origin_pincode" => $ordinfo['pickup_pin'],
            "destinate_pincode" => $ordinfo['delivery_pin'],
            "status" => 1
        );
        $chkdays = $ci->common->gettblrowdata(
            $whr,
            "return_cutoff,dto_cutoff,return_tat,dto_tat",
            "tb_uniqlo_rvp_tat",
            0,
            0
        );
        if (count($chkdays) == 0) {
            $whr = array(
                "origin_pincode" => $ordinfo['delivery_pin'],
                "destinate_pincode" => $ordinfo['pickup_pin'],
                "status" => 1
            );
            $chkdays = $ci->common->gettblrowdata(
                $whr,
                "return_cutoff,dto_cutoff,return_tat,dto_tat",
                "tb_uniqlo_rvp_tat",
                0,
                0
            );
            if (count($chkdays) > 0) {
                $chkcount = 1;
            }
        } else {
            $chkcount = 1;
        }
        if ($chkcount == 1) {
            $updwhr = ['id' => $ordinfo['order_id']];
            $curdt = date("Y-m-d H:i:s");
            $ordtz = "Asia/Kolkata";
            $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $ordtz);
            $curdt = $getactual['datetime'];
            if ($ordinfo['order_type'] == $this->returnOrderTypeId) {
                $returntat = $chkdays['return_tat'];
                $exppickdate = date("Y-m-d", strtotime("+$returntat days", strtotime($curdt)));
                $exppickdate = $exppickdate . " " . $chkdays['return_cutoff'];
                $updset = ['pickup_endtime' => $exppickdate];
            } else {
                $dtotat = $chkdays['dto_tat'];
                $exppickdate = date("Y-m-d", strtotime("+$dtotat days", strtotime($curdt)));
                $exppickdate = $exppickdate . " " . $chkdays['dto_cutoff'];
                $updset = ['drop_endtime' => $exppickdate];
            }

            log_error(
                UNIQLO_LOG_PREFIX .
                "updateexpecteddate inserted data in a tb_orders: " . json_encode($updset)
            );

            $upd = $ci->common->updatetbledata("tb_orders", $updset, $updwhr);
        }
        return true;
    }

    private function getshipformateddata($shipid)
    {
        $request = [];
        $ordersinfo = [];
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "getshipformateddata inbound data: " . $shipid);

        $whr = [
            'shift_id' => $shipid,
            'trip_sts' => 0,
            'status <>' => 0
        ];
        $select = "*";
        $orders = $ci->common->gettbldata($whr, $select, "tb_orders", 0, 0);
        if (count($orders) > 0) {
            $shipments = [];
            $request['order_id'] = $request['misc'] = [];
            $request['pickup_location'] = [];
            $ordtype = $orders[0]['created_source'];
            $isReturnOrder = $ordtype == $this->returnOrderTypeId;

            foreach ($orders as $ord) {
                $request['ordtype'][] = $ordtype;
                $request['misc'] = [
                    'user_id' => $ord['user_id'],
                    'company_code' => $ord['company_code'],
                    'branch_code' => $ord['branch_code']
                ];
                $request['order_id'][] = $ord['id'];
                $items = [];
                $whr = "o.cargo_id=c.id";
                $whr1 = [
                    'o.order_id' => $ord['id'],
                    'o.status' => 1
                ];
                $select = 'o.id, o.quantity_type, o.quantity, o.cargo_content, '
                    . 'o.qr_code, c.id as carid, c.cargo_type, c.handling_unit, '
                    . 'o.length, c.length_unit, o.width, c.width_unit, o.height, '
                    . 'c.height_unit, o.weight, o.load_plan_connote, c.weight_unit, '
                    . 'o.volume, c.volume_unit, c.goods_description';
                $itemqry = $ci->common->getjointbldata(
                    "tb_order_cargodetails o",
                    "tb_cargo_details c",
                    $whr,
                    $whr1,
                    $select,
                    0,
                    0
                );
                $return_reason = "";
                $payment_mode = "Prepaid";
                if ($isReturnOrder) {
                    $payment_mode = "Pickup";
                }
                $height = $width = $length = $quantity = $weight = $commodity_value = 0;
                $goods_category = $goods_content = "";
                $cgst_amount = $sgst_amount = $igst_amount = $sgst_rate = $cgst_rate = $igst_rate = 0;
                $return_state = $return_city = $return_phone = $return_country = $return_pin = $return_add = "";
                $hsn_code = "";
                if (count($itemqry) > 0) {
                    foreach ($itemqry as $ic) {
                        $height += $ic['height'];
                        $weight += $ic['weight'];
                        $width += $ic['width'];
                        $length += $ic['length'];
                        $quantity += $ic['quantity'];
                        $goods_category = str_replace("&", "and", $ic['handling_unit']);
                        $goods_category = str_replace(";", "", $goods_category);
                        if ($isReturnOrder && $ic['load_plan_connote'] != "") {
                            $rscode = trim($ic['load_plan_connote']);
                            $rs = $ci->common->gettblrowdata(
                                array("reason_code" => $rscode),
                                'reason_name',
                                "tb_return_reasons",
                                0,
                                0
                            );
                            if (count($rs) > 0) {
                                $return_reason = $rs['reason_name'];
                            }
                        }
                        $cargo_id = $ic['carid'];
                        /*check forward order if it is return order*/
                        $item_order_id = $ord['id'];
                        if ($isReturnOrder) {
                            $chkxsr = [
                                'reference_id' => 'XSR',
                                'order_id' => $item_order_id,
                                'status' => 1
                            ];
                            $chkxsrqry = $ci->common->gettblrowdata($chkxsr, "ref_value", "tb_order_references", 0, 0);
                            if (count($chkxsrqry) > 0) {
                                $chkpo = array(
                                    'reference_id' => "PO",
                                    'ref_value' => $chkxsrqry['ref_value'],
                                    "status" => 1
                                );
                                $chkordqry = $ci->common->gettblrowdata(
                                    $chkpo,
                                    "order_id",
                                    "tb_order_references",
                                    0,
                                    0
                                );
                                if (count($chkordqry) > 0) {
                                    $item_order_id = $chkordqry['order_id'];
                                }
                            }
                        }
                        $select = 'cargo_type, goods_description, color_code, color_code_name, '
                            . 'size_code,size_name, pattern_length_code, pattern_length_name, '
                            . 'unit_price, d_hsn_code, igst_rate, sgst_rate, cgst_rate, '
                            . 'igst_amount, sgst_amount, cgst_amount';
                        if ($item_order_id == $ord['id']) {
                            $whereInnerCargo = [
                                'cargo_id' => $cargo_id,
                                'item_order_id' => $item_order_id,
                                'status' => 1
                            ];
                            $inncargoData = $ci->common->gettbldata($whereInnerCargo, $select, "tb_inner_cargo", 0, 0);
                        } else {
                            $orditems = [$item_order_id, $ord['id']];
                            $where_in = [
                                'col' => 'item_order_id',
                                'arr' => $orditems
                            ];
                            $whereInnerCargo = [
                                'cargo_id' => $cargo_id,
                                'status' => 1
                            ];
                            $inncargoData = $ci->common->gettbldata_where_in(
                                $whereInnerCargo,
                                $where_in,
                                $select,
                                "tb_inner_cargo",
                                0,
                                0
                            );
                        }
                        $images = $color = $reason = "";
                        $brand = $ic['cargo_type'];
                        $descr = $ic['goods_description'];
                        if (count($inncargoData) > 0) {
                            foreach ($inncargoData as $inncargo) {
                                $color = $inncargo['color_code_name'];
                                $descr = $inncargo['goods_description'];
                                $brand = $inncargo['cargo_type'];
                                $commodity_value += $inncargo['unit_price'];
                                if ($isReturnOrder) {
                                    $reason = str_replace("&", "and", $return_reason);
                                } else {
                                    $reason = str_replace("&", "and", $inncargo['pattern_length_name']);
                                }
                                $cgst_amount += $inncargo['cgst_amount'];
                                $sgst_amount += $inncargo['sgst_amount'];
                                $igst_amount += $inncargo['igst_amount'];
                                $sgst_rate += $inncargo['sgst_rate'];
                                $cgst_rate += $inncargo['cgst_rate'];
                                $igst_rate += $inncargo['igst_rate'];
                                $hsn_code = $inncargo['d_hsn_code'];
                            }
                        }
                        $descr = str_replace("&", "and", $descr);
                        $descr = str_replace(";", "", $descr);
                        $brand = str_replace("&", "and", $brand);
                        $brand = str_replace(";", "", $brand);
                        if ($ic['cargo_content'] != "") {
                            $goods_content = str_replace("&", "and", $ic['cargo_content']);
                            $goods_content = str_replace(";", "", $goods_content);
                        }

                        $specialInstructions = $goods_content;
                        if ($isReturnOrder) {
                            $specialInstructions = "Tag to be attached to the garment";
                        }

                        $itemqty = round($ic['quantity']);

                        log_error(UNIQLO_LOG_PREFIX . "Uniqloediservices SI 406 " . $specialInstructions);

                        $items[] = array(
                            "images" => $images,
                            "color" => $color,
                            "reason" => $reason,
                            "descr" => $descr,
                            "ean" => $ic['qr_code'],
                            "imei" => "",
                            "brand" => $isReturnOrder ? 'UNIQLO' : $brand,
                            "pcat" => "",
                            "si" => $specialInstructions,
                            "item_quantity" => $itemqty
                        );
                    }
                }
                $cargos = array('item' => $items);
                $extra_parameters = array("return_reason" => $return_reason);
                $address_type = "office";
                $consignee_party_type = 3;
                $whr = [
                    'name' => 'Consignee',
                    'company_code' => $ord['company_code'],
                    'branch_code' => $ord['branch_code'],
                    'status' => 1
                ];
                $select = "id";
                $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
                if (count($partyqry) > 0) {
                    $consignee_party_type = $partyqry['id'];
                }
                $state = $phone = $city = "";
                $cust_party_type = 5;
                $whr = [
                    'name' => 'Customer',
                    'company_code' => $ord['company_code'],
                    'branch_code' => $ord['branch_code'],
                    'status' => 1
                ];
                $select = "id";
                $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
                if (count($partyqry) > 0) {
                    $cust_party_type = $partyqry['id'];
                }
                $whr = "p.id=c.party_id";
                $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $cust_party_type, "c.status" => 1);
                $select = "p.id";
                $customer = $ci->common->getjointbldata(
                    "tbl_party_master p",
                    "tb_order_parties c",
                    $whr,
                    $whr1,
                    $select,
                    1,
                    0
                );
                if (count($customer) > 0) {
                    $custs = $customer[0];
                    $sendwh1 = $this->createwarehouse($custs['id']);
                }
                $whr = "p.id=c.party_id";
                $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $cust_party_type, "c.status" => 1);
                $select = "p.id,p.name,p.mobile,p.address,p.state,p.pincode,p.country,p.location_id";
                $customer = $ci->common->getjointbldata(
                    "tbl_party_master p",
                    "tb_order_parties c",
                    $whr,
                    $whr1,
                    $select,
                    1,
                    0
                );
                if (count($customer) > 0) {
                    $custs1 = $customer[0];
                    if (!is_numeric($custs1['mobile'])) {
                        $custs1['mobile'] = "9871605533";
                    }
                    $custaddrarr = explode(",", $custs1['address']);
                    $custaddrtrim = array_map("trim", $custaddrarr);
                    $custaddr = array_unique($custaddrtrim);
                    $custs1['address'] = implode(", ", $custaddr);
                    $custs1['address'] = str_replace("&", "and", $custs1['address']);
                    $custs1['address'] = str_replace(";", "", $custs1['address']);
                    $custs1['location_id'] = str_replace("&", "and", $custs1['location_id']);
                    $custs1['location_id'] = str_replace(";", "", $custs1['location_id']);
                    $request['pickup_location'] = array(
                        'name' => $custs1['name'],
                        'city' => $custs1['location_id'],
                        'pin' => $custs1['pincode'],
                        'country' => $custs1['country'],
                        'phone' => $custs1['mobile'],
                        'add' => $custs1['address']
                    );
                }
                $devaddr = "";
                $delivcmp = "";
                $country = "India";
                $whr = "p.id=c.party_id";
                $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $consignee_party_type, "c.status" => 1);
                $select = "p.id,p.name,p.mobile,p.state,p.country,p.location_id,p.address,p.partyindetifier";
                $consignee = $ci->common->getjointbldata(
                    "tbl_party_master p",
                    "tb_order_parties c",
                    $whr,
                    $whr1,
                    $select,
                    1,
                    0
                );
                if (count($consignee) > 0) {
                    $cons = $consignee[0];
                    if ($isReturnOrder && $cons['partyindetifier'] == "") {
                        $sendwh1 = $this->createwarehouse($cons['id']);
                        $select = "p.id,p.name,p.mobile,p.state,p.country,p.location_id,p.address,p.partyindetifier";
                        $consignee = $ci->common->getjointbldata(
                            "tbl_party_master p",
                            "tb_order_parties c",
                            $whr,
                            $whr1,
                            $select,
                            1,
                            0
                        );
                        if (count($consignee) > 0) {
                            $cons = $consignee[0];
                        }
                    }
                    $state = $cons['state'];
                    $country = $cons['country'];
                    $phone = $cons['mobile'];
                    $delivcmp = $cons['name'];
                    $delivcmp = str_replace("&", "and", $delivcmp);
                    $delivcmp = str_replace(";", "", $delivcmp);
                    $devaddr = $cons['address'];
                    $consigneraddrarr = explode(",", $devaddr);
                    $consignaddrtrim = array_map("trim", $consigneraddrarr);
                    $consignaddr = array_unique($consignaddrtrim);
                    $devaddr = implode(", ", $consignaddr);
                    $devaddr = str_replace("&", "and", $devaddr);
                    $devaddr = str_replace(";", "", $devaddr);
                    if ($phone == "8888") {
                        $phone = "9871605533";
                    }
                    $city = $cons['location_id'];
                    if ($state == "") {
                        $state = $city;
                    }
                }
                $partyindetifier = DELHIVERY_CLIENT;
                $ord['delivery_address1'] = $ord['delivery_address1'] . ", " . $ord['delivery_address2'];
                $ord['pickup_datetime'] = date("Y-m-d H:i:s");
                if ($isReturnOrder) {
                    $ord['delivery_address1'] = $ord['pickup_address1'] . ", " . $ord['pickup_address2'];
                    $whphone = $phone;
                    if ($whphone == "") {
                        $whphone = "9871605533";
                    }
                    $phone = isset($request['pickup_location']['phone']) ? $request['pickup_location']['phone'] : "";
                    $devpincode = $ord['delivery_pincode'];
                    $ord['delivery_company'] = $ord['vendor_name'];
                    $ord['delivery_pincode'] = $ord['pickup_pincode'];
                    if ($delivcmp == "") {
                        $delivcmp = "KN JKS LOGISTICS PARK WH2";
                    }
                    $city = $ord['pickup_city'];
                    $city = str_replace("&", "and", $city);
                    $city = str_replace(";", "", $city);
                    $country = $ord['pickup_country'];
                    $ord['delivery_city'] = str_replace("&", "and", $ord['delivery_city']);
                    $ord['delivery_city'] = str_replace(";", "", $ord['delivery_city']);
                    $request['pickup_location'] = array(
                        'name' => $delivcmp,
                        'city' => $ord['delivery_city'],
                        'pin' => $devpincode,
                        'country' => $ord['delivery_country'],
                        'phone' => $whphone,
                        'add' => $devaddr
                    );
                    $weight = $ord['weight'];
                    $quantity = $ord['quantity'];
                }
                $goods_value = $ord['goods_value'];
                if ($goods_value < 5 || $goods_value == "") {
                    $goods_value = $commodity_value;
                }
                /*remove weight height and length as said by sagar uniqlo "shipment_height"=>$height, "shipment_width"=>$width, "shipment_length"=>$length, */
                $ord['delivery_company'] = str_replace("&", "and", $ord['delivery_company']);
                $ord['delivery_address1'] = str_replace("&", "and", $ord['delivery_address1']);
                $ord['delivery_address1'] = str_replace(";", "", $ord['delivery_address1']);
                $deliveraddrarr = explode(",", $ord['delivery_address1']);
                $deliveraddrtrim = array_map("trim", $deliveraddrarr);
                $deliveraddr = array_unique($deliveraddrtrim);
                $ord['delivery_address1'] = implode(", ", $deliveraddr);
                $shipments[] = array(
                    'add' => $ord['delivery_address1'],
                    'address_type' => $address_type,
                    'phone' => $phone,
                    'payment_mode' => $payment_mode,
                    'name' => $ord['delivery_company'],
                    'pin' => $ord['delivery_pincode'],
                    'order' => $ord['order_id'],
                    "consignee_gst_amount" => "",
                    "integrated_gst_amount" => "",
                    "ewbn" => "",
                    "consignee_gst_tin" => "",
                    "seller_gst_tin" => "",
                    "client_gst_tin" => "",
                    "hsn_code" => $hsn_code,
                    "gst_cess_amount" => "",
                    "client" => $partyindetifier,
                    "tax_value" => "",
                    "seller_tin" => "",
                    "seller_gst_amount" => "",
                    "seller_inv" => "",
                    "city" => $city,
                    "commodity_value" => $goods_value,
                    "weight" => $weight,
                    "return_state" => $return_state,
                    "document_number" => "",
                    "od_distance" => "",
                    "sales_tax_form_ack_no" => "",
                    "document_type" => "",
                    "seller_cst" => "",
                    "seller_name" => "",
                    "fragile_shipment" => "",
                    "return_city" => $return_city,
                    "return_phone" => $return_phone,
                    "qc" => $cargos,
                    "category_of_goods" => $goods_category,
                    "cod_amount" => 0,
                    "return_country" => $return_country,
                    "document_date" => "",
                    "taxable_amount" => "",
                    "products_desc" => $goods_content,
                    "state" => $state,
                    "dangerous_good" => "False",
                    "waybill" => "",
                    "consignee_tin" => "",
                    "order_date" => $ord['pickup_datetime'],
                    "return_add" => $return_add,
                    "total_amount" => $goods_value,
                    "seller_add" => "",
                    "country" => $country,
                    "return_pin" => $return_pin,
                    "extra_parameters" => $extra_parameters,
                    "return_name" => "",
                    "supply_sub_type" => "",
                    "plastic_packaging" => "false",
                    "quantity" => $quantity
                );
            }
            $request['shipments'] = $shipments;
            $ordersinfo[] = $request;
        }

        log_error(UNIQLO_LOG_PREFIX . "getshipformateddata outbound data: " . json_encode($ordersinfo));

        return $ordersinfo;
    }

    public function senddocketnumber($orderid)
    {
        $sftpMaxAttempts = 3;
        $sftpRetries = 1;

        $ci = &get_instance();
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "senddocketnumber inbound data: " . $orderid);

        if ($orderid != "") {
            $details = $this->getdocketnumdetails($orderid);
            if (!empty($details)) {
                $request = "";
                $ReceiverInstance = SWIFLOG_SYS;
                $ReceiverId = 'SWIFT';
                $OrderType = $details['header']['order_type'];
                $request .= "<?xml version='1.0' encoding='UTF-8'?>
                <oor:OutboundOrderRequest xmlns:oor='http://kn.swift/outboundorderrequest/0200' xmlns:adr='http://kn.swiftlog/address/0200' xmlns:ooh='http://kn.swiftlog/outboundorderrequestheader/0200' xmlns:ohn='http://kn.swiftlog/orderheadernote/0200' xmlns:ool='http://kn.swiftlog/outboundorderrequestline/0200' xmlns:oln='http://kn.swiftlog/orderlinenote/0200' xmlns:cmn='http://kn.swiftlog/commontypes/0200' xmlns:rou='http://kn.swiftlog/routing/0200' xmlns:kn='http://knie4.int.kn/ns/kn' xmlns:javauuid='java:java.util.UUID'>
                	<rou:Routing>
						<rou:Uuid>" . $details['header']['uuid'] . "</rou:Uuid>
						<rou:JMSCorrelationID>" . $details['header']['correlationid'] . "</rou:JMSCorrelationID>
						<rou:KNESB_Routing_Country>" . $details['header']['country'] . "</rou:KNESB_Routing_Country>
						<rou:KNESB_Routing_Warehouse>" . $details['header']['warehouse'] . "</rou:KNESB_Routing_Warehouse>
						<rou:KNESB_Routing_Client>" . $details['header']['client'] . "</rou:KNESB_Routing_Client>
						<rou:KNESB_Routing_ReceiverId>" . $ReceiverId . "</rou:KNESB_Routing_ReceiverId>
						<rou:KNESB_Routing_ReceiverInstance>" . $ReceiverInstance . "</rou:KNESB_Routing_ReceiverInstance>
					</rou:Routing>
					<MessageType>OutboundOrderRequest</MessageType>
					<MessageVersion>0200</MessageVersion>
					<ProcessMode>C</ProcessMode>
					<OutboundOrder>
					    <ooh:OutboundOrderRequestHeader>
					        <Warehouse>" . $details['shipment']['warehouse'] . "</Warehouse>
					        <Client>" . $details['shipment']['client'] . "</Client>
					        <OrderNumber>" . $details['shipment']['ordernumber'] . "</OrderNumber>
					        <OrderType>" . $OrderType . "</OrderType>
					        <DeliveryNumber>" . $details['shipment']['delivery_note'] . "</DeliveryNumber>
					    </ooh:OutboundOrderRequestHeader>
					    <ohn:OrderHeaderNote>
							<OrderNumber>" . $details['shipment']['ordernumber'] . "</OrderNumber>
							<Sequence>0075</Sequence>
							<NoteType>" . $details['shipment']['carriertype'] . "</NoteType>
							<NoteText>" . $details['shipment']['carrier'] . "</NoteText>
						</ohn:OrderHeaderNote>
					</OutboundOrder>
				</oor:OutboundOrderRequest>";
                $rndnum = mt_rand(100000000, 999999999);
                $filename = "OutboundOrderRequestV0200_IN_" . $details['shipment']['warehouse'] . "_UNIQLOE_" . $rndnum . ".xml";
                $localfile = "./assets/swiftlog/" . $filename;
                if (!file_exists(dirname($localfile))) {
                    mkdir(dirname($localfile), 0700, true);
                }
                @file_put_contents($localfile, $request);
                $folder_name = "/pub/inbound/uniqlo/etnundocnoupdate";
                $sftp_url = SWIFLOG_FTP;
                $username = SWIFLOG_FTP_USER;
                $password = SWIFLOG_FTP_PWD;
                do {
                    try {
                        $this->sftpConnection = new SFTP($sftp_url);
                        if (!$this->sftpConnection->login($username, $password)) {
                            unset($this->sftpConnection);
                            log_error(
                                UNIQLO_LOG_PREFIX . "senddocketnumber - Cannot authorize on MFT server: " . $sftp_url
                            );

                            return "not connected";
                        } else {
                            $this->sftpConnection->chdir($folder_name);
                            $this->sftpUpload($folder_name . "/" . $filename, $localfile);
                            log_error(
                                UNIQLO_LOG_PREFIX . "senddocketnumber - File sent to MFT server: " . $filename
                            );
                            return "connected";
                        }
                    } catch (Exception $ex) {
                        log_error(
                            UNIQLO_LOG_PREFIX . "senddocketnumber - Some problems occured during the transfer of ". $filename
                                    . " to MTF server #" . $sftpRetries
                        );
                        $sftpRetries++;
                        switch($sftpRetries) {
                            case 2:
                                $sleep = 3;
                            case 3:
                                $sleep = 6;
                            default:
                                $sleep = 1;
                        }
                        sleep($sleep);
                        continue;
                    }
                    unset($this->sftpConnection);
                    break;
                } while($sftpRetries <= $sftpMaxAttempts);
            }
        }
    }

    public function getdocketnumdetails($orderid)
    {
        $data = array();
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "getdocketnumdetails inbound data: " . $orderid);

        $whr = array("id" => $orderid);
        $select = "id,order_id,vendor_id,created_source,physicalsender,physicalreceiver";
        $ord = $ci->common->gettblrowdata($whr, $select, "tb_orders", 0, 0);
        if (count($ord) > 0) {
            $refs = $ci->common->gettbldata(
                array("order_id" => $ord['id']),
                "reference_id,ref_value",
                "tb_order_references",
                0,
                0
            );
            $uuid = $correlationid = $warehouse = $ordernum = $awb = "";
            if (count($refs) > 0) {
                foreach ($refs as $ref) {
                    if ($ref['reference_id'] == "UUID") {
                        $uuid = $ref['ref_value'];
                    }
                    if ($ref['reference_id'] == "CORID") {
                        $correlationid = $ref['ref_value'];
                    }
                    if ($ref['reference_id'] == "WH") {
                        $warehouse = $ref['ref_value'];
                    }
                    if ($ref['reference_id'] == "DQ") {
                        $ordernum = $ref['ref_value'];
                    }
                    if ($ref['reference_id'] == "AWB") {
                        $awb = $ref['ref_value'];
                    }
                }
            }
            $ordtype = "SO";
            if ($ord['created_source'] == $this->returnOrderTypeId) {
                $ordtype = "Return";
            } elseif ($ord['created_source'] == $this->forwardOrderTypeId) {
                $orddetail = $ci->db->query(
                    "SELECT o.id,t.ordtype_code FROM tb_order_details o,tb_order_types t WHERE o.order_type=t.id AND o.order_row_id='" . $ord['id'] . "' AND t.ordtype_code='CC' LIMIT 1"
                );
                if ($orddetail->num_rows() > 0) {
                    $ordtype = $orddetail->row()->ordtype_code;
                }
            }
            if ($uuid == "") {
                $uuidrdm = $this->uuidgenerate();
                $uuid = $correlationid = $uuidrdm;
            }
            $data['header'] = array(
                'uuid' => $uuid,
                'correlationid' => $correlationid,
                'country' => 'IN',
                'warehouse' => $warehouse,
                'client' => $ord['physicalsender'],
                'receiver' => $ord['physicalreceiver'],
                'receiverinstance' => '',
                'order_type' => $ordtype
            );
            $ord_type = "C";
            $carriertype = "DELIVERY_CARRIER";
            $carrier = "DELHIVERY";
            if ($ord['vendor_id'] > 0) {
                $whr = array("id" => $ord['vendor_id']);
                $select = "name";
                $carr = $ci->common->gettblrowdata($whr, $select, "tb_vendors", 0, 0);
                if (count($carr) > 0) {
                    if ($carr['name'] == "ECOM EXPRESS") {
                        $carrier = "ECOM";
                    } elseif ($carr['name'] == "EXPRESSBEES") {
                        $carrier = "EXPRESSBEES";
                    } elseif ($carr['name'] == "BLOWHORN") {
                        $carrier = "BLOWHORN";
                    }
                }
            }
            if ($ordtype == "CC") {
                $carrier = "K+N";
            } elseif ($awb == "" && ($ordtype == "SO" || $ordtype == "Return")) {
                $carrier = "NOC";
            }
            $whr = array("order_row_id" => $ord['id']);
            $select = "order_type,service,delivery_note,purchase_order,customs_required,department_code,warehouse,client,ord_num,po_type,po_date,cust_payment,shipmentby,delivery_request,rush_flag,shipment_id";
            $orddet = $ci->common->gettblrowdata($whr, $select, "tb_order_details", 0, 0);
            $data['shipment'] = array(
                'warehouse' => '',
                'client' => '',
                'ordernumber' => '',
                'ord_type' => $ord_type,
                'purchase_order' => '',
                'po_type' => '',
                'po_date' => '',
                'cust_payment' => '',
                'delivery_request' => '',
                'rush_flag' => '',
                'shipment_id' => '',
                'deliver_contact' => '',
                'service' => '',
                'delivery_note' => '',
                'customs_required' => '',
                'carriertype' => $carriertype,
                'carrier' => $carrier
            );
            if (count($orddet) > 0) {
                $service = "";
                if ($carrier == "NOC") {
                    $orddet['delivery_note'] = "";
                } else {
                    if ($orddet['delivery_note'] == "") {
                        if ($ordtype == "CC") {
                            $orddet['delivery_note'] = $ord['order_id'];
                        } elseif ($awb != "") {
                            $orddet['delivery_note'] = $awb;
                        }
                    }
                }
                $data['shipment'] = array(
                    'warehouse' => $warehouse,
                    'client' => $ord['physicalsender'],
                    'ordernumber' => $orddet['ord_num'],
                    'ord_type' => $ord_type,
                    'purchase_order' => $orddet['purchase_order'],
                    'po_type' => $orddet['po_type'],
                    'po_date' => $orddet['po_date'],
                    'cust_payment' => $orddet['cust_payment'],
                    'delivery_request' => $orddet['delivery_request'],
                    'rush_flag' => $orddet['rush_flag'],
                    'shipment_id' => $orddet['shipment_id'],
                    'deliver_contact' => $orddet['shipmentby'],
                    'service' => $service,
                    'delivery_note' => $orddet['delivery_note'],
                    'customs_required' => $orddet['customs_required'],
                    'carriertype' => $carriertype,
                    'carrier' => $carrier
                );
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getdocketnumdetails outbound data: " . json_encode($data));

        return $data;
    }

    public function uuidgenerate()
    {
        return sprintf(
            '%04x%04x-%04x-%04x-%04x-%04x%04x%04x', /*32 bits for "time_low"*/
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff), /*16 bits for "time_mid"*/
            mt_rand(0, 0xffff), /*16 bits for "time_hi_and_version",
            four most significant bits holds version number 4*/
            mt_rand(0, 0x0fff) | 0x4000, /*16 bits, 8 bits for "clk_seq_hi_res",
            8 bits for "clk_seq_low",
            two most significant bits holds zero and one for variant DCE1.1*/
            mt_rand(0, 0x3fff) | 0x8000, /*48 bits for "node"*/
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff)
        );
    }

    public function createwarehouse($id)
    {
        $whresponse = "";
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "createwarehouse inbound data: " . $id);

        /*if(!empty($clientwh)){*/
        $party = $ci->common->gettblrowdata(
            array("id" => $id),
            "id,name,email,mobile,code,location_id,address,country,state,pincode",
            "tbl_party_master",
            0,
            0
        );
        $clientwh = array(
            'id' => $party['id'],
            'mobile' => $party['mobile'],
            'location_id' => $party['location_id'],
            'name' => $party['name'],
            'pincode' => $party['pincode'],
            'address' => $party['address'],
            'country' => $party['country'],
            'email' => $party['email'],
            'code' => $party['code'],
            'state' => $party['state']
        );
        $whdata = [
            'phone' => $clientwh['mobile'],
            'city' => $clientwh['location_id'],
            'name' => $clientwh['name'],
            'pin' => $clientwh['pincode'],
            'address' => $clientwh['address'],
            'country' => $clientwh['country'],
            'email' => $clientwh['email'],
            'registered_name' => $clientwh['code'],
            'return_address' => $clientwh['address'],
            'return_pin' => $clientwh['pincode'],
            'return_city' => $clientwh['location_id'],
            'return_state' => $clientwh['state'],
            'return_country' => $clientwh['country']
        ];
        $reqdata = json_encode($whdata);
        $reqdata = str_replace('\"', '', $reqdata);
        $api_token = DELHIVERY_AUTH_TOKEN;
        $server_url = DELHIVERY_WH_CREATE;
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($server_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $config = [
            'follow_redirects' => true,
            'ssl_verify_peer' => false,
            'connect_timeout' => 100,
            'timeout' => 120
        ];
        if (ENVIRONMENT !== "development") {
            $config['proxy'] = PROXY_CONSTANT_HERE;
        }
        $request->setConfig($config);
        $request->setHeader(array(
                                'Authorization' => "Token " . $api_token,
                                'Content-Type' => 'application/json',
                                'Accept' => 'application/json'
                            ));
        $request->setBody($reqdata);

        log_error(
            UNIQLO_LOG_PREFIX . 'createwarehouse connecting with API: ' . $server_url . ' with payload ' . $reqdata
        );

        try {
            $response = $request->send();
            $resp = $response->getBody();

            log_error(
                UNIQLO_LOG_PREFIX . 'createwarehouse API response payload: ' . $resp
            );

            $pinresp = json_decode($resp, true);
            if (!empty($pinresp)) {
                /*update waybill*/
                if (isset($pinresp['success']) && $pinresp['success'] == 'true') {
                    $whresp = $pinresp['data'];
                    if ($whresp['active'] == 'true') {
                        $set = array("partyindetifier" => $whresp['client']);
                        $whr = array("id" => $clientwh['id']);

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "createwarehouse updated data in a tbl_party_master: " . json_encode($set)
                        );

                        $upd = $ci->common->updatetbledata("tbl_party_master", $set, $whr);
                        /* add working hours */
                        $whrs = $whresp['working_hours'];
                        if (!empty($whrs)) {
                            $carrier = $ci->common->gettblrowdata(
                                array("name" => "Delhivery"),
                                "id",
                                "tb_vendors",
                                0,
                                0
                            );
                            foreach ($whrs as $key => $wh) {
                                $ins = array(
                                    "client_id" => $clientwh['id'],
                                    "carrier_id" => $carrier['id'],
                                    "day_name" => $key,
                                    "start_time" => $wh['start_time'],
                                    "close_time" => $wh['close_time']
                                );
                                $whr = array(
                                    "client_id" => $clientwh['id'],
                                    "day_name" => $key,
                                    "start_time" => $wh['start_time'],
                                    "close_time" => $wh['close_time']
                                );
                                $select = "id";
                                $refqry = $ci->common->gettblrowdata($whr, $select, "kn_wh_work_hours", 0, 0);
                                if (count($refqry) > 0) {
                                    $whr1 = array("id" => $refqry['id']);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "createwarehouse updated data in a kn_wh_work_hours: " . json_encode($whr)
                                    );

                                    $srefqryins = $ci->common->updatetbledata('kn_wh_work_hours', $whr, $whr1);
                                } else {
                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "createwarehouse inserted data in a kn_wh_work_hours: " . json_encode($ins)
                                    );

                                    $srefqryins = $ci->common->insertTableData('kn_wh_work_hours', $ins);
                                }
                            }
                        }
                        $whresponse = "Success";
                    } else {
                        $whresponse = "Failed";
                    }
                } elseif (isset($pinresp['error_code'][0]) && $pinresp['error_code'][0] == '2000') {
                    $whresp = $pinresp['data'];
                    if (isset($whresp['name']) && $whresp['name'] != '') {
                        $set = array("partyindetifier" => $whresp['name']);
                        $whr = array("id" => $clientwh['id']);

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "createwarehouse updated data in a tbl_party_master: " . json_encode($set)
                        );

                        $upd = $ci->common->updatetbledata("tbl_party_master", $set, $whr);
                        /* add working hours */
                        $whrs = isset($whresp['working_hours']) ? $whresp['working_hours'] : array();
                        if (!empty($whrs)) {
                            $carrier = $ci->common->gettblrowdata(
                                array("name" => "DELHIVERY"),
                                "id",
                                "tb_vendors",
                                0,
                                0
                            );
                            foreach ($whrs as $key => $wh) {
                                $ins = array(
                                    "client_id" => $clientwh['id'],
                                    "carrier_id" => $carrier['id'],
                                    "day_name" => $key,
                                    "start_time" => $wh['start_time'],
                                    "close_time" => $wh['close_time']
                                );
                                $whr = array(
                                    "client_id" => $clientwh['id'],
                                    "day_name" => $key,
                                    "start_time" => $wh['start_time'],
                                    "close_time" => $wh['close_time']
                                );
                                $select = "id";
                                $refqry = $ci->common->gettblrowdata($whr, $select, "kn_wh_work_hours", 0, 0);
                                if (count($refqry) > 0) {
                                    $whr1 = array("id" => $refqry['id']);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "createwarehouse updated data in a kn_wh_work_hours: " . json_encode($whr)
                                    );

                                    $srefqryins = $ci->common->updatetbledata('kn_wh_work_hours', $whr, $whr1);
                                } else {
                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "createwarehouse inserted data in a kn_wh_work_hours: " . json_encode($ins)
                                    );

                                    $srefqryins = $ci->common->insertTableData('kn_wh_work_hours', $ins);
                                }
                            }
                        }
                        $whresponse = "Success";
                    }
                }
            } else {
                $whresponse = 'Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $whresponse = 'Error: ' . $e->getMessage();
        }

        log_error(UNIQLO_LOG_PREFIX . "createwarehouse outbound data: " . $whresponse);

        return $whresponse;
    }

    public function fetchawb($ordtype)
    {
        $ci = &get_instance();
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "fetchawb inbound data: " . $ordtype);

        $server_url = ECOM_EXP_FETCH_AWB;
        $username = ECOM_EXP_UNAME;
        $password = ECOM_EXP_PWD;
        $proxy = defined('VZEN_PROXY') ? VZEN_PROXY : '';
        $method = 'POST';
        $headers = [];
        $request = 'username=' . $username . '&password=' . $password . '&count=1&type=' . $ordtype;

        $ecomResponse = curlRequestor(
            $server_url,
            $method,
            $request,
            $proxy,
            $headers,
            retryDecider(),
            retryDelay()
        );
        $resp = $ecomResponse['body'];

        log_error(
            UNIQLO_LOG_PREFIX . 'forwardmanifestation API response payload: ' . json_encode($resp)
        );

        if ($ecomResponse['respCode'] === 200) {
            log_error(
                UNIQLO_LOG_PREFIX . 'EcomExpress fetch API request for order type '
                . $ordtype . ' succeeded.'
            );
        } else {
            log_error(
                UNIQLO_LOG_PREFIX . 'EcomExpress tracking API request for order type '
                . $ordtype . ' failed with: ' . $ecomResponse['curlError']
            );
        }
        return $resp;
    }

    public function forwardmanifestation($shipmentid = null)
    {
        $status = 0;
        $postresp = "no data";
        if ($shipmentid != "") {
            $ci = &get_instance();
            $ci->load->helper('log_helper');
            $ci->load->model("common");
            /* check forward or return order*/
            $whr = array("shift_id" => $shipmentid, "trip_sts" => 0, "status <>" => 0);
            $ordinfo = $ci->common->gettblrowdata($whr, "*", "tb_orders", 0, 0);
            if (count($ordinfo) > 0) {
                if ($ordinfo['created_source'] == $this->forwardOrderTypeId) {
                    $shipdata = $this->getecomshipformateddata($ordinfo);
                    $server_url = ECOM_EXP_FMANFEST_AWB;
                } else {
                    $shipdata = $this->getshiprevformateddata($ordinfo);
                    $server_url = ECOM_EXP_RMANFEST_AWB;
                }

                if (!empty($shipdata)) {
                    $ordid = $shipdata['order_id'];
                    $misc = $shipdata['misc'];
                    unset($shipdata['misc']);
                    unset($shipdata['order_id']);
                    if (!empty($shipdata['shipments'])) {
                        $reqdata = json_encode($shipdata['shipments']);
                        $reqdata = $edi_request = str_replace('\"', '', $reqdata);
                        $company_code = isset($misc['company_code']) ? $misc['company_code'] : "INKN";
                        $branch_code = isset($misc['branch_code']) ? $misc['branch_code'] : "INCL";
                        $user_id = isset($misc['user_id']) ? $misc['user_id'] : "244";
                        $edi_response = "No pincodes availability";
                        $edi_id = 9;
                        $edi_name = "Ecom Express";
                        $params = array(
                            'edi_type' => 1,
                            'transaction_id' => time(),
                            'edi_id' => $edi_id,
                            'edi_name' => $edi_name,
                            'bounded_type' => 2,
                            'edi_format_type' => 'json',
                            'status' => $status,
                            'obj_type' => 1,
                            'txn_obj_id' => $ordid,
                            'user_id' => $user_id,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'edi_request' => $edi_request,
                            'edi_response' => $edi_response
                        );

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "forwardmanifestation inserted data in a tb_etn_edi_transactions: " . json_encode($params)
                        );

                        $edilogid = $ci->common->insertTableData('tb_etn_edi_transactions', $params);
                        $username = ECOM_EXP_UNAME;
                        $password = ECOM_EXP_PWD;
                        $method = 'POST';
                        $headers = [];
                        $request = 'username=' . $username . '&password=' . $password . '&json_input=' . $reqdata;
                        $proxy = defined('VZEN_PROXY') ? VZEN_PROXY : '';

                        $ecomResponse = curlRequestor(
                            $server_url,
                            $method,
                            $request,
                            $proxy,
                            $headers,
                            retryDecider(),
                            retryDelay()
                        );
                        $resp = json_decode($ecomResponse['body'], true);

                        log_error(
                            UNIQLO_LOG_PREFIX . 'forwardmanifestation API response payload: ' . json_encode($resp)
                        );

                        if ($ecomResponse['respCode'] === 200) {
                            log_error(
                                UNIQLO_LOG_PREFIX . 'EcomExpress manifest API request for data '
                                . $reqdata . ' succeeded.'
                            );
                        } else {
                            log_error(
                                UNIQLO_LOG_PREFIX . 'EcomExpress manifest API request for data '
                                . $reqdata . ' failed with: ' . $ecomResponse['curlError']
                            );
                        }

                        if (!empty($resp)) {
                            $edi_response = json_encode($resp);
                            if (isset($resp['shipments'])) {
                                $respc = isset($resp['shipments'][0]) ? $resp['shipments'][0] : array();
                                if ($respc['success']) {
                                    $status = 1;
                                    $curdt = date("Y-m-d H:i:s");
                                    $waybill = $respc['awb'];
                                    $postresp = $waybill;
                                    $updwhr = array("order_row_id" => $ordid);
                                    $updset = array("delivery_note" => $waybill);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "forwardmanifestation updated data in a tb_order_details: " .
                                        json_encode($updset)
                                    );

                                    $upd = $ci->common->updatetbledata("tb_order_details", $updset, $updwhr);
                                    $whr = array(
                                        "order_id" => $ordid,
                                        "reference_id" => "AWB",
                                        "ref_value" => $waybill,
                                        "status" => 1
                                    );
                                    $chk = $ci->common->gettblrowdata($whr, "id", "tb_order_references", 0, 0);
                                    if (count($chk) == 0) {
                                        $insarr = array(
                                            "order_id" => $ordid,
                                            "reference_id" => "AWB",
                                            "ref_value" => $waybill,
                                            "createdon" => $curdt,
                                            "status" => 1
                                        );

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "forwardmanifestation inserted data in a tb_order_references: " .
                                            json_encode($insarr)
                                        );

                                        $ins = $ci->common->insertTableData("tb_order_references", $insarr);
                                    }
                                    /*update vendor id*/
                                    $vend = $ci->common->gettblrowdata(
                                        array("mobile" => "ECOMEXPRESS"),
                                        "id",
                                        "tb_vendors",
                                        0,
                                        0
                                    );
                                    $upd = array("vendor_id" => $vend['id']);
                                    $whr = array("id" => $ordid);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "forwardmanifestation updated data in a tb_orders: " . json_encode($upd)
                                    );

                                    $updqry = $ci->common->updatetbledata("tb_orders", $upd, $whr);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "forwardmanifestation updated data in a tb_shifts: " . json_encode($upd)
                                    );

                                    $updqry = $ci->common->updatetbledata("tb_shifts", $upd, array("id" => $shipmentid)
                                    );

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "forwardmanifestation updated data in a tb_employee: " . json_encode($upd)
                                    );

                                    $updqry = $ci->common->updatetbledata(
                                        "tb_employee",
                                        $upd,
                                        array("shift_id" => $shipmentid)
                                    );
                                    $senddocket = $this->senddocketnumber($ordid);
                                } else {
                                    $postresp = isset($respc['reason']) ? $respc['reason'] : "";
                                    $replace_str = array('"', "'");
                                    $postresp = str_replace($replace_str, "", $postresp);
                                }
                            } else {
                                if (isset($resp['RESPONSE-OBJECTS'])) {
                                    $awbarr = $resp['RESPONSE-OBJECTS'];
                                    if (isset($awbarr['AIRWAYBILL-OBJECTS'])) {
                                        $airwbill = $awbarr['AIRWAYBILL-OBJECTS'];
                                        if ($airwbill['AIRWAYBILL']['success'] == "True") {
                                            $status = 1;
                                            $waybill = $postresp = $airwbill['AIRWAYBILL']['airwaybill_number'];
                                            $curdt = date("Y-m-d H:i:s");
                                            $updwhr = array("order_row_id" => $ordid);
                                            $updset = array("delivery_note" => $waybill);

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "forwardmanifestation updated data in a tb_order_details: " .
                                                json_encode($updset)
                                            );

                                            $upd = $ci->common->updatetbledata("tb_order_details", $updset, $updwhr);
                                            $whr = array(
                                                "order_id" => $ordid,
                                                "reference_id" => "AWB",
                                                "ref_value" => $waybill,
                                                "status" => 1
                                            );
                                            $chk = $ci->common->gettblrowdata($whr, "id", "tb_order_references", 0, 0);
                                            if (count($chk) == 0) {
                                                $insarr = array(
                                                    "order_id" => $ordid,
                                                    "reference_id" => "AWB",
                                                    "ref_value" => $waybill,
                                                    "createdon" => $curdt,
                                                    "status" => 1
                                                );

                                                log_error(
                                                    UNIQLO_LOG_PREFIX .
                                                    "forwardmanifestation inserted data in a tb_order_references: " .
                                                    json_encode($insarr)
                                                );

                                                $ins = $ci->common->insertTableData("tb_order_references", $insarr);
                                            }
                                            /*update vendor id*/
                                            $vend = $ci->common->gettblrowdata(
                                                array("mobile" => "ECOMEXPRESS"),
                                                "id",
                                                "tb_vendors",
                                                0,
                                                0
                                            );
                                            $upd = array("vendor_id" => $vend['id']);
                                            $whr = array("id" => $ordid);

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "forwardmanifestation updated data in a tb_orders: " . implode(
                                                    ', ',
                                                    $upd
                                                )
                                            );

                                            $updqry = $ci->common->updatetbledata("tb_orders", $upd, $whr);

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "forwardmanifestation updated data in a tb_shifts: " . implode(
                                                    ', ',
                                                    $upd
                                                )
                                            );

                                            $updqry = $ci->common->updatetbledata(
                                                "tb_shifts",
                                                $upd,
                                                array("id" => $shipmentid)
                                            );

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "forwardmanifestation updated data in a tb_employee: " . implode(
                                                    ', ',
                                                    $upd
                                                )
                                            );

                                            $updqry = $ci->common->updatetbledata(
                                                "tb_employee",
                                                $upd,
                                                array("shift_id" => $shipmentid)
                                            );
                                            $senddocket = $this->senddocketnumber($ordid);
                                        } else {
                                            $postresp = $awbarr['RESPONSE-COMMENT'];
                                        }
                                    } else {
                                        $postresp = "Order data wrong";
                                    }
                                } elseif (isset($resp['_error'])) {
                                    $postresp = $resp['_error'];
                                }
                            }
                        } else {
                            $edi_response = "Ecom API Connection Issue";
                            $postresp = "Ecom API Connection Issue";
                        }
                        /* here getting success and return awb number and eTN order number*/
                        $set = array("status" => $status, "edi_response" => $edi_response);
                        $whr = array("id" => $edilogid);

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "forwardmanifestation updated data in a tb_etn_edi_transactions: " . json_encode($set)
                        );

                        $upd = $ci->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
                    }
                }
            }
        }
        $respstatus = array("status" => $status, "data" => $postresp);

        log_error(UNIQLO_LOG_PREFIX . "forwardmanifestation outbound data: " . json_encode($respstatus));

        return $respstatus;
    }

    public function getecomshipformateddata($ord)
    {
        $ci = &get_instance();
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "getecomshipformateddata inbound data: " . json_encode($ord));

        $request = array();
        if (!empty($ord)) {
            $ci->load->model("common");
            $curdt = date("Y-m-d H:i:s");
            $shipments = array();
            $request['order_id'] = $ord['id'];
            $request['misc'] = array(
                'user_id' => $ord['user_id'],
                'company_code' => $ord['company_code'],
                'branch_code' => $ord['branch_code']
            );
            $customerid = $ord['customer_id'];
            $whr = "o.cargo_id=c.id";
            $whr1 = array("o.order_id" => $ord['id'], "o.status" => 1);
            $select = "o.id,o.quantity_type,o.cargo_content,o.volumetric_weight,o.qr_code,c.id as carid,c.cargo_type,c.handling_unit,o.length,c.length_unit,o.width,c.width_unit,o.height,c.height_unit,o.weight,c.weight_unit,o.volume,c.volume_unit,o.quantity,c.goods_description";
            $itemqry = $ci->common->getjointbldata(
                "tb_order_cargodetails o",
                "tb_cargo_details c",
                $whr,
                $whr1,
                $select,
                0,
                0
            );
            $height = $width = $length = $quantity = $weight = $volumetric_weight = $commodity_value = 0;
            $goods_category = $goods_content = "";
            $cgst_amount = $sgst_amount = $igst_amount = $sgst_rate = $cgst_rate = $igst_rate = 0;
            $return_state = $return_city = $return_phone = $return_country = $return_pin = $return_add = "";
            $quantity = round($ord['quantity']);
            $hsn_code = "";
            $weight_unit = "G";
            $additionalinfo = $itemsinfo = array();
            $ranom = substr(str_shuffle("0123456789"), 0, 5);
            if (count($itemqry) > 0) {
                foreach ($itemqry as $ic) {
                    $height += $ic['height'];
                    $weight += $ic['weight'];
                    $width += $ic['width'];
                    if ($ic['weight_unit'] != "") {
                        $weight_unit = $ic['weight_unit'];
                    }
                    $length += $ic['length'];
                    if ($ic['volumetric_weight'] > 0) {
                        $volumetric_weight += $ic['volumetric_weight'];
                    }
                    $goods_category = $ic['quantity_type'];
                    if ($goods_category == "") {
                        $goods_category = $ic['cargo_content'];
                    }
                    $goods_content1 = $ic['cargo_content'];
                    if ($goods_content1 != "") {
                        $goods_content = $goods_content1;
                    }
                    $cargo_id = $ic['carid'];
                    $select = "cargo_type,goods_description,color_code,color_code_name,size_code,size_name,pattern_length_code,pattern_length_name,unit_price,d_hsn_code,item_discount,igst_rate,sgst_rate,cgst_rate,igst_amount,sgst_amount,cgst_amount";
                    $inncargo = $ci->common->gettblrowdata(
                        array("cargo_id" => $cargo_id, "item_order_id" => $ord['id']),
                        $select,
                        "tb_inner_cargo",
                        0,
                        0
                    );
                    $images = $color = $reason = $ean = $imei = "";
                    $brand = $ic['cargo_type'];
                    $descr = $ic['goods_description'];
                    $item_discount = 0;
                    if (count($inncargo) > 0) {
                        $color = $inncargo['color_code_name'];
                        $descr = $inncargo['goods_description'];
                        $brand = $inncargo['cargo_type'];
                        if ($inncargo['unit_price'] > 0) {
                            $commodity_value += $inncargo['unit_price'];
                        }
                        $reason = $inncargo['pattern_length_name'];
                        $cgst_amount += $inncargo['cgst_amount'];
                        $sgst_amount += $inncargo['sgst_amount'];
                        $igst_amount += $inncargo['igst_amount'];
                        $sgst_rate += $inncargo['sgst_rate'];
                        $cgst_rate += $inncargo['cgst_rate'];
                        $igst_rate += $inncargo['igst_rate'];
                        $hsn_code = $inncargo['d_hsn_code'];
                        $item_discount = $inncargo['item_discount'];
                    }
                    $tottax = ($sgst_rate + $cgst_rate + $igst_rate);
                    $tottax = round($tottax, 2);
                    $cgst_amount = round($cgst_amount, 2);
                    $sgst_amount = round($sgst_amount, 2);
                    $igst_amount = round($igst_amount, 2);
                    $sgst_rate = round($sgst_rate, 2);
                    $cgst_rate = round($cgst_rate, 2);
                    $igst_rate = round($igst_rate, 2);
                    if ($goods_category == "") {
                        $goods_category = "MBOX";
                    } /*1-100*/
                    $goods_category = substr($goods_category, 0, 98);
                    $itemsinfo[] = array(
                        "DELIVERY_TYPE" => "",
                        "SELLER_TIN" => "SELLER_TIN_" . $ranom,
                        "INVOICE_NUMBER" => "INVOICE_" . $ranom,
                        "INVOICE_DATE" => date("d-m-Y", strtotime($ord['pickup_datetime'])),
                        "ESUGAM_NUMBER" => "",
                        "ITEM_CATEGORY" => $goods_category,
                        "PACKING_TYPE" => "Box",
                        "PICKUP_TYPE" => "WH",
                        "RETURN_TYPE" => "WH",
                        "CONSIGNEE_ADDRESS_TYPE" => "R",
                        "PICKUP_LOCATION_CODE" => $ord['pickup_pincode'],
                        "SELLER_GSTIN" => "GST" . $ranom,
                        "GST_HSN" => $hsn_code,
                        "GST_ERN" => $ic['qr_code'],
                        "GST_TAX_NAME" => "DELHI GST",
                        "GST_TAX_BASE" => $cgst_rate,
                        "DISCOUNT" => $item_discount,
                        "GST_TAX_RATE_CGSTN" => $cgst_rate,
                        "GST_TAX_RATE_SGSTN" => $sgst_rate,
                        "GST_TAX_RATE_IGSTN" => $igst_rate,
                        "GST_TAX_TOTAL" => $tottax,
                        "GST_TAX_CGSTN" => $cgst_amount,
                        "GST_TAX_SGSTN" => $sgst_amount,
                        "GST_TAX_IGSTN" => $igst_amount
                    );
                }
                $additionalinfo = array(
                    "essentialProduct" => "N",
                    "IS_OTP_REQUIRED" => "N",
                    "MULTI_SELLER" => $itemsinfo
                );
            }
            if ($weight_unit == "G" || $weight_unit == "grm") {
                $weight = round(($weight / 1000), 2);
                $volumetric_weight = round(($volumetric_weight / 1000), 2);
            }
            if ($weight == 0) {
                $weight = 1.00;
            } /*1-100*/
            if ($goods_content == "") {
                $goods_content = "PALLETS";
            }
            $goods_content = str_replace("&", "and", $goods_content);
            $goods_content = str_replace(";", ",", $goods_content);
            $extra_parameters = array("return_reason" => "");
            $payment_mode = "Pickup";
            $address_type = "office";
            $awb_num = "";
            $awbnum = json_decode($this->fetchawb("ppd"), true);
            if (!empty($awbnum)) {
                if (isset($awbnum['success'])) {
                    if ($awbnum['success'] == "yes") {
                        $awb_num = $awbnum['awb'][0];
                        $ecomrefqry = array(
                            "order_id" => $ord['id'],
                            "reference_id" => "WAY",
                            "ref_value" => $awb_num,
                            "status" => 1
                        );
                        $select = "id";
                        $refs1 = $ci->common->gettblrowdata($ecomrefqry, $select, "tb_order_references", 0, 0);
                        if (count($refs1) == 0) {
                            $ecomrefqry = array(
                                'order_id' => $ord['id'],
                                'reference_id' => "WAY",
                                'ref_value' => $awb_num,
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "getecomshipformateddata inserted data in a tb_order_references: " .
                                json_encode($ecomrefqry)
                            );

                            $upd = $ci->common->insertTableData('tb_order_references', $ecomrefqry);
                        }
                    }
                }
            }
            /*if($awb_num != ""){*/
            $consignee_party_type = 3;
            $whr = array(
                "name" => 'Consignee',
                "company_code" => $ord['company_code'],
                "branch_code" => $ord['branch_code'],
                "status" => 1
            );
            $select = "id";
            $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
            if (count($partyqry) > 0) {
                $consignee_party_type = $partyqry['id'];
            }
            $ship_party_type = 1;
            $whr = array(
                "name" => 'Shipper',
                "company_code" => $ord['company_code'],
                "branch_code" => $ord['branch_code'],
                "status" => 1
            );
            $select = "id";
            $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
            if (count($partyqry) > 0) {
                $ship_party_type = $partyqry['id'];
            }
            $state = $phone = $city = $partyindetifier = $partyindetifier1 = $sphone = "";
            $cust_party_type = 5;
            $whr = array(
                "name" => 'Customer',
                "company_code" => $ord['company_code'],
                "branch_code" => $ord['branch_code'],
                "status" => 1
            );
            $select = "id";
            $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
            if (count($partyqry) > 0) {
                $cust_party_type = $partyqry['id'];
            }
            $returninfo = array('name' => "", 'city' => "", 'pin' => "", 'country' => "", 'phone' => "", 'add' => "");
            $whr = "p.id=c.party_id";
            $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $cust_party_type, "c.status" => 1);
            $select = "p.id,p.name,p.mobile,p.partyindetifier,p.address,p.state,p.pincode,p.country,p.location_id";
            $customer = $ci->common->getjointbldata(
                "tbl_party_master p",
                "tb_order_parties c",
                $whr,
                $whr1,
                $select,
                1,
                0
            );
            if (count($customer) > 0) {
                $custs = $customer[0];
                $partyindetifier1 = $custs['partyindetifier'];
                $returninfo = array(
                    'name' => $custs['name'],
                    'city' => $custs['location_id'],
                    'pin' => $custs['pincode'],
                    'country' => $custs['country'],
                    'phone' => $custs['mobile'],
                    'add' => $custs['address']
                );
            }
            $whr = "p.id=c.party_id";
            $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $ship_party_type, "c.status" => 1);
            $select = "p.name,p.mobile,p.partyindetifier,p.state,p.country,p.location_id";
            $shipper = $ci->common->getjointbldata(
                "tbl_party_master p",
                "tb_order_parties c",
                $whr,
                $whr1,
                $select,
                1,
                0
            );
            if (count($shipper) > 0) {
                $consh = $shipper[0];
                $sphone = $consh['mobile'];
            }
            if ($sphone == "" || $sphone = "8888") {
                $sphone = "9871605533";
            }
            $country = "India";
            $whr = "p.id=c.party_id";
            $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $consignee_party_type, "c.status" => 1);
            $select = "p.name,p.mobile,p.partyindetifier,p.state,p.country,p.location_id";
            $consignee = $ci->common->getjointbldata(
                "tbl_party_master p",
                "tb_order_parties c",
                $whr,
                $whr1,
                $select,
                1,
                0
            );
            if (count($consignee) > 0) {
                $cons = $consignee[0];
                $state = $cons['state'];
                $country = $cons['country'];
                $phone = $cons['mobile'];
                $city = $cons['location_id'];
                $partyindetifier = $cons['partyindetifier'];
                if ($partyindetifier == "") {
                    $partyindetifier = $partyindetifier1;
                }
            }
            if ($partyindetifier == "") {
                $partyindetifier = DELHIVERY_CLIENT;
            }
            $product = "PPD";
            $addonservice = array();
            $ord['delivery_address1'] = str_replace("&", "and", $ord['delivery_address1']);
            $ord['delivery_address1'] = str_replace(";", ",", $ord['delivery_address1']);
            $ord['delivery_address2'] = str_replace("&", "and", $ord['delivery_address2']);
            $ord['delivery_address2'] = str_replace(";", ",", $ord['delivery_address2']);
            if ($ord['delivery_address1'] == "") {
                $ord['delivery_address1'] = $ord['delivery_address2'];
            }
            if ($state == "") {
                $dest_cnt = explode(", ", $ord['delivery_address2']);
                if (!empty($dest_cnt)) {
                    if (count($dest_cnt) > 0) {
                        $state = isset($dest_cnt[count($dest_cnt) - 1]) ? $dest_cnt[count($dest_cnt) - 1] : "";
                    }
                }
            }
            if ($ord['pickup_address1'] == "") {
                $ord['pickup_address1'] = $ord['pickup_address2'];
            }
            /*remove duplications from addresses*/
            $deliveraddrarr = explode(",", $ord['delivery_address1']);
            $deliveraddrtrim = array_map("trim", $deliveraddrarr);
            $deliveraddr = array_unique($deliveraddrtrim);
            $ord['delivery_address1'] = implode(", ", $deliveraddr);
            $deliveraddrarr1 = explode(",", $ord['delivery_address2']);
            $deliveraddrtrim1 = array_map("trim", $deliveraddrarr1);
            $deliveraddr1 = array_unique($deliveraddrtrim1);
            $ord['delivery_address2'] = implode(", ", $deliveraddr1);
            $pickupaddrarr = explode(",", $ord['pickup_address1']);
            $pickupaddrtrim = array_map("trim", $pickupaddrarr);
            $pickupaddr = array_unique($pickupaddrtrim);
            $ord['pickup_address1'] = implode(", ", $pickupaddr);
            $goods_value = $ord['goods_value'];
            if ($goods_value == 0 || $goods_value == "") {
                $goods_value = $commodity_value;
            }
            if ($length > 150) {
                $length = 150;
            }
            $awb_num = (string)$awb_num;
            $shipments[] = [
                'AWB_NUMBER' => $awb_num,
                'ORDER_NUMBER' => $ord['order_id'],
                'PRODUCT' => $product,
                'CONSIGNEE' => $ord['delivery_company'],
                'CONSIGNEE_ADDRESS1' => $ord['delivery_address1'],
                'CONSIGNEE_ADDRESS2' => $ord['delivery_address2'],
                'CONSIGNEE_ADDRESS3' => $ord['delivery_address2'],
                'DESTINATION_CITY' => $ord['delivery_city'],
                'PINCODE' => $ord['delivery_pincode'],
                'STATE' => $state,
                'MOBILE' => $phone,
                'TELEPHONE' => $phone,
                'ITEM_DESCRIPTION' => $goods_content,
                'PIECES' => $quantity,
                'COLLECTABLE_VALUE' => 0,
                'DECLARED_VALUE' => $goods_value,
                'ACTUAL_WEIGHT' => $weight,
                'VOLUMETRIC_WEIGHT' => $volumetric_weight,
                'HEIGHT' => $height,
                'BREADTH' => $width,
                'LENGTH' => $length,
                'PICKUP_NAME' => $ord['pickup_company'],
                'PICKUP_ADDRESS_LINE1' => $ord['pickup_address1'],
                'PICKUP_ADDRESS_LINE2' => $ord['pickup_address2'],
                'PICKUP_PINCODE' => $ord['pickup_pincode'],
                'PICKUP_PHONE' => $sphone,
                'PICKUP_MOBILE' => $sphone,
                'RETURN_NAME' => $ord['pickup_company'],
                'RETURN_ADDRESS_LINE1' => $ord['pickup_address1'],
                'RETURN_ADDRESS_LINE2' => $ord['pickup_address2'],
                'RETURN_PINCODE' => $ord['pickup_pincode'],
                'RETURN_PHONE' => $sphone,
                'RETURN_MOBILE' => $sphone,
                'ADDONSERVICE' => $addonservice,
                'DG_SHIPMENT' => 'False',
                'ADDITIONAL_INFORMATION' => $additionalinfo
            ];
            /*}*/
            $request['shipments'] = $shipments;
        }

        log_error(UNIQLO_LOG_PREFIX . "getecomshipformateddata outbound data: " . json_encode($request));

        return $request;
    }

    public function getshiprevformateddata($ord)
    {
        $ci = &get_instance();
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "getshiprevformateddata inbound data: " . json_encode($ord));

        $request = array();
        if (!empty($ord)) {
            $ci->load->model("common");
            $curdt = date("Y-m-d H:i:s");
            $shipments = array();
            $request['ECOMEXPRESS-OBJECTS'] = array('SHIPMENT' => array());
            $request['order_id'] = $ord['id'];
            $customerid = $ord['customer_id'];
            $request['misc'] = array(
                'user_id' => $ord['user_id'],
                'company_code' => $ord['company_code'],
                'branch_code' => $ord['branch_code']
            );
            $whr = "o.cargo_id=c.id";
            $whr1 = array("o.order_id" => $ord['id'], "o.status" => 1);
            $select = "o.id,o.quantity_type,o.cargo_content,o.volumetric_weight,o.qr_code,c.id as carid,c.cargo_type,c.handling_unit,o.length,c.length_unit,o.width,c.width_unit,o.height,c.height_unit,o.weight,c.weight_unit,o.volume,c.volume_unit,o.quantity,c.goods_description";
            $itemqry = $ci->common->getjointbldata(
                "tb_order_cargodetails o",
                "tb_cargo_details c",
                $whr,
                $whr1,
                $select,
                0,
                0
            );
            $height = $width = $length = $quantity = $weight = $volumetric_weight = $commodity_value = 0;
            $goods_category = $goods_content = "";
            $cgst_amount = $sgst_amount = $igst_amount = $sgst_rate = $cgst_rate = $igst_rate = 0;
            $return_state = $return_city = $return_phone = $return_country = $return_pin = $return_add = "";
            $quantity = round($ord['quantity']);
            $hsn_code = "";
            $weight_unit = "G";
            $additionalinfo = $itemsinfo = $qcitemdata = array();
            $ranom = substr(str_shuffle("0123456789"), 0, 5);
            if (count($itemqry) > 0) {
                $l = 0;
                $k = 1;
                foreach ($itemqry as $ic) {
                    $height += $ic['height'];
                    $weight += $ic['weight'];
                    $width += $ic['width'];
                    if ($ic['weight_unit'] != "") {
                        $weight_unit = $ic['weight_unit'];
                    }
                    $length += $ic['length'];
                    if ($ic['volumetric_weight'] > 0) {
                        $volumetric_weight += $ic['volumetric_weight'];
                    }
                    $goods_category = $ic['quantity_type'];
                    if ($goods_category == "") {
                        $goods_category = $ic['cargo_content'];
                    }
                    $goods_content1 = $ic['cargo_content'];
                    if ($l == 0) {
                        $goods_content .= "PLU/" . $goods_content1;
                    } else {
                        $goods_content .= "|PLU/" . $goods_content1;
                    }
                    $l++;
                    $cargo_id = $ic['carid'];
                    /*check forward order if it is return order*/
                    $item_order_id = $ord['id'];
                    $chkxsr = array('reference_id' => "XSR", 'order_id' => $item_order_id, "status" => 1);
                    $chkxsrqry = $ci->common->gettblrowdata($chkxsr, "ref_value", "tb_order_references", 0, 0);
                    if (count($chkxsrqry) > 0) {
                        $chkpo = array('reference_id' => "PO", 'ref_value' => $chkxsrqry['ref_value'], "status" => 1);
                        $chkordqry = $ci->common->gettblrowdata($chkpo, "order_id", "tb_order_references", 0, 0);
                        if (count($chkordqry) > 0) {
                            $item_order_id = $chkordqry['order_id'];
                        }
                    }
                    $select = "cargo_type,goods_description,color_code,color_code_name,size_code,size_name,pattern_length_code,pattern_length_name,unit_price,d_hsn_code,item_discount,igst_rate,sgst_rate,cgst_rate,igst_amount,sgst_amount,cgst_amount";
                    if ($item_order_id == $ord['id']) {
                        $inncargo = $ci->common->gettblrowdata(
                            array("cargo_id" => $cargo_id, "item_order_id" => $item_order_id, "status" => 1),
                            $select,
                            "tb_inner_cargo",
                            0,
                            0
                        );
                    } else {
                        $orditems = array($item_order_id, $ord['id']);
                        $where_in = array('col' => 'item_order_id', 'arr' => $orditems);
                        $inncargo = $ci->common->gettbldata_where_in(
                            array("cargo_id" => $cargo_id, "status" => 1),
                            $where_in,
                            $select,
                            "tb_inner_cargo",
                            0,
                            0
                        );
                    }
                    $images = $color = $reason = $ean = $imei = "";
                    $brand = $ic['cargo_type'];
                    $descr = $ic['goods_description'];
                    $item_discount = 0;
                    if (count($inncargo) > 0) {
                        $color = $inncargo['color_code_name'];
                        $descr = $inncargo['goods_description'];
                        $brand = $inncargo['cargo_type'];
                        if ($inncargo['unit_price'] > 0) {
                            $commodity_value += $inncargo['unit_price'];
                        }
                        $reason = $inncargo['pattern_length_name'];
                        $cgst_amount += $inncargo['cgst_amount'];
                        $sgst_amount += $inncargo['sgst_amount'];
                        $igst_amount += $inncargo['igst_amount'];
                        $sgst_rate += $inncargo['sgst_rate'];
                        $cgst_rate += $inncargo['cgst_rate'];
                        $igst_rate += $inncargo['igst_rate'];
                        $hsn_code = $inncargo['d_hsn_code'];
                        $item_discount = $inncargo['item_discount'];
                    }
                    $qcitemdata[] = array(
                        "QCCHECKCODE" => "GEN_ITEM_CHECK_TAG_ATTACHED" . $k,
                        "VALUE" => "CHECK",
                        "DESC" => "CHECK"
                    );
                    $qcitemdata[] = array(
                        "QCCHECKCODE" => "GEN_ITEM_PLUCODE_CHECK" . $k,
                        "VALUE" => $ic['qr_code'],
                        "DESC" => "CHECK"
                    );
                    $qcitemdata[] = array(
                        "QCCHECKCODE" => "GEN_ITEM_QUANTITY_CHECK" . $k,
                        "VALUE" => $ic['quantity'],
                        "DESC" => "CHECK"
                    );
                    $qcitemdata[] = array(
                        "QCCHECKCODE" => "GEN_ITEM_BRAND_CHECK" . $k,
                        "VALUE" => $goods_category,
                        "DESC" => "CHECK"
                    );
                    $qcitemdata[] = array(
                        "QCCHECKCODE" => "GEN_ITEM_COLOR_CHECK" . $k,
                        "VALUE" => $color,
                        "DESC" => "CHECK"
                    );
                    $k++;
                    $tottax = ($sgst_rate + $cgst_rate + $igst_rate);
                    $tottax = round($tottax, 2);
                    $cgst_amount = round($cgst_amount, 2);
                    $sgst_amount = round($sgst_amount, 2);
                    $igst_amount = round($igst_amount, 2);
                    $sgst_rate = round($sgst_rate, 2);
                    $cgst_rate = round($cgst_rate, 2);
                    $igst_rate = round($igst_rate, 2);
                    if ($goods_category == "") {
                        $goods_category = "MBOX";
                    } /*1-100*/
                    $goods_category = substr($goods_category, 0, 98);
                    $itemsinfo[] = array(
                        "DELIVERY_TYPE" => "",
                        "SELLER_TIN" => "SELLER_TIN_" . $ranom,
                        "INVOICE_NUMBER" => "INVOICE_" . $ranom,
                        "INVOICE_DATE" => date("d-m-Y", strtotime($ord['pickup_datetime'])),
                        "ESUGAM_NUMBER" => null,
                        "ITEM_CATEGORY" => $goods_category,
                        "PACKING_TYPE" => "Box",
                        "PICKUP_TYPE" => null,
                        "RETURN_TYPE" => null,
                        "PICKUP_LOCATION_CODE" => "R",
                        "SELLER_GSTIN" => "GST" . $ranom,
                        "GST_HSN" => $hsn_code,
                        "GST_ERN" => $ic['qr_code'],
                        "GST_TAX_NAME" => "DELHI GST",
                        "GST_TAX_BASE" => $cgst_rate,
                        "GST_TAX_RATE_CGSTN" => $cgst_rate,
                        "GST_TAX_RATE_SGSTN" => $sgst_rate,
                        "GST_TAX_RATE_IGSTN" => $igst_rate,
                        "GST_TAX_TOTAL" => $tottax,
                        "GST_TAX_CGSTN" => $cgst_amount,
                        "GST_TAX_SGSTN" => $sgst_amount,
                        "GST_TAX_IGSTN" => $igst_amount,
                        "DISCOUNT" => $item_discount
                    );
                }
                $additionalinfo = array(
                    "essentialProduct" => "N",
                    "IS_OTP_REQUIRED" => "N",
                    "MULTI_SELLER" => $itemsinfo
                );
            }
            if ($weight_unit == "G" || $weight_unit == "grm") {
                $weight = round(($weight / 1000), 2);
                $volumetric_weight = round(($volumetric_weight / 1000), 2);
            }
            if ($weight == 0) {
                $weight = 1.00;
            } /*1-100*/
            if ($goods_content == "") {
                $goods_content = "PALLETS";
            }
            $goods_content = str_replace("&", "and", $goods_content);
            $goods_content = str_replace(";", "", $goods_content);
            $extra_parameters = array("return_reason" => "");
            $payment_mode = "Pickup";
            $address_type = "office";
            $awb_num = "";
            $awbnum = json_decode($this->fetchawb("REV"), true);
            if (!empty($awbnum)) {
                if (isset($awbnum['success'])) {
                    if ($awbnum['success'] == "yes") {
                        $awb_num = $awbnum['awb'][0];
                        $ecomrefqry = array(
                            'order_id' => $ord['id'],
                            'reference_id' => "WAY",
                            "ref_value" => $awb_num,
                            "status" => 1
                        );
                        $select = "id";
                        $refs1 = $ci->common->gettblrowdata($ecomrefqry, $select, "tb_order_references", 0, 0);
                        if (count($refs1) == 0) {
                            $ecomrefqry = array(
                                'order_id' => $ord['id'],
                                'reference_id' => "WAY",
                                'ref_value' => $awb_num,
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "getshiprevformateddata inserted data in a tb_order_references: " .
                                json_encode($ecomrefqry)
                            );

                            $upd = $ci->common->insertTableData('tb_order_references', $ecomrefqry);
                        }
                    }
                }
            }
            /*if($awb_num != ""){*/
            $consignee_party_type = 3;
            $whr = array(
                "name" => 'Consignee',
                "company_code" => $ord['company_code'],
                "branch_code" => $ord['branch_code'],
                "status" => 1
            );
            $select = "id";
            $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
            if (count($partyqry) > 0) {
                $consignee_party_type = $partyqry['id'];
            }
            $ship_party_type = 1;
            $whr = array(
                "name" => 'Shipper',
                "company_code" => $ord['company_code'],
                "branch_code" => $ord['branch_code'],
                "status" => 1
            );
            $select = "id";
            $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
            if (count($partyqry) > 0) {
                $ship_party_type = $partyqry['id'];
            }
            $state = $phone = $city = $partyindetifier = $partyindetifier1 = $sphone = "";
            $cust_party_type = 5;
            $whr = array(
                "name" => 'Customer',
                "company_code" => $ord['company_code'],
                "branch_code" => $ord['branch_code'],
                "status" => 1
            );
            $select = "id";
            $partyqry = $ci->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);
            if (count($partyqry) > 0) {
                $cust_party_type = $partyqry['id'];
            }
            $returninfo = array('name' => "", 'city' => "", 'pin' => "", 'country' => "", 'phone' => "", 'add' => "");
            $whr = "p.id=c.party_id";
            $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $cust_party_type, "c.status" => 1);
            $select = "p.id,p.name,p.mobile,p.partyindetifier,p.address,p.state,p.pincode,p.country,p.location_id";
            $customer = $ci->common->getjointbldata(
                "tbl_party_master p",
                "tb_order_parties c",
                $whr,
                $whr1,
                $select,
                1,
                0
            );
            if (count($customer) > 0) {
                $custs = $customer[0];
                $partyindetifier1 = $custs['partyindetifier'];
                $returninfo = array(
                    'name' => $custs['name'],
                    'city' => $custs['location_id'],
                    'pin' => $custs['pincode'],
                    'country' => $custs['country'],
                    'phone' => $custs['mobile'],
                    'add' => $custs['address']
                );
            }
            $whr = "p.id=c.party_id";
            $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $ship_party_type, "c.status" => 1);
            $select = "p.name,p.mobile,p.partyindetifier,p.state,p.country,p.location_id";
            $shipper = $ci->common->getjointbldata(
                "tbl_party_master p",
                "tb_order_parties c",
                $whr,
                $whr1,
                $select,
                1,
                0
            );
            if (count($shipper) > 0) {
                $consh = $shipper[0];
                $sphone = $consh['mobile'];
            }
            $country = "India";
            $whr = "p.id=c.party_id";
            $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $consignee_party_type, "c.status" => 1);
            $select = "p.name,p.mobile,p.partyindetifier,p.state,p.country,p.location_id";
            $consignee = $ci->common->getjointbldata(
                "tbl_party_master p",
                "tb_order_parties c",
                $whr,
                $whr1,
                $select,
                1,
                0
            );
            if (count($consignee) > 0) {
                $cons = $consignee[0];
                $state = $cons['state'];
                $country = $cons['country'];
                $phone = $cons['mobile'];
                if ($phone == "" || $phone = "8888") {
                    $phone = "9871605533";
                }
                $city = $cons['location_id'];
                $partyindetifier = $cons['partyindetifier'];
                if ($partyindetifier == "") {
                    $partyindetifier = $partyindetifier1;
                }
            }
            if ($partyindetifier == "") {
                $partyindetifier = DELHIVERY_CLIENT;
            }
            $product = "REV";
            $addonservice = array();
            $ord['pickup_address1'] = str_replace("&", "and", $ord['pickup_address1']);
            $ord['pickup_address1'] = str_replace(";", "", $ord['pickup_address1']);
            $ord['pickup_address2'] = str_replace("&", "and", $ord['pickup_address2']);
            $ord['pickup_address2'] = str_replace(";", "", $ord['pickup_address2']);
            if ($ord['pickup_address1'] == "") {
                $ord['pickup_address1'] = $ord['pickup_address2'];
            }
            /*remove duplications from addresses*/
            $pickupaddrarr = explode(",", $ord['pickup_address1']);
            $pickupaddrtrim = array_map("trim", $pickupaddrarr);
            $pickupaddr = array_unique($pickupaddrtrim);
            $ord['pickup_address1'] = implode(", ", $pickupaddr);
            $pickupaddrarr1 = explode(",", $ord['pickup_address2']);
            $pickupaddrtrim1 = array_map("trim", $pickupaddrarr1);
            $pickupaddr1 = array_unique($pickupaddrtrim1);
            $ord['pickup_address2'] = implode(", ", $pickupaddr1);
            if ($state == "") {
                $dest_cnt = explode(", ", $ord['pickup_address2']);
                if (!empty($dest_cnt)) {
                    if (count($dest_cnt) > 0) {
                        $state = isset($dest_cnt[count($dest_cnt) - 1]) ? $dest_cnt[count($dest_cnt) - 1] : "";
                    }
                }
            }
            $goods_value = $ord['goods_value'];
            if ($goods_value == 0 || $goods_value == "") {
                $goods_value = $commodity_value;
            }
            if ($length > 150) {
                $length = 150;
            }
            $awb_num = (string)$awb_num;
            $reverseqc = array("QC");
            $shipments = array(
                'AWB_NUMBER' => $awb_num,
                'ORDER_NUMBER' => $ord['order_id'],
                "PRODUCT" => $product,
                "REVPICKUP_NAME" => $ord['pickup_company'],
                'REVPICKUP_ADDRESS1' => $ord['pickup_address1'],
                'REVPICKUP_ADDRESS2' => $ord['pickup_address2'],
                'REVPICKUP_ADDRESS3' => $ord['pickup_address2'],
                'REVPICKUP_CITY' => $ord['pickup_city'],
                'REVPICKUP_PINCODE' => $ord['pickup_pincode'],
                "REVPICKUP_STATE" => $state,
                "REVPICKUP_MOBILE" => $sphone,
                "REVPICKUP_TELEPHONE" => $sphone,
                "PIECES" => $quantity,
                "COLLECTABLE_VALUE" => 1,
                "DECLARED_VALUE" => $goods_value,
                "ACTUAL_WEIGHT" => $weight,
                "VOLUMETRIC_WEIGHT" => $volumetric_weight,
                "LENGTH" => $length,
                "BREADTH" => $width,
                "HEIGHT" => $height,
                "VENDOR_ID" => "",
                "DROP_NAME" => $ord['delivery_company'],
                "DROP_ADDRESS_LINE1" => $ord['delivery_address1'],
                "DROP_ADDRESS_LINE2" => $ord['delivery_address2'],
                "DROP_PINCODE" => $ord['delivery_pincode'],
                "DROP_MOBILE" => $phone,
                "ITEM_DESCRIPTION" => $goods_content,
                "DROP_PHONE" => $phone,
                "EXTRA_INFORMATION" => $ord['customer_comments'],
                "DG_SHIPMENT" => "false",
                "ADDONSERVICE" => $reverseqc,
                "QC" => $qcitemdata,
                'ADDITIONAL_INFORMATION' => $additionalinfo
            );
            /*}*/
            $request['shipments'] = array('ECOMEXPRESS-OBJECTS' => array('SHIPMENT' => $shipments));
        }

        log_error(UNIQLO_LOG_PREFIX . "getshiprevformateddata outbound data: " . json_encode($request));

        return $request;
    }

    public function generatedocketlabel($orddata)
    {
        $data = array();
        $sendurl = "";
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "generatedocketlabel inbound data: " . json_encode($orddata));

        require 'vendor/autoload.php';
        $order_id = $orddata['order_id'];
        if ($order_id != "") {
            $data['carrier'] = "";
            $select = "id,order_id,vendor_id";
            $chkorder = $ci->common->gettblrowdata(array('id' => $order_id), $select, "tb_orders", 0, 0);
            if (count($chkorder) > 0) {
                $select = "id,name";
                $carrier_id = $chkorder['vendor_id'];
                $chkven = $ci->common->gettblrowdata(array('id' => $carrier_id), $select, "tb_vendors", 0, 0);
                if (count($chkven) > 0) {
                    $data['carrier'] = $chkven['name'];
                }
            }
            if ($data['carrier'] == "KN_CARR") {
                $data['carrier'] = "Delhivery";
            }
            $refs = $ci->common->gettbldata(
                array("order_id" => $order_id, "status" => 1),
                "reference_id,ref_value",
                "tb_order_references",
                0,
                0
            );
            $data['ordernumber'] = $data['docketnum'] = $data['ponumber'] = '';
            if (count($refs) > 0) {
                foreach ($refs as $ref) {
                    if ($ref['reference_id'] == "XSR") {
                        $data['ordernumber'] = $ref['ref_value'];
                    }
                    if ($ref['reference_id'] == "AWB") {
                        $data['docketnum'] = $ref['ref_value'];
                    }
                    if ($ref['reference_id'] == "PO") {
                        $data['ponumber'] = $ref['ref_value'];
                    }
                }
            }
            if ($data['docketnum'] != "") {
                $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
                $mpdf = new \Mpdf\Mpdf([
                                           'mode' => 'utf-8',
                                           'tempDir' => FCPATH . 'assets/tmp',
                                           'format' => [
                                               40,
                                               20
                                           ],
                                           'margin_left' => 0,
                                           'margin_right' => 0,
                                           'margin_top' => 0,
                                           'margin_bottom' => 0,
                                           'margin_header' => 0,
                                           'margin_footer' => 0
                                       ]);
                $html = $ci->load->view('uniqloe/docketlabel', $data, true);
                /*$data1['labelcontent'] = $html;*/
                $sendurl = "Shipping" . $data['docketnum'] . ".pdf";
                $labelpdf = "./assets/swiftlog/docketlabel/" . $sendurl;
                /*$output = $ci->load->view('uniqloe/docket_label', $data1, true);*/
                $mpdf->WriteHTML($html);
                $mpdf->Output($labelpdf, 'F');
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "generatedocketlabel outbound data: " . $sendurl);

        return $sendurl;
    }

    /* send order creation to delhivery */
    public function xbordercreatemanifestation($shipmentid = null)
    {
        $ci = &get_instance();
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "xbordercreatemanifestation inbound data: " . $shipmentid);

        $postresp = "no data";
        $status = 0;
        $resp = array();
        if ($shipmentid != "") {
            $shipdata = $this->getxbshipformateddata($shipmentid);
            if (!empty($shipdata)) {
                $ci->load->model("common");
                $orderinfo = $shipdata['ord_info'];
                $misc = $shipdata['misc'];
                unset($shipdata['misc']);
                unset($shipdata['ord_info']);
                $reqdata = json_encode($shipdata);
                $company_code = isset($misc['company_code']) ? $misc['company_code'] : "INKN";
                $branch_code = isset($misc['branch_code']) ? $misc['branch_code'] : "INCL";
                $user_id = isset($misc['user_id']) ? $misc['user_id'] : "244";
                $edi_request = $reqdata;
                $edi_response = $postresp = "No pincodes availability";
                $edi_id = 10;
                $edi_name = "ExpressBees";
                $params = array(
                    'edi_type' => 1, /*'1->EDI Transport Order,2->EDI Status'*/
                    'transaction_id' => time(),
                    'edi_id' => $edi_id, /*edi id based on name take it from tb_edi_types*/
                    'edi_name' => $edi_name,
                    'bounded_type' => 2, /*'1->Inbound(partner => kN),2->Outbound (KN => partner)'*/
                    'edi_format_type' => 'json',
                    'status' => $status,
                    'obj_type' => 1,
                    'txn_obj_id' => $orderinfo[0]['id'],
                    'user_id' => $user_id,
                    'company_code' => $company_code,
                    'branch_code' => $branch_code,
                    'edi_request' => $edi_request,
                    'edi_response' => $edi_response
                );

                log_error(
                    UNIQLO_LOG_PREFIX .
                    "xbordercreatemanifestation inserted data in a tb_etn_edi_transactions: " . json_encode($params)
                );

                $edilogid = $ci->common->insertTableData('tb_etn_edi_transactions', $params);
                $server_url = EXP_BEES_PUSH_MANIFEST;
                $api_token = "Token " . EXP_BEES_XBKEY;
                require_once './vendor/pear/http_request2/HTTP/Request2.php';
                $request = new HTTP_Request2();
                $request->setUrl($server_url);
                $request->setMethod(HTTP_Request2::METHOD_POST);
                $request->setConfig(getHttpRequestConfig());
                $request->setHeader(array(
                                        'Content-Type' => 'application/json'
                                    ));
                $request->setBody($reqdata);

                log_error(
                    UNIQLO_LOG_PREFIX . 'xbordercreatemanifestation connecting with API: ' . $server_url . ' with payload ' . $reqdata
                );

                try {
                    $response = $request->send();
                    if ($response->getStatus() == 200) {
                        $postresp1 = $edi_response = $response->getBody();

                        log_error(
                            UNIQLO_LOG_PREFIX . 'xbordercreatemanifestation API response payload: ' . $postresp1
                        );

                        $resp = json_decode($postresp1);
                        $waybill = "";
                        if (isset($resp['AddManifestDetails'])) {
                            foreach ($resp['AddManifestDetails'] as $res) {
                                if ($res['AuthKey'] == "Valid" && $res['ReturnMessage'] == "successful") {
                                    $postresp = $waybill = $res['AWBNo'];
                                    $tokennum = $res['TokenNumber'];
                                    /*add in order reference*/
                                    $whr = array(
                                        "order_id" => $orderinfo[0]['id'],
                                        "reference_id" => 'AWB',
                                        "status" => 1
                                    );
                                    $select = "id";
                                    $refqry = $ci->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);
                                    if (count($refqry) > 0) {
                                        $set = array("ref_value" => $waybill);
                                        $whr = array("id" => $refqry['id']);

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "xbordercreatemanifestation updated data in a tb_order_references: " .
                                            json_encode($set)
                                        );

                                        $upd = $ci->common->updatetbledata("tb_order_references", $set, $whr);
                                    } else {
                                        $insarr = array(
                                            "order_id" => $orderinfo[0]['id'],
                                            "reference_id" => 'AWB',
                                            "ref_value" => $waybill,
                                            "status" => 1
                                        );

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "xbordercreatemanifestation inserted data in a tb_order_references: " .
                                            json_encode($insarr)
                                        );

                                        $ins = $ci->common->insertTableData("tb_order_references", $insarr);
                                    }
                                    $updwhr = array("order_row_id" => $orderinfo[0]['id']);
                                    $updset = array("delivery_note" => $waybill);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "xbordercreatemanifestation updated data in a tb_order_details: " .
                                        json_encode($updset)
                                    );

                                    $upd = $ci->common->updatetbledata("tb_order_details", $updset, $updwhr);
                                    $whr = array(
                                        "order_id" => $orderinfo[0]['id'],
                                        "reference_id" => 'WBN',
                                        "status" => 1
                                    );
                                    $select = "id";
                                    $refqry = $ci->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);
                                    if (count($refqry) > 0) {
                                        $set = array("ref_value" => $tokennum);
                                        $whr = array("id" => $refqry['id']);

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "xbordercreatemanifestation updated data in a tb_order_references: " .
                                            json_encode($set)
                                        );

                                        $upd = $ci->common->updatetbledata("tb_order_references", $set, $whr);
                                    } else {
                                        $insarr = array(
                                            "order_id" => $orderinfo[0]['id'],
                                            "reference_id" => 'WBN',
                                            "ref_value" => $tokennum,
                                            "status" => 1
                                        );

                                        log_error(
                                            UNIQLO_LOG_PREFIX .
                                            "xbordercreatemanifestation inserted data in a tb_order_references: " .
                                            json_encode($insarr)
                                        );

                                        $ins = $ci->common->insertTableData("tb_order_references", $insarr);
                                    }
                                    $status = 1;
                                    /*update vendor id*/
                                    $vend = $ci->common->gettblrowdata(
                                        array("name" => "EXPRESSBEES"),
                                        "id",
                                        "tb_vendors",
                                        0,
                                        0
                                    );
                                    $upd = array("vendor_id" => $vend['id']);
                                    $whr = array("id" => $orderinfo[0]['id']);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "xbordercreatemanifestation updated data in a tb_orders: " . json_encode($upd)
                                    );

                                    $updqry = $ci->common->updatetbledata("tb_orders", $upd, $whr);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "xbordercreatemanifestation updated data in a tb_shifts: " . json_encode($upd)
                                    );

                                    $updqry = $ci->common->updatetbledata("tb_shifts", $upd, array("id" => $shipmentid)
                                    );

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "xbordercreatemanifestation updated data in a tb_employee: " .
                                        json_encode($upd)
                                    );

                                    $updqry = $ci->common->updatetbledata(
                                        "tb_employee",
                                        $upd,
                                        array("shift_id" => $shipmentid)
                                    );
                                    $senddocket = $this->senddocketnumber($orderinfo[0]['id']);
                                } else {
                                    $postresp = $res['ReturnMessage'];
                                }
                            }
                        }
                    } else {
                        $postresp = 'Unexpected HTTP status: ' . $response->getStatus(
                            ) . ' ' . $response->getReasonPhrase();
                    }
                } catch (HTTP_Request2_Exception $e) {
                    $postresp = 'Error: ' . $e->getMessage();
                }
                $set = array("status" => $status, "edi_response" => $edi_response);
                $whr = array("id" => $edilogid);

                log_error(
                    UNIQLO_LOG_PREFIX .
                    "xbordercreatemanifestation updated data in a tb_etn_edi_transactions: " .
                    json_encode($set)
                );

                $upd = $ci->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
            }
        }
        $respstatus = array("status" => $status, "data" => $postresp);

        log_error(UNIQLO_LOG_PREFIX . "xbordercreatemanifestation outbound data: " . json_encode($respstatus));

        return $respstatus;
    }

    public function getxbshipformateddata($shipid)
    {
        $request = array();
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        log_error(UNIQLO_LOG_PREFIX . "getxbshipformateddata inbound data: " . $shipid);

        $whr = array("shift_id" => $shipid, "trip_sts" => 0, "status <>" => 0);
        $select = "*";
        $orders = $ci->common->gettbldata($whr, $select, "tb_orders", 0, 0);
        if (count($orders) > 0) {
            $customerid = 0;
            $shipments = array();
            $request['ord_info'] = array();
            $request['XBkey'] = EXP_BEES_XBKEY;
            $request['VersionNumber'] = 'V5';
            $request['ManifestDetails'] = array();
            $request['misc'] = array();
            $tripdata = array();
            $payment_mode = "COD";
            foreach ($orders as $ord) {
                $ordtype = $ord['created_source'];
                $request['misc'] = array(
                    'user_id' => $ord['user_id'],
                    'company_code' => $ord['company_code'],
                    'branch_code' => $ord['branch_code']
                );
                $request['ord_info'][] = array("id" => $ord['id'], "order_id" => $ord['order_id']);
                $tripdata['ManifestID'] = $ord['shipmentid'];
                $tripdata['OrderType'] = $payment_mode;
                $tripdata['OrderNo'] = $ord['order_id'];
                $tripdata['SubOrderNo'] = $ord['order_id'];
                $tripdata['PaymentStatus'] = $payment_mode;
                $vendor_id = $ord['vendor_id'];
                $customerid = $ord['customer_id'];
                $goods_value = $ord['goods_value'];
                $cust_party_type = 5;
                $shipper_party_type = 1;
                $consignee_party_type = 3;
                $whr = " name IN('Shipper','Consignee','Customer') AND company_code='" . $ord['company_code'] . "' AND branch_code='" . $ord['branch_code'] . "' AND status=1";
                $select = "id,name";
                $partyqry = $ci->common->gettbldata($whr, $select, "tbl_party_types", 0, 0);
                if (count($partyqry) > 0) {
                    foreach ($partyqry as $pr) {
                        if ($pr['name'] == "Consignee") {
                            $consignee_party_type = $pr['id'];
                        }
                        if ($pr['name'] == "Shipper") {
                            $shipper_party_type = $pr['id'];
                        }
                        if ($pr['name'] == "Customer") {
                            $cust_party_type = $pr['id'];
                        }
                    }
                }
                $cnname = $cnstate = $cnphone = $cncity = $cncountry = $cnaddress = $cnpin = $cnaddr2 = $cncontact = "";
                $caname = $castate = $caphone = $cacity = $cacountry = $caaddress = $capin = $caaddr2 = $cacontact = $cacode = "";
                $cuname = $custate = $cuphone = $cucity = $cucountry = $cuaddress = $cupin = $cuaddr2 = $cucontact = "";
                $country = "India";
                $whr = "p.id=c.party_id";
                $whr1 = "c.order_id='" . $ord['id'] . "' AND c.party_type IN($consignee_party_type,$shipper_party_type,$cust_party_type) AND c.status=1";
                $select = "p.party_type_id,p.name,p.mobile,p.code,p.state,p.country,p.location_id,p.address,p.pincode,p.street,p.contract_no";
                $consignee = $ci->common->getjointbldata(
                    "tbl_party_master p",
                    "tb_order_parties c",
                    $whr,
                    $whr1,
                    $select,
                    0,
                    0
                );
                if (count($consignee) > 0) {
                    foreach ($consignee as $pinfo) {
                        if ($pinfo['party_type_id'] == $consignee_party_type) {
                            $cnname = $ord['delivery_company'];
                            if ($cnname == "") {
                                $cnname = $pinfo['name'];
                            }
                            $cnstate = $pinfo['state'];
                            $cncountry = $ord['delivery_country'];
                            /*$cncountry = $pinfo['country'];*/
                            $cnphone = $pinfo['mobile'];
                            $cnaddress = $ord['delivery_address1'] . ", " . $ord['delivery_address2'];
                            /*$cnaddress = $pinfo['address'];*/
                            $cncity = $ord['delivery_city'];
                            /*$cncity = $pinfo['location_id'];*/
                            $cnpin = $ord['delivery_pincode'];
                            /*$cnpin = $pinfo['pincode'];*/
                            $cnaddr2 = $ord['delivery_address2'];
                            /*$cnaddr2 = $pinfo['street'];*/
                            $cncontact = $pinfo['contract_no'];
                        }
                        if ($pinfo['party_type_id'] == $shipper_party_type) {
                            $caname = $ord['pickup_company'];
                            if ($caname == "") {
                                $caname = $pinfo['name'];
                            }
                            $castate = $pinfo['state'];
                            $cacountry = $ord['pickup_country'];
                            /*$cacountry = $pinfo['country'];*/
                            $caphone = $pinfo['mobile'];
                            $caaddress = $ord['pickup_address1'] . ", " . $ord['pickup_address2'];
                            /*$caaddress = $pinfo['address'];*/
                            $cacity = $ord['pickup_city'];
                            /*$cacity = $pinfo['location_id'];*/
                            $capin = $ord['pickup_pincode'];
                            /*$capin = $pinfo['pincode'];*/
                            $caaddr2 = $ord['pickup_address2'];
                            /*$caaddr2 = $pinfo['street'];*/
                            $cacontact = $pinfo['contract_no'];
                            $cacode = $pinfo['code'];
                        }
                        if ($pinfo['party_type_id'] == $cust_party_type) {
                            $cuname = $ord['delivery_company'];
                            if ($cuname == "") {
                                $cuname = $pinfo['name'];
                            }
                            $custate = $pinfo['state'];
                            $cucountry = $ord['delivery_country'];
                            /*$cucountry = $pinfo['country'];*/
                            $cuphone = $pinfo['mobile'];
                            if (!is_numeric($cuphone)) {
                                $cuphone = '7799999360';
                            }
                            $cuaddress = $ord['delivery_address1'] . ", " . $ord['delivery_address2'];
                            /*$cuaddress = $pinfo['address'];*/
                            $cucity = $ord['delivery_city'];
                            /*$cucity = $pinfo['location_id'];*/
                            $cupin = $ord['delivery_pincode'];
                            /*$cupin = $pinfo['pincode'];*/
                            $cuaddr2 = $ord['delivery_address2'];
                            /*$cuaddr2 = $pinfo['street'];*/
                            $cucontact = $pinfo['contract_no'];
                        }
                    }
                }
                $commodity_value = 0;
                $cgst_amount = $sgst_amount = $igst_amount = $sgst_rate = $cgst_rate = $igst_rate = 0;
                $tripdata['PickupVendor'] = $caname;
                $tripdata['PickVendorPhoneNo'] = $caphone;
                $tripdata['PickVendorAddress'] = $caaddress;
                $tripdata['PickVendorCity'] = $cacity;
                $tripdata['PickVendorState'] = $castate;
                $tripdata['PickVendorPinCode'] = $capin;
                $tripdata['CustomerName'] = $cuname;
                $tripdata['CustomerCity'] = $cucity;
                $tripdata['CustomerState'] = $custate;
                $tripdata['ZipCode'] = $cupin;
                $tripdata['CustomerAddressDetails'][] = array('Type' => 'Primary', 'Address' => $cuaddress);
                $tripdata['CustomerAddressDetails'][] = array('Type' => 'Secondary', 'Address' => $cuaddr2);
                $tripdata['CustomerMobileNumberDetails'][] = array('Type' => 'Primary', 'MobileNo' => $cuphone);
                $tripdata['CustomerMobileNumberDetails'][] = array('Type' => 'Secondary', 'MobileNo' => $cucontact);
                $tripdata['RTOName'] = $cupin;
                $tripdata['RTOMobileNo'] = $cupin;
                $tripdata['RTOAddress'] = $cupin;
                $tripdata['RTOToCity'] = $cupin;
                $tripdata['RTOToState'] = $cupin;
                $tripdata['RTOPinCode'] = $cupin;
                $whr = "o.cargo_id=c.id";
                $whr1 = array("o.order_id" => $ord['id'], "o.status" => 1);
                $select = "o.id,o.cargo_id,o.quantity_type,o.cargo_content,c.cargo_type, c.handling_unit,o.length,c.length_unit,o.width,c.width_unit,o.height,c.height_unit,o.weight,c.weight_unit,o.volume,c.volume_unit,o.quantity,c.goods_description";
                $itemqry = $ci->common->getjointbldata(
                    "tb_order_cargodetails o",
                    "tb_cargo_details c",
                    $whr,
                    $whr1,
                    $select,
                    0,
                    0
                );
                $height = $width = $length = $quantity = $weight = 0;
                $goods_category = $goods_content = $hsn_code = "";
                $weight_unit = "gms";
                $items = array();
                /*check forward order if it is return order*/
                $item_order_id = $ord['id'];
                if ($ordtype == $this->returnOrderTypeId) {
                    $chkxsr = array('reference_id' => "XSR", 'order_id' => $item_order_id, "status" => 1);
                    $chkxsrqry = $ci->common->gettblrowdata($chkxsr, "ref_value", "tb_order_references", 0, 0);
                    if (count($chkxsrqry) > 0) {
                        $chkpo = array('reference_id' => "PO", 'ref_value' => $chkxsrqry['ref_value'], "status" => 1);
                        $chkordqry = $ci->common->gettblrowdata($chkpo, "order_id", "tb_order_references", 0, 0);
                        if (count($chkordqry) > 0) {
                            $item_order_id = $chkordqry['order_id'];
                        }
                    }
                }
                if (count($itemqry) > 0) {
                    foreach ($itemqry as $ic) {
                        $height += $ic['height'];
                        $weight += $ic['weight'];
                        $width += $ic['width'];
                        $length += $ic['length'];
                        $quantity += $ic['quantity'];
                        $goods_category = $ic['handling_unit'];
                        $goods_content = $ic['cargo_content'];
                        if ($ic['weight_unit'] != "") {
                            $weight_unit = $ic['weight_unit'];
                        }
                        $select = "cargo_type,goods_description,color_code,color_code_name,size_code,size_name,pattern_length_code,pattern_length_name,unit_price,d_hsn_code,igst_rate,sgst_rate,cgst_rate,igst_amount,sgst_amount,cgst_amount";
                        if ($item_order_id == $ord['id']) {
                            $inncargo = $ci->common->gettblrowdata(
                                array("cargo_id" => $ic['cargo_id'], "item_order_id" => $item_order_id, "status" => 1),
                                $select,
                                "tb_inner_cargo",
                                0,
                                0
                            );
                        } else {
                            $orditems = array($item_order_id, $ord['id']);
                            $where_in = array('col' => 'item_order_id', 'arr' => $orditems);
                            $inncargo = $ci->common->gettbldata_where_in(
                                array("cargo_id" => $cargo_id, "status" => 1), //TODO $cargo_id is not defined
                                $where_in,
                                $select,
                                "tb_inner_cargo",
                                0,
                                0
                            );
                        }
                        $images = $color = $reason = $ean = $imei = "";
                        if (count($inncargo) > 0) {
                            $color = $inncargo['color_code_name'];
                            $reason = $inncargo['pattern_length_name'];
                            $descr = $inncargo['goods_description'];
                            $brand = $inncargo['cargo_type'];
                            $commodity_value += $inncargo['unit_price'];
                            if ($ordtype == $this->returnOrderTypeId) {
                                $return_reason = $reason;
                            }

                            $specialInstructions = $brand;
                            if ($ordtype == $this->returnOrderTypeId) {
                                $specialInstructions = "Tag to be attached to the garment";
                            }

                            $cgst_amount += $inncargo['cgst_amount'];
                            $sgst_amount += $inncargo['sgst_amount'];
                            $igst_amount += $inncargo['igst_amount'];
                            $sgst_rate += $inncargo['sgst_rate'];
                            $cgst_rate += $inncargo['cgst_rate'];
                            $igst_rate += $inncargo['igst_rate'];
                            $hsn_code = $inncargo['d_hsn_code'];

                            log_error(
                                UNIQLO_LOG_PREFIX . "Uniqloediservices SI 1910 " . $specialInstructions
                            );

                            $items[] = array(
                                "descr" => $descr,
                                "ean" => "",
                                "brand" => $brand,
                                "pcat" => $ic['handling_unit'],
                                "si" => $specialInstructions,
                                'hsn_code' => $hsn_code,
                                "cgst_amount" => $cgst_amount,
                                "sgst_amount" => $sgst_amount,
                                "igst_amount" => $igst_amount,
                                "sgst_rate" => $sgst_rate,
                                "cgst_rate" => $cgst_rate,
                                "igst_rate" => $igst_rate
                            );
                        } else {
                            $specialInstructions = $ic['cargo_content'];
                            if ($ordtype == $this->returnOrderTypeId) {
                                $specialInstructions = "Tag to be attached to the garment";
                            }

                            log_error(
                                UNIQLO_LOG_PREFIX . "Uniqloediservices SI 1931 " . $specialInstructions
                            );

                            $items[] = array(
                                "descr" => $ic['goods_description'],
                                "ean" => "",
                                "brand" => $ic['cargo_type'],
                                "pcat" => $ic['handling_unit'],
                                "si" => $specialInstructions,
                                'hsn_code' => $hsn_code,
                                "cgst_amount" => 0,
                                "sgst_amount" => 0,
                                "igst_amount" => 0,
                                "sgst_rate" => 0,
                                "cgst_rate" => 0,
                                "igst_rate" => 0
                            );
                        }
                    }
                }
                /* get awb */
                $awbnumval = "";
                $awbqry = $ci->common->gettblrowdata(
                    array(
                        "vendor_id" => $vendor_id,
                        "service_type" => 1,
                        "deliver_type" => $payment_mode,
                        "status" => 1
                    ),
                    "id,awb_start,awb_end,current_awb",
                    "tb_xpressbees_awb_data",
                    0,
                    0
                );
                if (count($awbqry) > 0) {
                    $awbnumval = ($awbqry['current_awb'] + 1);
                    $awbid = $awbqry['id'];

                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "getxbshipformateddata updated data in a tb_xpressbees_awb_data: " .
                        json_encode(array("current_awb" => $awbnumval))
                    );

                    $upd = $ci->common->updatetbledata(
                        "tb_xpressbees_awb_data",
                        array("current_awb" => $awbnumval),
                        array("id" => $awbid)
                    );
                }
                if (strpos($weight_unit, "Kg") === false) {
                    $weight = round(($weight / 1000), 2);
                }
                $tripdata['BillableWeight'] = $weight;
                $tripdata['VolWeight'] = $weight;
                $tripdata['PhyWeight'] = $weight;
                $tripdata['ShipLength'] = $length;
                $tripdata['ShipWidth'] = $width;
                $tripdata['ShipHeight'] = $height;
                $tripdata['AirWayBillNO'] = $awbnumval;
                $tripdata['ServiceType'] = 'SD';
                $tripdata['Quantity'] = $quantity;
                $tripdata['PickupVendorCode'] = $cacode;
                $tripdata['PickupType'] = 'Vendor';
                $tripdata['IsDGShipmentType'] = 0;
                $tripdata['IsOpenDelivery'] = 0;
                $tripdata['CollectibleAmount'] = $goods_value;
                $tripdata['DeclaredValue'] = $goods_value;
                $tripdata['GSTMultiSellerInfo'] = array();
                if (count($items) > 0) {
                    foreach ($items as $it) {
                        $tripdata['GSTMultiSellerInfo'][] = array(
                            "ProductDesc" => $it['descr'],
                            "ProductCategory" => $it['brand'],
                            "SellerName" => $tripdata['CustomerName'],
                            "SellerAddress" => $tripdata['CustomerCity'],
                            "SupplySellerStatePlace" => $tripdata['CustomerState'],
                            "SellerPincode" => $tripdata['ZipCode'],
                            "InvoiceNumber" => "",
                            "InvoiceDate" => date("Y-m-d"),
                            "EWayBillSrNumber" => "",
                            "EBNExpiryDate" => "",
                            "BuyerGSTRegNumber" => "",
                            "IsSellerRegUnderGST" => "No",
                            "SellerGSTRegNumber" => "",
                            "HSNCode" => $it['hsn_code'],
                            "TaxableValue" => 0,
                            "SGSTAmount" => $it['sgst_amount'],
                            "CGSTAmount" => $it['cgst_amount'],
                            "IGSTAmount" => $it['igst_amount'],
                            "Discount" => 0,
                            "GSTTaxRateCGSTN" => $it['cgst_rate'],
                            "GSTTaxRateSGSTN" => $it['sgst_rate'],
                            "GSTTAXRateIGSTN" => $it['igst_rate'],
                            "GSTTaxTotal" => ($it['cgst_rate'] + $it['sgst_rate'] + $it['igst_rate'])
                        );
                    }
                }
                $request['ManifestDetails'] = $tripdata;
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getxbshipformateddata outbound data: " . json_encode($request));

        return $request;
    }

    public function getxbawbbatch($servicetype, $delivertype)
    {
        $ci = &get_instance();
        $ci->load->helper('log_helper');

        /*$servicetype = "FORWARD";
        $delivertype = "COD";*/
        $postresp = "";
        $status = 0;
        $reqdata1 = array("BusinessUnit" => "ECOM", "ServiceType" => $servicetype, "DeliveryType" => $delivertype);
        $reqdata = json_encode($reqdata1);
        $headerdata = array("Content-Type" => "application/json", "XBKey" => EXP_BEES_XBKEY);
        $server_url = EXP_BEES_AWB;
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($server_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headerdata);
        $request->setBody($reqdata);

        log_error(
            UNIQLO_LOG_PREFIX . 'getxbawbbatch connecting with API: ' . $server_url . ' with payload ' . $reqdata
        );

        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $postresp = $response->getBody();

                log_error(
                    UNIQLO_LOG_PREFIX . 'getxbawbbatch API response payload: ' . $postresp
                );

                $resp = json_decode($postresp, true);
                if (isset($resp['ReturnCode'])) {
                    if ($resp['ReturnCode'] == "100") {
                        $batchid = $resp['BatchID'];
                        $getawbs = $this->getawbseries($batchid, $servicetype, $delivertype);
                        $status = 1;
                    }
                }
            } else {
                $postresp = 'Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $postresp = 'Error: ' . $e->getMessage();
        }

        log_error(UNIQLO_LOG_PREFIX . "getxbawbbatch outbound data: " . $postresp);

        echo $postresp;
    }

    public function getawbseries($batchid, $servicetype, $delivertype)
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->helper('log_helper');

        $reqdata1 = array("BusinessUnit" => "ECOM", "ServiceType" => $servicetype, "BatchID" => $batchid);
        $reqdata = json_encode($reqdata1);
        $headerdata = array("Content-Type" => "application/json", "XBKey" => EXP_BEES_XBKEY);
        $server_url = EXP_BEES_AWB_SR;
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($server_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headerdata);
        $request->setBody($reqdata);

        log_error(
            UNIQLO_LOG_PREFIX . 'getawbseries connecting with API: ' . $server_url . ' with payload ' . $reqdata
        );

        $response = $request->send();
        if ($response->getStatus() == 200) {
            $postresp = $response->getBody();

            log_error(
                UNIQLO_LOG_PREFIX . 'getawbseries API response payload: ' . $postresp
            );

            $resp = json_decode($postresp, true);
            if (isset($resp['ReturnCode'])) {
                if ($resp['ReturnCode'] == "100") {
                    $servtype = 1;
                    if ($servicetype != "FORWARD") {
                        $servtype = 0;
                    }
                    $whr = array(
                        "vendor_id" => '312',
                        "batch_id" => $batchid,
                        "service_type" => $servtype,
                        "deliver_type" => $delivertype,
                        "status" => 1
                    );
                    $select = "id";
                    $serieslist = $resp['AWBNoSeries'];
                    $start = $serieslist[0];
                    $end = $serieslist[count($serieslist) - 1];
                    $refqry = $ci->common->gettblrowdata($whr, $select, "tb_xpressbees_awb_data", 0, 0);
                    if (count($refqry) == 0) {
                        $insarr = array(
                            "vendor_id" => '312',
                            "batch_id" => $batchid,
                            "awb_start" => $start,
                            "awb_end" => $end,
                            "current_awb" => $start,
                            "service_type" => $servtype,
                            "deliver_type" => $delivertype,
                            "status" => 1,
                            "awb_reqdate" => $resp['AWBNoGenRequestedDateTime']
                        );

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "getawbseries inserted data in a tb_xpressbees_awb_data: " . json_encode($insarr)
                        );

                        $ins = $ci->common->insertTableData("tb_xpressbees_awb_data", $insarr);
                    }
                }
            }
        }
    }

    private function sftpUpload(string $remoteFile, string $data): void
    {
        $upload = $this->sftpConnection->put($remoteFile, $data, SFTP::SOURCE_LOCAL_FILE);
        if(!$upload)
        {
            throw new \Exception('MFT upload failed!');
        }
    }
}
