<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Vehicledriverupdatehandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['standardstatusmodel', 'common','Roadlogtosalogmodel']);
    }


    public function updateVehicleDriverForTrip(array $postXMLData): array
    {
        try {
            $orderTripinfo = $this->readRequestedXML($postXMLData);
            if (array_key_exists("status", $orderTripinfo) && $orderTripinfo['status'] == "Failed") {
                return $orderTripinfo;
            }
            return $this->updateOrderTripDetails($orderTripinfo);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While inserting the Order Status " . $ex->getMessage());
        }
        return ['status' => "Failed", "status_code" => "500", 'message' => "Some Internal Server Error server"];
    }

    private function readRequestedXML(array $postXMLData): array
    {
        $orderHeader = $postXMLData['SVKEDITransmissionHeader'];
        $orderInfo = $postXMLData['SVKEDITransmissionBody']['TripDetails'];
        $orderID = !empty($orderInfo['OrderID']) ? $orderInfo['OrderID'] : "";
        $tripID = !empty($orderInfo['TripID']) ? $orderInfo['TripID'] : "";
        $vehicleRegistrationNumber = !empty($orderInfo['VehicleDetails']['VehicleRegistrationNumber']) ? $orderInfo['VehicleDetails']['VehicleRegistrationNumber'] : "";
        $driverName = !empty($orderInfo['DriverDetails']['DriverName']) ? $orderInfo['DriverDetails']['DriverName'] : "";
        if ($orderID === "") {
            log_message("error", "Booking ID Empty for: " . json_encode($orderInfo));
            return ['status' => "Failed", "status_code" => "400", 'message' => "Booking ID Empty"];
        }
        if ($vehicleRegistrationNumber === "") {
            log_message("error", "Vehicle Registration Number Empty for: " . json_encode($orderInfo));
            return ['status' => "Failed", "status_code" => "400", 'message' => "Vehicle Registration Number Empty"];
        }
        if ($driverName === "") {
            log_message("error", "Driver Name Empty for: " . json_encode($orderInfo));
            return ['status' => "Failed", "status_code" => "400", 'message' => "Driver Name Empty"];
        }

        $headerdata = [
            "EDIVersion" => !empty($orderHeader['EDIVersion']) ? $orderHeader['EDIVersion'] : "",
            "SenderTransmissionNo" => !empty($orderHeader['SenderTransmissionNo']) ? $orderHeader['SenderTransmissionNo'] : "",
            "AckOption" => !empty($orderHeader['AckSpec']['AckOption']) ? $orderHeader['AckSpec']['AckOption'] : "",
            "EmailAddress" => !empty($orderHeader['AckSpec']['EmailAddress']) ? $orderHeader['AckSpec']['EmailAddress'] : "",
            "SourceApp" => !empty($orderHeader['SourceApp']) ? $orderHeader['SourceApp'] : "",
            "DestinationApp" => !empty($orderHeader['DestinationApp']) ? $orderHeader['DestinationApp'] : "",
            "Action" => !empty($orderHeader['Action']) ? $orderHeader['Action'] : ""
        ];
        $vehicleDetails = [
            "register_number" => !empty($orderInfo['VehicleDetails']['VehicleRegistrationNumber']) ? $orderInfo['VehicleDetails']['VehicleRegistrationNumber'] : "",
            "truck_type" => !empty($orderInfo['VehicleDetails']['VehicleTypeCode']) ? $orderInfo['VehicleDetails']['VehicleTypeCode'] : "TRUCK",
            "truck_weight" => !empty($orderInfo['VehicleDetails']['VehicleWeight']) ? $orderInfo['VehicleDetails']['VehicleWeight'] : "100",
            "fuel_type" => !empty($orderInfo['VehicleDetails']['VehicleFuelType']) ? $orderInfo['VehicleDetails']['VehicleFuelType'] : "PETROL",
        ];

        $driverDetails = [
            "name" => !empty($orderInfo['DriverDetails']['DriverName']) ? $orderInfo['DriverDetails']['DriverName'] : "",
            "driving_licence_num" => !empty($orderInfo['DriverDetails']['DriverLicence']) ? $orderInfo['DriverDetails']['DriverLicence'] : "",
            "driver_national_identification_number" => !empty($orderInfo['DriverDetails']['DriverNationalIdentificationNumber']) ? $orderInfo['DriverDetails']['DriverNationalIdentificationNumber'] : "",
            "contact_num" => !empty($orderInfo['DriverDetails']['ContactNo']) ? $orderInfo['DriverDetails']['ContactNo'] : "",
        ];
        $remark =  !empty($orderInfo['Remark']) ? $orderInfo['Remark'] : "";

        $orderDetails = [
            "order_id" => $orderID,
            "shipment_id" => $tripID,
            "vehicleDetails" => $vehicleDetails,
            "driverDetails" => $driverDetails,
            "remark" => $remark,
        ];
        return $orderDetails ?? [];
    }

    private function updateOrderTripDetails(array $orderDetails): array
    {
        $tripInformation = $this->ci->standardstatusmodel->getTripInformation($orderDetails['order_id']);
        if (empty($tripInformation)) {
            log_message("error", "There is no Data Found with this Booking " . $orderDetails['order_id']);
            return ['status' => "Failed", "status_code" => "401", 'message' => "Invalid Booking ID " . $orderDetails['order_id']];
        }
        $orderid = $tripInformation['orderid'];
        $this->ci->edi_logger->setTxn_obj_id($orderid);
        $shift_id = $tripInformation['shift_id'];
        $trip_id = $tripInformation['trip_id'];
        $carrier_id = $tripInformation['carrier_id'];
        $driver_id = $tripInformation['driver_id'];
        $vehicle_id = $tripInformation['vehicle_id'];
        $company_code = $tripInformation['company_code'];
        $branch_code = $tripInformation['branch_code'];
        $user_id = $tripInformation['user_id'];
        $this->ci->edi_logger->setUser_id($user_id);
        $this->ci->edi_logger->setCompany_code($company_code);
        $this->ci->edi_logger->setBranch_code($branch_code);
        $ediVehicleIid = $this->checkVehicleDetails($orderDetails['vehicleDetails'], $carrier_id, $user_id, $company_code, $branch_code);
        $ediDriverID = $this->checkDriverDetails($orderDetails['driverDetails'], $carrier_id, $user_id, $company_code, $branch_code);
        $newVehicleAndDriverFlag = 0;
        //log_message("error", "ediVehicleIid " . $ediVehicleIid);
        //log_message("error", "vehicle_id " . $vehicle_id);
        //log_message("error", "ediDriverID " . $ediDriverID);
        //log_message("error", "driver_id " . $driver_id);
        if ($ediVehicleIid != $vehicle_id || $ediDriverID != $driver_id) {
            $newVehicleAndDriverFlag = 1;
            $checkAssignedDriverExists = $this->ci->common->gettblrowdata(['vehicle_id' => $ediVehicleIid, 'driver_id' => $ediDriverID, 'status' => 1], "id", "tbl_assigned_drivers", 0, 0);
            if (empty($checkAssignedDriverExists)) {
                $data["driver_id"] = $ediDriverID;
                $data["vehicle_id"] = $ediVehicleIid;
                $data["user_id"] = $user_id;
                $data['mobile_no'] = $orderDetails['driverDetails']['contact_num'] ?? (str_replace(" ", "", $orderDetails['driverDetails']['name']));
                $data["created_on"] = $data["from_time"] = $data["to_time"] = date('Y-m-d H:i:s');
                $this->ci->common->updatetbledata("tbl_assigned_drivers", ['status' => 0], ['vehicle_id' => $ediVehicleIid]);
                $this->ci->common->insertTableData("tbl_assigned_drivers", $data);
            }
            $this->ci->common->insertTableData("tb_vehicles_drivers", ["vehicle_id" => $ediVehicleIid, "driver_id" => $ediDriverID, "imei" => "", "status" => "1", "createdon" => date('Y-m-d H:i:s')]);
            $this->ci->common->insertTableData("tb_vendor_vehicles", ["vehicle_id" => $ediVehicleIid, "vendor_id" => $carrier_id, "status" => "1", "createdon" => date('Y-m-d H:i:s')]);
            $this->ci->common->updatetbledata("tb_trips", ["vehicle_id" => $ediVehicleIid, "driver_id" => $ediDriverID], ["id" => $trip_id]);
            $this->ci->common->updatetbledata("tb_shft_veh", ["vehicle_id" => $ediVehicleIid, "register_number" => $orderDetails['vehicleDetails']['register_number']], ["shft_id" => $shift_id]);
            $this->ci->common->insertTableData("tb_shft_veh_history", [
                "user_id" => $user_id,
                "shft_id" => $shift_id,
                "carrier_id" => $carrier_id,
                "vehicle_id" => $ediVehicleIid,
                "driver_id" => $ediDriverID,
                "register_number" => $orderDetails['vehicleDetails']['register_number'],
                "remarks" => $orderDetails['remark'],
                "status" => "1",
                'created_on' => date('Y-m-d H:i:s'),
                'updated_on' => date('Y-m-d H:i:s')
            ]);
        } else {
            $checkMultiOrders = $this->ci->common->gettbldata(["shift_id" => $shift_id], "id,order_id", "tb_orders", 0, 0);
            if (count($checkMultiOrders) > 1) {
                foreach ($checkMultiOrders as $orders) {
                    if ($orders['order_id'] === $orderDetails['order_id']) {
                        $newVehicleAndDriverFlag = 1;
                        $orderid = $orders['id'];
                    }
                }
            }
        }
        if ($newVehicleAndDriverFlag == 1 && in_array($company_code, ['CNKN', 'TWKN'])) {
            //log_message("error", "company_code " . $company_code);
            $this->sendNotificationForNewDriverAndVehicle($orderDetails, $orderid);
        }
        return ['status' => "Success", "status_code" => "200", 'message' => "Vehicle Driver Details Uploaded Successfully"];
    }

    public function checkVehicleDetails(array $vehicleDetails, int $carrier_id, int $user_id, string $company_code, string $branch_code): int
    {
        $vehicleTypeData = [
            "trucktype" => $vehicleDetails['truck_type'],
            "description" => $vehicleDetails['truck_type'],
            "company_code" => $company_code,
            "branch_code" => $branch_code,
            "user_id" => $user_id,
            "status" => 'Active'
        ];
        $checkVehicleType = $this->ci->common->gettblrowdata($vehicleTypeData, "id", "tb_trucktypes", 0, 0);
        if (!empty($checkVehicleType)) {
            $vehicleTypeID = $checkVehicleType['id'];
        } else {
            $vehicleTypeID = $this->ci->common->insertTableData('tb_trucktypes', $vehicleTypeData);
        }
        $vehicleDetails ['vendor_id'] = $carrier_id;
        $vehicleDetails ['user_id'] = $user_id;
        $vehicleDetails ['truck_type'] = $vehicleTypeID ?? 0;
        $checkExistingVehicle = $this->ci->common->gettblrowdata(['register_number' => $vehicleDetails['register_number'], 'vendor_id' => $carrier_id, 'user_id' => $user_id, 'status' => 1], "id", "tb_trucks_data", 0, 0);
        if (empty($checkExistingVehicle)) {
            $vehicle_id = $this->ci->common->insertTableData('tb_trucks_data', $vehicleDetails);
        } else {
            $vehicle_id = $checkExistingVehicle['id'];
            $this->ci->common->updatetbledata("tb_trucks_data", $vehicleDetails, ['id' => $vehicle_id]);
        }
        return $vehicle_id ?? 0;
    }

    public function checkDriverDetails(array $driverDetails, int $carrier_id, int $user_id, string $company_code, string $branch_code): int
    {
        $checkExistingDriver = $this->ci->common->gettblrowdata(['name' => $driverDetails['name'], 'vendor_id' => $carrier_id, 'user_id' => $user_id, 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 1], "id", "tb_truck_drivers", 0, 0);
        if (empty($checkExistingDriver)) {
            $driverDetails ['vendor_id'] = $carrier_id;
            $driverDetails ['user_id'] = $user_id;
            $driverDetails ['company_code'] = $company_code;
            $driverDetails ['branch_code'] = $branch_code;
            $password = str_replace(" ", "", $driverDetails['name']);
            $driverDetails ['password'] =  password_hash($password,PASSWORD_DEFAULT);
            $driverDetails ['contact_num'] = $driverDetails ['contact_num'] ?? (str_replace(" ", "", $driverDetails['name']));
            $driver_id = $this->ci->common->insertTableData('tb_truck_drivers', $driverDetails);
        } else {
            $driver_id = $checkExistingDriver['id'];
        }
        return $driver_id ?? 0;
    }

    private function sendNotificationForNewDriverAndVehicle(array $data, int $orderRowId): void
    {
        $vehicleDetails = $data['vehicleDetails'];
        $driverDetails = $data['driverDetails'];
        $vehicleTypeCode = (!empty($vehicleDetails['truck_type'])) ? $vehicleDetails['truck_type'] : '';
        $registrationNumber = (!empty($vehicleDetails['register_number'])) ? $vehicleDetails['register_number'] : '';
        $driverName = (!empty($driverDetails['name'])) ? $driverDetails['name'] : '';
        $driverLicence = (!empty($driverDetails['driving_licence_num'])) ? $driverDetails['driving_licence_num'] : '';
        $driverNationalIdentificationNumber = (!empty($driverDetails['driver_national_identification_number'])) ? $driverDetails['driver_national_identification_number'] : '';
        $driverContactNo = (!empty($driverDetails['contact_num'])) ? $driverDetails['contact_num'] : '';
        $getCustomerIdAndCode = $this->ci->standardstatusmodel->getCustomerIdAndCode($data['order_id']);
        $customerCode = '';
        $customerGroupEmailIds = $bccMailIds = [];
        $getCarrierEmailId = $this->ci->Roadlogtosalogmodel->getCarrierEmailId($data['order_id']);
        if (($getCarrierEmailId['email'] ?? '') != '') {
            $bccMailIds[] = $getCarrierEmailId['email'];
        }
        if ($registrationNumber == '' && $driverName == '') {
            return;
        }
        if (!empty($getCustomerIdAndCode)) {
            $customerId = $getCustomerIdAndCode['id'];
            $customerCode = $getCustomerIdAndCode['code'];
            $customerGroupEmailIds = $this->ci->Roadlogtosalogmodel->getCustomerGroupEmailIds($customerId);
        }
        $getReferences = $this->ci->common->gettbldata_where_in(['order_id' => $orderRowId, 'status' => 1], ['col' => 'reference_id', 'arr' => ['SAC', 'XSR', 'SDT']], 'reference_id,ref_value', 'tb_order_references', 0, 0);
        if (empty($getReferences)) {
            return;
        }
        $toEmailId = $trackingNumber = $importType = '';
        foreach ($getReferences as $eachReferences) {
            if ($eachReferences['reference_id'] == 'SAC') {
                $toEmailId = $eachReferences['ref_value'];
            } elseif ($eachReferences['reference_id'] == 'XSR') {
                $trackingNumber = $eachReferences['ref_value'];
            } elseif ($eachReferences['reference_id'] == 'SDT') {
                $importType = $eachReferences['ref_value'];
            }
        }
        if ($toEmailId == '') {
            return;
        }
        $ccMailIds = [];

        switch ($customerCode) {
            case "1000211110":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'SZX-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'scnair-import.occ@kuehne-nagel.com';
                }
                break;
            case "1000211118":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'XMN-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                }
                break;
            case "1000353916":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'HDU-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                }
                break;
            case "1000397871":
                $ccMailIds[] = 'knzsn.air.ccl@kuehne-nagel.com';
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'SZX-OCC@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'SCNAIR-IMPORT.OCC@KUEHNE-NAGEL.COM';
                }
                break;
            case "1000466462":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                } elseif ($importType == 'DEL') {
                    $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                    $ccMailIds[] = 'knhkg.zao.import@kuehne-nagel.com';
                }
                break;
            case "1004573268":
                if ($importType == 'PUP' || $importType == 'IMP') {
                    $ccMailIds[] = 'knhkg.zao.trucking@kuehne-nagel.com';
                }
                break;
            case "1000659010":
                $ccMailIds[] = 'kncgo.air.pricing@kuehne-nagel.com';
                break;
            case "1000211120":
                $ccMailIds[] = 'knsia.air.ccl@kuehne-nagel.com';
                break;
            case "1000210679":
                $ccMailIds[] = 'knckg.air.ccl@kuehne-nagel.com';
                break;
            case "1000084925":
                $ccMailIds[] = 'knwuh.air.ccl@kuehne-nagel.com';
                break;
            case "1000599141":
                $ccMailIds[] = 'jerry.w.ding@kuehne-nagel.com';
                break;
            case "1000210660":
                $ccMailIds[] = 'knctu.air.ccl@kuehne-nagel.com';
                break;
            default:
                $ccMailIds = [];
        }
        $ccMailIds = array_merge($customerGroupEmailIds,$ccMailIds);
        $subject = "Booking ID:" . $data['order_id'] . " SALOG Tracking No: " . ($trackingNumber ?? '');
        $message = "Hi, <br><br>";
        $message .= "Vehicle Type                           : " . $vehicleTypeCode . "<br>";
        $message .= "Registration Number                    : " . $registrationNumber . "<br>";
        $message .= "Driver Name                            : " . $driverName . "<br>";
        $message .= "Driver Licence                         : " . $driverLicence . "<br>";
        $message .= "DriverNational Identification Number   : " . $driverNationalIdentificationNumber . "<br>";
        $message .= "Driver Contact No                      : " . $driverContactNo . "<br><br>";
        $message .= "Remark                                 : " . $data['remark'] . "<br><br>";
        $message .= "Best Regards,<br>";
        $message .= "svkonekt Team";
        try {
            $this->ci->load->library('PhpMailerLibrary');
            if ($this->ci->phpmailerlibrary->sendmail($toEmailId, $subject, $message, $ccMailIds, [], $bccMailIds)) {
                log_message("error", "sendNotificationForNewDriverAndVehicle DTO  email success " . $subject . " -- " . $message." bcc -".json_encode($bccMailIds)." cc -".json_encode($ccMailIds)." toEmailId " . $toEmailId. " " . $customerCode);
            } else {
                log_message("error", "sendNotificationForNewDriverAndVehicle DTO  email failed" . $subject . " -- " . $message." bcc -".json_encode($bccMailIds)." cc -".json_encode($ccMailIds)." toEmailId " . $toEmailId. " " . $customerCode);
            }
        } catch (Exception $e) {
            log_message("error", "sendNotificationForNewDriverAndVehicle DTO  email failed - " . $e->getMessage());
        }
    }
}
