<?php

class Vendorservice
{
    private $ci;

    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('ediroutermodel');
    }

    public function vendorsRequestHandler(int $shift_id, int $carrerid, string $carrer, string $company_code): void
    {
        $carrername = trim(urldecode($carrer));
        switch ($carrername) {
            case 'КОМПАНИЯ СКИФ-КАРГО ООО':
            case 'SKIF':
                $this->ci->load->library("carrierskifcargoedi");
                $this->ci->carrierskifcargoedi->shipmentdata($shift_id);
                self::success('API triggered successfully.');
                break;
            case 'РУС-ЭКСПРЕСС ООО':
            case 'RUEXP':
                $this->ci->load->library("Orderdetailsrusiaedi");
                $this->ci->orderdetailsrusiaedi->shipmentdata($shift_id);
                self::success('API triggered successfully.');
                break;
            case 'ВОЗОВОЗ ООО':
            case 'VOZOVOZ':
                $this->ci->load->library('VozovozEdi');
                $this->ci->vozovozedi->shipmentdata($shift_id);
                self::success('API triggered successfully.');
                break;
            case 'БТК ООО':
            case 'BITE-TRANSIT':
                $this->ci->load->library('BiteTransitService');
                $this->ci->bitetransitservice->shipmentdata($shift_id);
                break;
            case 'ETN-URBS':
                $this->etnUrbsRequestHandler($shift_id, $carrerid);
                break;
            default:
                $customerInfo = $this->ci->ediroutermodel->getTripCustomer($shift_id);
                if (isset($customerInfo['name'])
                    && in_array($customerInfo['name'], ['COMMON WEALTH GAMES', 'COMMONWEALTH GAMES'], true)
                    && 'UKKN-CG' === $company_code) {
                    $this->commonWealthGamesRequestHandler($shift_id, $carrerid);
                    return;
                }
                self::failure('Unable to perform any actions');
                break;
        }
    }

    public function commonWealthGamesRequestHandler(int $shiftId, int $carrerId): void
    {
        $shipmentId = $this->ci->ediroutermodel->getShipmentId($shiftId);
        $this->ci->load->library(
            'edi/carriernotification/CarrierTripNotification',
            'carriertripnotification'
        );
        try {
            $outputXml = $this->ci->carriertripnotification->generateXml($shiftId, '', '');
        } catch (\Throwable $th) {
            self::failure($th->getMessage());
            return;
        }
        if ($outputXml) {
            $this->ci->load->library(
                'edi/carriernotification/CarrierNotificationSftpManager',
                'carriernotificationsftpmanager'
            );
            try {
                $this->ci->carriernotificationsftpmanager->initializeConnectionSettings(
                    [
                        'url' => OPENBOX_SERVER_IP,
                        'username' => OPENBOX_USERNAME,
                        'password' => OPENBOX_PASSWORD,
                        'path' => OPENBOX_TRIP_NOTIFICATION_INBOUND
                    ]
                );
                $this->ci->carriernotificationsftpmanager->uploadToSftp(
                    $outputXml,
                    $shipmentId . '_' . $carrerId
                );
            } catch (\Throwable $th) {
                self::failure($th->getMessage());
                return;
            }
            self::success('API triggered successfully.');
        } else {
            self::failure('Invalid xml is generated');
        }
    }

    public function etnUrbsRequestHandler(int $shiftId, int $carrerId): void
    {
        $shipmentId = $this->ci->ediroutermodel->getShipmentId($shiftId);
        $this->ci->load->library('edi/carriernotification/CarrierTripNotification', 'carriertripnotification');
        try {
            $outputXml = $this->ci->carriertripnotification->generateXml($shiftId, '', '');
        } catch (\Throwable $th) {
            self::failure($th->getMessage());
            return;
        }
        if ($outputXml) {
            $this->ci->load->library(
                'edi/carriernotification/CarrierNotificationSftpManager',
                'carriernotificationsftpmanager'
            );
            try {
                $this->ci->carriernotificationsftpmanager->initializeConnectionSettings(
                    [
                        'url' => CARRIER_NOTIFICATION_URL,
                        'username' => CARRIER_NOTIFICATION_USERNAME,
                        'password' => CARRIER_NOTIFICATION_PWD,
                        'path' => CARRIER_NOTIFICATION_OUTBOUND,
                    ]
                );
                $this->ci->carriernotificationsftpmanager->uploadToSftp(
                    $outputXml,
                    $shipmentId . '_' . $carrerId
                );
            } catch (\Throwable $th) {
                self::failure($th->getMessage());
                return;
            }
            self::success('API triggered successfully.');
        } else {
            self::failure('Invalid xml is generated');
        }
    }

    public static function success(string $message): void
    {
        self::status(1, $message);
    }

    public static function failure(string $message): void
    {
        self::status(0, $message);
    }

    public static function status(int $status, string $message): void
    {
        echo json_encode(['status' => $status, 'message' => $message]);
    }
}
