<?php
class Wechat {
    private $CI;
    public string $orderId = "";
    public int $isDuplicateTrigger = 0;

    public function __construct() {
        $this->CI = &get_instance();
    }

    public function sendNotificationsToWeChat(): array {
        $status = 0; $response = [];
        $this->CI->load->model('wechatmodel', 'chat');
        log_message("error", "WECHAT NOTIFICATION isDuplicateTrigger => ".$this->isDuplicateTrigger." ORDER ID ".$this->orderId." @ ".gmdate('d-m-Y H:i:s'));
        $isTriggered = (int) $this->CI->chat->checkShipmentHistory($this->orderId);
        if ( $this->isDuplicateTrigger === 1 ||  $isTriggered === 0) {
            $shipmentDetails = $this->CI->chat->getShipmentDetails($this->orderId);
            if (empty($shipmentDetails)) {
                return ['status' => $status, 'message' => 'Invalid Shipment Id', 'data' => []];
            }
            $this->CI->load->model('Common');
            $this->CI->load->helper("jwt");
            $headerParams = [
                'Content-Type:application/json',
                'x-kn-api-key:' . WECHAT_ACCESS_TOKEN
            ];
            $vendorInfo = $this->CI->Common->gettblrowdata(['id' => $shipmentDetails["vendor_id"]], ['code'], 'tb_vendors', 1, 0);
            $carrierPartyIdentifier = $vendorInfo['code'] ?? 0;
            $transAction = "";
            if ((int)$shipmentDetails["trip_id"] > 0) {
                $getXSRDetailsByTripId = $this->CI->chat->getXSRDetailsByTripId($shipmentDetails["trip_id"]);
                if ($getXSRDetailsByTripId) {
                    $getXSRDetailsByTripId = array_column($getXSRDetailsByTripId, "ref_value");
                    $transAction = implode("/", $getXSRDetailsByTripId);
                }
            }
            $functionCode = (int) $shipmentDetails['status'] === 3 ? 'CA' : 'CR';
            $expDate = strtotime('+10 days');
            $jwtClaim = ["sub" => $shipmentDetails["shipmentid"], "exp" => $expDate, 'iss' => 'kn' . $carrierPartyIdentifier];
            $getJwt = generate_jwt($jwtClaim);
            $shortUrl = base_url() . "driverappv3/" . $getJwt;
            $this->CI->load->library('shorturl_l');
            $shortUrl = $this->CI->shorturl_l->urlToShortCode($shortUrl);
            $tinyUrl = base_url('shurl/'.$shortUrl);
            $tinyUrl = $tinyUrl ? $tinyUrl : base_url();
            $bodyParams = [
                "shipmentCode" => $shipmentDetails["shipmentid"],
                "pickUpDate" => (new DateTime($shipmentDetails["pickup_datetime"]))->format('Y-m-d\TH:i:s.v\Z'),
                "deliveryUpDate" => (new DateTime($shipmentDetails["delivery_datetime"]))->format('Y-m-d\TH:i:s.v\Z'),
                "companyCode" => $shipmentDetails["carrier_code"],
                "companyName" => $shipmentDetails["carrier_name"],
                "shortUrl" => $tinyUrl,
                "FNCODE" => $functionCode,
                "TN" => (string) $transAction
            ];
            $post = json_encode($bodyParams);
            log_message("error", "WECHAT POST SHIPMENT DATA => ".$post);
            require_once './vendor/pear/http_request2/HTTP/Request2.php';
            $request = new HTTP_Request2();
            $request->setUrl(WECHAT_BASE_URL);
            $request->setMethod(HTTP_Request2::METHOD_POST);
            $request->setConfig(getHttpRequestConfig());
            $request->setHeader($headerParams);
            $request->setBody($post);
            try {
                $response = $request->send();
                if (in_array($response->getStatus(), [200, 201])) {
                    log_message("error", 'You have successfully triggered shipment from eTN to weChat at'.gmdate('d-m-Y h:i A'));
                    $responseBody = $response->getBody();
                    $responseBody = json_decode($responseBody, true);
                    $response = $responseBody['data'];
                    $status = 1;
                    if ($this->isDuplicateTrigger === 0 && $isTriggered === 0) {
                        $this->CI->chat->createShipmentHistory($this->orderId);
                    }
                } else {
                    $errorMsg = 'HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                    log_message("error", $errorMsg);
                }
            } catch (HTTP_Request2_Exception $e) {
                $errorMsg = 'Wechat  Error: ' . $e->getMessage();
                log_message("error", $errorMsg);
            }
        } else {
            log_message("error", "Duplicate shipment is triggered to wechat, Shipment ID ".$this->orderId." @ ".gmdate('d-m-Y h:i A'));
        }
        return ['status' => $status, 'message' => 'Success', 'data' => $response];
    }
}