<?php
class WheelsEye
{
    private const LOCATION_REQUIRED = false;
    private const RESPONSE_LIMIT = 100;

    public function getAllVehicles(): array
    {
        $vehicleData = $vehicleList = [];
        $currentPageNo = 0;
        $url = $this->getApiUrl($currentPageNo);
        $vehicleLocation = $this->getLocation($url);
        if ($vehicleLocation && isset($vehicleLocation['data']['list']) && is_array($vehicleLocation['data']['list'])) {
            $vehicleList = array_merge($vehicleList, $vehicleLocation['data']['list']);
            $totalPages = $vehicleLocation['data']['totalPages'];
            for ($currentPage = 1; $totalPages > $currentPage; $currentPage++) {
                $url = $this->getApiUrl($currentPage);

                $vehicleLocation = $this->getLocation($url);
                $vehicleList = array_merge($vehicleList, $vehicleLocation['data']['list']);
            }
            foreach ($vehicleList as $vehicleApiData) {
                $vehicleData[$vehicleApiData['vehicleNumber']] = $vehicleApiData;
            }
        }
        return $vehicleData;
    }

    private function getLocation(string $url): array
    {
        $vehicleData = [];
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig([
            'follow_redirects' => true,
            'ssl_verify_peer' => true,
            'ssl_verify_host' => true,
            'connect_timeout' => 100,
            'timeout' => 120
        ]);
        $curlAdapter = new HTTP_Request2_Adapter_Curl();
        $request->setAdapter($curlAdapter);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $responseBody = $response->getBody();
                $vehicleData = json_decode($responseBody, true);
            } else {
                $errorMsg = 'HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $errorMsg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $errorMsg = 'WHEELSEYE Vehicle Location Error: ' . $e->getMessage();
            log_message("error", $errorMsg);
        }
        return $vehicleData;
    }

    private function getApiUrl(int $pageNo): string
    {
        return WHEELSEYE_URL . "currentLoc?accessToken=" . WHEELSEYE_AUTH_KEY . "&isLocationReq=" . self::LOCATION_REQUIRED . "&size=" . self::RESPONSE_LIMIT . self::LOCATION_REQUIRED . "&pageNo=" . $pageNo;
    }

    public function getUnknownRegisterNumbers(array $orders, array $registerNumbers): array
    {
        $knownRegisterNumbers = [];
        $unknownRegisterNumbersFromApi = [];
        foreach($orders as $order) {
            $knownRegisterNumbers[] = $order['register_number'];
        }
        foreach ($registerNumbers as $registerNumber) {
            if (!in_array($registerNumber, $knownRegisterNumbers)) {
                $unknownRegisterNumbersFromApi[] = $registerNumber;
            }
        }
        return $unknownRegisterNumbersFromApi;
    }
    
    
}