<?php
namespace SVKAPI\v1\Interfaces;

use SVKAPI\v1\Models\Trip;

/**
 * @property string $endpoint
 * @property array $data
 * @property string $method
 */
interface ApiClientInterface
{
    /**
     * @return $this
     */
    public function setEndpoint(string $url) : self;

    /**
     * @return string
     */
    public function getEndpoint() : string;

    /**
     * @param string $data
     * @return $this
     */
    public function setData(string $data) : self;

    /**
     * @return array
     */
    public function getData() : array;

    /**
     * @param string $method
     * @return $this
     */
    public function setMethod(string $method) : self;

    /**
     * @return string
     */
    public function getMethod() : string;

    /**
     * @return bool
     */
    public function send() :  bool;
}
