<?php
namespace SVKAPI\v1\Mappings;

use SVKAPI\v1\Interfaces\MappingInterface;

abstract class AbstractMapping implements MappingInterface
{
    /**
     * @var array
     */
    protected $errors = [];


    /**
     * @return array
     */
    public function getErrors(): array
    {
        return $this->errors;
    }

    public function setError($error)
    {
        if (is_array($error)) {
            $this->errors = array_merge($this->errors, $errors);
        } else {
            $this->errors[] = $error;
        }
    }


}
