<?php
namespace SVKAPI\v1\Mappings;

use SVKAPI\v1\Models\Trip;
use SVKAPI\v1\Models\Reference;

class ReferencesMapping extends AbstractMapping
{
    /**
     * Global Object for CI unstance
     */
    private $CI;

    /**
     */
    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model([
            'order',
            'order_references'
        ]);
    }

    /**
     * @param int $shiftId
     * @param Trip $model
     * @return Trip
     */
    public function map(int $shiftId, Trip &$model): Trip
    {
        $orders = $this->CI->order->base_query([
            'shift_id' => $shiftId
        ], false)->select(['id'])->get()->result_array();


        $references = [];
        if (!empty($orders)) {
            $orderIds = array_column($orders, 'id');
            $orderReferences = $this->CI->order_references->find([
                'order_id' => $orderIds
            ]);
            foreach ($orderReferences as $entity) {
                $references[] = new Reference([
                    'code' => $entity->reference_id,
                    'value' => $entity->ref_value
                ]);
            }
        }

        $model->setTripReferences($references);
        return $model;
    }
}
