<?php
/**
 * Order
 *
 * PHP version 7.1.3
 *
 * @category Class
 * @package  SVKAPI\v1\Models
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * Shipsy
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace SVKAPI\v1\Models;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlRoot;
use JMS\Serializer\Annotation\XmlElement;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class representing the Order model.
 *
 * @package SVKAPI\v1\Models
 * @author  OpenAPI Generator team
 */
/** @XmlRoot("Order") */
class Order 
{
        /**
     * The ID of the order
     *
     * @var int
     * @SerializedName("OrderId")
     * @Assert\NotNull()
     * @Assert\Type("int")
     * @Type("int")
     */
    protected $orderId;

    /**
     * The ID of the leg
     *
     * @var string
     * @SerializedName("LegId")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $legId;

    /**
     * @var string
     * @SerializedName("ServiceLevel")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $serviceLevel;

    /**
     * @var string
     * @SerializedName("ServiceType")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $serviceType;

    /**
     * The code of the company that the order belongs to
     *
     * @var string
     * @SerializedName("CompanyCode")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $companyCode;

    /**
     * The branch of the company that the order belongs to
     *
     * @var string
     * @SerializedName("Branch")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $branch;

    /**
     * The tracking number of the order
     *
     * @var string
     * @SerializedName("TrackingNumber")
     * @Assert\NotNull()
     * @Assert\Type("string")
     * @Type("string")
     * @XmlElement(cdata=false)
     */
    protected $trackingNumber;

    /**
     * @var SVKAPI\v1\Models\OrderGood
     * @SerializedName("OrderGoods")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\Type("SVKAPI\v1\Models\OrderGood")
     * @Type("SVKAPI\v1\Models\OrderGood")
     */
    protected $orderGoods;

    /**
     * @var SVKAPI\v1\Models\PickupStop
     * @SerializedName("Pickup")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\Type("SVKAPI\v1\Models\PickupStop")
     * @Type("SVKAPI\v1\Models\PickupStop")
     */
    protected $pickup;

    /**
     * @var SVKAPI\v1\Models\DeliveryStop
     * @SerializedName("Delivery")
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\Type("SVKAPI\v1\Models\DeliveryStop")
     * @Type("SVKAPI\v1\Models\DeliveryStop")
     */
    protected $delivery;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->orderId = isset($data['orderId']) ? $data['orderId'] : null;
        $this->legId = isset($data['legId']) ? $data['legId'] : null;
        $this->serviceLevel = isset($data['serviceLevel']) ? $data['serviceLevel'] : null;
        $this->serviceType = isset($data['serviceType']) ? $data['serviceType'] : null;
        $this->companyCode = isset($data['companyCode']) ? $data['companyCode'] : null;
        $this->branch = isset($data['branch']) ? $data['branch'] : null;
        $this->trackingNumber = isset($data['trackingNumber']) ? $data['trackingNumber'] : null;
        $this->orderGoods = isset($data['orderGoods']) ? $data['orderGoods'] : null;
        $this->pickup = isset($data['pickup']) ? $data['pickup'] : null;
        $this->delivery = isset($data['delivery']) ? $data['delivery'] : null;
    }

    /**
     * Gets orderId.
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * Sets orderId.
     *
     * @param int $orderId  The ID of the order
     *
     * @return $this
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;

        return $this;
    }

    /**
     * Gets legId.
     *
     * @return string
     */
    public function getLegId()
    {
        return $this->legId;
    }

    /**
     * Sets legId.
     *
     * @param string $legId  The ID of the leg
     *
     * @return $this
     */
    public function setLegId($legId)
    {
        $this->legId = $legId;

        return $this;
    }

    /**
     * Gets serviceLevel.
     *
     * @return string
     */
    public function getServiceLevel()
    {
        return $this->serviceLevel;
    }

    /**
     * Sets serviceLevel.
     *
     * @param string $serviceLevel
     *
     * @return $this
     */
    public function setServiceLevel($serviceLevel)
    {
        $this->serviceLevel = $serviceLevel;

        return $this;
    }

    /**
     * Gets serviceType.
     *
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }

    /**
     * Sets serviceType.
     *
     * @param string $serviceType
     *
     * @return $this
     */
    public function setServiceType($serviceType)
    {
        $this->serviceType = $serviceType;

        return $this;
    }

    /**
     * Gets companyCode.
     *
     * @return string
     */
    public function getCompanyCode()
    {
        return $this->companyCode;
    }

    /**
     * Sets companyCode.
     *
     * @param string $companyCode  The code of the company that the order belongs to
     *
     * @return $this
     */
    public function setCompanyCode($companyCode)
    {
        $this->companyCode = $companyCode;

        return $this;
    }

    /**
     * Gets branch.
     *
     * @return string
     */
    public function getBranch()
    {
        return $this->branch;
    }

    /**
     * Sets branch.
     *
     * @param string $branch  The branch of the company that the order belongs to
     *
     * @return $this
     */
    public function setBranch($branch)
    {
        $this->branch = $branch;

        return $this;
    }

    /**
     * Gets trackingNumber.
     *
     * @return string
     */
    public function getTrackingNumber()
    {
        return $this->trackingNumber;
    }

    /**
     * Sets trackingNumber.
     *
     * @param string $trackingNumber  The tracking number of the order
     *
     * @return $this
     */
    public function setTrackingNumber($trackingNumber)
    {
        $this->trackingNumber = $trackingNumber;

        return $this;
    }

    /**
     * Gets orderGoods.
     *
     * @return SVKAPI\v1\Models\OrderGood
     */
    public function getOrderGoods(): OrderGood
    {
        return $this->orderGoods;
    }

    /**
     * Sets orderGoods.
     *
     * @param SVKAPI\v1\Models\OrderGood $orderGoods
     *
     * @return $this
     */
    public function setOrderGoods(OrderGood $orderGoods)
    {
        $this->orderGoods = $orderGoods;

        return $this;
    }

    /**
     * Gets pickup.
     *
     * @return SVKAPI\v1\Models\PickupStop
     */
    public function getPickup(): PickupStop
    {
        return $this->pickup;
    }

    /**
     * Sets pickup.
     *
     * @param SVKAPI\v1\Models\PickupStop $pickup
     *
     * @return $this
     */
    public function setPickup(PickupStop $pickup)
    {
        $this->pickup = $pickup;

        return $this;
    }

    /**
     * Gets delivery.
     *
     * @return SVKAPI\v1\Models\DeliveryStop
     */
    public function getDelivery(): DeliveryStop
    {
        return $this->delivery;
    }

    /**
     * Sets delivery.
     *
     * @param SVKAPI\v1\Models\DeliveryStop $delivery
     *
     * @return $this
     */
    public function setDelivery(DeliveryStop $delivery)
    {
        $this->delivery = $delivery;

        return $this;
    }
}


