<?php
defined('BASEPATH') or exit('No direct script access allowed');

class BlueDartEDIServices
{
    private $CI;
    private $carrier = 'BLUEDART_TRANSPORT_MUM';
    private $appKey  = '';
    private $baseUrl = '';
    private $bluedartBaseUrl = '';

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model(['Singlestatusmodel', 'Order']);
        $this->CI->load->library(['Edi_logger', 'uuid']);
        $this->CI->load->helper('user_helper');

        $tokenRow = $this->CI->db
            ->get_where('tb_auth_tokens', ['token_for' => 'BlueDart OTM'])
            ->row_array();

        $this->appKey  = $tokenRow['auth_token'] ?? '';
        $this->baseUrl = $tokenRow['base_url'] ?? '';
        $this->code    = $tokenRow['code'] ?? '';
    }

    public function createOrder(array $orderData, string $orderId): array
    {
        $pickupDate = '';

        if (
            isset($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) &&
            is_string($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) &&
            $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime'] !== ''
        ) {
            $pickupDate = $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime'];
        }

        if ($pickupDate === '' || $pickupDate === '0000-00-00 00:00:00') {
            $pickupDate = date('Y-m-d H:i:s');
        }

        $dateObj = DateTime::createFromFormat('Y-m-d H:i:s', $pickupDate);

        $timestampMs = $dateObj->getTimestamp() * 1000;

        $pickupDateFormatted = '/Date(' . $timestampMs . ')/';
        $pickupTimeFormatted = $dateObj->format('Hi');

        $thuData = [];

        if (! empty($orderData['cargoDetails']['CargoThuDetails'])) {
            $thuData = $orderData['cargoDetails']['CargoThuDetails'];
        }

        log_message("error", "thuData:" . json_encode($thuData));

        $orderCargoDetails = [];

        if (is_array($thuData) && array_key_exists(0, $thuData)) {

            $totalLength = $totalWidth = $totalHeight = 0;

            foreach ($thuData as $orderCargo) {

                $cargoType     = is_array($orderCargo['CargoType']) ? '' : $orderCargo['CargoType'];
                $valueOfGoods  = is_array($orderCargo['ValueOfGoods']) ? '' : $orderCargo['ValueOfGoods'];
                $cargoQuantity = is_array($orderCargo['Quantity']) ? '' : $orderCargo['Quantity'];
                $itemId        = is_array($orderCargo['ItemID']) ? '' : $orderCargo['ItemID'];
                $length        = is_array($orderCargo['Length']) ? '' : $orderCargo['Length'];
                $width         = is_array($orderCargo['Width']) ? '' : $orderCargo['Width'];
                $height        = is_array($orderCargo['Height']) ? '' : $orderCargo['Height'];

                $totalLength = $totalLength + (float) $length;
                $totalWidth  = $totalWidth + (float) $width;
                $totalHeight = $totalHeight + (float) $height;

                $innerCargo = [];

                if (! empty($orderCargo['PackagingUnit'])) {

                    if (is_array($orderCargo['PackagingUnit']) && array_key_exists(0, $orderCargo['PackagingUnit'])) {

                        foreach ($orderCargo['PackagingUnit'] as $packagingunit) {
                            $innerCargo[] = [
                                'cargo_type' => is_array($packagingunit['PackageType']) ? '' : $packagingunit['PackageType'],
                                'quantity'   => is_array($packagingunit['Quantity']) ? '' : $packagingunit['Quantity'],
                            ];

                            $length = is_array($packagingunit['Length']) ? '' : $packagingunit['Length'];
                            $width  = is_array($packagingunit['Width']) ? '' : $packagingunit['Width'];
                            $height = is_array($packagingunit['Height']) ? '' : $packagingunit['Height'];

                            $totalLength = $totalLength + (float) $length;
                            $totalWidth  = $totalWidth + (float) $width;
                            $totalHeight = $totalHeight + (float) $height;
                        }

                    } else {
                        $innerCargo[] = [
                            'cargo_type' => is_array($orderCargo['PackagingUnit']['PackageType']) ? '' : $orderCargo['PackagingUnit']['PackageType'],
                            'quantity'   => is_array($orderCargo['PackagingUnit']['Quantity']) ? '' : $orderCargo['PackagingUnit']['Quantity'],
                        ];

                        $length = is_array($thuData['PackagingUnit']['Length']) ? '' : $thuData['PackagingUnit']['Length'];
                        $width  = is_array($thuData['PackagingUnit']['Width']) ? '' : $thuData['PackagingUnit']['Width'];
                        $height = is_array($thuData['PackagingUnit']['Height']) ? '' : $thuData['PackagingUnit']['Height'];

                        $totalLength = $totalLength + (float) $length;
                        $totalWidth  = $totalWidth + (float) $width;
                        $totalHeight = $totalHeight + (float) $height;
                    }
                }

                $orderCargoDetails[] = [
                    'cargo_type'     => $cargoType,
                    'item_id'        => $itemId,
                    'value_of_goods' => $valueOfGoods,
                    'quantity'       => $cargoQuantity,
                    'packaging'      => $innerCargo,
                ];
            }

        } else {

            $totalLength = $totalWidth = $totalHeight = 0;

            $cargoType     = is_array($thuData['CargoType']) ? '' : $thuData['CargoType'];
            $valueOfGoods  = is_array($thuData['ValueOfGoods']) ? '' : $thuData['ValueOfGoods'];
            $cargoQuantity = is_array($thuData['Quantity']) ? '' : $thuData['Quantity'];
            $itemId        = is_array($thuData['ItemID']) ? '' : $thuData['ItemID'];

            $innerCargo = [];

            if (! empty($thuData['PackagingUnit'])) {

                if (is_array($thuData['PackagingUnit']) && array_key_exists(0, $thuData['PackagingUnit'])) {

                    foreach ($thuData['PackagingUnit'] as $packagingunit) {
                        $innerCargo[] = [
                            'cargo_type' => is_array($packagingunit['PackageType']) ? '' : $packagingunit['PackageType'],
                            'quantity'   => is_array($packagingunit['Quantity']) ? '' : $packagingunit['Quantity'],
                        ];

                        $length = is_array($packagingunit['Length']) ? '' : $packagingunit['Length'];
                        $width  = is_array($packagingunit['Width']) ? '' : $packagingunit['Width'];
                        $height = is_array($packagingunit['Height']) ? '' : $packagingunit['Height'];

                        $totalLength = $totalLength + (float) $length;
                        $totalWidth  = $totalWidth + (float) $width;
                        $totalHeight = $totalHeight + (float) $height;
                    }

                } else {
                    $innerCargo[] = [
                        'cargo_type' => is_array($thuData['PackagingUnit']['PackageType']) ? '' : $thuData['PackagingUnit']['PackageType'],
                        'quantity'   => is_array($thuData['PackagingUnit']['Quantity']) ? '' : $thuData['PackagingUnit']['Quantity'],
                    ];

                    $length = is_array($thuData['PackagingUnit']['Length']) ? '' : $thuData['PackagingUnit']['Length'];
                    $width  = is_array($thuData['PackagingUnit']['Width']) ? '' : $thuData['PackagingUnit']['Width'];
                    $height = is_array($thuData['PackagingUnit']['Height']) ? '' : $thuData['PackagingUnit']['Height'];

                    $totalLength = $totalLength + (float) $length;
                    $totalWidth  = $totalWidth + (float) $width;
                    $totalHeight = $totalHeight + (float) $height;
                }
            }

            $orderCargoDetails[] = [
                'cargo_type'     => $cargoType,
                'item_id'        => $itemId,
                'value_of_goods' => $valueOfGoods,
                'quantity'       => $cargoQuantity,
                'packaging'      => $innerCargo,
            ];
        }

        foreach ($orderCargoDetails as $cargoIndex => $cargo) {

            $item = [
                "CGSTAmount"       => 0,
                "HSCode"           => "",
                "IGSTAmount"       => 0,
                "Instruction"      => "",
                "InvoiceDate"      => $pickupDateFormatted,
                "InvoiceNumber"    => "",
                "ItemID"           => $cargo['item_id'],
                "ItemName"         => $cargo['cargo_type'],
                "ItemValue"        => $cargo['value_of_goods'] ?: "0.01",
                "Itemquantity"     => (int) ($cargo['quantity'] ?: 1),
                "PlaceofSupply"    => "",
                "ProductDesc1"     => "",
                "ProductDesc2"     => "",
                "ReturnReason"     => "",
                "SGSTAmount"       => 0,
                "SKUNumber"        => "",
                "SellerGSTNNumber" => "",
                "SellerName"       => "",
                "TaxableAmount"    => 0,
                "TotalValue"       => $cargo['value_of_goods'] ?: "0.01",
                "cessAmount"       => "0.0",
                "countryOfOrigin"  => "",
                "docType"          => "",
                "subSupplyType"    => 0,
                "supplyType"       => "",
            ];

            if (! empty($cargo['packaging'])) {

                $subIndex = 1;

                foreach ($cargo['packaging'] as $innerCargo) {

                    if ($subIndex > 10) {
                        break;
                    }

                    $item['SubProduct' . $subIndex] =
                        ($innerCargo['cargo_type'])
                        . " " . $subIndex;

                    $subIndex++;
                }
            }
        }

        $bluedartCargoDetails[] = $item;

        log_message("error", "bluedartCargoDetails:" . json_encode($bluedartCargoDetails));

        $totalQuantityValue = $orderData['cargoSummary']['TotalQuantity']['Value'];
        $totalWeightValue   = $orderData['cargoSummary']['TotalWeight']['Value'];

        $pickup_name      = $orderData['sourceInfo']['Company']['Name'];
        $pickup_address   = $orderData['sourceInfo']['Address']['Address1'] . "," . $orderData['sourceInfo']['Address']['Street'];
        $pickup_street    = $orderData['sourceInfo']['Address']['Address2'];
        $pickup_city      = $orderData['sourceInfo']['Address']['City'];
        $pickup_state     = $orderData['sourceInfo']['Address']['State'];
        $pickup_country   = $orderData['sourceInfo']['Address']['Country'];
        $pickup_pincode   = $orderData['sourceInfo']['Address']['Postal'];
        $pickup_contact   = $orderData['sourceInfo']['Address']['ContactInfo']['ContactNo'];
        $drop_name        = $orderData['destinationInfo']['Company']['Name'];
        $drop_address     = $orderData['destinationInfo']['Address']['Address1'] . "," . $orderData['destinationInfo']['Address']['Street'];
        $drop_street      = $orderData['destinationInfo']['Address']['Address2'];
        $drop_city        = $orderData['destinationInfo']['Address']['City'];
        $drop_state       = $orderData['destinationInfo']['Address']['State'];
        $drop_country     = $orderData['destinationInfo']['Address']['Country'];
        $drop_pincode     = $orderData['destinationInfo']['Address']['Postal'];
        $drop_contact     = $orderData['destinationInfo']['Address']['ContactInfo']['ContactNo'];
        $customer_name    = $orderData['customerDetails']['Company']['Name'];
        $customer_address = $orderData['customerDetails']['Address']['Address1'] . "," . $orderData['customerDetails']['Address']['Street'];
        $customer_street  = $orderData['customerDetails']['Address']['Address2'];
        $customer_city    = $orderData['customerDetails']['Address']['City'];
        $customer_state   = $orderData['customerDetails']['Address']['State'];
        $customer_country = $orderData['customerDetails']['Address']['Country'];
        $customer_pincode = $orderData['customerDetails']['Address']['Postal'];

        $bluedartRequest =
            [
            "Request" =>
            [
                "Consignee"  => [
                    "AvailableDays"                => "",
                    "AvailableTiming"              => "",
                    "ConsigneeAddress1"            => $drop_address,
                    "ConsigneeAddress2"            => $drop_street,
                    "ConsigneeAddress3"            => $drop_city,
                    "ConsigneeAddressType"         => "",
                    "ConsigneeAddressinfo"         => "",
                    "ConsigneeAttention"           => "ABCD",
                    "ConsigneeEmailID"             => "",
                    "ConsigneeFullAddress"         => "",
                    "ConsigneeGSTNumber"           => "",
                    "ConsigneeLatitude"            => "",
                    "ConsigneeLongitude"           => "",
                    "ConsigneeMaskedContactNumber" => "",
                    "ConsigneeMobile"              => $drop_contact ?: "967676765",
                    "ConsigneeName"                => $drop_name,
                    "ConsigneePincode"             => $drop_pincode,
                    "ConsigneeTelephone"           => "",
                ],
                "Returnadds" => [
                    "ManifestNumber"            => "",
                    "ReturnAddress1"            => $pickup_address,
                    "ReturnAddress2"            => $pickup_street,
                    "ReturnAddress3"            => $pickup_city,
                    "ReturnAddressinfo"         => "",
                    "ReturnContact"             => $pickup_name,
                    "ReturnEmailID"             => "",
                    "ReturnLatitude"            => "",
                    "ReturnLongitude"           => "",
                    "ReturnMaskedContactNumber" => "",
                    "ReturnMobile"              => $pickup_contact,
                    "ReturnPincode"             => $pickup_pincode,
                    "ReturnTelephone"           => "",
                ],
                "Services"   => [
                    "AWBNo"                      => "",
                    "ActualWeight"               => formatNumber($totalWeightValue < 1 ? 1 : $totalWeightValue),
                    "CollectableAmount"          => 0,
                    "Commodity"                  => [],
                    "CreditReferenceNo"          => (string) $orderId,
                    "DeclaredValue"              => 0.01,
                    "Dimensions"                 => [
                        "Breadth" => $totalWidth ?? 0.01,
                        "Count"   => 1,
                        "Height"  => $totalHeight ?? 0.01,
                        "Length"  => $totalLength ?? 0.01,
                    ],
                    "FavouringName"              => "",
                    "IsDedicatedDeliveryNetwork" => false,
                    "IsDutyTaxPaidByShipper"     => false,
                    "IsForcePickup"              => false,
                    "IsPartialPickup"            => false,
                    "IsReversePickup"            => false, //is return shipment
                    "ItemCount"                  => 1,
                    "Officecutofftime"           => "",
                    "PDFOutputNotRequired"       => false,
                    "PackType"                   => "",
                    "ParcelShopCode"             => "",
                    "PayableAt"                  => "",
                    "PickupDate"                 => $pickupDateFormatted,
                    "PickupMode"                 => "",
                    "PickupTime"                 => $pickupTimeFormatted,
                    "PickupType"                 => "",
                    "PieceCount"                 => 1,
                    "PreferredPickupTimeSlot"    => "",
                    "ProductCode"                => "A",
                    "ProductFeature"             => "",
                    "ProductType"                => 1,
                    "RegisterPickup"             => true,
                    "SpecialInstruction"         => "",
                    "SubProductCode"             => "",
                    "TotalCashPaytoCustomer"     => 0,
                    "itemdtl"                    => $bluedartCargoDetails,
                    "noOfDCGiven"                => 0,
                ],
                "Shipper"    => [
                    "CustomerAddress1"              => $customer_address,
                    "CustomerAddress2"              => $customer_street,
                    "CustomerAddress3"              => $customer_city,
                    "CustomerAddressinfo"           => "",
                    "CustomerBusinessPartyTypeCode" => "",
                    "CustomerCode"                  => "099960",
                    "CustomerEmailID"               => "",
                    "CustomerGSTNumber"             => "",
                    "CustomerLatitude"              => "",
                    "CustomerLongitude"             => "",
                    "CustomerMaskedContactNumber"   => "",
                    "CustomerMobile"                => $customer_contact,
                    "CustomerName"                  => $customer_name,
                    "CustomerPincode"               => $customer_pincode,
                    "CustomerTelephone"             => "",
                    "IsToPayCustomer"               => false,
                    "OriginArea"                    => "BOM",
                    "Sender"                        => "TestRvp",
                    "VendorCode"                    => "",
                ],
            ],
            "Profile" => [
                "LoginID"    => "BOM00001",
                "LicenceKey" => "vhijqilhjmequmhjuhiehspsehmujlrn",
                "Api_type"   => "S",
            ],
        ];

        log_message("error", "bluedartRequest:" . json_encode($bluedartRequest));
        
        $this->getBluedartResponse($bluedartRequest, $orderinfo['id']);

        /*$jsonData = json_encode($bluedartRequest);
        $vendor   = $this->CI->db->get_where("tb_vendors", ['code' => $this->code])->row_array();

        $companyCode = $vendor['company_code'] ?? '';
        $branchCode  = $vendor['branch_code'] ?? '';
        $userId      = $vendor['user_id'] ?? '';

        $responseArray = [];

        try {
            $ch = curl_init($this->baseUrl);
            curl_setopt_array($ch, [
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/json",
                    "JWTToken: {$this->appKey}",
                ],
                CURLOPT_POST           => true,
                CURLOPT_POSTFIELDS     => $jsonData,
                CURLOPT_RETURNTRANSFER => true,
            ]);

            $responseRaw = curl_exec($ch);

            if ($responseRaw === false) {
                $responseArray = ['success' => false, 'error' => curl_error($ch)];
            } else {
                $responseArray = json_decode($responseRaw, true) ?: [
                    'success' => false,
                    'error'   => 'Invalid JSON from API',
                    'raw'     => $responseRaw,
                ];
            }

            curl_close($ch);
            log_message("error", "Bluedart Order Response: " . json_encode($responseArray));

        } catch (Exception $e) {
            log_message("error", "Bluedart Order Exception: " . $e->getMessage());
        } finally {
            $this->logEdiTransaction($jsonData, $responseArray, $companyCode, $branchCode, $userId, 'Bluedart Carrier Order Request');
        }

        $bluedartPickupResponseBookingId = $bluedartRequestResponse['DocketNumber'];

        log_message("error", "bluedartPickupResponseBookingId: " . $bluedartPickupResponseBookingId);

        if (! empty($bluedartPickupResponseBookingId) && $bluedartPickupResponseBookingId !== '') {

            $bluedart_tkn_ref = [
                'order_id'     => $orderinfo['id'],
                'reference_id' => 'TKN',
                'ref_value'    => $bluedartPickupResponseBookingId,
                'createdon'    => $cdate,
            ];

            $insTkn = $this->ci->db->insert('tb_order_references', $bluedart_tkn_ref);
        }*/

        return $responseArray;
    }
    
    public function getBluedartResponse(array $bluedartRequest, int $orderId): array
    {
        $cdate                = date('Y-m-d H:i:s');
        $jsonData = json_encode($bluedartRequest);
        $vendor   = $this->CI->db->get_where("tb_vendors", ['code' => $this->code])->row_array();

        $companyCode = $vendor['company_code'] ?? '';
        $branchCode  = $vendor['branch_code'] ?? '';
        $userId      = $vendor['user_id'] ?? '';

        $responseArray = [];
        
        $bluedartUrl = $this->CI->db
            ->get_where('tb_auth_tokens', ['token_for' => 'BlueDart'])
            ->row_array();
            
        log_message("error", "Qry: " . $this->CI->db->last_query());

        $bluedartBaseUrl = $bluedartUrl['base_url'] ?? '';
        $bluedartAuthToken = $bluedartUrl['auth_token'] ?? '';

        try {
            log_message("error", "bluedartBaseUrl: " . $bluedartBaseUrl);
            log_message("error", "jsonData: " . $jsonData);
            $ch = curl_init($bluedartBaseUrl);
            curl_setopt_array($ch, [
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/json",
                    "JWTToken: {$bluedartAuthToken}",
                ],
                CURLOPT_POST           => true,
                CURLOPT_POSTFIELDS     => $jsonData,
                CURLOPT_RETURNTRANSFER => true,
            ]);

            $responseRaw = curl_exec($ch);

            if ($responseRaw === false) {
                $responseArray = ['success' => false, 'error' => curl_error($ch)];
            } else {
                $responseArray = json_decode($responseRaw, true) ?: [
                    'success' => false,
                    'error'   => 'Invalid JSON from API',
                    'raw'     => $responseRaw,
                ];
            }

            curl_close($ch);
            log_message("error", "Bluedart Order Response: " . json_encode($responseArray));

        } catch (Exception $e) {
            log_message("error", "Bluedart Order Exception: " . $e->getMessage());
        } finally {
            $this->logEdiTransaction($jsonData, $responseArray, $companyCode, $branchCode, $userId, 'Bluedart Carrier Order Request');
        }

        $bluedartAWBNo = $responseArray['GenerateWayBillResult']['AWBNo'];
        $bluedartTKNNo = $responseArray['GenerateWayBillResult']['TokenNumber'];

        log_message("error", "bluedartAWBNo: " . $bluedartAWBNo);
        log_message("error", "orderId: " . $orderId);
        if (! empty($bluedartAWBNo) && $bluedartAWBNo !== '') {

            $bluedart_awb_ref = [
                'order_id'     => $orderId,
                'reference_id' => 'AWB',
                'ref_value'    => $bluedartAWBNo,
                'createdon'    => $cdate,
            ];

            $insTkn = $this->CI->db->insert('tb_order_references', $bluedart_awb_ref);
        }
        
        log_message("error", "bluedartTKNNo: " . $bluedartTKNNo);
        
        if (! empty($bluedartTKNNo) && $bluedartTKNNo !== '') {

            $bluedart_tkn_ref = [
                'order_id'     => $orderId,
                'reference_id' => 'TKN',
                'ref_value'    => $bluedartTKNNo,
                'createdon'    => $cdate,
            ];

            $insTkn = $this->CI->db->insert('tb_order_references', $bluedart_tkn_ref);
        }
        
        return $responseArray;
    }

    public function getStatus(string $docketNo, int $orderId): int
    {
        if (empty($docketNo) || $orderId <= 0) {
            log_message('error', "Invalid DocketNo");
            return 0;
        }

        $url = $this->baseUrl . '/TrackConsignment?' . http_build_query([
            'Status'       => 'L',
            'lstAWB'       => $docketNo,
            'customerCode' => $this->customerCode,
        ]);

        $curl = curl_init($url);
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPGET        => true,
            CURLOPT_HTTPHEADER     => [
                "Content-Type: application/json",
                "X-APPKEY: {$this->appKey}",
            ],
            CURLOPT_TIMEOUT => 30,
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        if ($response === false) {
            log_message('error', 'Curl Error: ' . curl_error($curl));
            return 0;
        }

        $data = json_decode($response, true);
        log_message('error', "API Response: " . $response);

        $responseStatus = $data['ResponseStatus'] ?? [];
        $trackingResult = $data['TrackingResult'][0] ?? [];

        if (($responseStatus['Message'] ?? '') !== 'SUCCESS') {
            return 0;
        }

        $statusList = $trackingResult['TrackList'] ?? [];

        // Generate XML
        $statusInput = $this->generateStatusXML($docketNo, $statusList);

        // Convert XML and save status
        $xml = simplexml_load_string($statusInput);
        return $this->getStatusXml($xml, $orderId, $this->carrier);
    }

    private function generateStatusXML(string $docketNo, array $statusList): string
    {
        $xml = '<SVKEDIResponseMessage>';
        $xml .= '<SVKEDITransmissionHeader>';
        $xml .= '<EDIVersion>SVK2.0</EDIVersion>';
        $xml .= '<AckSpec><AckOption>SUCCESS</AckOption></AckSpec>';
        $xml .= '<SourceApp>' . $this->carrier . '</SourceApp>';
        $xml .= '<DestinationApp>SVKONEKT</DestinationApp>';
        $xml .= '<Action>BookingStatusUpdate</Action>';
        $xml .= '</SVKEDITransmissionHeader>';
        $xml .= '<SVKEDITransmissionBody><Order>';
        $xml .= '<OrderID>' . $docketNo . '</OrderID>';

        foreach ($statusList as $status) {
            $status['ActivityCode'] = "BOK";
            $status['ActivityDate'] = DateTime::createFromFormat('d/m/Y H:i:s', $status['ActivityDate'])->format('Y-m-d H:i:s');
            $xml .= '<Status>';
            $xml .= '<StatusCode>' . ($status['ActivityCode'] ?? '') . '</StatusCode>';
            $xml .= '<StatusValue>' . ($status['ActivityCode'] ?? '') . '</StatusValue>';
            $xml .= '<StatusType>' . ($status['ActivityCode'] ?? '') . '</StatusType>';
            $xml .= '<DateTime>' . ($status['ActivityDate'] ?? '') . '</DateTime>';
            $xml .= '<TimeZone>+00:00</TimeZone>';
            $xml .= '<Location>' . ($status['ActivityFromLocation'] ?? '') . '</Location>';
            $xml .= '</Status>';
        }

        $xml .= '</Order></SVKEDITransmissionBody></SVKEDIResponseMessage>';

        log_message('error', "Generated Status XML: " . $xml);
        return $xml;
    }

    private function logEdiTransaction(string $request, array $response, string $companyCode, string $branchCode, string $userId, string $ediName): void
    {
        $this->CI->edi_logger->setEdi_type(1);
        $this->CI->edi_logger->setTransaction_id(time());
        $this->CI->edi_logger->setEdi_name($ediName);
        $this->CI->edi_logger->setBounded_type(1);
        $this->CI->edi_logger->setCompany_code($companyCode);
        $this->CI->edi_logger->setBranch_code($branchCode);
        $this->CI->edi_logger->setUser_id($userId);
        $this->CI->edi_logger->setEdi_format_type('JSON');
        $status = isset($response['ResponseStatus']['Message']) && $response['ResponseStatus']['Message'] === 'SUCCESS' ? 1 : 0;
        $this->CI->edi_logger->setStatus($status);
        $this->CI->edi_logger->setEdi_request($request);
        $this->CI->edi_logger->setEdi_response(json_encode($response));
        $this->CI->edi_logger->setObj_type_name($ediName);
        $this->CI->edi_logger->saveToEdiLogs();
    }

    public function getStatusXml(object $xmlData, int $orderId, string $carrier): int
    {
        $statusResponse = 0;
        $body           = $xmlData->xpath('SVKEDITransmissionBody');

        if (empty($body)) {
            return 0;
        }

        foreach ($body[0]->Order as $order) {
            $chkOrder = $this->CI->db->get_where('tb_orders', ['id' => $orderId])->row_array();
            if (! $chkOrder) {
                continue;
            }

            $ordersData = [];
            $orderIdDb  = $chkOrder['order_id'];

            foreach ($order->Status as $status) {
                $statusCode = (string) ($status->StatusCode ?? '');
                if (! $statusCode) {
                    continue;
                }

                $ordersData[] = [
                    "OrderID"     => $orderIdDb,
                    "statustype"  => (string) ($status->StatusType ?? ''),
                    "statuscode"  => $statusCode,
                    "statusvalue" => (string) ($status->StatusValue ?? ''),
                    "datetime"    => (string) ($status->DateTime ?? ''),
                    "timezone"    => (string) ($status->TimeZone ?? ''),
                    "lat"         => (string) ($status->Lat ?? ''),
                    "lng"         => (string) ($status->Lng ?? ''),
                    "location"    => (string) ($status->Location ?? ''),
                ];
            }

            if (! empty($ordersData)) {
                $statusResponse = $this->CI->Singlestatusmodel->updateXPStatus(json_encode($ordersData), $carrier);
            }
        }

        return $statusResponse;
    }
}
