<?php
class CarrierInboundServices
{
    private $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model(['common', 'apis/CarrierInboundModel', 'Standardbookingmodel']);
        $this->CI->load->library(['standardbookinghandler', 'apis/FlipkartEDIServices']);
        $this->CI->load->library('Edi_logger');
        $this->CI->load->helper('user_helper');
        $this->CI->load->library('session');
    }

    public function checkClientAuth(): bool
    {
        $authHeader = $this->CI->input->get_request_header('Authorization');

        if (! $authHeader) {
            return false;
        }
        // Match "Basic base64encoded"
        /*$authDetails = $this->CI->common->gettblrowdata(
            "status = 1 AND (token_for = 'EKART' OR token_for = 'XP_INDIA_INBOUND')",
            "auth_token",
            "tb_auth_tokens",
            0,
            0
        );*/
        $authDetails = $this->CI->common->gettblrowdata(['token_for' => 'XP_INDIA_INBOUND', 'status' => 1], "auth_token", "tb_auth_tokens", 0, 0);
        log_message('error', "cURL Request URL:" . json_encode($authDetails));
        $authToken = $authDetails['auth_token'];
        if (preg_match('/Basic\s+(\S+)/', $authHeader, $matches)) {
            $clientToken = trim($matches[1]);
            // Compare client token with saved token
            log_message('error', "clientToken:" . $clientToken);
            log_message('error', "authToken:" . $authToken);
            if ($clientToken === $authToken) {
                return true;
            }
        }
        return false;
    }

    public function generateStandardInbound(array $data): string
    {
        //log_message("error", "validationRes11:" . json_encode($data));
        $jsonData = json_encode($data);

        // Replace all "&" with "and"
        $cleanedJson = str_replace('&', 'and', $jsonData);
        $data        = json_decode($cleanedJson, true);
        // Log the cleaned data
        //log_message("error", "validationRes11: " . $data);
        $validationRes = $this->checkValidation($data);
        if ($validationRes) {
            //log_message("error", "validationRes11:" . $validationRes);
            exit;
        }
        try {
            $booking = $data['BookingDetails'] ?? null;
            if ($booking) {
                $schedulePickup = $booking['ScheduledPickupDate'] ?? "";
                $latitude       = $booking['Latitude'] ?? "";
                $longitude      = $booking['Longitude'] ?? "";
            }

            // Loop through ConsignmentNoteDetails

            if (! empty($data['ConsignmentNoteDetails'])) {

                foreach ($data['ConsignmentNoteDetails'] as $consignmentData) {
                    try {
                        $XMLHeader         = $XMLBody         = $XMLCustomer         = $XMLSource         = $XMLDestination         = $XMLCargoSummary         = "";
                        $XMLCargo          = $XMLValueAddedServices          = $XMLReferences          = $XMLRemarks          = $XMLOutput          = "";
                        $XMLSourceDateTime = $XMLDestinationDateTime = "";

                        $docketNo         = $consignmentData['XPCNNumber'] ?? "";
                        $goodsDescription = $consignmentData['GoodsDescription'] ?? "";
                        $chargedWeight    = $consignmentData['ChargedWeight'] ?? "";
                        $chargedWeightUOM = $consignmentData['ChargedWeightUOM'] ?? "";
                        //$actualWeight     = $consignmentData['ActualWeight'] ?? "";
                        $actualWeightUOM = $consignmentData['ActualWeightUOM'] ?? "";
                        //$volumetricWeight    = $consignmentData['VolumetricWeight'] ?? "";
                        $volumetricWeightUOM = $consignmentData['VolumtericWeightUOM'] ?? "";
                        $quantity            = $consignmentData['NoOfBoxes'] ?? "";
                        $pieceQuantity       = $consignmentData['QuantityOfPieces'] ?? "";

                        $consigneeName     = $consignmentData['ConsigneeName'] ?? "";
                        $consigneeEmail    = $consignmentData['ConsigneeEmail'] ?? "";
                        $consigneePOC      = $consignmentData['ConsigneePOC'] ?? "";
                        $consigneeState    = $consignmentData['ConsigneeState'] ?? "";
                        $consigneeDistrict = $consignmentData['ConsigneeDistrict'] ?? "";
                        $consigneeLocation = $consignmentData['ConsigneeLocation'] ?? "";
                        $consigneePostCode = $consignmentData['ConsigneePostcode'] ?? "";
                        $consigneeAddress  = $consignmentData['ConsigneeAddress'] ?? "";

                        $consignorName     = $consignmentData['ConsignorName'] ?? "";
                        $consignorEmail    = $consignmentData['ConsignorEmail'] ?? "";
                        $consignorPOC      = $consignmentData['ConsignorPOC'] ?? "";
                        $consignorState    = $consignmentData['ConsignorState'] ?? "";
                        $consignorDistrict = $consignmentData['ConsignorDistrict'] ?? "";
                        $consignorLocation = $consignmentData['ConsignorLocation'] ?? "";
                        $consignorPostCode = $consignmentData['ConsignorPostcode'] ?? "";
                        $consignorAddress  = $consignmentData['ConsignorAddress'] ?? "";

                        $customerDocumentNumber = $consignmentData['CustomerDocumentNumber'] ?? "";
                        $specialRemarks         = $consignmentData['SpecialRemarks'] ?? "";

                        $shipperExistsData   = $this->CI->CarrierInboundModel->checkPartyRoleExists($consignorName, $consignorState, $consignorPostCode, 'Shipper');
                        $consigneeExistsData = $this->CI->CarrierInboundModel->checkPartyRoleExists($consigneeName, $consigneeState, $consigneePostCode, 'Consignee');

                        if (! empty($shipperExistsData) || ! empty($consigneeExistsData)) {
                            $companyCode   = $shipperExistsData[0]['company_code'] ?? $consigneeExistsData[0]['company_code'] ?? null;
                            $clientCode    = $shipperExistsData[0]['branch_code'] ?? $consigneeExistsData[0]['branch_code'] ?? null;
                            $userId        = $shipperExistsData[0]['user_id'] ?? $consigneeExistsData[0]['user_id'] ?? null;
                            $country       = $shipperExistsData[0]['country'] ?? $consigneeExistsData[0]['country'] ?? null;
                            $shipperCode   = $shipperExistsData[0]['code'] ?? null;
                            $consigneeCode = $consigneeExistsData[0]['code'] ?? null;
                            $customerId    = $shipperExistsData[0]['id'] ?? $consigneeExistsData[0]['id'] ?? null;

                            $countryCode            = substr($companyCode, 0, 2);
                            $departmentCustomerCode = "";
                            if ($specialRemarks != "" && $clientCode == "LTLDEMO") {
                                $departmentExistsData = $this->CI->CarrierInboundModel->checkDepartment($companyCode, $clientCode, $specialRemarks);
                                //log_message("error", "$departmentExistsData:" . json_encode($departmentExistsData));
                                if (! empty($departmentExistsData)) {
                                    $departmentCustomerCode = $departmentExistsData[0]['department_code'];
                                }
                            }

                            $departmentCode = $departmentCustomerCode ?? $shipperExistsData[0]['department_code'];

                            if ($shipperCode != null) {
                                $consigneeCode = $this->CI->CarrierInboundModel->getPartyData($consignmentData, 'Consignee', $companyCode, $clientCode, $userId, $country);
                                $XMLCustomer .= "<ID>" . $shipperCode . "</ID>";
                                $XMLCustomer .= "<Company>";
                                $XMLCustomer .= "<Name>" . $consignorName . "</Name>";
                                $XMLCustomer .= "<RegistrationNumber>" . $shipperCode . "</RegistrationNumber>";
                                $XMLCustomer .= "</Company>";
                                $XMLCustomer .= "<Address>";
                                $XMLCustomer .= "<CustomerName>" . $consignorName . "</CustomerName>";
                                $XMLCustomer .= "<Address1>" . $consignorAddress . "</Address1>";
                                $XMLCustomer .= "<Address2/>";
                                $XMLCustomer .= "<HouseNumber/>";
                                $XMLCustomer .= "<Street>" . $consignorLocation . "</Street>";
                                $XMLCustomer .= "<City>" . $consignorDistrict . "</City>";
                                $XMLCustomer .= "<State>" . $consignorState . "</State>";
                                $XMLCustomer .= "<Postal>" . $consignorPostCode . "</Postal>";
                                $XMLCustomer .= "<Country>" . $country . "</Country>";
                                $XMLCustomer .= "<Latitude>" . $latitude . "</Latitude>";
                                $XMLCustomer .= "<Longitude>" . $longitude . "</Longitude>";
                                $XMLCustomer .= "<ContactInfo>";
                                $XMLCustomer .= "<CountryCode>" . $countryCode . "</CountryCode>";
                                $XMLCustomer .= "<ContactNo>" . $consignorPOC . "36040</ContactNo>";
                                $XMLCustomer .= "<EmailAddress>" . $consignorEmail . "</EmailAddress>";
                                $XMLCustomer .= "</ContactInfo>";
                                $XMLCustomer .= "</Address>";
                            } else {
                                $shipperCode = $this->CI->CarrierInboundModel->getPartyData($consignmentData, 'Shipper', $companyCode, $clientCode, $userId, $country);
                                $XMLCustomer .= "<ID>" . $consigneeCode . "</ID>";
                                $XMLCustomer .= "<Company>";
                                $XMLCustomer .= "<Name>" . $consigneeName . "</Name>";
                                $XMLCustomer .= "<RegistrationNumber>" . $consigneeCode . "</RegistrationNumber>";
                                $XMLCustomer .= "</Company>";
                                $XMLCustomer .= "<Address>";
                                $XMLCustomer .= "<CustomerName>" . $consigneeName . "</CustomerName>";
                                $XMLCustomer .= "<Address1>" . $consigneeAddress . "</Address1>";
                                $XMLCustomer .= "<Address2/>";
                                $XMLCustomer .= "<HouseNumber/>";
                                $XMLCustomer .= "<Street>" . $consigneeLocation . "</Street>";
                                $XMLCustomer .= "<City>" . $consigneeDistrict . "</City>";
                                $XMLCustomer .= "<State>" . $consigneeState . "</State>";
                                $XMLCustomer .= "<Postal>" . $consigneePostCode . "</Postal>";
                                $XMLCustomer .= "<Country>" . $country . "</Country>";
                                $XMLCustomer .= "<Latitude>" . $latitude . "</Latitude>";
                                $XMLCustomer .= "<Longitude>" . $longitude . "</Longitude>";
                                $XMLCustomer .= "<ContactInfo>";
                                $XMLCustomer .= "<CountryCode>" . $countryCode . "</CountryCode>";
                                $XMLCustomer .= "<ContactNo>" . $consigneePOC . "36040</ContactNo>";
                                $XMLCustomer .= "<EmailAddress>" . $consigneeEmail . "</EmailAddress>";
                                $XMLCustomer .= "</ContactInfo>";
                                $XMLCustomer .= "</Address>";
                            }

                            $XMLSource .= "<ID>" . $shipperCode . "</ID>";
                            $XMLSource .= "<Company>";
                            $XMLSource .= "<Name>" . $consignorName . "</Name>";
                            $XMLSource .= "<RegistrationNumber>" . $shipperCode . "</RegistrationNumber>";
                            $XMLSource .= "</Company>";
                            $XMLSource .= "<Address>";
                            $XMLSource .= "<CompanyName>" . $consignorName . "</CompanyName>";
                            $XMLSource .= "<Address1>" . $consignorAddress . "</Address1>";
                            $XMLSource .= "<Address2/>";
                            $XMLSource .= "<HouseNumber/>";
                            $XMLSource .= "<Street>" . $consignorLocation . "</Street>";
                            $XMLSource .= "<City>" . $consignorDistrict . "</City>";
                            $XMLSource .= "<State>" . $consignorState . "</State>";
                            $XMLSource .= "<Postal>" . $consignorPostCode . "</Postal>";
                            $XMLSource .= "<Country>" . $country . "</Country>";
                            $XMLSource .= "<Latitude>" . $latitude . "</Latitude>";
                            $XMLSource .= "<Longitude>" . $longitude . "</Longitude>";
                            $XMLSource .= "<ContactInfo>";
                            $XMLSource .= "<CountryCode>" . $countryCode . "</CountryCode>";
                            $XMLSource .= "<ContactNo>" . $consignorPOC . "36040</ContactNo>";
                            $XMLSource .= "<EmailAddress>" . $consignorEmail . "</EmailAddress>";
                            $XMLSource .= "</ContactInfo>";
                            $XMLSource .= "</Address>";
                            $XMLSourceDateTime .= "<EstimatedDateTime>";
                            $XMLSourceDateTime .= "<From>";
                            $XMLSourceDateTime .= "<DateTime>" . $schedulePickup . "</DateTime>";
                            $XMLSourceDateTime .= "<TimeZone> 00.00 </TimeZone>";
                            $XMLSourceDateTime .= "<UTC>";
                            $XMLSourceDateTime .= "<Time>" . $schedulePickup . "</Time>";
                            $XMLSourceDateTime .= "</UTC>";
                            $XMLSourceDateTime .= "</From>";
                            $XMLSourceDateTime .= "<To>";
                            $XMLSourceDateTime .= "<DateTime>" . $schedulePickup . "</DateTime>";
                            $XMLSourceDateTime .= "<TimeZone> 00.00 </TimeZone>";
                            $XMLSourceDateTime .= "<UTC>";
                            $XMLSourceDateTime .= "<Time>" . $schedulePickup . "</Time>";
                            $XMLSourceDateTime .= "</UTC>";
                            $XMLSourceDateTime .= "</To>";
                            $XMLSourceDateTime .= "</EstimatedDateTime>";

                            $XMLDestination .= "<ID>" . $consigneeCode . "</ID>";
                            $XMLDestination .= "<Company>";
                            $XMLDestination .= "<Name>" . $consigneeName . "</Name>";
                            $XMLDestination .= "<RegistrationNumber>" . $consigneeCode . "</RegistrationNumber>";
                            $XMLDestination .= "</Company>";
                            $XMLDestination .= "<Address>";
                            $XMLDestination .= "<CompanyName>" . $consigneeName . "</CompanyName>";
                            $XMLDestination .= "<Address1>" . $consigneeAddress . "</Address1>";
                            $XMLDestination .= "<Address2/>";
                            $XMLDestination .= "<HouseNumber/>";
                            $XMLDestination .= "<Street>" . $consigneeLocation . "</Street>";
                            $XMLDestination .= "<City>" . $consigneeDistrict . "</City>";
                            $XMLDestination .= "<State>" . $consigneeState . "</State>";
                            $XMLDestination .= "<Postal>" . $consigneePostCode . "</Postal>";
                            $XMLDestination .= "<Country>" . $country . "</Country>";
                            $XMLDestination .= "<Latitude>" . $consignorLatitude . "</Latitude>";
                            $XMLDestination .= "<Longitude>" . $consignorLongitude . "</Longitude>";
                            $XMLDestination .= "<ContactInfo>";
                            $XMLDestination .= "<CountryCode>" . $countryCode . "</CountryCode>";
                            $XMLDestination .= "<ContactNo>" . $consigneePOC . "36040</ContactNo>";
                            $XMLDestination .= "<EmailAddress>" . $consigneeEmail . "</EmailAddress>";
                            $XMLDestination .= "</ContactInfo>";
                            $XMLDestination .= "</Address>";
                            $XMLDestinationDateTime .= "<EstimatedDateTime>";
                            $XMLDestinationDateTime .= "<From>";
                            $XMLDestinationDateTime .= "<DateTime></DateTime>";
                            $XMLDestinationDateTime .= "<TimeZone> 00.00 </TimeZone>";
                            $XMLDestinationDateTime .= "<UTC>";
                            $XMLDestinationDateTime .= "<Time></Time>";
                            $XMLDestinationDateTime .= "</UTC>";
                            $XMLDestinationDateTime .= "</From>";
                            $XMLDestinationDateTime .= "<To>";
                            $XMLDestinationDateTime .= "<DateTime></DateTime>";
                            $XMLDestinationDateTime .= "<TimeZone> 00.00 </TimeZone>";
                            $XMLDestinationDateTime .= "<UTC>";
                            $XMLDestinationDateTime .= "<Time></Time>";
                            $XMLDestinationDateTime .= "</UTC>";
                            $XMLDestinationDateTime .= "</To>";
                            $XMLDestinationDateTime .= "</EstimatedDateTime>";

                        }

                        /*$companyCode = "INKNRL";
                    $clientCode  = "GODAER";
                    $userId      = "423";
                    $country     = "India";*/

                        if ($booking) {
                            $bookingNo   = $booking['BookingNumber'] ?? "";
                            $serviceType = $booking['ServiceType'] ?? "";
                            $serviceType = "LTL-EXPRESS";
                            /*$chk_qry_service = $this->CI->db->query("Select ts.id FROM tb_service_master ts WHERE UPPER(ts.name) = UPPER(?) and ts.status=1", [$serviceType]);
                        if ($chk_qry_service->num_rows() == 0) {
                            $status = $this->CI->common->insertTableData("tb_service_master", [
                                'company_code'   => $companyCode,
                                'branch_code'    => $clientCode,
                                'service_id'     => $serviceType,
                                'name'           => $serviceType,
                                'user_id'        => $userId,
                                'transport_mode' => "LTL",
                                'createdon'      => date('Y-m-d H:i:s'),
                                'updatedon'      => date('Y-m-d H:i:s'),
                                'status'         => 1,
                            ]);
                        }*/
                            $tripSchedulePickup = $booking['ScheduledPickupDate'] ?? "";
                        }

                        $totalVolume = 0;

                        $currentDateTime = date('YmdHis');

                        $XMLHeader .= "<?xml version='1.0' encoding='UTF-8'?>";
                        $XMLHeader .= "<SVKEDIMessage>";
                        $XMLHeader .= "<SVKEDIOrderHeader>";
                        $XMLHeader .= "<Version>1.0</Version>";
                        $XMLHeader .= "<UserName></UserName>";
                        $XMLHeader .= "<Password></Password>";
                        $XMLHeader .= "<SenderTransmissionNo>" . $docketNo . "_" . $currentDateTime . "</SenderTransmissionNo>";
                        $XMLHeader .= "<AckSpec>";
                        $XMLHeader .= "<EmailAddress>dummy@email.com</EmailAddress>";
                        $XMLHeader .= "<AckOption>SUCCESS</AckOption>";
                        $XMLHeader .= "</AckSpec>";
                        $XMLHeader .= "<SourceApp>XP_INDIA</SourceApp>";
                        $XMLHeader .= "<DestinationApp>SVKONEKT</DestinationApp>";
                        $XMLHeader .= "<ReferenceId>" . $docketNo . "</ReferenceId>";
                        $XMLHeader .= "<Action>IU</Action>";
                        $XMLHeader .= "</SVKEDIOrderHeader>";
                        $XMLBody .= "<SVKEDIOrderBody>";
                        $XMLBody .= "<SVKOrgDetails>";
                        $XMLBody .= "<Companycode>" . $companyCode . "</Companycode>";
                        $XMLBody .= "<Branchcode>" . $clientCode . "</Branchcode>";
                        $XMLBody .= "<Departmentcode>" . $departmentCode . "</Departmentcode>";
                        $XMLBody .= "<PhysicalReceiver/>";
                        $XMLBody .= "<LogicalReceiver/>";
                        $XMLBody .= "<PhysicalSender/>";
                        $XMLBody .= "<LogicalSender></LogicalSender>";
                        $XMLBody .= "</SVKOrgDetails>";
                        $XMLBody .= "<OrderID>" . $docketNo . "</OrderID>";
                        $XMLBody .= "<EXTOrderID>" . $docketNo . "</EXTOrderID>";
                        $XMLBody .= "<Transits>";
                        $XMLBody .= "<TransitLegId/>";
                        $XMLBody .= "</Transits>";
                        $XMLBody .= "<OrderType>GEN</OrderType>";
                        $XMLBody .= "<ModeOfTransport>LTL</ModeOfTransport>";
                        $XMLBody .= "<Product>B2C</Product>";
                        $XMLBody .= "<ServiceType>" . $serviceType . "</ServiceType>";
                        $XMLBody .= "<TypeOfBusiness></TypeOfBusiness>";
                        $XMLBody .= "<TermsOfTrade>";
                        $XMLBody .= "<Incoterm></Incoterm>";
                        $XMLBody .= "<FreightName>";
                        $XMLBody .= "<Term/>";
                        $XMLBody .= "<Name/>";
                        $XMLBody .= "</FreightName>";
                        $XMLBody .= "</TermsOfTrade>";

                        if (! empty($consignmentData['BoxDetails'])) {
                            foreach ($consignmentData['BoxDetails'] as $packageData) {
                                $lineID           = $packageData['LineID'] ?? "";
                                $length           = $packageData['Length'] ?? "";
                                $breadth          = $packageData['Breadth'] ?? "";
                                $height           = $packageData['Height'] ?? "";
                                $noOfBoxes        = $packageData['NumberOfBoxes'] ?? "";
                                $packageTypeCode  = $packageData['PackageTypeCode'] ?? "NULL";
                                $packageType      = $packageData['PackageType'] ?? "NULL";
                                $volumetricWeight = $packageData['VolumetricWeight'] ?? "";
                                $actualWeight     = $packageData['ActualWeight'] ?? "";
                                //$uom              = $packageData['UnitOfMeasurement'] ?? "";

                                $length  = $length / 12;
                                $breadth = $breadth / 12;
                                $height  = $height / 12;
                                $volume  = 0;
                                $volume  = $length * $breadth * $height;
                                //$volume      = $volume * 0.0254;
                                $totalVolume = $totalVolume + $volume;
                                $uom         = "FT";
                                $volumeUOM   = "CB FT";

                                $XMLCargo .= "<TransportHandlingUnit>";
                                $XMLCargo .= "<CargoType>" . $packageType . "</CargoType>";
                                $XMLCargo .= "<GoodsDescription>" . $goodsDescription . "</GoodsDescription>";
                                $XMLCargo .= "<MarksandNumbers></MarksandNumbers>";
                                $XMLCargo .= "<ValueOfGoods>0.00</ValueOfGoods>";
                                $XMLCargo .= "<HandlingUnit/>";
                                $XMLCargo .= "<ItemId>" . $lineID . "</ItemId>";
                                $XMLCargo .= "<Length>";
                                $XMLCargo .= "<Value>" . $length . "</Value>";
                                $XMLCargo .= "<UOM>" . $uom . "</UOM>";
                                $XMLCargo .= "</Length>";
                                $XMLCargo .= "<Width>";
                                $XMLCargo .= "<Value>" . $breadth . "</Value>";
                                $XMLCargo .= "<UOM>" . $uom . "</UOM>";
                                $XMLCargo .= "</Width>";
                                $XMLCargo .= "<Height>";
                                $XMLCargo .= "<Value>" . $height . "</Value>";
                                $XMLCargo .= "<UOM>" . $uom . "</UOM>";
                                $XMLCargo .= "</Height>";
                                $XMLCargo .= "<ActualWeight>";
                                $XMLCargo .= "<Value>" . $actualWeight . "</Value>";
                                $XMLCargo .= "<UOM>" . $actualWeightUOM . "</UOM>";
                                $XMLCargo .= "</ActualWeight>";
                                $XMLCargo .= "<Weight>";
                                $XMLCargo .= "<Value>" . $actualWeight . "</Value>";
                                $XMLCargo .= "<UOM>" . $actualWeightUOM . "</UOM>";
                                $XMLCargo .= "</Weight>";
                                $XMLCargo .= "<VolumetricWeight>";
                                $XMLCargo .= "<Value>" . $volumetricWeight . "</Value>";
                                $XMLCargo .= "<UOM>" . $volumetricWeightUOM . "</UOM>";
                                $XMLCargo .= "</VolumetricWeight>";
                                $XMLCargo .= "<Volume>";
                                $XMLCargo .= "<Value>" . $volume . "</Value>";
                                $XMLCargo .= "<UOM>" . $volumeUOM . "</UOM>";
                                $XMLCargo .= "</Volume>";
                                $XMLCargo .= "<ActualVolume>";
                                $XMLCargo .= "<Value>" . $volume . "</Value>";
                                $XMLCargo .= "<UOM>" . $volumeUOM . "</UOM>";
                                $XMLCargo .= "</ActualVolume>";
                                $XMLCargo .= "<Quantity>" . $noOfBoxes . "</Quantity>";
                                $XMLCargo .= "<ScannedQuantity/>";
                                $XMLCargo .= "<ldm>0.000</ldm>";
                                $XMLCargo .= "<GroundedFlag>0</GroundedFlag>";
                                $XMLCargo .= "<StackableFlag>0</StackableFlag>";
                                $XMLCargo .= "<SplittableFlag>0</SplittableFlag>";
                                $XMLCargo .= "<DangerousGoodsFlag>0</DangerousGoodsFlag>";
                                $XMLCargo .= "<TotalPackagesOfDangerousGoods>0</TotalPackagesOfDangerousGoods>";
                                $XMLCargo .= "<PackagingUnit />";
                                $XMLCargo .= "</TransportHandlingUnit>";
                            }
                        }

                        $XMLCargoSummary .= "<CargoSummary>";
                        $XMLCargoSummary .= "<TotalQuantity>";
                        $XMLCargoSummary .= "<Value>" . $quantity . "</Value>";
                        $XMLCargoSummary .= "<UOM>Numbers</UOM>";
                        $XMLCargoSummary .= "</TotalQuantity>";
                        $XMLCargoSummary .= "<TotalVolume>";
                        $XMLCargoSummary .= "<Value>" . $totalVolume . "</Value>";
                        $XMLCargoSummary .= "<UOM>" . $volumeUOM . "</UOM>";
                        $XMLCargoSummary .= "</TotalVolume>";
                        $XMLCargoSummary .= "<TotalWeight>";
                        $XMLCargoSummary .= "<Value>" . $chargedWeight . "</Value>";
                        $XMLCargoSummary .= "<UOM>" . $chargedWeight . "</UOM>";
                        $XMLCargoSummary .= "</TotalWeight>";
                        $XMLCargoSummary .= "</CargoSummary>";

                        $XMLValueAddedServices .= "<ValueAddedServices>";
                        if (! empty($consignmentData['ValueAddedServices'])) {
                            foreach ($consignmentData['ValueAddedServices'] as $vasData) {
                                $vasCode = $vasData['ValueAddedServiceId'] ?? "";
                                $vasName = $vasData['ValueAddedServiceName'] ?? "";

                                $XMLValueAddedServices .= "<Addon>";
                                $XMLValueAddedServices .= "<AddonName>" . $vasName . "</AddonName>";
                                $XMLValueAddedServices .= "<AddonCode>" . $vasCode . "</AddonCode>";
                                $XMLValueAddedServices .= "<Currency></Currency>";
                                $XMLValueAddedServices .= "<RateUnit></RateUnit>";
                                $XMLValueAddedServices .= "<AddonAmount></AddonAmount>";
                                $XMLValueAddedServices .= "<AddonQuantity></AddonQuantity>";
                                $XMLValueAddedServices .= "</Addon>";
                            }
                        }
                        $XMLValueAddedServices .= "</ValueAddedServices>";
                        $timeZone = $this->CI->Standardbookingmodel->getUserTimeZone($userId);
                        $XMLReferences .= "<ManageReferences>";
                        if (!empty($consignmentData['InvoiceDetails'])) {
                            foreach ($consignmentData['InvoiceDetails'] as $invoiceData) {
                        
                                $invoiceNo    = $invoiceData['InvoiceNumber'] ?? '';
                                $invoiceDate  = $invoiceData['InvoiceDate'] ?? '';
                                $invoiceValue = $invoiceData['InvoiceValue'] ?? '';
                        
                                if (empty($invoiceNo) && empty($invoiceDate) && empty($invoiceValue)) {
                                    continue;
                                }
                        
                                if (!empty($invoiceNo)) {
                                    $XMLReferences .= "<References>
                                        <RefType>
                                            <Code>IV</Code>
                                            <Value>{$invoiceNo}</Value>
                                        </RefType>
                                    </References>";
                                }
                        
                                if (!empty($invoiceDate)) {
                                    $getInvoiceDate = getdatetimebytimezone(
                                        DFLT_TZ,
                                        str_replace("T", " ", $invoiceDate),
                                        $timeZone
                                    );
                        
                                    $invoiceDateFormatted = $getInvoiceDate['datetime'];
                        
                                    $XMLReferences .= "<References>
                                        <RefType>
                                            <Code>ID</Code>
                                            <Value>{$invoiceDateFormatted}</Value>
                                        </RefType>
                                    </References>";
                                }
                        
                                if (!empty($invoiceValue)) {
                                    $XMLReferences .= "<References>
                                        <RefType>
                                            <Code>INV</Code>
                                            <Value>{$invoiceValue}</Value>
                                        </RefType>
                                    </References>";
                                }
                            }
                        }


                        if (! empty($consignmentData['EwaybillDetails'])) if (!empty($consignmentData['EwaybillDetails'])) {
                            foreach ($consignmentData['EwaybillDetails'] as $ewayBillData) {
                        
                                $ewayBillNo    = $ewayBillData['EwaybillNumber'] ?? '';
                                $ewayBillDate  = $ewayBillData['EwaybillDate'] ?? '';
                                $ewayBillValue = $ewayBillData['EwaybillValue'] ?? '';
                        
                                if (empty($ewayBillNo) && empty($ewayBillDate) && empty($ewayBillValue)) {
                                    continue;
                                }
                        
                                if (!empty($ewayBillNo)) {
                                    $XMLReferences .= "<References>
                                        <RefType>
                                            <Code>AWB</Code>
                                            <Value>{$ewayBillNo}</Value>
                                        </RefType>
                                    </References>";
                                }
                        
                                if (!empty($ewayBillDate)) {
                                    $getEwayBillDate = getdatetimebytimezone(
                                        DFLT_TZ,
                                        str_replace("T", " ", $ewayBillDate),
                                        $timeZone
                                    );
                        
                                    $ewayBillDateFormatted = $getEwayBillDate['datetime'];
                        
                                    $XMLReferences .= "<References>
                                        <RefType>
                                            <Code>AWBD</Code>
                                            <Value>{$ewayBillDateFormatted}</Value>
                                        </RefType>
                                    </References>";
                                }
                        
                                if (!empty($ewayBillValue)) {
                                    $XMLReferences .= "<References>
                                        <RefType>
                                            <Code>AWBV</Code>
                                            <Value>{$ewayBillValue}</Value>
                                        </RefType>
                                    </References>";
                                }
                            }
                        }

                        if ($customerDocumentNumber != null && $customerDocumentNumber != "" && $customerDocumentNumber != "null") {
                            $XMLReferences .= "<References>";
                            $XMLReferences .= "<RefType>";
                            $XMLReferences .= "<Code>DQ</Code>";
                            $XMLReferences .= "<Value>" . $customerDocumentNumber . "</Value>";
                            $XMLReferences .= "</RefType>";
                            $XMLReferences .= "</References>";
                            $XMLReferences .= "<References>";
                            $XMLReferences .= "<RefType>";
                            $XMLReferences .= "<Code>KNLR</Code>";
                            $XMLReferences .= "<Value>" . $customerDocumentNumber . "</Value>";
                            $XMLReferences .= "</RefType>";
                            $XMLReferences .= "</References>";
                        } else {
                            $XMLReferences .= "<References>";
                            $XMLReferences .= "<RefType>";
                            $XMLReferences .= "<Code>DQ</Code>";
                            $XMLReferences .= "<Value>" . $docketNo . "</Value>";
                            $XMLReferences .= "</RefType>";
                            $XMLReferences .= "</References>";
                        }

                        $XMLReferences .= "<References>";
                        $XMLReferences .= "<RefType>";
                        $XMLReferences .= "<Code>CRF</Code>";
                        $XMLReferences .= "<Value>" . $bookingNo . "</Value>";
                        $XMLReferences .= "</RefType>";
                        $XMLReferences .= "</References>";
                        $XMLReferences .= "<References>";
                        $XMLReferences .= "<RefType>";
                        $XMLReferences .= "<Code>TKN</Code>";
                        $XMLReferences .= "<Value>" . $docketNo . "</Value>";
                        $XMLReferences .= "</RefType>";
                        $XMLReferences .= "</References>";
                        $XMLReferences .= "</ManageReferences>";
                        $XMLRemarks .= "<Remarks/>";

                        $XMLOutput = $XMLHeader . $XMLBody . "<CustomerDetails>" . $XMLCustomer . "</CustomerDetails>" . "<LocationInfo><Source>" . $XMLSource . $XMLSourceDateTime . "</Source><Destination>" . $XMLDestination . $XMLDestinationDateTime . "</Destination></LocationInfo>" . $XMLCargoSummary . "<CargoDetails>" . $XMLCargo . "</CargoDetails>" . $XMLValueAddedServices . "<InvolvedParties><PartyType><Type>Customer</Type>" . $XMLCustomer . "</PartyType><PartyType><Type>Shipper</Type>" . $XMLSource . "</PartyType><PartyType><Type>Consignee</Type>" . $XMLDestination . "</PartyType></InvolvedParties>" . $XMLReferences . $XMLRemarks . "</SVKEDIOrderBody></SVKEDIMessage>";
                        log_message("error", "Response:" . $XMLOutput);

                        // Load XML string into a SimpleXMLElement
                        $xmlObject = simplexml_load_string($XMLOutput);

                        // Convert SimpleXMLElement to JSON
                        $json = json_encode($xmlObject);

                        // Decode JSON to associative array
                        $array = json_decode($json, true);

                        $bookingId = $this->CI->standardbookinghandler->pullOrderXml($array);
                        //log_message("error", "Booking ID:" . $bookingId);

                    } catch (Throwable $e) {
                        // 🔴 Catches both Exceptions and Errors
                        $subject = "Exception in XP INDIA Consignment Processing";
                        $body    = "Error during processing of consignment:\n\n"
                        . json_encode($consignmentData, JSON_PRETTY_PRINT) . "\n\n"
                        . "Message: " . $e->getMessage() . "\n\n"
                        . "Trace:\n" . $e->getTraceAsString();

                        // Log the error
                        log_message('error', "Body:" . $body);

                        $this->sendEmailNotification($consignmentData, $subject, $body, $data);

                        continue; // Skip to next consignment
                    }
                }
            } else {
                echo "No consignment data found.";
            }

        } catch (Throwable $e) {

            $subject = "FATAL: XP INDIA EDI Processing Failed (Before XML)";
            $body    = "A fatal error occurred in generateStandardInbound()\n\n"
            . "Message: " . $e->getMessage() . "\n\n"
            . "Trace:\n" . $e->getTraceAsString()
            . "\n\nPayload:\n" . json_encode($data, JSON_PRETTY_PRINT);

            log_message('error', "Body:" . $body);

            $this->sendEmailNotification($consignmentData, $subject, $body, $data);

        } finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('XP INDIA');
            $this->CI->edi_logger->setBounded_type(1);
            $this->CI->edi_logger->setCompany_code($companyCode);
            $this->CI->edi_logger->setBranch_code($clientCode);
            $this->CI->edi_logger->setUser_id($userId);
            $this->CI->edi_logger->setEdi_format_type('JSON');
            $this->CI->edi_logger->setStatus(((isset($data) && $data) ? 1 : 0));
            $this->CI->edi_logger->setEdi_request(json_encode($data));
            $this->CI->edi_logger->setObj_type_name('XP INDIA CARRIER INBOUND ORDER REQUEST THROUGH API/EDI');
            $this->CI->edi_logger->saveToEdiLogs();
        }
        return "success";
    }

    public function checkValidation(array $data): bool
    {
        $booking = $data['BookingDetails'] ?? null;
        if ($booking) {
            $tripSchedulePickup = $booking['ScheduledPickupDate'] ?? "";
        }

        $showPopup = false;

        // Loop through ConsignmentNoteDetails
        if (! empty($data['ConsignmentNoteDetails'])) {
            foreach ($data['ConsignmentNoteDetails'] as $consignmentData) {
                $consignorName     = $consignmentData['ConsignorName'] ?? "";
                $consignorState    = $consignmentData['ConsignorState'] ?? "";
                $consignorPostCode = $consignmentData['ConsignorPostcode'] ?? "";
                $consigneeName     = $consignmentData['ConsigneeName'] ?? "";
                $consigneeState    = $consignmentData['ConsigneeState'] ?? "";
                $consigneePostCode = $consignmentData['ConsigneePostcode'] ?? "";

                $shipperExistsData   = $this->CI->CarrierInboundModel->checkPartyRoleExists($consignorName, $consignorState, $consignorPostCode, 'Shipper');
                $consigneeExistsData = $this->CI->CarrierInboundModel->checkPartyRoleExists($consigneeName, $consigneeState, $consigneePostCode, 'Consignee');

                if (empty($shipperExistsData) && empty($consigneeExistsData)) {
                    $subject = "XP INDIA Shipment Inbound request failed for Consignor: " . $consignmentData['ConsignorName'];

                    $message = "Hi Team,<br><br>";
                    $message .= "XP INDIA Shipment Inbound request failed for below Consignor/Consignee Address: <br><br>";
                    $message .= "Consignor:  " . "<br>";
                    $message .= "Name:  " . $consignmentData['ConsignorName'] . "<br>";
                    $message .= "State:  " . $consignmentData['ConsignorState'] . "<br>";
                    $message .= "District:  " . $consignmentData['ConsignorDistrict'] . "<br>";
                    $message .= "Location:  " . $consignmentData['ConsignorLocation'] . "<br>";
                    $message .= "Post Code:  " . $consignmentData['ConsignorPostcode'] . "<br>";
                    $message .= "Address:  " . $consignmentData['ConsignorAddress'] . "<br><br>";
                    $message .= "Consignee:  " . "<br>";
                    $message .= "Name:  " . $consignmentData['ConsigneeName'] . "<br>";
                    $message .= "State:  " . $consignmentData['ConsigneeState'] . "<br>";
                    $message .= "District:  " . $consignmentData['ConsigneeDistrict'] . "<br>";
                    $message .= "Location:  " . $consignmentData['ConsigneeLocation'] . "<br>";
                    $message .= "Post Code:  " . $consignmentData['ConsigneePostcode'] . "<br>";
                    $message .= "Address:  " . $consignmentData['ConsigneeAddress'] . "<br><br>";
                    $message .= "This is an automatically generated EMail, please do not reply <br><br>";
                    $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
                    $this->sendEmailNotification($consignmentData, $subject, $message, $data);
                    $showPopup = true; // Flag to trigger popup
                    break;             // Optional: exit loop after first missing entry
                }
            }
        }
        return $showPopup;
    }

    public function sendEmailNotification(array $consignmentData, string $subject, string $message, array $data): void
    {
        $this->CI->load->library('PhpMailerLibrary');
        try {
            $mail = $this->CI->phpmailerlibrary->mail;

                                  // Turn off SMTP debugging output
            $mail->SMTPDebug = 0; // Or SMTP::DEBUG_OFF

            $mail->clearAllRecipients();
            $mail->clearAttachments();
            $mail->setFrom('no-reply@svkonekt.com', 'SVKonekt Support');

            // Add To recipients
            if (is_array(MAIL_TO)) {
                foreach (MAIL_TO as $toEmail) {
                    $mail->addAddress($toEmail);
                }
            } else {
                $mail->addAddress(MAIL_TO);
            }

            // Add CC recipients
            if (! empty(MAIL_CC)) {
                if (is_array(MAIL_CC)) {
                    foreach (MAIL_CC as $ccEmail) {
                        $mail->addCC($ccEmail);
                    }
                } else {
                    $mail->addCC(MAIL_CC);
                }
            }

            $mail->Subject = $subject;
            $mail->isHTML(true);
            $mail->Body = $message;

            $tmpFile = tempnam(sys_get_temp_dir(), 'shipment_') . '.json';
            file_put_contents($tmpFile, json_encode($consignmentData, JSON_PRETTY_PRINT));

            $tmpFile1 = tempnam(sys_get_temp_dir(), 'Mainshipment_') . '.json';
            file_put_contents($tmpFile1, json_encode($data, JSON_PRETTY_PRINT));

            $fileName  = $consignmentData['XPCNNumber'] . ".json";
            $fileName1 = $consignmentData['XPCNNumber'] . "_MainFile" . ".json";
            $mail->addAttachment($tmpFile, $fileName);
            $mail->addAttachment($tmpFile1, $fileName1);

            if ($mail->send()) {
                log_message("error", "Email Sent For " . $subject);
            } else {
                log_message("error", "Email Failed For " . $subject);
            }

            unlink($tmpFile);

        } catch (Exception $e) {
            log_message("error", "Consignor Party Address Missing Email Failed - " . $e->getMessage());
        }
    }

    public function generateStandardDocumentInbound(array $data): array
    {
        $consignmentNoteNumber = $data['ConsignmentNoteNumber'] ?? "";
        $orderDetails          = $this->CI->CarrierInboundModel->getOrderId($consignmentNoteNumber, 'TKN');
        if (! empty($orderDetails)) {
            try
            {
                $companyCode = $orderDetails[0]['company_code'];
                $clientCode  = $orderDetails[0]['branch_code'];
                $orderId     = $orderDetails[0]['order_id'];
                $userId      = $orderDetails[0]['user_id'];
                $id          = $orderDetails[0]['id'];

                $documents    = $data['ProofOfDeliveryDocuments'];
                $documentType = $data['DocumentType'] ?? "POD";

                // Output the values
                echo "Consignment Note Number: " . $consignmentNoteNumber . "\n";

                echo "Proof of Delivery Documents:\n";
                foreach ($documents as $doc) {
                    $podInput = '<SVKDocumentUpload>';
                    $podInput .= '<SVKHeader>';
                    $podInput .= '<SVKSourceApp>XP_INDIA</SVKSourceApp>';
                    $podInput .= '<SVKDestinationApp>SVKonekt</SVKDestinationApp>';
                    $podInput .= '</SVKHeader>';
                    $podInput .= '<SVKAction>POD UPLOADED</SVKAction>';
                    $podInput .= '<SVKOrderID>' . $orderId . '</SVKOrderID>';
                    $podInput .= '<SVKDocumentType>' . $documentType . '</SVKDocumentType>';
                    $podInput .= '<SVKUploadDetails>';
                    $podInput .= '<SVKDocumentName>' . $documentType . '</SVKDocumentName>';
                    $podInput .= '<SVKURL>' . $doc . '</SVKURL>';
                    $podInput .= '</SVKUploadDetails>';
                    $podInput .= '</SVKDocumentUpload>';

                    $xml = simplexml_load_string($podInput);
                    $res = $this->CI->flipkartediservices->getXPPod($xml, $id);
                    $msg = [
                        "success" => true,
                        "Message" => "POD Uploaded Successfully",
                    ];

                }
            } catch (Exception $e) {
                $message = 'Error: ' . $e->getMessage();
            } finally {
                $this->CI->edi_logger->setEdi_type(1);
                $this->CI->edi_logger->setTransaction_id(time());
                $this->CI->edi_logger->setEdi_name('XP INDIA');
                $this->CI->edi_logger->setBounded_type(1);
                $this->CI->edi_logger->setCompany_code($companyCode);
                $this->CI->edi_logger->setBranch_code($clientCode);
                $this->CI->edi_logger->setUser_id($userId);
                $this->CI->edi_logger->setEdi_format_type('JSON');
                $this->CI->edi_logger->setStatus(((isset($data) && $data) ? 1 : 0));
                $this->CI->edi_logger->setEdi_request(json_encode($data));
                $this->CI->edi_logger->setObj_type_name('XP INDIA CARRIER INBOUND DOCUMENT REQUEST THROUGH API/EDI');
                $this->CI->edi_logger->saveToEdiLogs();
            }
        } else {
            $msg = [
                "success" => false,
                "Message" => "Invalid Consignment Note Number",
            ];
        }
        return $msg;
    }

}
