<?php
defined('BASEPATH') or exit('No direct script access allowed');

class DTDCEDIServices
{
    private $CI;
    private $carrier      = 'DTDC';
    private $customerCode = 'C0002001';
    private $appKey       = '';
    private $apiKey       = '';
    private $baseUrl      = '';

    public function __construct()
    {
        $this->CI = &get_instance();

        $this->CI->load->model(['Singlestatusmodel', 'Order']);
        $this->CI->load->library(['Edi_logger', 'uuid', 'apis/FlipkartEDIServices']);
        $this->CI->load->helper('user_helper');

        $query = $this->CI->db->get_where(
            'tb_auth_tokens',
            ['token_for' => $this->carrier]
        );

        $tokenRow = $query->row_array();

        $this->appKey  = $tokenRow['auth_token'] ?? '';
        $this->apiKey  = $tokenRow['api_key'] ?? '';
        $this->baseUrl = $tokenRow['base_url'] ?? '';
        $this->code    = $tokenRow['code'] ?? '';
    }

    public function createOrder(array $orderData, string $orderId, int $id): void
    {
        $dtdcRefNo  = "ORD-" . (string) $orderId;
        $pickupDate = '';

        if (
            isset($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) &&
            is_string($orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime']) &&
            $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime'] !== ''
        ) {
            $pickupDate = $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime'];
        }

        $totalQuantityValue = $orderData['cargoSummary']['TotalQuantity']['Value'];
        $totalWeightValue   = $orderData['cargoSummary']['TotalWeight']['Value'];

        $pickup_name    = $orderData['sourceInfo']['Company']['Name'];
        $pickup_address = $orderData['sourceInfo']['Address']['Address1'] . "," . $orderData['sourceInfo']['Address']['Street'];
        $pickup_street  = $orderData['sourceInfo']['Address']['Address2'];
        $pickup_city    = $orderData['sourceInfo']['Address']['City'];
        $pickup_state   = $orderData['sourceInfo']['Address']['State'];
        $pickup_country = $orderData['sourceInfo']['Address']['Country'];
        $pickup_pincode = $orderData['sourceInfo']['Address']['Postal'];
        $drop_name      = $orderData['destinationInfo']['Company']['Name'];
        $drop_address   = $orderData['destinationInfo']['Address']['Address1'] . "," . $orderData['destinationInfo']['Address']['Street'];
        $drop_street    = $orderData['destinationInfo']['Address']['Address2'];
        $drop_city      = $orderData['destinationInfo']['Address']['City'];
        $drop_state     = $orderData['destinationInfo']['Address']['State'];
        $drop_country   = $orderData['destinationInfo']['Address']['Country'];
        $drop_pincode   = $orderData['destinationInfo']['Address']['Postal'];
        $drop_contact   = $orderData['destinationInfo']['Address']['ContactInfo']['ContactNo'];
        $carrierCode    = $orderData['header']['CarrierDetails']['ID'];

        log_message("error", "pickup_datetime: " . $pickupDate);

        if ($pickupDate === '' || $pickupDate === '0000-00-00 00:00:00') {
            $pickupDate = date('Y-m-d H:i:s');
        }

        $dt          = new DateTime($pickupDate);
        $pickup_date = $dt->format('Y-m-d');
        $pickup_time = $dt->format('H:i:s');

        $thuData      = $orderData['cargoDetails']['CargoThuDetails'] ?? [];
        $pieceDetails = [];

        $totalLength = $totalWidth = $totalHeight = $totalWeight = 0;

        if (! isset($thuData[0])) {
            $thuData = [$thuData];
        }

        foreach ($thuData as $orderCargo) {

            $length = ! empty($orderCargo['Length']) && ! is_array($orderCargo['Length'])
                ? (float) $orderCargo['Length'] : 0;

            $width = ! empty($orderCargo['Width']) && ! is_array($orderCargo['Width'])
                ? (float) $orderCargo['Width'] : 0;

            $height = ! empty($orderCargo['Height']) && ! is_array($orderCargo['Height'])
                ? (float) $orderCargo['Height'] : 0;

            if (! empty($orderCargo['Weight']) && ! is_array($orderCargo['Weight']) && (float) $orderCargo['Weight'] > 0) {
                $weight = (float) $orderCargo['Weight'];
            } else {
                $weight = 0.5;
            }

            $totalWeight += $weight;
            $totalLength += $length;
            $totalWidth += $width;
            $totalHeight += $height;

            $pieceDetails[] = [
                'weight' => $weight,
                'length' => $length,
                'height' => $height,
                'width'  => $width,
            ];
        }

        $dtdcPickupRequestBooking = [
            "consignments" => [
                [
                    "origin_details"               => [
                        "address_line_1"  => $pickup_address ?: "",
                        "address_line_2"  => $pickup_street ?: "",
                        "city"            => $pickup_city ?: "",
                        "name"            => $pickup_name,
                        "phone"           => $pickup_contact ?: "",
                        "alternate_phone" => $pickup_contact ?: "",
                        "pincode"         => $pickup_pincode ?: "",
                        "state"           => $pickup_state ?: "",
                    ],
                    "destination_details"          => [
                        "address_line_1"  => $drop_address ?: "",
                        "address_line_2"  => $drop_street ?: "",
                        "city"            => $drop_city ?: "",
                        "name"            => $drop_name ?: "",
                        "phone"           => $drop_contact ?: "",
                        "pincode"         => $drop_pincode ?: "",
                        "state_name"      => $drop_state ?: "",
                        "alternate_phone" => $drop_contact ?: "",
                        "email"           => $drop_email ?: "",
                    ],
                    "pay_basis"                    => "TBB",
                    "dimension_unit"               => "cm",
                    "length"                       => $totalLength,
                    "width"                        => $totalWidth,
                    "height"                       => $totalHeight,
                    "weight_unit"                  => "kg",
                    "weight"                       => $totalWeight,
                    "declared_value"               => "",
                    "service_type_id"              => "SURFACE",
                    "is_risk_surcharge_applicable" => false,
                    "commodity_name"               => "Laptop",
                    "num_pieces"                   => count($pieceDetails),
                    "reference_number"             => "",
                    "customer_reference_number"    => $orderId,
                    "customer_code"                => $this->customerCode,
                    "pieces_detail"                => $pieceDetails,
                ],
            ],
        ];

        log_message("error", "dtdcPickupRequestBooking:" . json_encode($dtdcPickupRequestBooking));

        $jsonData = json_encode($dtdcPickupRequestBooking);
        log_message("error", "apiKey:" . $this->apiKey);
        $vendor = $this->CI->db->get_where("tb_vendors", ['code' => $this->code])->row_array();

        $companyCode = $vendor['company_code'] ?? '';
        $branchCode  = $vendor['branch_code'] ?? '';
        $userId      = $vendor['user_id'] ?? '';

        $dtdcPickupRequestBookingResponse = [];
        try {
            $ch = curl_init($this->baseUrl);
            curl_setopt_array($ch, [
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/json",
                    "api-key: {$this->apiKey}",
                ],
                CURLOPT_POST           => true,
                CURLOPT_POSTFIELDS     => $jsonData,
                CURLOPT_RETURNTRANSFER => true,
            ]);

            $responseRaw = curl_exec($ch);

            $response = json_decode($responseRaw, true);

            log_message('error', 'Response: ' . json_encode($response));

            $dtdcPickupRequestBookingResponse = $response;

            if (
                empty($response['status']) ||
                $response['status'] !== 'OK'
            ) {
                log_message('error', 'DTDC API Error: ' . json_encode($response));
            }

            $dtdcPickupResponseBookingId = null;

            if (
                isset($response['status']) &&
                $response['status'] === 'OK' &&
                isset($response['data'][0]['success']) &&
                $response['data'][0]['success'] === true
            ) {
                $dtdcPickupResponseBookingId = $response['data'][0]['reference_number'] ?? null;
            }

            curl_close($ch);
            log_message("error", "DTDC Order Response: " . json_encode($dtdcPickupRequestBookingResponse));

        } catch (Exception $e) {
            log_message("error", "DTDC Order Exception: " . $e->getMessage());
        } finally {
            $this->logEdiTransaction($jsonData, $dtdcPickupRequestBookingResponse, $companyCode, $branchCode, $userId, 'DTDC Carrier Order Request');
        }
        $cdate = date('Y-m-d H:i:s');
        if (! empty($dtdcPickupResponseBookingId)) {

            $dtdc_tkn_ref = [
                'order_id'     => $id,
                'reference_id' => 'TKN',
                'ref_value'    => $dtdcPickupResponseBookingId,
                'createdon'    => $cdate,
            ];

            $this->CI->db->insert('tb_order_references', $dtdc_tkn_ref);
        }
    }

    public function getStatus(string $docketNo, string $orderId, int $id): int
    {
        $query = $this->CI->db->get_where(
            'tb_auth_tokens',
            ['token_for' => 'DTDC TRACK']
        );

        $tokenRow = $query->row_array();

        $this->appKey  = $tokenRow['auth_token'] ?? '';
        $this->baseUrl = $tokenRow['base_url'] ?? '';

        log_message("error", "DocketNo: " . $docketNo);

        if (empty($docketNo) || $orderId <= 0) {
            log_message('error', "Invalid DocketNo");
            return 0;
        }

        $url = $this->baseUrl;

        $payload = [
            'TrkType'   => 'cnno',
            'strCnno'   => $docketNo,
            'addtnlDtl' => 'Y',
        ];

        $jsonPayload = json_encode($payload);

        log_message("error", "Tracking Payload: " . $jsonPayload);
        log_message("error", "AppKey: " . $this->appKey);

        $curl = curl_init($url);
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $jsonPayload,
            CURLOPT_HTTPHEADER     => [
                "Content-Type: application/json",
                "xx-authentication-token: {$this->appKey}",
            ],
            CURLOPT_TIMEOUT => 30,
        ]);

        $response = curl_exec($curl);

        log_message("error", "DTDC Tracking Response: " . $response);

        if ($response === false) {
            log_message('error', 'Curl Error: ' . curl_error($curl));
            curl_close($curl);
            return 0;
        }

        curl_close($curl);

        $data = json_decode($response, true);

        if ($data === null) {
            log_message('error', 'DTDC Tracking Invalid JSON: ' . $response);
            return 0;
        }

        if (! isset($data['IsSuccess']) || $data['IsSuccess'] !== true) {
            log_message('error', 'DTDC Tracking API failed: ' . json_encode($data));
            return 0;
        }

        $trackingResult = $data['CONSIGNMENT']['CNBODY'] ?? [];
        $headerResult   = $data['CONSIGNMENT']['CNHEADER'] ?? [];
        $statusList     = $trackingResult['CNACTION'] ?? [];

        if (isset($statusList['strAction'])) {
            $statusList = $statusList;
        }

        $statusInput = $this->generateStatusXML($docketNo, $statusList);
        $xml         = simplexml_load_string($statusInput);

        $podImageUrl = $headerResult['PODLink'] ?? "";
        $edd         = $headerResult['EDD'] ?? "";

        $edd = $headerResult['EDD'] ?? "";
        log_message('error', 'edd: ' . $edd);
        if (! empty($edd)) {

            $utcTz = new DateTimeZone('UTC');
            $dt    = DateTime::createFromFormat('d/m/Y', $edd, $utcTz);

            if ($dt) {

                $startDatetimeUtc = $dt->setTime(0, 0, 0)->format('Y-m-d H:i:s');

                $endDatetimeUtc = $dt->setTime(23, 59, 59)->format('Y-m-d H:i:s');

                $status = $this->CI->common->updatetbledata(
                    "tb_orders",
                    [
                        'delivery_datetime' => $startDatetimeUtc,
                        'drop_endtime'      => $endDatetimeUtc,
                        'updatedon'         => gmdate('Y-m-d H:i:s'),
                    ],
                    ['id' => $id]
                );
            } else {
                log_message('error', "Invalid EDD format: " . $edd);
            }
        }
        log_message('error', 'podImageUrl: ' . $podImageUrl);
        if (! empty($podImageUrl)) {
            $podInput = '<SVKDocumentUpload>';
            $podInput .= '<SVKHeader>';
            $podInput .= '<SVKSourceApp>' . $carrier . '</SVKSourceApp>';
            $podInput .= '<SVKDestinationApp>SVKonekt</SVKDestinationApp>';
            $podInput .= '</SVKHeader>';
            $podInput .= '<SVKAction>POD UPLOADED</SVKAction>';
            $podInput .= '<SVKOrderID>' . $orderId . '</SVKOrderID>';
            $podInput .= '<SVKDocumentType>POD</SVKDocumentType>';
            $podInput .= '<SVKUploadDetails>';
            $podInput .= '<SVKDocumentName>POD</SVKDocumentName>';
            $podInput .= '<SVKURL>' . $podImageUrl . '</SVKURL>';
            $podInput .= '</SVKUploadDetails>';
            $podInput .= '</SVKDocumentUpload>';

            $xml1 = simplexml_load_string($podInput);
            $res = $this->CI->flipkartediservices->getXPPod($xml1, $id);
        }
        log_message('error', 'xml: ' . $xml);
        return $this->getStatusXml($xml, $orderId, $this->carrier);
    }

    private function generateStatusXML(string $docketNo, array $statusList): string
    {
         log_message("error", "DTDC statusList: " . json_encode($statusList));
        $xml = '<SVKEDIResponseMessage>';
        $xml .= '<SVKEDITransmissionHeader>';
        $xml .= '<EDIVersion>SVK2.0</EDIVersion>';
        $xml .= '<AckSpec><AckOption>SUCCESS</AckOption></AckSpec>';
        $xml .= '<SourceApp>' . $this->carrier . '</SourceApp>';
        $xml .= '<DestinationApp>SVKONEKT</DestinationApp>';
        $xml .= '<Action>BookingStatusUpdate</Action>';
        $xml .= '</SVKEDITransmissionHeader>';
        $xml .= '<SVKEDITransmissionBody><Order>';
        $xml .= '<OrderID>' . $docketNo . '</OrderID>';

        foreach ($statusList as $status) {
            $status['ActivityCode']    = $status['strAction'] ?? '';
            $status['ActivityAddress'] = $status['strAddress'] ?? '';
            $dt                        = DateTime::createFromFormat(
                'dmYHi',
                $status['strActionDate'] . $status['strActionTime']
            );

            $status['ActivityDate'] = $dt ? $dt->format('Y-m-d H:i:s') : '';
            $xml .= '<Status>';
            $xml .= '<StatusCode>' . $status['ActivityCode'] . '</StatusCode>';
            $xml .= '<StatusValue>' . $status['ActivityCode'] . '</StatusValue>';
            $xml .= '<StatusType>' . $status['ActivityCode'] . '</StatusType>';
            $xml .= '<DateTime>' . $status['ActivityDate'] . '</DateTime>';
            $xml .= '<TimeZone>+00:00</TimeZone>';
            $xml .= '<Location>' . $status['ActivityAddress'] . '</Location>';
            $xml .= '</Status>';
        }

        $xml .= '</Order></SVKEDITransmissionBody></SVKEDIResponseMessage>';

        log_message('error', "Generated Status XML: " . $xml);
        return $xml;
    }

    private function logEdiTransaction(string $request, array $response, string $companyCode, string $branchCode, string $userId, string $ediName): void
    {
        $this->CI->edi_logger->setEdi_type(1);
        $this->CI->edi_logger->setTransaction_id(time());
        $this->CI->edi_logger->setEdi_name($ediName);
        $this->CI->edi_logger->setBounded_type(1);
        $this->CI->edi_logger->setCompany_code($companyCode);
        $this->CI->edi_logger->setBranch_code($branchCode);
        $this->CI->edi_logger->setUser_id($userId);
        $this->CI->edi_logger->setEdi_format_type('JSON');
        $status = isset($response['ResponseStatus']['Message']) && $response['ResponseStatus']['Message'] === 'SUCCESS' ? 1 : 0;
        $this->CI->edi_logger->setStatus($status);
        $this->CI->edi_logger->setEdi_request($request);
        $this->CI->edi_logger->setEdi_response(json_encode($response));
        $this->CI->edi_logger->setObj_type_name($ediName);
        $this->CI->edi_logger->saveToEdiLogs();
    }

    public function getStatusXml(object $xmlData, int $orderId, string $carrier): int
    {
        log_message('error', 'xmlData: ' . $xmlData);
        $statusResponse = 0;
        $body           = $xmlData->xpath('SVKEDITransmissionBody');

        if (empty($body)) {
            return 0;
        }
        log_message('error', 'body: ' . json_encode($body[0]));
        foreach ($body[0]->Order as $order) {
            log_message('error', '$order: ' . json_encode($order));
            log_message('error', 'orderId: ' . $orderId);
            /*$chkOrder = $this->CI->db->get_where('tb_orders', ['id' => $orderId])->row_array();
            if (! $chkOrder) {
                continue;
            }
            
            //$val = getorderreftypeinfo('TKN', $orderId);
            
            $orderIdDb  = $chkOrder['order_id'];*/
            $ordersData = [];
            
            foreach ($order->Status as $status) {
                
                $statusCode = (string) ($status->StatusCode ?? '');
                log_message('error', 'statusCode: ' . $statusCode);
                if (! $statusCode) {
                    continue;
                }

                $ordersData[] = [
                    "OrderID"     => $orderId,
                    "statustype"  => (string) ($status->StatusType ?? ''),
                    "statuscode"  => $statusCode,
                    "statusvalue" => (string) ($status->StatusValue ?? ''),
                    "datetime"    => (string) ($status->DateTime ?? ''),
                    "timezone"    => (string) ($status->TimeZone ?? ''),
                    "lat"         => (string) ($status->Lat ?? ''),
                    "lng"         => (string) ($status->Lng ?? ''),
                    "location"    => (string) ($status->Location ?? ''),
                ];
            }
            log_message("error", "DTDC ordersData: " . json_encode($ordersData));
            if (! empty($ordersData)) {
                $statusResponse = $this->CI->Singlestatusmodel->updateXPStatus(json_encode($ordersData), $carrier);
            }
        }

        return $statusResponse;
    }
}
