<?php

class SarathiEDIServices
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance(); //
        $this->ci->load->model(['common', 'otmTripModel', 'OtmBookingModel']);
        $this->ci->load->library(['otmordershipmenthandler','standardtriphandler']);
    }

    public function getOtmShipmentData(string $data): string
    {
        $data = preg_replace('/\s+xmlns(:\w+)?="[^"]+"/', '', $data);

        $xml = simplexml_load_string($data);
        
        $gLogElement = $xml->xpath('/Transmission/TransmissionBody/GLogXMLElement');
        $plannedShipment = $gLogElement[0]->xpath('PlannedShipment/Shipment');
        $domainName = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/DomainName')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/DomainName')[0];
        $shipmentId = empty((string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/Xid')[0]) ? 0 : (string) $plannedShipment[0]->xpath('ShipmentHeader/ShipmentGid/Gid/Xid')[0];
        $shipmentRefNumAry = $plannedShipment[0]->xpath('ShipmentHeader/ShipmentRefnum');
        $driverLicense = $driverDob = "";
        foreach ($shipmentRefNumAry as $shipmentRefNum) {
            $shipmentRefNumXid = (string) $shipmentRefNum[0]->xpath('ShipmentRefnumQualifierGid/Gid/Xid')[0];
            if($shipmentRefNumXid == "DRIVER_LICENSEE")
            {
                $driverLicense = (string) $shipmentRefNum[0]->xpath('ShipmentRefnumValue')[0];
            }
            if($shipmentRefNumXid == "DRVLIC_DOB")
            {
                $driverDob = (string) $shipmentRefNum[0]->xpath('ShipmentRefnumValue')[0];
            }
        }
        
        $baseUrl = "https://api.intudb.intusystems.info/ulip/sarathi";
        $appKey = "eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICItNTZWQ1oydXV4TUF2QVZIeDFqbFBkdjROaVdQUlYwcXEtbGJ5TnJFbXJVIn0.eyJleHAiOjIwNzIyNjE3NTUsImlhdCI6MTc1NjkwMTc1NiwiYXV0aF90aW1lIjoxNzU2OTAxNzU1LCJqdGkiOiJvbnJ0YWM6NDkwMTg0ZTUtZDRmZC04YWZkLWQ4OTAtODE1NDcxNzc1NDA4IiwiaXNzIjoiaHR0cHM6Ly9hdXRoLmludHVzeXN0ZW1zLmluZm8vYXV0aC9yZWFsbXMvSW50dURCIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6IjRiMzdiYjA4LWFkNmUtNGEyZC1iYTNkLWVkYmNkMDMyMGIzMCIsInR5cCI6IkJlYXJlciIsImF6cCI6ImZyb250ZW5kIiwic2lkIjoiY2UxNDUzY2QtNjgzMC00NWEyLTg4ZjgtNjM4MTk4YmQzZmQ1IiwiYWNyIjoiMSIsImFsbG93ZWQtb3JpZ2lucyI6WyJodHRwczovL21hc3Rlci5kazJ4cG44ZnIwa25yLmFtcGxpZnlhcHAuY29tIiwiaHR0cDovL2xvY2FsaG9zdDo4MDgwIiwiaHR0cHM6Ly9pbnR1ZGIuaW50dXN5c3RlbXMuaW5mbyIsImh0dHBzOi8vaW50dWRiLWFkbWluLmludHVzeXN0ZW1zLmluZm8iLCJodHRwczovL21hc3Rlci5kNGZxNHY3YW1iNWo3LmFtcGxpZnlhcHAuY29tIiwiaHR0cHM6Ly9tYXN0ZXIuZHRxOTU2ZGo5ZjdzNC5hbXBsaWZ5YXBwLmNvbSJdLCJyZWFsbV9hY2Nlc3MiOnsicm9sZXMiOlsiZGVmYXVsdC1yb2xlcy1pbnR1ZGIiLCJvZmZsaW5lX2FjY2VzcyIsInVtYV9hdXRob3JpemF0aW9uIl19LCJyZXNvdXJjZV9hY2Nlc3MiOnsiYWNjb3VudCI6eyJyb2xlcyI6WyJtYW5hZ2UtYWNjb3VudCIsIm1hbmFnZS1hY2NvdW50LWxpbmtzIiwidmlldy1wcm9maWxlIl19fSwic2NvcGUiOiJvcGVuaWQgZW1haWwgcHJvZmlsZSIsImVtYWlsX3ZlcmlmaWVkIjpmYWxzZSwiY2xpZW50TmFtZSI6IktOX0xvZ2lzdGljcyIsInByZWZlcnJlZF91c2VybmFtZSI6ImtuX2xvZ2lzdGljc18xIn0.fBNXkFkqEGW3Ud1C7hMuELyx6Z1tvxXuqi6CNl_jjpL1aaCpvlI-PHfSEQwnc5HTe_-jR7p8wZjT5qxUT6MlI5arAzatr-FR-EtGXbT7g_DtLdVUl1VeYkvkfG7dYLYyIykKSyZgGfF3HhOjl6rsQz8ownbGO0tHVMl2iAneSJmOFOadDBIm5y2M1hiaF4CLArsNEogASHQuWK5wxcVBZ2YRSR-5l3OTQChFRTqLu5qt3HiRMkvliy62jjSoAeaP97KQRZIq8_Mm5Nx4GtZZTSD080IR0BgvEq78qnuRYnqZcB9AuenQm4o6Le232fvCm8I3uwbNfM_MSn7zdSJzBw";
        
        $url = $baseUrl . '?' . http_build_query([
            'dlnumber' => $driverLicense,
            'dob'      => $driverDob,
        ]);

        try {
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_TIMEOUT        => 30,
                CURLOPT_HTTPHEADER     => [
                    'Authorization: Bearer ' . $appKey,
                ],
            ]);

            $response = curl_exec($ch);
            log_message("error", "response:" . json_encode($response));
            $data = json_decode($response, true);
            
            $dl = $data['data'] ?? [];
            $tValidFrom  = $dl['Driving License Transporter Valid From'] ?? null;
            $tValidUpto  = $dl['Driving License Transporter Valid To'] ?? null;
            $ntValidFrom = $dl['Driving License Non Transporter Valid From'] ?? null;
            $ntValidUpto = $dl['Driving License Non Transporter Valid Upto'] ?? null;
            $fromValid = $tValidFrom ?: $ntValidFrom ?: "";
            $toValid   = $tValidUpto ?: $ntValidUpto ?: "";
            
            date_default_timezone_set('Asia/Kolkata');
            $currentDate = date('YmdHis');
                        
            $otmRequest="";
            
            if($fromValid !="" && $toValid!="")
            {
                $otmRequest = $otmRequest . "<?xml version='1.0' encoding='UTF-8'?><Transmission xmlns='http://xmlns.oracle.com/apps/otm/transmission/v6.4'>";
                $otmRequest = $otmRequest . "<otm:TransmissionHeader xmlns:otm='http://xmlns.oracle.com/apps/otm/transmission/v6.4' xmlns:gtm='http://xmlns.oracle.com/apps/gtm/transmission/v6.4'/>";
                $otmRequest = $otmRequest . "<TransmissionBody>";
                $otmRequest = $otmRequest . "<GLogXMLElement>";
                $otmRequest = $otmRequest . "<otm:TransactionHeader xmlns:otm='http://xmlns.oracle.com/apps/otm/transmission/v6.4' xmlns:gtm='http://xmlns.oracle.com/apps/gtm/transmission/v6.4'>";
                $otmRequest = $otmRequest . "<otm:ObjectModInfo>";
                $otmRequest = $otmRequest . "<otm:InsertDt>";
                $otmRequest = $otmRequest . "<otm:GLogDate>" . $currentDate . "</otm:GLogDate>";
                $otmRequest = $otmRequest . "<otm:TZId>UTC</otm:TZId>";
                $otmRequest = $otmRequest . "<otm:TZOffset>+00:00</otm:TZOffset>";
                $otmRequest = $otmRequest . "</otm:InsertDt>";
                $otmRequest = $otmRequest . "</otm:ObjectModInfo>";
                $otmRequest = $otmRequest . "</otm:TransactionHeader>";
                $otmRequest = $otmRequest . "<otm:ActualShipment xmlns:otm='http://xmlns.oracle.com/apps/otm/transmission/v6.4' xmlns:gtm='http://xmlns.oracle.com/apps/gtm/transmission/v6.4'>";
                $otmRequest = $otmRequest . "<otm:Shipment>";
                $otmRequest = $otmRequest . "<otm:ShipmentHeader>";
                $otmRequest = $otmRequest . "<otm:ShipmentGid>";
                $otmRequest = $otmRequest . "<otm:Gid>";
                $otmRequest = $otmRequest . "<otm:DomainName>" . $domainName . "</otm:DomainName>";
                $otmRequest = $otmRequest . "<otm:Xid>" . $shipmentId . "</otm:Xid>";
                $otmRequest = $otmRequest . "</otm:Gid>";
                $otmRequest = $otmRequest . "</otm:ShipmentGid>";
                $otmRequest = $otmRequest . "<otm:ShipmentRefnum>";
                $otmRequest = $otmRequest . "<otm:ShipmentRefnumQualifierGid>";
                $otmRequest = $otmRequest . "<otm:Gid>";
                $otmRequest = $otmRequest . "<otm:DomainName>" . $domainName . "</otm:DomainName>";
                $otmRequest = $otmRequest . "<otm:Xid>DRVLIC_VALIDFROM</otm:Xid>";
                $otmRequest = $otmRequest . "</otm:Gid>";
                $otmRequest = $otmRequest . "</otm:ShipmentRefnumQualifierGid>";
                $otmRequest = $otmRequest . "<otm:ShipmentRefnumValue>" . $fromValid . "</otm:ShipmentRefnumValue>";
                $otmRequest = $otmRequest . "</otm:ShipmentRefnum>";
                $otmRequest = $otmRequest . "<otm:ShipmentRefnum>";
                $otmRequest = $otmRequest . "<otm:ShipmentRefnumQualifierGid>";
                $otmRequest = $otmRequest . "<otm:Gid>";
                $otmRequest = $otmRequest . "<otm:DomainName>" . $domainName . "</otm:DomainName>";
                $otmRequest = $otmRequest . "<otm:Xid>DRVLIC_VALIDTO</otm:Xid>";
                $otmRequest = $otmRequest . "</otm:Gid>";
                $otmRequest = $otmRequest . "</otm:ShipmentRefnumQualifierGid>";
                $otmRequest = $otmRequest . "<otm:ShipmentRefnumValue>" . $toValid . "</otm:ShipmentRefnumValue>";
                $otmRequest = $otmRequest . "</otm:ShipmentRefnum>";
                $otmRequest = $otmRequest . "<otm:TransactionCode>IU</otm:TransactionCode>";
                $otmRequest = $otmRequest . "</otm:ShipmentHeader>";
                $otmRequest = $otmRequest . "</otm:Shipment>";
                $otmRequest = $otmRequest . "</otm:ActualShipment>";
                $otmRequest = $otmRequest . "</GLogXMLElement>";
                $otmRequest = $otmRequest . "</TransmissionBody>";
                $otmRequest = $otmRequest . "</otm:TransmissionHeader>";
                $otmRequest = $otmRequest . "</Transmission>";
                
                $getOtmUserDetails = $this->ci->common->gettblrowdata(["domain" => $domainName,"object"=>'Cloud_Event'], "url, username, password", "int_cred", 0, 0);
    
                $serviceurl = $getOtmUserDetails['url'];
                $userName = $getOtmUserDetails['username'];
                $password = $getOtmUserDetails['password'];
                
                $headers = [
                    'Content-Type: application/xml',
                    'Authorization: Basic ' . base64_encode("$userName:$password"),
                ];
                log_message("error", "userName:" . $userName);
                log_message("error", "password:" . $password);
                log_message("error", "otmRequest:" . $otmRequest);
                log_message("error", "serviceurl:" . $serviceurl);
                log_message("error", "headers:" . json_encode($headers));
                log_message("error", "otmRequest:" . $otmRequest);
                $output = thirdpartyotmservicecurl($serviceurl, $headers, $otmRequest);
                log_message('error', "response: " . json_encode($output));
                return $output;
            }

            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            log_message("error","otmResponse:".$otmResponse);
        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
        } 
        return $otmResponse;
    }
}
