<?php

class StandardTripInboundService
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->helper('Log');
        $this->ci->load->model(['common', 'Standardbookingmodel', 'carriercommonmodel', 'order', 'apis/StandardTripInboundModel']);
        $this->ci->load->library(['Altovaordercreation', 'knlogin', 'apis/FlipkartEDIServices', '/Standardtriphandler']);
    }

    public function insertTripXmlData(array $data): array
    {
        $tripOrderDetails = $data['SVKEDITripBody']['TripDetails']['TripOrderDetails'] ?? [];
        $tripHeader = $data['SVKEDITripHeader'];
        $sourceApp  = !empty($tripHeader['SourceApp']) ? $tripHeader['SourceApp'] : "";
        if (empty($sourceApp))
        {
            log_error('Standard Trip Create :  Source Not Exists ');
            return ["status" => 1, "message" => ' Source Not Exists '];
        }
        $clientIdentifier  = !empty($tripHeader['ClientIdentifier']) ? $tripHeader['ClientIdentifier'] : "";
        if (empty($clientIdentifier))
        {
            log_error('Standard Trip Create :  Client Identifier must not be Empty');
            return ["status" => 1, "message" => ' Client Identifier must not be Empty'];
        }
        $carrierIdentifier = !empty($tripHeader['CarrierIdentifier']) ? $tripHeader['CarrierIdentifier'] : "";
        
        $tripDetails       = !empty($data['SVKEDITripBody']['TripDetails']) ? $data['SVKEDITripBody']['TripDetails'] : [];
        $tripDetailsHeader = !empty($tripDetails['TripHeader']) ? $tripDetails['TripHeader'] : [];

        $carrierDetails = !empty($tripDetailsHeader['CarrierDetails']) ? $tripDetailsHeader['CarrierDetails'] : [];
        $carrierIdData      = !empty($carrierDetails['ID']) ? $carrierDetails['ID'] : "";
        
        $carrierData = [];
        if (! empty($carrierIdData) || ! empty($carrierIdentifier)) {
            $carrierId = !empty($carrierIdentifier) ? $carrierIdentifier : $carrierIdData;
            $carrierId = $this->ci->StandardTripInboundModel->getPartyUsersAPIData      (
                'Carrier',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $carrierId
            );
           //log_message("error","carrierId:".$carrierId);
            if (! empty($carrierId)) {
                $carrierData = $this->ci->Standardbookingmodel->checkPartyType($carrierId);
                $data['SVKEDITripBody']['SVKOrgDetails']['Companycode']= $carrierData['company_code'];
                $data['SVKEDITripBody']['SVKOrgDetails']['Branchcode']=$carrierData['branch_code'];
                $data['SVKEDITripBody']['SVKOrgDetails']['UserId']=$carrierData['user_id'];
               //log_message("error","carrierData:".json_encode($carrierData));
                if (empty($carrierData)) {
                    log_error('Standard Trip Create :  Invalid Carrier ' . $carrierData);
                    return ["status" => 1, "message" => ' Invalid Carrier ' . $carrierData];
                } else {
                    $tripDetailsHeader['CarrierDetails']['ID'] = $carrierData['code'];
                    $tripDetailsHeader['CarrierDetails']['Address'] = [
                        'CompanyName' => $carrierData['name'],
                        'Address1'    => $carrierData['address'],
                        'Street'      => $carrierData['street'],
                        'City'        => $carrierData['location_id'],
                        'State'       => $carrierData['state'],
                        'Postal'      => $carrierData['pincode'],
                        'Country'     => $carrierData['country'],
                        'Latitude'    => $carrierData['latitude'],
                        'Longitude'   => $carrierData['longitude'],
                        'ContactInfo' => [
                            'ContactNo'    => $carrierData['mobile'],
                            'EmailAddress' => $carrierData['email'],
                        ],
                    ];
                    
                    $tripOrderDetails['InvolvedParties'][] = [
                        'PartyType' => [
                            'Type'   => 'CARRIER',
                            'ID'     => $carrierData['code'],
                            'Company'=> [
                                'Name'              => $carrierData['name'],
                                'RegistrationNumber'=> $carrierData['code'],
                            ],
                            'Address'=> [
                                'CompanyName' => $carrierData['name'],
                                'Address1'    => $carrierData['address'],
                                'Street'      => $carrierData['street'],
                                'City'        => $carrierData['location_id'],
                                'State'       => $carrierData['state'],
                                'Postal'      => $carrierData['pincode'],
                                'Country'     => $carrierData['country'],
                                'Latitude'    => $carrierData['latitude'],
                                'Longitude'   => $carrierData['longitude'],
                                'ContactInfo' => [
                                    'ContactNo'    => $carrierData['mobile'],
                                    'EmailAddress' => $carrierData['email'],
                                ],
                            ],
                        ]
                    ];
                }
            }
            else
            {
                log_error('Standard Trip Create :  Carrier Not Exists ' . $carrierId);
                return ["status" => 1, "message" => ' Carrier Not Exists ' . $carrierId];
            }
        }
        else
        {
            log_error('Standard Trip Create :  Carrier must not be Empty');
            return ["status" => 1, "message" => ' Carrier must not be Empty'];
        }
       //log_message("error","tripDetailsHeader['CarrierDetails']:".json_encode($tripDetailsHeader['CarrierDetails']));
        /*$pickupData  = [];
        $tripLocationDetails = $tripDetailsHeader['TripLocation'];
        $tripStartLocationDetails = $tripLocationDetails['TripStartLocation'];
        $pickupId = (empty($tripStartLocationDetails['ID']) ? "" : $tripStartLocationDetails['ID']);
        if (! empty($pickupId)) {
            $pickupId = $this->ci->StandardTripInboundModel->getPartyUsersAPIData   (
                'Pickup',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $pickupId
            );
            if (! empty($pickupId)) {
                $pickupData = $this->ci->Standardbookingmodel->checkPartyType($pickupId);
                log_message("error","Qry:".$this->ci->db->last_query());
                if (empty($pickupData)) {
                    log_error('Standard Trip Create :  Invalid Pick Up ' . $pickupData);
                    return ["status" => 1, "message" => ' Invalid Pick Up ' . $pickupData];
                } else {
                    $tripStartLocationDetails['ID']      = $pickupData['code'];
                    $tripStartLocationDetails['Address'] = [
                        'CompanyName' => $pickupData['name'],
                        'Address1'    => $pickupData['address'],
                        'Street'      => $pickupData['street'],
                        'City'        => $pickupData['location_id'],
                        'State'       => $pickupData['state'],
                        'Postal'      => $pickupData['pincode'],
                        'Country'     => $pickupData['country'],
                        'ContactInfo' => [
                            'ContactNo'    => $pickupData['mobile'],
                            'EmailAddress' => $pickupData['email'],
                        ],
                    ];
                    
                    $tripOrderDetails['InvolvedParties'][] = [
                        'PartyType' => [
                            'Type'   => 'PICKUP',
                            'ID'     => $pickupData['code'],
                            'Company'=> [
                                'Name'              => $pickupData['name'],
                                'RegistrationNumber'=> $pickupData['code'],
                            ],
                            'Address'=> [
                                'CompanyName' => $pickupData['name'],
                                'Address1'    => $pickupData['address'],
                                'Street'      => $pickupData['street'],
                                'City'        => $pickupData['location_id'],
                                'State'       => $pickupData['state'],
                                'Postal'      => $pickupData['pincode'],
                                'Country'     => $pickupData['country'],
                                'Latitude'    => $pickupData['latitude'],
                                'Longitude'   => $pickupData['longitude'],
                                'ContactInfo' => [
                                    'ContactNo'    => $pickupData['mobile'],
                                    'EmailAddress' => $pickupData['email'],
                                ],
                            ],
                        ]
                    ];
                }
            }
            else
            {
                log_error('Standard Trip Create :  Pick Up Not Exists ' . $pickupId);
                return ["status" => 1, "message" => ' Pick Up Not Exists ' . $pickupId];
            }
        }
        else
        {
            log_error('Standard Trip Create :  Pick Up Not Exists ' . $pickupId);
            return ["status" => 1, "message" => ' Pick Up Not Exists ' . $pickupId];
        }
        
        $deliveryData  = [];
        $tripEndLocationDetails = $tripLocationDetails['TripEndLocation'];
        $deliveryId = (empty($tripEndLocationDetails['ID']) ? "" : $tripEndLocationDetails['ID']);
        if (! empty($deliveryId)) {
            $deliveryId = $this->ci->StandardTripInboundModel->getPartyUsersAPIData   (
                'Delivery',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $deliveryId
            );
            if (! empty($deliveryId)) {
                $deliveryData = $this->ci->Standardbookingmodel->checkPartyType($deliveryId);
                log_message("error","Qry:".$this->ci->db->last_query());
                if (empty($deliveryData)) {
                    log_error('Standard Trip Create :  Invalid Delivery ' . $deliveryId);
                    return ["status" => 1, "message" => ' Invalid Delivery ' . $deliveryId];
                } else {
                    $tripEndLocationDetails['ID'] = $deliveryData['code'];
                    $tripEndLocationDetails['Address'] = [
                        'CompanyName' => $deliveryData['name'],
                        'Address1'    => $deliveryData['address'],
                        'Street'      => $deliveryData['street'],
                        'City'        => $deliveryData['location_id'],
                        'State'       => $deliveryData['state'],
                        'Postal'      => $deliveryData['pincode'],
                        'Country'     => $deliveryData['country'],
                        'ContactInfo' => [
                            'ContactNo'    => $deliveryData['mobile'],
                            'EmailAddress' => $deliveryData['email'],
                        ],
                    ];
                    
                    $tripOrderDetails['InvolvedParties'][] = [
                        'PartyType' => [
                            'Type'   => 'DELIVERY',
                            'ID'     => $deliveryData['code'],
                            'Company'=> [
                                'Name'              => $deliveryData['name'],
                                'RegistrationNumber'=> $deliveryData['code'],
                            ],
                            'Address'=> [
                                'CompanyName' => $deliveryData['name'],
                                'Address1'    => $deliveryData['address'],
                                'Street'      => $deliveryData['street'],
                                'City'        => $deliveryData['location_id'],
                                'State'       => $deliveryData['state'],
                                'Postal'      => $deliveryData['pincode'],
                                'Country'     => $deliveryData['country'],
                                'Latitude'    => $deliveryData['latitude'],
                                'Longitude'   => $deliveryData['longitude'],
                                'ContactInfo' => [
                                    'ContactNo'    => $deliveryData['mobile'],
                                    'EmailAddress' => $deliveryData['email'],
                                ],
                            ],
                        ]
                    ];
                }
            }
            else
            {
                log_error('Standard Trip Create :  Delivery Not Exists ' . $deliveryId);
                return ["status" => 1, "message" => ' Delivery Not Exists ' . $deliveryId];
            }
        }
        else
        {
            log_error('Standard Trip Create :  Delivery Not Exists ' . $deliveryId);
            return ["status" => 1, "message" => ' Delivery Not Exists ' . $deliveryId];
        }*/
        
        $bookingIds = [];
        // If it's a single object, wrap it into an array
        if (!empty($tripOrderDetails) && ! !empty($tripOrderDetails[0])) {
            $tripOrderDetails = [$tripOrderDetails];
        }
        /*log_message("error","tripOrderDetails['InvolvedParties']:".json_encode($tripOrderDetails));*/
        $orgDetails = $data['SVKEDITripBody']['SVKOrgDetails'];

        foreach ($tripOrderDetails as $tripOrder) {
            //log_message("error","tripOrder:".json_encode($tripOrder));
            $filterData = $this->tripData($tripOrder, $data, $orgDetails);
            if (1 == $filterData['status']) {
                return ["status" => 1, "message" => ' Order Creation Failed ' . $filterData['message']];
            }
            $orgDetails['Companycode']= $carrierData['company_code'];
            $orgDetails['Branchcode']=$carrierData['branch_code'];
            $tripDetailsHeader['TripLocation']['TripStartLocation']['EstimatedDateTime']['From']['DateTime'] = $tripOrder['LocationInfo']['Source']['EstimatedDateTime']['From']['DateTime'];
            $tripDetailsHeader['TripLocation']['TripEndLocation']['EstimatedDateTime']['From']['DateTime'] = $tripOrder['LocationInfo']['Destination']['EstimatedDateTime']['From']['DateTime'];
            
           //log_message("error","filterData['data']:".json_encode($filterData['data']));
            
            $shipperData  = $filterData['data']['sourceInfo'];
            
            $tripDetailsHeader['TripLocation']['TripStartLocation']['ID']      = $shipperData['ID'];
            $tripDetailsHeader['TripLocation']['TripStartLocation']['Address'] = [
                    'CompanyName' => $shipperData['Address']['CompanyName'],
                    'Address1'    => $shipperData['Address']['Address'],
                    'Street'      => $shipperData['Address']['Street'],
                    'City'        => $shipperData['Address']['City'],
                    'State'       => $shipperData['Address']['State'],
                    'Postal'      => $shipperData['Address']['Postal'],
                    'Country'     => $shipperData['Address']['country'],
                    'ContactInfo' => [
                        'ContactNo'    => $shipperData['Address']['ContactInfo']['ContactNo'],
                        'EmailAddress' => $shipperData['Address']['ContactInfo']['EmailAddress'],
                    ],
                ];
                
            $destinationData = $filterData['data']['destinationInfo'];
            
            $tripDetailsHeader['TripLocation']['TripEndLocation']['ID']      = $destinationData['ID'];
            $tripDetailsHeader['TripLocation']['TripEndLocation']['Address'] = [
                    'CompanyName' => $destinationData['Address']['CompanyName'],
                    'Address1'    => $destinationData['Address']['Address'],
                    'Street'      => $destinationData['Address']['Street'],
                    'City'        => $destinationData['Address']['City'],
                    'State'       => $destinationData['Address']['State'],
                    'Postal'      => $destinationData['Address']['Postal'],
                    'Country'     => $destinationData['Address']['country'],
                    'ContactInfo' => [
                        'ContactNo'    => $destinationData['Address']['ContactInfo']['ContactNo'],
                        'EmailAddress' => $destinationData['Address']['ContactInfo']['EmailAddress'],
                    ],
                ];
                
            $cargoSummaryData = $filterData['data']['cargoSummary'];
            
            $volume = $cargoSummaryData['TotalVolume']['Value'] ?? 0;
            $weight = $cargoSummaryData['TotalWeight']['Value'] ?? 0;
            $quantity = $cargoSummaryData['TotalQuantity']['Value'] ?? 0;
            
            $tripDetailsHeader['CargoSummary']['TotalVolume']['Value'] =
                is_array($volume) ? 0 : ($volume === "" ? 0 : $volume);
            
            $tripDetailsHeader['CargoSummary']['TotalWeight']['Value'] =
                is_array($weight) ? 0 : ($weight === "" ? 0 : $weight);
            
            $tripDetailsHeader['CargoSummary']['TotalQuantity']['Value'] =
                is_array($quantity) ? 0 : ($quantity === "" ? 0 : $quantity);
               
            $BookingId    = $this->saveOrderDetails($filterData['data'], $orgDetails);
            $bookingIds[] = $BookingId;
        }
       //log_message("error","tripDetailsHeader:".json_encode($tripDetailsHeader));
        $shipmentId = $this->tripInsertData($tripDetailsHeader, $orgDetails, $bookingIds);

        return ["status" => 1, "message" => ' Shipment Created Successfully: Shipment - ' . $shipmentId];
    }

    public function tripInsertData(array $tripHeader, array $orgDetails, array $booking_id): String
    {
       //log_message("error","tripHeader:".json_encode($tripHeader));
       //log_message("error","orgDetails:".json_encode($orgDetails));
        $carrierCode = "";
        $carrierId   = "";
        $vendor_list = $this->ci->db->select("id, code")->get_where("tb_vendors", ['code' => $tripHeader['CarrierDetails']['ID']]);
       //log_message("error","10:".$this->ci->db->last_query());
        if ($vendor_list->num_rows() > 0) {
            $carrierId   = $vendor_list->row()->id;
            $carrierCode = $vendor_list->row()->code;
        }
        $latequickbook_pickup = $latequickbook_delivery = "";
        $earlyquickbook_pickup   = $tripHeader['TripLocation']['TripStartLocation']['EstimatedDateTime']['From']['DateTime'];
        if($earlyquickbook_pickup!==""){
            $latequickbook_pickup    = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_pickup)));
        }
        $earlyquickbook_delivery = $tripHeader['TripLocation']['TripEndLocation']['EstimatedDateTime']['From']['DateTime'];
        if($earlyquickbook_delivery!==""){
            $latequickbook_delivery  = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_delivery)));
        }

        $company_code = $orgDetails['Companycode'];
        $branch_code  = $orgDetails['Branchcode'];

        if (strlen($company_code) > 2) {
            $firstTwoChars = substr($company_code, 0, 2);
        } else {
            $firstTwoChars = $company_code;
        }

        $user_id = $this->ci->Standardbookingmodel->checkUser($company_code, $branch_code, $firstTwoChars);

        $timeZone  = $this->ci->Standardbookingmodel->getUserTimeZone($user_id);
        $getactual = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $timeZone);
        $logdate   = $getactual['datetime'];
        $cdate     = $logdate;

        $getpickup               = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_pickup, $timeZone);
        $earlyquickbook_pickup   = $getpickup['datetime'];
        $getdelivery             = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_delivery, $timeZone);
        $earlyquickbook_delivery = $getdelivery['datetime'];

        $partyStartName = $tripHeader['TripLocation']['TripStartLocation']['Address']['CompanyName'];
        $partyEndName   = $tripHeader['TripLocation']['TripEndLocation']['Address']['CompanyName'];
        $partyStartPincode = $tripHeader['TripLocation']['TripStartLocation']['Address']['Postal'];
        $partyEndPincode   = $tripHeader['TripLocation']['TripEndLocation']['Address']['Postal'];

        //$checkBusParty = $this->ci->common->gettblrowdata(['name' => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']), "status" => 1, 'company_code' => $company_code, 'branch_code' => $branch_code], "id,party_type_id,party_types,code,name,address,state,country,pincode,latitude,longitude", "tbl_party_master", 0, 0);

        $partyStartNameOrCode = is_array($partyStartName) ? "" : $partyStartName;

        $this->ci->db->group_start()
            ->where('name', $partyStartNameOrCode)
            ->or_where('code', $partyStartNameOrCode)
            ->group_end();
            
        $this->ci->db->where('pincode', $partyStartPincode);

        $checkBusStartParty = $this->ci->common->gettblrowdata(
            [
                "status"       => 1,
                "company_code" => $company_code,
                "branch_code"  => $branch_code,
            ],
            "id,party_type_id,party_types,code,name,address,state,country,pincode,latitude,longitude, location_id",
            "tbl_party_master",
            0,
            0
        );
        if (count($checkBusStartParty) > 0) {
            $businessPartyId  = $checkBusStartParty['id'];
            $pickup_name      = $checkBusStartParty['name'];
            $pickup_street    = $checkBusStartParty['address'] . "," . $checkBusStartParty['street'];
            $pickup_city      = $checkBusStartParty['location_id'];
            $pickup_state     = $checkBusStartParty['state'];
            $pickup_country   = $checkBusStartParty['country'];
            $pickup_pincode   = $checkBusStartParty['pincode'];
            $pickup_latitude  = $checkBusStartParty['latitude'];
            $pickup_longitude = $checkBusStartParty['longitude'];
        }

        $partyEndNameOrCode = is_array($partyEndName) ? "" : $partyEndName;

        $this->ci->db->group_start()
            ->where('name', $partyEndNameOrCode)
            ->or_where('code', $partyEndNameOrCode)
            ->group_end();
            
        $this->ci->db->where('pincode', $partyEndPincode);

        $checkBusEndParty = $this->ci->common->gettblrowdata(
            [
                "status"       => 1,
                "company_code" => $company_code,
                "branch_code"  => $branch_code,
            ],
            "id,party_type_id,party_types,code,name,address,state,country,pincode,latitude,longitude, location_id",
            "tbl_party_master",
            0,
            0
        );
        if (count($checkBusEndParty) > 0) {
            $businessPartyId = $checkBusEndParty['id'];
            $drop_name       = $checkBusEndParty['name'];
            $drop_street     = $checkBusEndParty['address'] . "," . $checkBusEndParty['street'];
            $drop_city       = $checkBusEndParty['location_id'];
            $drop_state      = $checkBusEndParty['state'];
            $drop_country    = $checkBusEndParty['country'];
            $drop_pincode    = $checkBusEndParty['pincode'];
        }

        if ($pickup_latitude != "" && $pickup_longitude != "") {
            $lat1 = $pickup_latitude;
            $lng1 = $pickup_longitude;
        } else {
            $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
            $data = getlatlngsbyplace($add1);
            $lat1 = @$data[0];
            $lng1 = @$data[1];
        }

        $add2     = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
        $dataDrop = getlatlngsbyplace($add2);
        $lat2     = @$dataDrop[0];
        $lng2     = @$dataDrop[1];

        $weight   = $tripHeader['CargoSummary']['TotalWeight']['Value'];
        $volume   = $tripHeader['CargoSummary']['TotalVolume']['Value'];
        $quantity = $tripHeader['CargoSummary']['TotalQuantity']['Value'];

        $popupmodeof_trasnport = "LTL";
        $ids                   = implode(",", $booking_id);
        $customerData          = $this->ci->db->query("SELECT customer_id, external_order_id FROM tb_orders where order_id IN ($ids)  group by customer_id");
        $customerId            = $externalOrderId            = "";
        //log_message("error","14:".$this->ci->db->last_query());
        if ($customerData->num_rows() > 0) {
            $customerId      = $customerData->row()->customer_id;
            $externalOrderId = $customerData->row()->external_order_id;
        }

        $customer_id = $customerId;
        //$bookingIdNew = $booking_id;
        // shift insertion
        $startTime          = date('H:i', strtotime($earlyquickbook_pickup));
        $endTime            = date('H:i', strtotime($earlyquickbook_delivery));
        $year               = date('y');
        $week               = date('W');
        $countCode          = substr($company_code, 0, 2);
        /*$orderNumber        = $externalOrderId;
        $sequenceNumber     = $countCode === 'UK' ? $orderNumber : substr($orderNumber, -6);*/
        $bookingIdVal = "";
        if (!empty($booking_id)) {
            foreach ($booking_id as $orderId) {
                $bookingIdVal = $orderId;
            }
        }
        
        $order_nm = $bookingIdVal;
        $seq_num = substr($order_nm, -6);
       
        $trip['shipmentId'] = "T" . $countCode . $week . $year . $seq_num;

        $driver_id = "";
        $vehId     = "";

        $truckTypeVal = "COURIER";

        $checkVehicle = $this->ci->common->getjointbldata("tb_trucks_data td", "tb_trucktypes t", "td.truck_type = t.id", ['t.trucktype' => $truckTypeVal, 'td.vendor_id' => $carrierId, 'td.status' => 'Active', 't.status' => 'Active'], "td.id,td.register_number,t.trucktype", 0, 0);
       //log_message("error","11:".$this->ci->db->last_query());
        $shiftarr = [
            'user_id'        => $user_id,
            'stime'          => $startTime,
            'etime'          => $endTime,
            'splace'         => $pickup_state,
            'slat'           => $lat1,
            'slng'           => $lng1,
            'eplace'         => $drop_state,
            'elat'           => $lat2,
            'elng'           => $lng2,
            'scity'          => $pickup_state,
            'dcity'          => $drop_state,
            'zone_id'        => 1,
            'empshift_start' => $startTime,
            'empshift_end'   => $endTime,
            'trip_type'      => 0,
            'startdate'      => $earlyquickbook_pickup,
            'enddate'        => $latequickbook_delivery,
            'shipment_name'  => 'Boxes',
            'shipment_id'    => 0,
            'transport_mode' => $popupmodeof_trasnport,
            'customer_id'    => $customer_id,
            'vendor_id'      => $carrierId,
            'vehicle_type'   => $checkVehicle[0]['trucktype'],
            'carrier_type'   => 0,
            'shipmentid'     => $trip['shipmentId'],
            'txnid'          => $trip['shipmentId'],
            'company_code'   => $company_code,
            'branch_code'    => $branch_code,
            'created_on'     => $cdate,
            'status'         => 1,
            'weight'         => $weight,
            'volume'         => $volume,
            'units'          => $quantity,
        ];
        $shiftRowId = $this->ci->common->insertTableData("tb_shifts", $shiftarr);
        //log_message("error","shiftRowId:".$shiftRowId);
        //log_message("error","12:".$this->ci->db->last_query());
        // insering driver,vehicle,vehicletype
        $shiftVehArr = [
            'user_id'         => $user_id,
            'shft_id'         => $shiftRowId,
            'carrier_id'      => $carrierId,
            'vehicle_id'      => $checkVehicle[0]['id'],
            'register_number' => $checkVehicle[0]['register_number'],
            'created_on'      => $cdate,
            'status'          => 1,
        ];
        $shiftVehRowId = $this->ci->common->insertTableData("tb_shft_veh", $shiftVehArr);
        //log_message("error","shiftVehRowId:".$shiftVehRowId);
        //log_message("error","13:".$this->ci->db->last_query());

        $vehId = $checkVehicle[0]['id'];
        if($vehId == ""){
            $vehId = 0;
        }

        //log_message("error","vehId:".$vehId);
        $driverData = $this->ci->db->query("SELECT d.driver_id FROM tbl_assigned_drivers d WHERE d.vehicle_id=$vehId and d.user_id=$user_id AND d.status=1 LIMIT 1");

        //log_message("error","14:".$this->ci->db->last_query());
        if ($driverData && $driverData->num_rows() > 0) {
            $driver_id = $driverData->row()->driver_id;
        }
        //log_message("error","driver_id:".$driver_id);

        $tripArr = [
            'shift_id'   => $shiftRowId,
            'status'     => 1,
            'created_on' => $cdate,
            'plat'       => $lat1,
            'plng'       => $lng1,
            'dlat'       => $lat2,
            'dlng'       => $lng2,
            'stime'      => $earlyquickbook_pickup,
            'etime'      => $latequickbook_delivery,
            'vehicle_id' => $vehId,
            'driver_id'  => $driver_id,
        ];
        $tripRowId = $this->ci->common->insertTableData("tb_trips", $tripArr);

        $getstatusid = $this->ci->db->select("id")->get_where("tb_status_master", ['status_code' => 'SV0100']);
        //log_message("error","15:".$this->ci->db->last_query());
        $status_id = 0;
        if ($getstatusid->num_rows() > 0) {
            $status_id = $getstatusid->row()->id;
        }

        $masterCheck = [
            'UPPER(name)'  => 'CONSIGNEE',
            'user_id'      => $user_id,
            'company_code' => $company_code,
            'branch_code'  => $client_code,
            'status'       => '1',
        ];
        $checkconsignee = $this->ci->common->gettblrowdata($masterCheck, "id", "tbl_party_types", 1, 0);

        if (count($checkconsignee) > 0) {
            $delivery = $checkconsignee['id'];
        }

        $popupcustomer_id = $shipperCode;
        $popuporder_type  = 'LTL';
        

        //log_message("error","tripRowId:".$tripRowId);

        foreach ($booking_id as $orderId) {            
            $order    = $this->ci->order->getOrderDetails($orderId);
            $order_id = $order->id;           
            //$invCarriertype = makeorderinvolvedpartiestype($carrierId, $order_id, "CARRIER", $user_id, $company_code);
            insertOrdersRefFileLineIdentifier(['pickupCity' => $pickup_city, 'pickupState' => $pickup_state, 'pickupCountry' => $pickup_country, 'dropCity' => $drop_city, 'dropState' => $drop_state, 'dropCountry' => $drop_country, 'companyCode' => $company_code, 'branchCode' => $branch_code, 'orderRowId' => $order_id, 'date' => $logdate]);
            $stopPickupAddress = $stopDropAddress = "";

            $stopPickupAddress .= $pickup_street;
            $stopDropAddress .= $drop_street;
            $stopPickupAddress .= ", " . $pickup_name;
            $stopDropAddress .= ", " . $drop_name;
            $stopPickupAddress .= ", " . $pickup_country;
            $stopDropAddress .= ", " . $drop_country;
            $stopPickupAddress .= ", " . $pickup_city;
            $stopDropAddress .= ", " . $drop_city;
            $stopPickupAddress .= ", " . $pickup_pincode;
            $stopDropAddress .= ", " . $drop_pincode;
            $pickshipArr = [
                'stopname'       => $pickup_city,
                'plat'           => $lat1,
                'plng'           => $lng1,
                'stopcity'       => $pickup_city,
                'address'        => $stopPickupAddress,
                'stoptype'       => 'P',
                'stopstatus'     => 0,
                'shipment_id'    => $shiftRowId,
                'ordernumber'    => 1,
                'startdate'      => $earlyquickbook_pickup,
                'enddate'        => $earlyquickbook_delivery,
                'shipmentstopid' => 0,
                'txncode'        => 'NP',
                'status'         => 1,
                'order_id'       => $order_id,
                'created_on'     => $cdate,
            ];

            $DdropshipArr = [
                'stopname'       => $drop_city,
                'plat'           => $lat2,
                'plng'           => $lng2,
                'stopcity'       => $drop_city,
                'address'        => $stopDropAddress,
                'stoptype'       => 'D',
                'stopstatus'     => 0,
                'shipment_id'    => $shiftRowId,
                'ordernumber'    => 2,
                'startdate'      => $earlyquickbook_pickup,
                'enddate'        => $earlyquickbook_delivery,
                'shipmentstopid' => 0,
                'txncode'        => 'NP',
                'status'         => 1,
                'order_id'       => $order_id,
                'created_on'     => $cdate,
            ];
            $insPickupShip = $this->ci->common->insertTableData("tb_shiporder_stops", $pickshipArr);
            $insDropShip   = $this->ci->common->insertTableData("tb_shiporder_stops", $DdropshipArr);
            $upd           = $this->ci->db->where(['order_id' => $orderId])->update("tb_orders", ['order_id' => $orderId, 'created_source' => '22', 'shift_id' => $shiftRowId, 'shipmentid' => $trip['shipmentId'], 'vendor_id' => $carrierId, 'trip_id' => $tripRowId]);

            // employee table update
            $employeearr = [
                'assoc_id '       => $trip['shipmentId'],
                'customer_id'     => $customer_id,
                'plat'            => $lat1,
                'plng'            => $lng1,
                'dlat'            => $lat2,
                'dlng'            => $lng2,
                'pickup_city'     => $pickup_city,
                'drop_city'       => $drop_city,
                'user_id'         => $user_id,
                'shift_id'        => $shiftRowId,
                'vendor_id'       => $carrierId,
                'order_id'        => $order_id,
                'status'          => 1,
                'startdate'       => $earlyquickbook_pickup,
                'enddate'         => $earlyquickbook_delivery,
                'pickup_datetime' => $earlyquickbook_pickup,
                'drop_datetime'   => $earlyquickbook_delivery,
                'pickup'          => $pickup_street,
                'drop'            => $drop_street,
                'ship_type'       => 'P',
                'stop_id'         => $insPickupShip,
                'stop_order'      => 1,
                'address'         => $stopPickupAddress,
                'createdon'       => $cdate,
            ];
            $employeeRowId = $this->ci->common->insertTableData("tb_employee", $employeearr);

            $getStopStatusid = $this->ci->db->select("id")->get_where("tb_stop_status", ['order_id' => $order_id, 'status_id' => $status_id, 'status_code' => 'SV0100']);
            if ($getStopStatusid->num_rows() == 0) {
                $insertedStatus = $this->ci->common->insertTableData("tb_stop_status", ['order_id' => $order_id, 'shipment_id' => $shiftRowId, 'stop_detail_id' => $ship_row_id, 'trip_id' => $tripRowId, 'status_id' => $status_id, 'status_code' => 'SV0100', 'stop_type' => '', 'loc_name' => '', 'comment' => '', 'status' => '1', 'reason' => '', 'createdon' => $cdate]);
            }

            $order_shipper_id   = isset($customer_id) ? $customer_id : "";
            $pickup_address     = $pickup_street . "," . $pickup_city . "," . $pickup_state;
            $shipper_address    = ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id];
            $chk_shipperaddress = $this->ci->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'status' => '1']);
            //("error","16:".$this->ci->db->last_query());
            if ($chk_shipperaddress->num_rows() > 0) {
                $shipperadd_id = $chk_shipperaddress->row()->id;
                $upd_add       = $this->ci->db->where(['id' => $shipperadd_id])->update("tbl_orderparty_address", $shipper_address);
            } else {
                $shipper_address['createdon'] = $cdate;
                $this->ci->db->insert("tbl_orderparty_address", $shipper_address);
                $shipperadd_id = $this->ci->db->insert_id();
            }
            $drop_address        = $drop_street . "," . $drop_city . "," . $drop_state;
            $delivery_address    = ['order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id];
            $chk_deliveryaddress = $this->ci->db->select("id")->get_where("tbl_orderparty_address", ['order_id' => $order_id, 'party_master_id' => $delivery, 'status' => '1']);
            //log_message("error","17:".$this->ci->db->last_query());
            if ($chk_deliveryaddress->num_rows() > 0) {
                $dropadd_id = $chk_deliveryaddress->row()->id;
                $upd_add    = $this->ci->db->where(['id' => $dropadd_id])->update("tbl_orderparty_address", $delivery_address);
            } else {
                $delivery_address['createdon'] = $cdate;
                $this->ci->db->insert("tbl_orderparty_address", $delivery_address);
                $dropadd_id = $this->ci->db->insert_id();
            }

            if (checkAccessConditions("CHECK_STS_REFERENCE_COUNTRIES", $company_code)) {
                $ins_ref     = ['order_id' => $order_id, 'reference_id' => 'STS'];
                $checkSTSRef = $this->ci->common->gettblrowdata($ins_ref, "id", "tb_order_references", 0, 0);
                if (count($checkSTSRef) == 0) {
                    $ins_ref['ref_value'] = "Pending";
                    $this->ci->common->insertTableData("tb_order_references", $ins_ref);
                }
            }
          
        }

        return $trip['shipmentId'];
    }

    public function tripData(array $data, $dataHeader, $dataOrg): array
    {
        /*$tripDetails = !empty($dataHeader['SVKEDITripBody']['TripDetails']) ? $dataHeader['SVKEDITripBody']['TripDetails'] : [];
        $tripDetailsHeader = !empty($tripDetails['TripHeader']) ? $tripDetails['TripHeader'] : [];
        $tripLocationDetails = $tripDetailsHeader['TripLocation'];
        $tripStartLocationDetails = $tripLocationDetails['TripStartLocation'];
        $tripEndLocationDetails = $tripLocationDetails['TripEndLocation'];*/
        $orderInfo = [];
       //log_message("error","dataOrg:".json_encode($dataOrg));
        $orderInfo = $data;
        //$orderInfo['SVKOrgDetails'] = $dataOrg;
       //log_message("error", "orderInfo:" . json_encode($orderInfo));
        $orderHeader = $dataHeader['SVKEDITripHeader'];
        /*$companyCode = $this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'Company Code',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                "DEFAULT"
            );
        $branchCode = $this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'Branch Code',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                "DEFAULT"
            );    
            
        $dataOrg['Companycode'] = $companyCode;
        $dataOrg['Branchcode'] = $branchCode;
        
        */
        
        $sourceApp  = !empty($orderHeader['SourceApp']) ? $orderHeader['SourceApp'] : "";
        $clientIdentifier  = !empty($orderHeader['ClientIdentifier']) ? $orderHeader['ClientIdentifier'] : "";
        $carrierIdentifier = !empty($orderHeader['CarrierIdentifier']) ? $orderHeader['CarrierIdentifier'] : "";

        $customerData = [];
        
        $externalOrderID = (empty($orderInfo['EXTOrderID']) ? "" : $orderInfo['EXTOrderID']);
        if (! empty($externalOrderID)) {
            $shipmentDetails = $this->ci->Standardbookingmodel->getOrderShipment($externalOrderID);
            if (! empty($shipmentDetails)) {
                $shiftId    = $shipmentDetails['shift_id'];
                $shipmentId = $shipmentDetails['shipmentid'];
            }
            if ($shiftId != "" && $shipmentId != "") {
                log_error('Standard Trip Create :  Trip Already Created for Booking ' . $externalOrderID);
                return ["status" => 1, "message" => ' Trip Already Created for Booking ' . $externalOrderID];
            }
        } else {
            return ["status" => 1, "message" => 'External Order ID in the XML: ' . $orderInfo['EXTOrderID']];
        }
        
        $orderType = !empty($orderInfo['OrderType']) ? $orderInfo['OrderType'] : "DEFAULT";
        
       //log_message("error", "orderType: " . $orderType);
        if (! empty($orderType)) {
            $orderType = $this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'Order Type',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $orderType
            );
            $orderInfo['OrderType']=$orderType;
           //log_message("error","Qry1111:".$this->ci->db->last_query());
            if (! empty($orderType)) {
                $orderType = $this->ci->Standardbookingmodel->checkOrderType($orderInfo);
               //log_message("error","Qry2222:".$this->ci->db->last_query());
                if ($orderType == 0) {
                    log_error('Standard Order Create :  Invalid Order Type ' . $orderType);
                    return ["status" => 1, "message" => ' Invalid Order Type ' . $orderType];
                }
            } else {
                return ["status" => 1, "message" => ' Order Type Does not Exist ' . $orderType];
            }
        } else {
            return ["status" => 1, "message" => ' Order Type Does not Exist ' . $orderType];
        }

        $modeOfTransport = !empty($orderInfo['ModeOfTransport']) ? $orderInfo['ModeOfTransport'] : "DEFAULT";

        if (! empty($modeOfTransport)) {
            $modeOfTransport =$this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'ModeOfTransport',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $modeOfTransport
            );
           //log_message("error","Qry:".$this->ci->db->last_query());
            if (! empty($modeOfTransport)) {
                $modeOfTransport = $this->ci->Standardbookingmodel->checkModeOfTransport($modeOfTransport);
               //log_message("error","Qry:".$this->ci->db->last_query());
                if (empty($modeOfTransport)) {
                    return ["status" => 1, "message" => ' Invalid Mode Of Transport ' . $modeOfTransport];
                }
            } else {
                return ["status" => 1, "message" => ' Mode Of Transport Does not Exist' . $modeOfTransport];
            }
        } else {
            return ["status" => 1, "message" => ' Mode Of Transport Does not Exist' . $modeOfTransport];
        }

        $product = !empty($orderInfo['Product']) ? $orderInfo['Product'] : "DEFAULT";

        if (! empty($product)) {
            $product = $this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'Product',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $product
            );
           //log_message("error","Qry:".$this->ci->db->last_query());
            if (! empty($product)) {
                $product = $this->ci->Standardbookingmodel->checkProduct($product);
               //log_message("error","Qry:".$this->ci->db->last_query());
                if (empty($product)) {
                    return ["status" => 1, "message" => ' Invalid Product ' . $product];
                }
            } else {
                return ["status" => 1, "message" => ' Product Does not Exist' . $product];
            }
        } else {
            return ["status" => 1, "message" => ' Product Does not Exist' . $product];
        }

        $serviceType = !empty($orderInfo['ServiceType']) ? $orderInfo['ServiceType'] : "DEFAULT";

        if (! empty($serviceType)) {
            $serviceType = $this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'Service Type',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $serviceType
            );
           //log_message("error","Qry:".$this->ci->db->last_query());
            if (! empty($serviceType)) {
                $serviceType = $this->ci->Standardbookingmodel->checkServiceType($serviceType);
               //log_message("error","Qry:".$this->ci->db->last_query());
                if (empty($serviceType)) {
                    return ["status" => 1, "message" => ' Invalid Service Type ' . $serviceType];
                }
            } else {
                return ["status" => 1, "message" => ' Service Type Does not Exist' . $serviceType];
            }
        } else {
            return ["status" => 1, "message" => ' Service Type Does not Exist' . $serviceType];
        }

        $incoTerm = !empty($orderInfo['TermsOfTrade']['Incoterm']) ? $orderInfo['TermsOfTrade']['Incoterm'] : "DEFAULT";

        if (! empty($incoTerm)) {
            $incoTerm = $this->ci->StandardTripInboundModel->getAPIHarmonizationData(
                'Incoterm',
                $sourceApp,
                $clientIdentifier,
                $carrierIdentifier,
                $incoTerm
            );
           //log_message("error","Qry:".$this->ci->db->last_query());
            if (! empty($incoTerm)) {
                /*$incoTerm = $this->ci->Standardbookingmodel->checkIncoterm($incoTerm);
                log_message("error","Qry:".$this->ci->db->last_query());*/
                /*if (empty($incoTerm)) {
                    return ["status" => 1, "message" => ' Invalid Incoterm ' . $incoTerm];
                }*/
            } /*else {
                return ["status" => 1, "message" => ' Incoterm Does not Exist' . $incoTerm];
            }*/
        } /*else {
            return ["status" => 1, "message" => ' Incoterm Does not Exist' . $incoTerm];
        }*/
        
        $customerData  = [];
        $customerName = '';

        if (!empty($orderInfo['CustomerDetails']['Company']['Name'])) {
            $customerName = $orderInfo['CustomerDetails']['Company']['Name'];
        } elseif (!empty($orderInfo['CustomerDetails']['Address']['CompanyName'])) {
            $customerName = $orderInfo['CustomerDetails']['Address']['CompanyName'];
        }
       
        if (!empty($customerName)) {
            $customerId = $this->ci->StandardTripInboundModel->getPartyData($orderInfo['CustomerDetails'], 'Customer', $dataOrg['Companycode'], $dataOrg['Branchcode'], $dataOrg['UserId']);
            $customerData = $this->ci->Standardbookingmodel->checkPartyType($customerId);
            $orderInfo['CustomerDetails']['ID'] = $customerData['code'];
                $orderInfo['CustomerDetails']['Company'] = [
                    'Name' => $customerData['name'],
                    'RegistrationNumber' => $customerData['code'],
                ];
                $orderInfo['CustomerDetails']['Address'] = [
                    'CompanyName' => $customerData['name'],
                    'Address1'    => $customerData['address'],
                    'Street'      => $customerData['street'],
                    'City'        => $customerData['location_id'],
                    'State'       => $customerData['state'],
                    'Postal'      => $customerData['pincode'],
                    'Country'     => $customerData['country'],
                    'Latitude'    => $customerData['latitude'],
                    'Longitude'   => $customerData['longitude'],
                    'ContactInfo' => [
                        'ContactNo'    => $customerData['mobile'],
                        'EmailAddress' => $customerData['email'],
                    ],
                ];
                
                $orderInfo['InvolvedParties'][] = [
                    'PartyType' => [
                        'Type'   => 'Customer',
                        'ID'     => $customerData['code'],
                        'Company'=> [
                        'Name'              => $customerData['name'],
                        'RegistrationNumber'=> $customerData['code'],
                        ],
                        'Address'=> [
                        'CompanyName' => $customerData['name'],
                        'Address1'    => $customerData['address'],
                        'Street'      => $customerData['street'],
                        'City'        => $customerData['location_id'],
                        'State'       => $customerData['state'],
                        'Postal'      => $customerData['pincode'],
                        'Country'     => $customerData['country'],
                        'Latitude'    => $customerData['latitude'],
                        'Longitude'   => $customerData['longitude'],
                        'ContactInfo' => [
                            'ContactNo'    => $customerData['mobile'],
                            'EmailAddress' => $customerData['email'],
                        ],
                    ],
                ]
            ];
        } 
        else {
            return ["status" => 1, "message" => ' Customer Does not Exist33' . $customerId];
        }
        
        $shipperData  = [];
        $shipperName = '';

        if (!empty($orderInfo['LocationInfo']['Source']['Company']['Name'])) {
            $shipperName = $orderInfo['LocationInfo']['Source']['Company']['Name'];
        } elseif (!empty($orderInfo['LocationInfo']['Source']['Address']['CompanyName'])) {
            $shipperName = $orderInfo['LocationInfo']['Source']['Address']['CompanyName'];
        }
        
        if (!empty($shipperName)) {
            $shipperId = $this->ci->StandardTripInboundModel->getPartyData($orderInfo['LocationInfo']['Source'], 'Shipper', $dataOrg['Companycode'], $dataOrg['Branchcode'], $dataOrg['UserId']);
            $shipperData = $this->ci->Standardbookingmodel->checkPartyType($shipperId);
            $orderInfo['LocationInfo']['Source']['ID'] = $shipperData['code'];
                $orderInfo['LocationInfo']['Source']['Company'] = [
                    'Name' => $shipperData['name'],
                    'RegistrationNumber' => $shipperData['code'],
                ];
                $orderInfo['LocationInfo']['Source']['Address'] = [
                    'CompanyName' => $shipperData['name'],
                    'Address1'    => $shipperData['address'],
                    'Street'      => $shipperData['street'],
                    'City'        => $shipperData['location_id'],
                    'State'       => $shipperData['state'],
                    'Postal'      => $shipperData['pincode'],
                    'Country'     => $shipperData['country'],
                    'Latitude'    => $shipperData['latitude'],
                    'Longitude'   => $shipperData['longitude'],
                    'ContactInfo' => [
                        'ContactNo'    => $shipperData['mobile'],
                        'EmailAddress' => $shipperData['email'],
                    ],
                ];
                
                $orderInfo['InvolvedParties'][] = [
                    'PartyType' => [
                        'Type'   => 'SHIPPER',
                        'ID'     => $shipperData['code'],
                        'Company'=> [
                        'Name'              => $shipperData['name'],
                        'RegistrationNumber'=> $shipperData['code'],
                        ],
                        'Address'=> [
                        'CompanyName' => $shipperData['name'],
                        'Address1'    => $shipperData['address'],
                        'Street'      => $shipperData['street'],
                        'City'        => $shipperData['location_id'],
                        'State'       => $shipperData['state'],
                        'Postal'      => $shipperData['pincode'],
                        'Country'     => $shipperData['country'],
                        'Latitude'    => $shipperData['latitude'],
                        'Longitude'   => $shipperData['longitude'],
                        'ContactInfo' => [
                            'ContactNo'    => $shipperData['mobile'],
                            'EmailAddress' => $shipperData['email'],
                        ],
                    ],
                ]
            ];
        } 
        else {
            return ["status" => 1, "message" => ' Source Does not Exist' . $shipperId];
        }
        
        $destinationData  = [];
        $destinationName = '';

        if (!empty($orderInfo['LocationInfo']['Destination']['Company']['Name'])) {
            $destinationName = $orderInfo['LocationInfo']['Destination']['Company']['Name'];
        } elseif (!empty($orderInfo['LocationInfo']['Destination']['Address']['CompanyName'])) {
            $destinationName = $orderInfo['LocationInfo']['Destination']['Address']['CompanyName'];
        }
        if (!empty($destinationName)) {
            $destinationId = $this->ci->StandardTripInboundModel->getPartyData($orderInfo['LocationInfo']['Destination'], 'Consignee', $dataOrg['Companycode'], $dataOrg['Branchcode'], $dataOrg['UserId']);
            $destinationData = $this->ci->Standardbookingmodel->checkPartyType($destinationId);
            $orderInfo['LocationInfo']['Destination']['ID'] = $destinationData['code'];
                $orderInfo['LocationInfo']['Destination']['Company'] = [
                    'Name' => $destinationData['name'],
                    'RegistrationNumber' => $destinationData['code'],
                ];
                $orderInfo['LocationInfo']['Destination']['Address'] = [
                    'CompanyName' => $destinationData['name'],
                    'Address1'    => $destinationData['address'],
                    'Street'      => $destinationData['street'],
                    'City'        => $destinationData['location_id'],
                    'State'       => $destinationData['state'],
                    'Postal'      => $destinationData['pincode'],
                    'Country'     => $destinationData['country'],
                    'Latitude'    => $destinationData['latitude'],
                    'Longitude'   => $destinationData['longitude'],
                    'ContactInfo' => [
                        'ContactNo'    => $destinationData['mobile'],
                        'EmailAddress' => $destinationData['email'],
                    ],
                ];
                
                $orderInfo['InvolvedParties'][] = [
                    'PartyType' => [
                        'Type'   => 'CONSIGNEE',
                        'ID'     => $destinationData['code'],
                        'Company'=> [
                        'Name'              => $destinationData['name'],
                        'RegistrationNumber'=> $destinationData['code'],
                        ],
                        'Address'=> [
                        'CompanyName' => $destinationData['name'],
                        'Address1'    => $destinationData['address'],
                        'Street'      => $destinationData['street'],
                        'City'        => $destinationData['location_id'],
                        'State'       => $destinationData['state'],
                        'Postal'      => $destinationData['pincode'],
                        'Country'     => $destinationData['country'],
                        'Latitude'    => $destinationData['latitude'],
                        'Longitude'   => $destinationData['longitude'],
                        'ContactInfo' => [
                            'ContactNo'    => $destinationData['mobile'],
                            'EmailAddress' => $destinationData['email'],
                        ],
                    ],
                ]
            ];
        } 
        else {
            return ["status" => 1, "message" => ' Destination Does not Exist' . $destinationId];
        }
        
        $units = $orderInfo['CargoDetails']['TransportHandlingUnit'] ?? [];

        // Normalize to always be an array of units
        if (!empty($units) && isset($units['CargoType'])) {
            $units = [$units];
        }
        
        if (!empty($units)) {
        
            foreach ($units as $key => $cargo) {
        
                $cargoType = $cargo['CargoType'] ?? "";
        
                if (empty($cargoType)) {
                    return ["status" => 1, "message" => 'Cargo Type Does not Exist: ' . $cargoType];
                }
        
                $cargoTypeData = $this->ci->StandardTripInboundModel->getCargoAPIData(
                    $sourceApp,
                    $clientIdentifier,
                    $carrierIdentifier,
                    $cargoType
                );
        
               //log_message("error", "Qry: " . $this->ci->db->last_query());
        
                if (empty($cargoTypeData)) {
                    return ["status" => 1, "message" => 'Cargo Type Does not Exist: ' . $cargoType];
                }
        
                // ðŸ”¥ This actually saves the updated CargoType
                $units[$key]['CargoType'] = $cargoTypeData;
            }
        
            // ðŸ”¥ Overwrite original data with updated version
            $orderInfo['CargoDetails']['TransportHandlingUnit'] = $units;
        }
        
        
        
        /*if (! empty($orderInfo['ManageReferences']['References'])) {
            foreach ($orderInfo['ManageReferences']['References'] as $key => $reference) {
                $referenceType = $reference['RefType']['Code'];
                if (! empty($referenceType)) {
                    $referenceType = $this->ci->StandardTripInboundModel->getReferenceAPIData   (
                        $sourceApp,
                        $clientIdentifier,
                        $carrierIdentifier,
                        $referenceType
                    );
                    log_message("error","Qry:".$this->ci->db->last_query());
                    if (empty($referenceType)) {
                        return ["status" => 1, "message" => ' Reference Does not Exist' . $referenceType];
                    }
                    else
                    {
                        $reference['RefType']['Code'] = $referenceType;
                    }
                } else {
                    return ["status" => 1, "message" => ' Reference Does not Exist ' . $referenceType];
                }
            }
        }*/

        $orderData = [
            'EXTOrderID'         => $externalOrderID,
            'OrderID'            => (empty($orderInfo['OrderID']) ? $externalOrderID : $orderInfo['OrderID']),
            'OrderType'          => $orderType,
            'ModeOfTransport'    => $modeOfTransport,
            'Product'            => $product,
            'ServiceType'        => $serviceType,
            'TypeOfBusiness'     => (empty($orderInfo['TypeOfBusiness']) ? "0" : $orderInfo['TypeOfBusiness']),
            'Incoterm'           => $incoTerm,
            'FreightTerm'        => (empty($orderInfo['TermsOfTrade']['FreightName']['Term']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Term']),
            'FreightTermName'    => (empty($orderInfo['TermsOfTrade']['FreightName']['Name']) ? "" : $orderInfo['TermsOfTrade']['FreightName']['Name']),
            'company_code'       => (empty($dataOrg['Companycode']) ? "" : $dataOrg['Companycode']),
            'branch_code'        => (empty($dataOrg['Branchcode']) ? "" : $dataOrg['Branchcode']),
            'department_code'    => (empty($dataOrg['Departmentcode']) ? "" : $dataOrg['Departmentcode']),
            'physicalReceiver'   => (empty($dataOrg['PhysicalReceiver']) ? "" : $dataOrg['PhysicalReceiver']),
            'logicalReceiver'    => (empty($dataOrg['LogicalReceiver']) ? "" : $dataOrg['LogicalReceiver']),
            'physicalSender'     => (empty($dataOrg['PhysicalSender']) ? "" : $dataOrg['PhysicalSender']),
            'logicalSender'      => (empty($dataOrg['LogicalSender']) ? "" : $dataOrg['LogicalSender']),
            'customerDetails'    => $orderInfo['CustomerDetails'],
            'sourceInfo'         => $orderInfo['LocationInfo']['Source'],
            'destinationInfo'    => $orderInfo['LocationInfo']['Destination'],
            'cargoSummary'       => $orderInfo['CargoSummary'],
            'cargoDetails'       => $orderInfo['CargoDetails'],
            'valueAddedServices' => $orderInfo['ValueAddedServices'],
            'involvedParties'    => $orderInfo['InvolvedParties'],
            'manageReferences'   => $orderInfo['ManageReferences'],
            'remarks'            => $orderInfo['Remarks'],
            'header'             => $orderHeader,
        ];
        log_message("error","orderData:".json_encode($orderData));
        return ["status" => 0, "data" => $orderData];
    }

    public function saveOrderDetails(array $orderData, array $orgDetails): string
    {
       //log_message("error","orgDetails:".json_encode($orgDetails));

        $booking_id = '';
        //$cdate           = date('Y-m-d H:i:s');
        $company_code = $orgDetails['Companycode'];
        $branch_code  = $orgDetails['Branchcode'];

        if (strlen($company_code) > 2) {
            $firstTwoChars = substr($company_code, 0, 2);
        } else {
            $firstTwoChars = $company_code;
        }

        $user_id = $this->ci->Standardbookingmodel->checkUser($company_code, $branch_code, $firstTwoChars);

        $timeZone     = $this->ci->Standardbookingmodel->getUserTimeZone($user_id);
        $getactual    = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $timeZone);
        $logdate      = $getactual['datetime'];
        $cdate        = $logdate;
        $company_code = $orgDetails['Companycode'];
        $branch_code  = $orgDetails['Branchcode'];
        /*$logicalReceiver = $orgDetails['logicalReceiver'];
        if ($logicalReceiver != "" && $company_code == "") {
            $checkBranchCompanyCodes = $this->ci->Standardbookingmodel->getBranchCompanyCodes($logicalReceiver);
            if (! empty($checkBranchCompanyCodes)) {
                $company_code = $checkBranchCompanyCodes['company_code'];
                $branch_code  = $checkBranchCompanyCodes['branch_code'];
            }
        }*/
        if (strlen($company_code) > 2) {
            $firstTwoChars = substr($company_code, 0, 2);
        } else {
            $firstTwoChars = $company_code;
        }
        $user_id = $this->ci->Standardbookingmodel->checkUser($company_code, $branch_code, $firstTwoChars);

        $customerInfo    = $this->checkPartyDetails($orderData['customerDetails'], $company_code, $branch_code, $user_id, "Customer");
        $sourceInfo      = $this->checkPartyDetails($orderData['sourceInfo'], $company_code, $branch_code, $user_id, "Shipper");
        $destinationInfo = $this->checkPartyDetails($orderData['destinationInfo'], $company_code, $branch_code, $user_id, "Consignee");

        $ship_row_id = $this->insertShipmentData($orderData, $company_code, $branch_code);
        $timeZone    = $this->ci->Standardbookingmodel->getUserTimeZone($user_id);

        $order_id       = $this->ci->Standardbookingmodel->insertOrder($orderData, $customerInfo, $sourceInfo, $destinationInfo, $ship_row_id, $timeZone, $company_code, $branch_code, $user_id);
        $checkBookingId = $this->ci->common->gettblrowdata(['id' => $order_id], "order_id", "tb_orders", 0, 0);
        //log_message("error", "checkBookingId" . $this->ci->db->last_query());
        if (! empty($checkBookingId)) {
            $booking_id = $checkBookingId['order_id'];
        }
        $orderDetails = [
            'shipper_id'      => $ship_row_id,
            'service'         => is_array($orderData['ServiceType']) ? "" : $orderData['ServiceType'],
            'delivery_term'   => is_array($orderData['FreightTerm']) ? "" : $orderData['FreightTerm'],
            'incoterm'        => is_array($orderData['Incoterm']) ? "" : $orderData['Incoterm'],
            'notify_party'    => "",
            'department_code' => is_array($orderData['department_code']) ? "" : $orderData['department_code'],
            'createdon'       => $cdate,
            'order_row_id'    => $order_id,
            'order_id'        => $booking_id,
            'order_type'      => is_array($orderData['OrderType']) ? "" : $orderData['OrderType'],
        ];
        //log_message("error","booking_id:".$booking_id);
        $orderDetailsCount = $this->ci->Standardbookingmodel->checkOrderDetails($order_id, $booking_id);
        if ($orderDetailsCount > 0) {
            $this->ci->db->where(["order_row_id" => $order_id])->update("tb_order_details", $orderDetails);
        } else {
            $this->ci->db->insert('tb_order_details', $orderDetails);
        }
        if (! empty($orderData['cargoDetails']['TransportHandlingUnit'])) {
            $this->ci->db->where(["order_id" => $order_id])->update("tb_order_cargodetails", ['status' => 0]);
        }
        $totalGoodValue = 0.0;
        if (array_key_exists("0", $orderData['cargoDetails']['TransportHandlingUnit']) == 1) {
            foreach ($orderData['cargoDetails']['TransportHandlingUnit'] as $orderCargo) {
                $this->ci->Standardbookingmodel->insertCargoInfo($orderCargo, $order_id, $user_id);
                $valueOfGoods = is_array($orderCargo['ValueOfGoods']) ? "0.00" : $orderCargo['ValueOfGoods'];
                $totalGoodValue += $valueOfGoods;
            }
        } else {
            $this->ci->Standardbookingmodel->insertCargoInfo($orderData['cargoDetails']['TransportHandlingUnit'], $order_id, $user_id);
            $valueOfGoods = is_array($orderData['cargoDetails']['TransportHandlingUnit']['ValueOfGoods']) ? "0.00" : $orderData['cargoDetails']['TransportHandlingUnit']['ValueOfGoods'];
            $totalGoodValue += $valueOfGoods;
        }

        $getCurrency = $this->ci->db->query(
            "SELECT c.currency, c.cntry_hrs,c.cntry_timezone
            FROM tbl_country_master AS c, tb_users AS u
            WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
            LIMIT 1",
            [$user_id]
        );
        if ($getCurrency && $getCurrency->num_rows() > 0) {
            $currency = $getCurrency->row()->currency;
        }
        $this->ci->db->where(['id' => $order_id])->update("tb_orders", ['goods_value' => $totalGoodValue, 'currency' => $currency]);
        if (! empty($orderData['valueAddedServices'])) {
            if (array_key_exists("0", $orderData['valueAddedServices']['Addon']) == 1) {
                foreach ($orderData['valueAddedServices']['Addon'] as $valueAddedServices) {
                    $this->ci->Standardbookingmodel->insertValueAddedServices($valueAddedServices, $order_id, $user_id);
                }
            } else {
                $this->ci->Standardbookingmodel->insertValueAddedServices($orderData['valueAddedServices']['Addon'], $order_id, $user_id);
            }
        }
        
        $parties = $orderData['involvedParties'] ?? [];

        // If single record → wrap into array
        if (!empty($parties) && isset($parties['PartyType'])) {
            $parties = [$parties];
        }
        
        foreach ($parties as $item) {
        
            $party = $item['PartyType'] ?? null;
        
            if (!$party) {
                log_message("error", "Missing PartyType: " . json_encode($item));
                continue;
            }
        
            $party_type_id = $this->ci->Standardbookingmodel->getPartyTypeId(
                $company_code,
                $branch_code,
                $party['Type']
            );
        
            $partyInfo = $this->checkPartyDetails(
                $party,
                $company_code,
                $branch_code,
                $user_id,
                $party['Type']
            );
        
            $orderParty = [
                'order_id'     => $order_id,
                'order_number' => $booking_id,
                'party_id'     => $partyInfo['party_id'],
                'party_type'   => $party_type_id,
                'status'       => 1,
            ];
        
           //log_message("error", "orderParty::" . json_encode($orderParty));
        
            $this->ci->Standardbookingmodel->insertOrderParties($orderParty);
        }
        
        if (! empty($orderData['ManageReferences'])) {
            if (array_key_exists("0", $orderData['ManageReferences']['References']) == 1) {
                foreach ($orderData['ManageReferences']['References'] as $orderRef) {
                    $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $orderRef);
                }
            } else {
                $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $orderData['ManageReferences']['References']);
            }
        } else {
            $orderData['ManageReferences']['References']['RefType']['Code'] = "EXTID";
            $orderData['ManageReferences']['References']['RefType']['Value'] = $orderData['EXTOrderID'];
            $this->ci->Standardbookingmodel->insertOrderReferences($order_id, $orderData['ManageReferences']['References']);
        }
        
        return $booking_id;
    }

    private function insertShipmentData(
        array $orderData,
        string $company_code,
        string $branch_code
    ): int {
        $cdate = date('Y-m-d H:i:s');
        if (! empty($orderData['OrderID'])) {
            $shipment_id = $orderData['OrderID'];
        } else {
            $shipment_id = "SVK" . time();
        }
        $transportmodeid  = $transportmodename  = "";
        $gettrasnportmode = $this->ci->Standardbookingmodel->getTransportModeName($orderData['ModeOfTransport']);
        if (! empty($gettrasnportmode)) {
            $transportmodeid   = $gettrasnportmode['id'];
            $transportmodename = $gettrasnportmode['name'];
        }
        $incoterm        = empty($orderData['Incoterm']) ?? "";
        $freightTerm     = empty($orderData['FreightTerm']) ?? "60";
        $freightTermName = empty($orderData['FreightTermName']) ?? "Free of Charge";
        $enddate         = date('Y-m-d H:i:s', strtotime("+1 day"));
        $ship_arr        = [
            'shipid'           => $shipment_id,
            'txnid'            => $shipment_id,
            'trucktype'        => $transportmodename,
            'pickupcnt'        => '1',
            'dropcnt'          => '1',
            'unitspec'         => 1,
            'insertusr'        => "",
            'carrier'          => '0',
            'insertuserdate'   => $cdate,
            'enddate'          => $enddate,
            'insdate'          => $cdate,
            'upddate'          => $cdate,
            'reason'           => 'SHIPMENT',
            'purpose'          => 'SEND INTEGRATION',
            'ship_object'      => 'SHIPMENT',
            'logdate'          => $cdate,
            'transport_mode'   => $orderData['ModeOfTransport'],
            'domainname'       => $branch_code,
            'company_code'     => $company_code,
            'branch_code'      => $branch_code,
            'product'          => $orderData['Product'],
            'freight_term'     => $freightTerm,
            'freight_termname' => $freightTermName,
            'incoterm'         => $incoterm,
            'modeoftransport'  => $transportmodeid,
        ];
        $checkShipid = $this->ci->common->gettblrowdata(['shipid' => $shipment_id], "id", "tb_shipments", 0, 0);
        if (! empty($checkShipid)) {
            $this->ci->db->where(['id' => $checkShipid['id']])->update("tb_shipments", $ship_arr);
            $ship_row_id = $checkShipid['id'];
        } else {
            $ship_arr['createdon'] = $cdate;
            $ship_ins              = $this->ci->db->insert("tb_shipments", $ship_arr);
            $ship_row_id           = $this->ci->db->insert_id();
        }
        return $ship_row_id;
    }

    public function checkPartyDetails(
        array $partyData,
        string $company_code,
        string $branch_code,
        int $user_id,
        string $partyDataType
    ): array {
        $curdt         = date("Y-m-d H:i:s");
        $party_type_id = $this->ci->Standardbookingmodel->getPartyTypeId($company_code, $branch_code, $partyDataType);
       //log_message("error","PartyDataDat:".json_encode($partyData));
        $party_code    = is_array($partyData['ID']) ? "" : $partyData['ID'];
        $partyWhere    = ["code" => $party_code];
        $customer_id   = 0;
        $address       = $partyData['Address']['Address1'];
        
        if ('' !== (is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street'])) {
            $address .= ", " . (is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street']);
        }
        if ('' !== (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City'])) {
            $address .= ", " . (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City']);
        }
        if ('' !== (is_array($partyData['Address']['State']) ? "" : $partyData['Address']['State'])) {
            $address .= ", " . (is_array($partyData['Address']['State']) ? "" : $partyData['Address']['State']);
        }
        if ('' !== (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal'])) {
            $address .= ", " . (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal']);
        }
        if ('' !== (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country'])) {
            $address .= ", " . (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country']);
        }
        $latitude  = empty($partyData['Address']['Latitude']) ?? "";
        $longitude = empty($partyData['Address']['Longitude']) ?? "";

        if ($latitude == "" && $longitude == "") {
            $data      = getlatlngsbyplace($address);
            $latitude  = @$data[0];
            $longitude = @$data[1];
        }
        
        $customerIdentifier      = "";
        $customerIdentifierExist = $this->ci->Standardbookingmodel->checkPartyType($party_code);
        //log_message("error","Qry:".$this->ci->db->last_query());
        if (! empty($customerIdentifierExist)) {
            //log_message("error","Name::".$pickupData['name']);
            $customerIdentifier = $$customerIdentifierExist['customer_identifier'];
        }

        $businessPartydata = [
            'name'               => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']),
            'email'              => empty($partyData['Address']['ContactNo']['EmailAddress']) ? "" : $partyData['Address']['ContactNo']['EmailAddress'],
            'location_id'        => (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City']),
            'street'             => (is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street']),
            'state'              => (is_array($partyData['Address']['State']) ? "" : $partyData['Address']['State']),
            'address'            => $address,
            'pincode'            => (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal']),
            'country'            => (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country']),
            'user_id'            => $user_id,
            'customeridentifier' => empty($customerIdentifier) ? $party_type_id : $customerIdentifier,
            'partyindetifier'    => $party_type_id,
            'company_code'       => $company_code,
            'branch_code'        => $branch_code,
            'status'             => 1,
            'updated_on'         => $curdt,
        ];
        $timeZone = $this->ci->carriercommonmodel->getOrderUserTimeZone($user_id);

        $partyWhere['company_code'] = $company_code;
        $partyWhere['status']       = 1;
        if ($party_code != "") {
            $checkBusParty = $this->ci->common->gettblrowdata($partyWhere, "id,party_type_id,party_types", "tbl_party_master", 0, 0);
            if (count($checkBusParty) > 0) {
                $businessPartyId  = $checkBusParty['id'];
                $busparty_type_id = $checkBusParty['party_type_id'];
                $busparty_types   = $checkBusParty['party_types'] ?? "";
                $party_types      = explode(',', $busparty_types);
                if (! in_array($party_type_id, $party_types)) {
                    array_push($party_types, $party_type_id);
                }
                $businessPartydata["party_types"] = implode(",", $party_types);

                $this->ci->common->updatetbledata("tbl_party_master", $businessPartydata, ["id" => $businessPartyId]);
            } else {
                $pwd                                = password_hash($party_type_id, PASSWORD_DEFAULT);
                $businessPartydata["party_type_id"] = $party_type_id;
                $businessPartydata["party_types"]   = $party_type_id;
                $businessPartydata["password"]      = $pwd;
                $businessPartydata["created_on"]    = $curdt;
                $checkBusParty                      = $this->ci->common->gettblrowdata(['name' => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']), "status" => 1, 'company_code' => $company_code, 'branch_code' => $branch_code], "id,party_type_id,party_types,code", "tbl_party_master", 0, 0);

                if (count($checkBusParty) > 0) {
                    $businessPartyId = $checkBusParty['id'];

                    $this->ci->common->updatetbledata("tbl_party_master", $businessPartydata, ['id' => $businessPartyId]);
                    if ($checkBusParty['code'] == "") {
                        $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                        $partyData['ID'] = $partyCode;
                        $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
                    }
                } else {

                    $businessPartyId = $this->ci->common->insertTableData('tbl_party_master', $businessPartydata);
                    $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                    $partyData['ID'] = $partyCode;
                    $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
                }
            }
        } else {
            $pwd                                = password_hash($party_type_id, PASSWORD_DEFAULT);
            $businessPartydata["party_type_id"] = $party_type_id;
            $businessPartydata["party_types"]   = $party_type_id;
            $businessPartydata["password"]      = $pwd;
            $businessPartydata["created_on"]    = $curdt;
            $checkBusParty                      = $this->ci->common->gettblrowdata(['name' => (is_array($partyData['Company']['Name']) ? "" : $partyData['Company']['Name']), "status" => 1, 'company_code' => $company_code, 'branch_code' => $branch_code], "id,party_type_id,party_types,code", "tbl_party_master", 0, 0);
            if (count($checkBusParty) > 0) {
                $businessPartyId = $checkBusParty['id'];
                $partyData['ID'] = $checkBusParty['code'];

                $this->ci->common->updatetbledata("tbl_party_master", $businessPartydata, ['id' => $businessPartyId]);
                if ($checkBusParty['code'] == "" || $checkBusParty['code'] == 0) {
                    $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                    $partyData['ID'] = $partyCode;
                    $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
                }
            } else {

                $businessPartyId = $this->ci->common->insertTableData('tbl_party_master', $businessPartydata);
                $partyCode       = $timeZone['phone_code'] . date('y') . date('W') . str_pad($businessPartyId, 4, '0', STR_PAD_LEFT);
                $partyData['ID'] = $partyCode;
                $this->ci->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $partyCode, 'customeridentifier' => empty($customerIdentifier) ? $partyCode : $customerIdentifier], ['id' => $businessPartyId]);
            }
        }

        if ($partyDataType == "Customer") {
            $partyWhere['branch_code'] = $branch_code;
            $chkcust                   = $this->ci->common->gettblrowdata($partyWhere, "id", "tb_customers", 0, 0);
            if (count($chkcust) > 0) {
                $customer_id = $chkcust['id'];
            } else {
                $pwd  = password_hash($partyData['ID'], PASSWORD_DEFAULT);
                $data = [
                    'name'         => $partyData['Company']['Name'],
                    'phone'        => $partyData['ID'],
                    'location'     => (is_array($partyData['Address']['City']) ? "" : $partyData['Address']['City']),
                    'address'      => $address,
                    'pincode'      => (is_array($partyData['Address']['Postal']) ? "" : $partyData['Address']['Postal']),
                    'code'         => $partyData['ID'],
                    'country'      => (is_array($partyData['Address']['Country']) ? "" : $partyData['Address']['Country']),
                    'street'       => is_array($partyData['Address']['Street']) ? "" : $partyData['Address']['Street'],
                    'email_id'     => empty($partyData['Address']['ContactNo']['EmailAddress']) ? "" : $partyData['Address']['ContactNo']['EmailAddress'],
                    'password'     => $pwd,
                    'user_id'      => $user_id,
                    'partner_id'   => $businessPartyId,
                    'partyid'      => $businessPartyId,
                    'company_code' => $company_code,
                    'branch_code'  => $branch_code,
                    'status'       => 1,
                    'createdon'    => $curdt,
                    'updatedon'    => $curdt,
                ];
                $customer_id = $this->ci->common->insertTableData('tb_customers', $data);
            }
        }
        $responseData = [
            'party_code'  => $partyData['ID'],
            'party_id'    => $businessPartyId,
            'party_type'  => $party_type_id,
            'customer_id' => $customer_id,
        ];
        //log_message("Error", "Party Information" . json_encode($responseData));
        return $responseData;
    }

    public function sendAWSOrderEmailNotification(int $order_id, string $booking_id): void
    {
        if ($order_id == "") {
           //log_message("error", "sendAWSOrderEmailNotification Empty Booking Id : ");
            return;
        }
        //log_message("error", "sendAWSOrderEmailNotification Booking Id : " . $order_id);
        $this->ci->load->library('PhpMailerLibrary');
        $orderReferences = $this->ci->common->gettbldata(["order_id" => $order_id, "status" => 1], "reference_id, ref_value", "tb_order_references", 0, 0);
        $awsDQ           = $aecINN           = $awsABO           = "";
        foreach ($orderReferences as $references) {
            if ($references['reference_id'] == "DQ") {
                $awsDQ = $references['ref_value'];
            }
            if ($references['reference_id'] == "INN") {
                $aecINN = $references['ref_value'];
            }
            if ($references['reference_id'] == "ABO") {
                $awsABO = $references['ref_value'];
            }
        }
        $subject = "AWS Order Created: " . $booking_id . " - " . $awsDQ;
        $message = "Hi Team,<br>";
        $message .= "Booking ID with below references <br>";
        $message .= "INN:  " . $aecINN . "<br>";
        $message .= "DQ:  " . $awsDQ . "<br><br>";
        $message .= "ABO:  " . $awsABO . "<br><br>";
        $message .= "SVK ID:  " . $booking_id . "<br><br>";
        $message .= "This is an automatically generated EMail, please do not reply <br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";

        try {
            if ($this->ci->phpmailerlibrary->sendmail(AWSREPORT_MAILS, $subject, $message, json_decode(AWSREPORT_CC_MAILS))) {
                log_message("error", "sendAWSOrderEmailNotification email sent for " . $subject);
            } else {
                log_message("error", " sendAWSOrderEmailNotification email failed for " . $subject);
            }
        } catch (Exception $e) {
            log_message("error", "sendAWSOrderEmailNotification email failed - " . $e->getMessage());
        }
    }

    public function insertOrderAcknowledgementStatus(int $order_id): void
    {
        $orderInfo   = $this->ci->common->gettblrowdata(["id" => $order_id], "id,plat,plng,shift_id,createdon", "tb_orders", 0, 0);
        $orderStatus = [
            'order_id'      => $order_id,
            'status_id'     => '81',
            'latitude'      => $orderInfo['plat'],
            'longitude'     => $orderInfo['plng'],
            'status_code'   => '0142',
            'status_date'   => $orderInfo['createdon'],
            'status_type'   => "P",
            'shift_id'      => $orderInfo['shift_id'],
            'action_user'   => "AWS EDI",
            'createdon'     => date('Y-m-d H:i:s'),
            'status_reason' => 'From EDI',
        ];
        $this->ci->common->insertTableData('tb_order_status', $orderStatus);
    }
    
    public function formatNumber($num) {
        $rounded = round($num, 2);
        if (fmod($rounded, 1) == 0.0) {
            return (int) $rounded;   // no decimals if whole number
        }
        return number_format($rounded, 2, '.', ''); // force 2 decimals
    }

}
