<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ThreeWLEDIServices
{
    private $CI;
    private $customerId   = '95BDD2D3-C22F-443B-B63F-8F036F9DC5E5';
    private $customerCode = 'VAD000002';
    private $carrier      = '3WL';
    private $appKey       = '';
    private $apiKey       = '';
    private $baseUrl      = '';
    private $code         = '';

    public function __construct()
    {
        $this->CI = &get_instance();

        $this->CI->load->model(['Singlestatusmodel', 'Order']);
        $this->CI->load->library(['Edi_logger', 'uuid', 'apis/FlipkartEDIServices']);
        $this->CI->load->helper('user_helper');

        $query = $this->CI->db->get_where(
            'tb_auth_tokens',
            ['token_for' => $this->carrier]
        );

        $tokenRow = $query->row_array();

        $this->appKey  = $tokenRow['auth_token'] ?? '';
        $this->apiKey  = $tokenRow['api_key'] ?? '';
        $this->baseUrl = $tokenRow['base_url'] ?? '';
        $this->code    = $tokenRow['code'] ?? '';
    }

    public function createOrder(array $orderData, string $orderId, int $id): void
    {
        $pickupDate = $orderData['sourceInfo']['EstimatedDateTime']['From']['DateTime'] ?? '';

        if (empty($pickupDate) || $pickupDate === '0000-00-00 00:00:00') {
            $pickupDate = date('Y-m-d H:i:s');
        }

        $dt = new DateTime($pickupDate);

        $pickup_date = $dt->format('Y-m-d');
        $pickup_time = $dt->format('H:i');

        $pickup = $orderData['sourceInfo'] ?? [];
        $drop   = $orderData['destinationInfo'] ?? [];

        $pickup_name    = $pickup['Company']['Name'] ?? '';
        $pickup_street  = $pickup['Address']['Address2'] ?? '';
        $pickup_city    = $pickup['Address']['City'] ?? '';
        $pickup_state   = $pickup['Address']['State'] ?? '';
        $pickup_pincode = $pickup['Address']['Postal'] ?? '';

        $drop_name    = $drop['Company']['Name'] ?? '';
        $drop_street  = $drop['Address']['Address2'] ?? '';
        $drop_city    = $drop['Address']['City'] ?? '';
        $drop_state   = $drop['Address']['State'] ?? '';
        $drop_pincode = $drop['Address']['Postal'] ?? '';

        $thuData = $orderData['cargoDetails']['CargoThuDetails'] ?? [];
        $thuData = isset($thuData[0]) ? $thuData : [$thuData];

        $lbhData     = [];
        $totalLength = $totalWidth = $totalHeight = $totalWeight = $totalQuantity = $totalGoodsValue = 0;

        foreach ($thuData as $i => $cargo) {

            $length     = (float) ($cargo['Length'] ?? 0);
            $width      = (float) ($cargo['Width'] ?? 0);
            $height     = (float) ($cargo['Height'] ?? 0);
            $weight     = (float) ($cargo['Weight'] ?? 0);
            $quantity   = (int) ($cargo['Quantity'] ?? 0);
            $goodsValue = (int) ($cargo['ValueOfGoods'] ?? 0);

            $totalLength     += $length;
            $totalWidth      += $width;
            $totalHeight     += $height;
            $totalWeight     += $weight;
            $totalQuantity   += $quantity;
            $totalGoodsValue += $goodsValue;
        }

        $payload  = [
            "CustomerID"             => $this->customerId,
            "BillingCustomerCode"    => $this->customerCode,
            "PONumber"               => "null",
            "WarehouseName"          => trim($pickup_name ?: ""),
            "WarehouseAddress"       => trim($pickup_street ?: ""),
            "ContactPersonName"      => trim($pickup_name ?: ""),
            "MobileNumber"           => trim($pickup_contact ?: ""),
            "PickupDate"             => $pickup_date,
            "ExpPickupTime"          => $pickup_time,
            "PickupPincode"          => "201301",
            "ConsigneeName"          => trim($drop_name ?: ""),
            "ConsigneeAdd1"          => trim($drop_street ?: ""),
            "ConsigneeAdd2"          => "",
            "ConsigneeContactNumber" => trim($drop_contact ?: ""),
            "DeliveryPincode"        => trim($drop_pincode ?: ""),
            "Total_Pcs"              => $totalQuantity,
            "Total_Weight"           => $this->formatNumber($totalWeight < 1 ? 0.5 : $totalWeight),
            "Contents"               => "PALLETS",
            "Remarks"                => "",
            "IsLRNumberRequired"     => "True",
            "lstVolumetric_Size"     => [
                [
                    "Measurement" => "CENTIMETER",
                    "Total_Pcs"   => $totalQuantity,
                    "Length"      => $totalLength,
                    "Width"       => $totalWidth,
                    "Height"      => $totalHeight,
                ],
            ],
            "lstPickupItemList"      => [
                [
                    /*"InvoiceType"    =>  "INVOICE",
                    "InvoiceNo"      =>  "PGST-24-25-25663",
                    "InvoiceDate"    =>  "12/02/2025",
                    "Contents"       =>  "GARMENTS",
                    "Amount"         =>  23590.99,
                    "EWBNumber"      =>  "",
                    "EWBValidDate"   =>  "",
                    "FileByteArray"  =>  0,
                    "FileExtesion"   =>  ""*/
                ],
            ],
            "ProductCode"            => "PTL",
            "ModeName"               => "ROAD",
            "IsTesting"              => 0,
        ];

        log_message("error", "payload:" . json_encode($payload));

        $vendor      = $this->CI->db->get_where('tb_vendors', ['code' => $this->code])->row_array();
        $companyCode = $vendor['company_code'] ?? '';
        $branchCode  = $vendor['branch_code'] ?? '';
        $userId      = $vendor['user_id'] ?? '';

        $responseData = [];

        try {
            $serverURL = $this->baseUrl . 'PostPickupRequest';
            log_message("error", "serverURL:" . $serverURL);
            log_message("error", "appKey:" . $this->appKey);
            $ch = curl_init($serverURL);
            curl_setopt_array($ch, [
                CURLOPT_HTTPHEADER     => [
                    'Content-Type: application/json',
                    "X-APPKEY: $this->appKey",
                ],
                CURLOPT_POST           => true,
                CURLOPT_POSTFIELDS     => json_encode($payload),
                CURLOPT_RETURNTRANSFER => true,
            ]);

            $responseRaw = curl_exec($ch);

            if ($responseRaw === false) {
                throw new Exception(curl_error($ch));
            }

            curl_close($ch);
            $responseData = json_decode($responseRaw, true);
            if (
                empty($responseData) ||
                ! isset($responseData['ResponseStatus']['Message'])
            ) {
                log_message('error', 'Invalid API response: ' . $responseRaw);
                return;
            }

            log_message("error", "Response:" . json_encode($responseData));

            $status  = $responseData['ResponseStatus'];
            $orderNo = $responseData['OrderNumber'] ?? "";
            $lrNo    = $responseData['LRNumber'] ?? "";

            if ($status['Message'] !== 'SUCCESS') {

                $errorCode = $status['error_code'] ?? '';
                $errorMsg  = $status['msg'] ?? 'Unknown error';

                log_message(
                    'error',
                    "API Failure | Code: {$errorCode} | Message: {$errorMsg}"
                );

                return;
            }

            $cdate = date('Y-m-d H:i:s');

            if (! empty($orderNo)) {

                if (! empty($orderNo)) {

                    $wl_tkn_ref = [
                        'order_id'     => $id,
                        'reference_id' => 'TKN',
                        'ref_value'    => $orderNo,
                        'createdon'    => $cdate,
                    ];

                    $this->CI->db->insert('tb_order_references', $wl_tkn_ref);
                }

            }
            if (! empty($lrNo)) {

                if (! empty($lrNo)) {

                    $wl_lr_ref = [
                        'order_id'     => $id,
                        'reference_id' => 'KNLR',
                        'ref_value'    => $lrNo,
                        'createdon'    => $cdate,
                    ];

                    $this->CI->db->insert('tb_order_references', $wl_lr_ref);
                }

            }
        } catch (Exception $e) {
            log_message('error', '3WL Exception: ' . $e->getMessage());
        } finally {
            $this->logEdiTransaction(
                json_encode($payload),
                $responseData,
                $companyCode,
                $branchCode,
                $userId,
                '3WL Carrier Order Request'
            );
        }
    }

    public function formatNumber($num)
    {
        $rounded = round((float) $num, 2);
        return fmod($rounded, 1) === 0.0 ? (int) $rounded : number_format($rounded, 2, '.', '');
    }

    private function logEdiTransaction(string $request, array $response, string $companyCode, string $branchCode, string $userId, string $ediName): void
    {
        $this->CI->edi_logger->setEdi_type(1);
        $this->CI->edi_logger->setTransaction_id(time());
        $this->CI->edi_logger->setEdi_name($ediName);
        $this->CI->edi_logger->setBounded_type(1);
        $this->CI->edi_logger->setCompany_code($companyCode);
        $this->CI->edi_logger->setBranch_code($branchCode);
        $this->CI->edi_logger->setUser_id($userId);
        $this->CI->edi_logger->setEdi_format_type('JSON');
        $status = isset($response['ResponseStatus']['Message']) && $response['ResponseStatus']['Message'] === 'SUCCESS' ? 1 : 0;
        $this->CI->edi_logger->setStatus($status);
        $this->CI->edi_logger->setEdi_request($request);
        $this->CI->edi_logger->setEdi_response(json_encode($response));
        $this->CI->edi_logger->setObj_type_name($ediName);
        $this->CI->edi_logger->saveToEdiLogs();
    }

    public function getStatus(string $docketNo, string $orderId, int $id): int
    {
        $message       = '';
        $response      = '';
        $apiResponse   = [];
        $companyCode   = $this->CI->session->userdata('company_code');
        $branchCode    = $this->CI->session->userdata('branch_code');
        $userId        = $this->CI->session->userdata('user_id');
        $chk_qry_order = $this->CI->db->get_where('tb_orders', ['id' => $id])->row_array();
        $orderId       = $chk_qry_order['order_id'];
        if ($userId == null || $userId == "") {
            $userId = $chk_qry_order['user_id'];
        }
        if ($companyCode == null || $companyCode == "") {
            $companyCode = $chk_qry_order['company_code'];
        }
        if ($branchCode == null || $branchCode == "") {
            $branchCode = $chk_qry_order['branch_code'];
        }

        $val = getorderreftypeinfo('KNLR', $id);

        $queryParams = [
            'OrderNumber' => $val,
            'CustomerID'  => $this->customerId,
        ];

        $url       = $this->baseUrl;
        $serverURL = $url . 'GetOrderTracking' . '?' . http_build_query($queryParams);

        try {
            $ch = curl_init($serverURL);
            curl_setopt_array($ch, [
                CURLOPT_HTTPHEADER     => [
                    'Content-Type: application/json',
                    "X-APPKEY: $this->appKey",
                ],
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_TIMEOUT        => 30,
            ]);

            $response = curl_exec($curl);

            log_message("error", "3WL Tracking Response: " . $response);
    
            if ($response === false) {
                log_message('error', 'Curl Error: ' . curl_error($curl));
                curl_close($curl);
                return 0;
            }
    
            curl_close($curl);
    
            $data = json_decode($response, true);
    
            if ($data === null) {
                log_message('error', '3WL Tracking Invalid JSON: ' . $response);
                return 0;
            }
    
            if (! isset($data['ResponseStatus']) || $data['ResponseStatus'] !== "SUCCESS") {
                log_message('error', '3WL Tracking API failed: ' . json_encode($data));
                return 0;
            }
    
            $statusList     = $data['TrackingResult'][0]['ResponseStatus'] ?? [];
    
            $statusInput = $this->generateStatusXML($docketNo, $statusList);
            $xml         = simplexml_load_string($statusInput);
    
            $podImageUrl = $data['TrackingResult'][0]['PODImagePath'] ?? "";
            $edd         = $data['TrackingResult'][0]['EDD'] ?? "";
    
            $edd = $headerResult['EDD'] ?? "";
            log_message('error', 'edd: ' . $edd);
            if (! empty($edd)) {
    
                $utcTz = new DateTimeZone('UTC');
                $dt    = DateTime::createFromFormat('d/m/Y', $edd, $utcTz);
    
                if ($dt) {
    
                    $startDatetimeUtc = $dt->setTime(0, 0, 0)->format('Y-m-d H:i:s');
    
                    $endDatetimeUtc = $dt->setTime(23, 59, 59)->format('Y-m-d H:i:s');
    
                    $status = $this->CI->common->updatetbledata(
                        "tb_orders",
                        [
                            'delivery_datetime' => $startDatetimeUtc,
                            'drop_endtime'      => $endDatetimeUtc,
                            'updatedon'         => gmdate('Y-m-d H:i:s'),
                        ],
                        ['id' => $id]
                    );
                } else {
                    log_message('error', "Invalid EDD format: " . $edd);
                }
            }
            
            log_message('error', 'podImageUrl: ' . $podImageUrl);
            if (! empty($podImageUrl)) {
                $podInput = '<SVKDocumentUpload>';
                $podInput .= '<SVKHeader>';
                $podInput .= '<SVKSourceApp>' . $carrier . '</SVKSourceApp>';
                $podInput .= '<SVKDestinationApp>SVKonekt</SVKDestinationApp>';
                $podInput .= '</SVKHeader>';
                $podInput .= '<SVKAction>POD UPLOADED</SVKAction>';
                $podInput .= '<SVKOrderID>' . $orderId . '</SVKOrderID>';
                $podInput .= '<SVKDocumentType>POD</SVKDocumentType>';
                $podInput .= '<SVKUploadDetails>';
                $podInput .= '<SVKDocumentName>POD</SVKDocumentName>';
                $podInput .= '<SVKURL>' . $podImageUrl . '</SVKURL>';
                $podInput .= '</SVKUploadDetails>';
                $podInput .= '</SVKDocumentUpload>';
    
                $xml1 = simplexml_load_string($podInput);
                $res = $this->CI->flipkartediservices->getXPPod($xml1, $id);
            }
           
            return $this->getStatusXml($xml, $orderId, $this->carrier);


        } catch (Exception $e) {
            $message = 'Error: ' . $e->getMessage();
        } finally {
            $this->CI->edi_logger->setEdi_type(1);
            $this->CI->edi_logger->setTransaction_id(time());
            $this->CI->edi_logger->setEdi_name('Instakart Carrier Tracking Status');
            $this->CI->edi_logger->setBounded_type(1);
            $this->CI->edi_logger->setCompany_code($companyCode);
            $this->CI->edi_logger->setBranch_code($branchCode);
            $this->CI->edi_logger->setUser_id($userId);
            $this->CI->edi_logger->setEdi_format_type($type);
            $this->CI->edi_logger->setStatus(((isset($apiResponse) && $apiResponse) ? 1 : 0));
            $this->CI->edi_logger->setEdi_request($docketNo);
            $this->CI->edi_logger->setEdi_response(json_encode($response));
            $this->CI->edi_logger->setObj_type_name('Instakart Carrier Tracking Status');
            $this->CI->edi_logger->saveToEdiLogs();
        }
        return $apiResponse;
    }

    /*public function parse3WLXml(string $xml): array
    {
        log_message('error', 'xml: ' . $xml);
        $statusList = [];

        $orders = isset($xml->Order) ? $xml->Order : [];

        foreach ($orders as $order) {

            $podImageUrl = trim((string) $order->POD);
            $docketNo    = (string) $order['trackingNo'];

            if (! empty($podImageUrl)) {
                $podInput  = '<SVKDocumentUpload>';
                $podInput .= '<SVKHeader>';
                $podInput .= '<SVKSourceApp>' . $this->carrier . '</SVKSourceApp>';
                $podInput .= '<SVKDestinationApp>SVKonekt</SVKDestinationApp>';
                $podInput .= '</SVKHeader>';
                $podInput .= '<SVKAction>POD UPLOADED</SVKAction>';
                $podInput .= '<SVKOrderID>' . $docketNo . '</SVKOrderID>';
                $podInput .= '<SVKDocumentType>POD</SVKDocumentType>';
                $podInput .= '<SVKUploadDetails>';
                $podInput .= '<SVKDocumentName>POD</SVKDocumentName>';
                $podInput .= '<SVKURL>' . $podImageUrl . '</SVKURL>';
                $podInput .= '</SVKUploadDetails>';
                $podInput .= '</SVKDocumentUpload>';

                $xml = simplexml_load_string($podInput);
                $res = $this->CI->flipkartediservices->getXPPod($xml, $id);
            }

            if (! empty($order->Scans->ScanDetail)) {
                foreach ($order->Scans->ScanDetail as $scan) {

                    $rawDateTime = trim($scan->ScanDate . ' ' . $scan->ScanTime);

                    $dt = DateTime::createFromFormat(
                        'd M Y h:i:s a',
                        $rawDateTime
                    );

                    $formattedDateTime = $dt
                        ? $dt->format('Y-m-d H:i:s')
                        : null;

                    $statusList[] = [
                        'location' => (string) $scan->Scan,
                        'datetime' => $formattedDateTime,
                        'status'   => (string) $scan->Cnstatus,
                    ];
                }
            }

            $statusInput = $this->generateStatusXML($docketNo, $statusList);

            libxml_use_internal_errors(true);

            $xml = simplexml_load_string($statusInput);

            if ($xml === false) {
                log_message('error', 'Invalid Status XML');
                return 0;
            }

            return $this->getStatusXml($xml, $id, $this->carrier);
        }
    }*/

    public function generateStatusXML(string $docketNo, array $statusList): string
    {
        $xml  = '<SVKEDIResponseMessage>';
        $xml .= '<SVKEDITransmissionHeader>';
        $xml .= '<EDIVersion>SVK2.0</EDIVersion>';
        $xml .= '<AckSpec><AckOption>SUCCESS</AckOption></AckSpec>';
        $xml .= '<SourceApp>FLIPKART</SourceApp>';
        $xml .= '<DestinationApp>SVKONEKT</DestinationApp>';
        $xml .= '<Action>BookingStatusUpdate</Action>';
        $xml .= '</SVKEDITransmissionHeader>';
        $xml .= '<SVKEDITransmissionBody><Order>';
        $xml .= '<OrderID>' . $docketNo . '</OrderID>';

        foreach ($statusList as $status) {
            $xml .= '<Status>';
            $xml .= '<StatusCode>' . ($status['status'] ?? '') . '</StatusCode>';
            $xml .= '<StatusValue>' . ($status['status'] ?? '') . '</StatusValue>';
            $xml .= '<StatusType>' . ($status['status'] ?? '') . '</StatusType>';
            $xml .= '<DateTime>' . ($status['datetime'] ?? '') . '</DateTime>';
            $xml .= '<TimeZone>+00:00</TimeZone>';
            $xml .= '<Location>' . ($status['location'] ?? '') . '</Location>';
            $xml .= '</Status>';
        }

        $xml .= '</Order></SVKEDITransmissionBody></SVKEDIResponseMessage>';
        return $xml;
    }

    public function getStatusXml(object $xmlData, int $orderId, string $carrier): int
    {
        $statusResponse = 0;

        $body = $xmlData->SVKEDITransmissionBody ?? null;
        if (! $body || empty($body->Order)) {
            log_message('error', 'SVKEDITransmissionBody or Order missing');
            return 0;
        }

        $orders = is_array($body->Order) || $body->Order instanceof Traversable
            ? $body->Order
            : [$body->Order];

        foreach ($orders as $orderNode) {

            $externalOrderId = (string) ($orderNode->OrderID ?? '');
            if ($externalOrderId === '') {
                continue;
            }

            $chkOrder = $this->CI->db
                ->get_where('tb_orders', ['id' => $orderId])
                ->row_array();

            if (! $chkOrder) {
                log_message('error', 'Order not found in DB: ' . $orderId);
                continue;
            }

            $orderIdDb  = $chkOrder['order_id'];
            $ordersData = [];

            if (empty($orderNode->Status)) {
                continue;
            }

            $statuses = is_array($orderNode->Status) || $orderNode->Status instanceof Traversable
                ? $orderNode->Status
                : [$orderNode->Status];

            foreach ($statuses as $status) {

                $statusCode = (string) ($status->StatusCode ?? '');
                if ($statusCode === '') {
                    continue;
                }

                $ordersData[] = [
                    "OrderID"     => $orderIdDb,
                    "statustype"  => (string) ($status->StatusType ?? ''),
                    "statuscode"  => $statusCode,
                    "statusvalue" => (string) ($status->StatusValue ?? ''),
                    "datetime"    => (string) ($status->DateTime ?? ''),
                    "timezone"    => (string) ($status->TimeZone ?? ''),
                    "lat"         => (string) ($status->Lat ?? ''),
                    "lng"         => (string) ($status->Lng ?? ''),
                    "location"    => (string) ($status->Location ?? ''),
                ];
            }

            if (! empty($ordersData)) {
                $statusResponse = $this->CI
                    ->Singlestatusmodel
                    ->updateXPStatus(json_encode($ordersData), $carrier);
            }
        }

        return $statusResponse;
    }
}
