<?php

class CarrierNotificationTimeHandler
{
    private string $timeOffset;
    private string $timeZone;
    private string $countryCode;
    private string $countryName;

    public function __construct()
    {
        $ci = &get_instance();
        $this->timeOffset = $ci->session->userdata('usr_tzone')['hrs'] ?? '+00.00';
        $this->timeZone = $ci->session->userdata('usr_tzone')['timezone'] ?? '';
        $this->countryCode = $ci->session->userdata('usr_tzone')['country'] ?? '';
        $this->countryName = $ci->session->userdata('usr_tzone')['country_name'] ?? '';
    }

    public function getTimeOffset(): string
    {
        return $this->timeOffset;
    }

    public function getTimeZone(): string
    {
        return $this->timeZone;
    }

    public function getCountryCode(): string
    {
        return $this->countryCode;
    }

    public function getCountryName(): string
    {
        return $this->countryName;
    }
}
