<?php

class CarrierTripNotification
{
    private $ci;
    const LIBRARY_PATH = 'edi/carriernotification/xmlsettersgetters';
    const DATE_FORMAT = 'Y-m-d\TH:i:s\Z';
    private $carrierInstructions = '';
    private $tripType = '';
    private $shift_id = 0;
    private $timeZone = '';
    private $typeOfBusiness = 0;
    private $pickupInstructions = '';
    private $deliveryInstructions = '';
    /*
     * Data Holders
     */
    private $tripDetailsList = [];
    private $knOrgDetailsList = [];
    private $carrierList = [];
    private $vehicleInfoList = [];
    private $driverInfoList = [];
    private $tripCargoSummaryList = [];
    private $orderInfoList = [];
    private $termOfTradeList = [];
    private $orderPartiesList = [];
    private $orderStartLocationList = [];
    private $orderEndLocationList = [];
    private $orderCargoSummaryList = [];
    private $orderCargoDetailsHeaderList = [];
    private $manageReferencesList = [];
    private $remarksList = [];
    private $orderCargoDetailsList = [];
    private $timeOffset = '+00:00';
    private $headerSegmentList = [];

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('Carriertripnotificationmodel', 'carriertripnotificationmodel');
        $this->ci->load->Library('edi/carriernotification/CarrierNotificationTimeHandler', 'carriernotificationtimehandler');
        $this->timeZone = $this->ci->carriernotificationtimehandler->getTimeZone();
        $this->timeOffset = $this->ci->carriernotificationtimehandler->getTimeOffset();
    }

    /**
     * @param int $shift_id
     */
    public function setShiftId(int $shift_id): void
    {
        $this->shift_id = $shift_id;
    }

    /**
     * @return int
     */
    public function getShiftId(): int
    {
        return $this->shift_id;
    }

    /**
     * @param int $typeOfBusiness
     */
    public function setTypeOfBusiness(int $typeOfBusiness): void
    {
        $this->typeOfBusiness = $typeOfBusiness;
    }

    /**
     * @return int
     */
    public function getTypeOfBusiness(): int
    {
        return $this->typeOfBusiness;
    }

    /**
     * @param mixed $timeOffset
     */
    public function setTimeOffset($timeOffset): void
    {
        $this->timeOffset = $timeOffset;
    }

    /**
     * @return mixed
     */
    public function getTimeOffset()
    {
        return $this->timeOffset;
    }

    /**
     * @param string $pickupInstructions
     */
    public function setPickupInstructions(string $pickupInstructions): void
    {
        $this->pickupInstructions = $pickupInstructions;
    }

    /**
     * @return string
     */
    public function getPickupInstructions(): string
    {
        return $this->pickupInstructions;
    }

    /**
     * @param string $deliveryInstructions
     */
    public function setDeliveryInstructions(string $deliveryInstructions): void
    {
        $this->deliveryInstructions = $deliveryInstructions;
    }

    /**
     * @return string
     */
    public function getDeliveryInstructions(): string
    {
        return $this->deliveryInstructions;
    }

    /*
     *  Used to get HeaderSegmentData
     */
    public function getHeaderSegment(): string
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/HeaderSegment', $this->headerSegmentList);
        return $this->ci->headersegment->getXml();
    }

    /*
     *  Used to get TripDetail info
     */
    public function getTripDetailsInfo()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/TripDetailsInfo', $this->tripDetailsList);
        $this->carrierInstructions = $this->ci->tripdetailsinfo->getWrappedCarrierInstructions($this->carrierInstructions);
        $this->tripType = $this->ci->tripdetailsinfo->getWrappedTripType();
        return $this->ci->tripdetailsinfo->getXml();
    }

    public function getKNOrgDetails()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/KNOrgDetails', $this->knOrgDetailsList);
        return $this->ci->knorgdetails->getXml();
    }

    public function getCarrier()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/CarrierDetails', $this->carrierList);
        return $this->ci->carrierdetails->getXml();
    }

    public function getVehicleDetails()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/VehicleDetails', $this->vehicleInfoList);
        return $this->ci->vehicledetails->getXml();
    }

    public function getDriverDetails()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/DriverDetails', $this->driverInfoList);
        return $this->ci->driverdetails->getXml();
    }

    public function getTripCargoSummary()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/TripCargoSummary', $this->tripCargoSummaryList);
        return $this->ci->tripcargosummary->getXml();
    }

    public function getOrderInfo()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/OrderInfo', $this->orderInfoList, 'orderInfoInstance');
        $orderInfoXml = $this->ci->orderInfoInstance->getXml();
        unset($this->ci->orderInfoInstance);
        return $orderInfoXml;
    }

    public function getTermsOfTrade()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/TermsOfTrade', $this->termOfTradeList, 'termsOfTradeInstance');
        $getTermsOfTradeXml = $this->ci->termsOfTradeInstance->getXml();
        unset($this->ci->termsOfTradeInstance);
        return $getTermsOfTradeXml;
    }

    public function getOrderParties(): string
    {
        $orderPartiesXml = '';
        foreach ($this->orderPartiesList as $orderParty) {
            $this->ci->load->library(self::LIBRARY_PATH . '/OrderParties', $orderParty, 'orderPartiesInstance');
            $orderPartiesXml .= $this->ci->orderPartiesInstance->getXml();
            unset($this->ci->orderPartiesInstance);
        }
        return $orderPartiesXml;
    }

    public function getOrderStartLocation()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/OrderStartLocation', $this->orderStartLocationList, 'orderStartLocationInstance');
        $orderStartLocationInstanceXml = $this->ci->orderStartLocationInstance->getXml();
        unset($this->ci->orderStartLocationInstance);
        return $orderStartLocationInstanceXml;
    }

    public function getOrderEndLocation()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/OrderEndLocation', $this->orderEndLocationList, 'orderEndLocationInstance');
        $orderEndLocationXml = $this->ci->orderEndLocationInstance->getXml();
        unset($this->ci->orderEndLocationInstance);
        return $orderEndLocationXml;
    }

    public function getOrderCargoSummary()
    {
        $this->ci->load->library(self::LIBRARY_PATH . '/OrderCargoSummary', $this->orderCargoSummaryList, 'orderCargoSummaryInstance');
        $orderCargoSummaryXml = $this->ci->orderCargoSummaryInstance->getXml();
        unset($this->ci->orderCargoSummaryInstance);
        return $orderCargoSummaryXml;
    }

    public function getOrderCargoDetails(): string
    {
        $orderCargoDetailsXml = '';
        foreach ($this->orderCargoDetailsList as $orderCargoDetail) {
            $this->ci->load->library(self::LIBRARY_PATH . '/OrderCargoDetails', $orderCargoDetail, 'orderCargoDetailsInstance');
            $orderCargoDetailsXml .= $this->ci->orderCargoDetailsInstance->getXml();
            unset($this->ci->orderCargoDetailsInstance);
        }
        return $orderCargoDetailsXml;
    }

    /*
     *  Initially order cargo details have an header then later as part of enhancement we removed it.
     *  so in feature if there is a need then we can utilize it.
     */
    public function getOrderCargoDetailsHeader()
    {
        if (false) {
            $this->ci->load->library(self::LIBRARY_PATH . '/OrderCargoDetailsHeader', $this->orderCargoDetailsHeaderList, 'orderCargoDetailsHeaderInstance');
            $orderCargoDetailsHeaderXml = $this->ci->orderCargoDetailsHeaderInstance->getXml();
            unset($this->ci->orderCargoDetailsHeaderInstance);
            return $orderCargoDetailsHeaderXml;
        }
    }

    public function getManageReferences(): string
    {
        $manageReferencesListXml = '';
        foreach ($this->manageReferencesList as $manageReference) {
            $this->ci->load->library(self::LIBRARY_PATH . '/ManageReferences', $manageReference, 'manageReferencesListInstance');
            $manageReferencesListXml .= $this->ci->manageReferencesListInstance->getXml();
            unset($this->ci->manageReferencesListInstance);
        }
        $this->manageReferencesList = [];
        return $manageReferencesListXml;
    }

    public function getRemarks(): string
    {
        $remarksXml = '';
        foreach ($this->remarksList as $remark) {
            $this->ci->load->library(self::LIBRARY_PATH . '/Remarks', $remark, 'remarksInstance');
            $remarksXml .= $this->ci->remarksInstance->getXml();
            unset($this->ci->remarksInstance);
        }
        $this->remarksList = [];
        return $this->encloseWithinManageRemarks($remarksXml);
    }

    /*
     *  Below methods are used to form complete xmls.
     */

    public function encloseWithinTripDetails(): string
    {
        $childXmlTags = '<TripDetails>';
        $childXmlTags .= $this->tripType;
        $childXmlTags .= $this->getCarrier();
        $childXmlTags .= $this->carrierInstructions;
        $childXmlTags .= $this->getVehicleDetails();
        $childXmlTags .= $this->getDriverDetails();
        $childXmlTags .= $this->getTripCargoSummary();
        $childXmlTags .= '</TripDetails>';
        return $childXmlTags;
    }

    public function encloseWithinTripOrderDetails($childXmlTags): string
    {
        return '<TripOrderDetails>' . $childXmlTags . '</TripOrderDetails>';
    }

    public function encloseWithinOrders(): string
    {
        $childXmlTags = '';
        $childXmlTags .= $this->getOrderInfo();
        $childXmlTags .= $this->getTermsOfTrade();
        $childXmlTags .= $this->encloseWithinOrderParties();
        $childXmlTags .= $this->getOrderStartLocation();
        $childXmlTags .= $this->getOrderEndLocation();
        $childXmlTags .= $this->getOrderCargoSummary();
        $childXmlTags .= $this->encloseWithinOrderCargoDetails();
        $childXmlTags .= $this->encloseWithinManageReferences();
        $childXmlTags .= $this->getRemarks();
        return '<Orders>' . $childXmlTags . '</Orders>';
    }

    public function encloseWithinOrderCargoDetails(): string
    {
        $orderCargoDetailHeader = $this->getOrderCargoDetailsHeader();
//        $items = $this->encloseWithinItemsTag($this->getOrderCargoDetails());
        $items = $this->getOrderCargoDetails();
        return $this->encloseWithinOrderCargoDetailsTag($orderCargoDetailHeader . $items);
    }

    public function encloseWithinOrderCargoDetailsTag($childTags): string
    {
        return '<OrderCargoDetails>' . $childTags . '</OrderCargoDetails>';
    }

    public function encloseWithinOrderParties(): string
    {
        $childXmlTags = $this->getOrderParties();
        return '<OrderParties>' . $childXmlTags . '</OrderParties>';
    }

    public function encloseWithinItemsTag($childTag): void
    {
//        return '<Items>' . $childTag . '</Items>';
    }

    public function encloseWithinManageReferences(): string
    {
        return '<ManageReferences>' . $this->getManageReferences() . '</ManageReferences>';
    }

    public function generateXml($shift_id, $username = '', $password = ''): string
    {
        $this->setShiftId($shift_id);
        $this->headerSegmentList = ['username' => $username, 'password' => $password];
        $this->initializeDataLoading();

        $orderList = $this->ci->carriertripnotificationmodel->getOrderDetails($this->getShiftId());
        $individualOrdersSegments = '';
        foreach ($orderList as $order) {
            $this->manageReferencesList = $this->ci->carriertripnotificationmodel->getOrderReferences($order['order_row_id']);
//            $this->remarksList = $this->ci->carriertripnotificationmodel->getRemarks($order['order_row_id']);
            $this->remarksList = $this->ci->carriertripnotificationmodel->getOrderRemarks();
            $this->setPickupInstructions($this->ci->carriertripnotificationmodel->getPickupInstructions());
            $this->setDeliveryInstructions($this->ci->carriertripnotificationmodel->getDeliveryInstructions());
            $this->extractOrderInfo($order);
            $this->extractOrderCargoSummary($order['order_row_id']);
            $individualOrdersSegments .= $this->encloseWithinOrders();

            $firstOrderId = $firstOrderId ?? $order['order_id'];
        }

        $xmlVersionAndNs = '<?xml version="1.0" encoding="UTF-8"?><Trip xmlns="https://elog360.app/svkonekt_test/edi/carrier/trip_notification/v1">';
        $headerSegment = $this->getHeaderSegment();
        $tripDetailsInfo = $this->getTripDetailsInfo();
        $kNOrgDetails = $this->getKNOrgDetails();
        $tripDetails = $this->encloseWithinTripDetails();
        $tripOrderDetails = $this->encloseWithinTripOrderDetails($individualOrdersSegments);

        $xmlTripClose = '</Trip>';
        $xmlString = $this->validateXml($xmlVersionAndNs . $headerSegment . $tripDetailsInfo . $kNOrgDetails . $tripDetails . $tripOrderDetails . $xmlTripClose);

        try {
            $service = new \App\Libraries\TripNotificationXmlCacheService();
            $service->forOrderId($firstOrderId ?? 0)->store($xmlString ?? '-');
        } catch (\RuntimeException $e) {
            //
        }

        return $xmlString;
    }

    public function initializeDataLoading(): void
    {
        // extract & set driver and vehicle info
        $this->extractDriverAndVehicleInfo($this->ci->carriertripnotificationmodel->getTripDriverAndVehicle($this->getShiftId()));
        // extract & set trip cargo summary
        $this->extractTripCargoSummary();
    }

    public function extractOrderinfo($order)
    {
        $company_code = $order['company_code'];
        $branch_code = $order['branch_code'];
        $physicalreceiver = $order['physicalreceiver'];
        $logicalreceiver = $order['logicalreceiver'];
        $physicalsender = $order['physicalsender'];
        $logicalsender = $order['logicalsender'];
        $order_row_id = $order['order_row_id'];
        $shipmentid = $order['shipmentid'];
        $department_code = $order['department_code'];
        $order_id = $order['order_id'];
        $external_order_id = $order['external_order_id'];
        $transport_mode = $order['transport_mode'];
        $type_name = $order['type_name'];
        $service_id = $order['service_id'];
        $service_name = $order['service_name'];
        $incoterm_name = $order['incoterm_name'];
        $freight_term = $order['freight_term'];
        $freight_termname = $order['freight_termname'];
        $border_type = $order['border_type'] ?: 0;
        $this->carrierInstructions = $order['carrier_instructions'];
        $goods_value = $order['goods_value'];
        $currency = $order['currency'];
        $additional_conditions = $order['additional_conditions'];
        $temperature_regime = $order['temperature_regime'];
        $time_for_loading_penality_rate = $order['time_for_loading_penality_rate'];

        $this->setTypeOfBusiness($border_type);
        $pickup_datetime = $this->dateFormatter($order['pickup_datetime']);
        $pickup_endtime = $this->dateFormatter($order['pickup_endtime']);
        $delivery_datetime = $this->dateFormatter($order['delivery_datetime']);
        $drop_endtime = $this->dateFormatter($order['drop_endtime']);

        $pickup_company = $order['pickup_company'];
        $delivery_company = $order['delivery_company'];
        $pickup_country = $order['pickup_country'];
        $delivery_country = $order['delivery_country'];
        $pickup_city = $order['pickup_city'];
        $delivery_city = $order['delivery_city'];
        $pickup_pincode = $order['pickup_pincode'];
        $delivery_pincode = $order['delivery_pincode'];
        $pickup_address1 = $order['pickup_address1'];
        $delivery_address1 = $order['delivery_address1'];
        $pickup_address2 = $order['pickup_address2'];
        $delivery_address2 = $order['delivery_address2'];
        $incoterm = $order['incoterm'];

        $delivery_term_id = $order['delivery_term_id'];
        $delivery_term_name = $order['delivery_term_name'];

        // set TripDetails
        if (sizeof($this->tripDetailsList) == 0) {
            $this->tripDetailsList = ['action' => 'CREATE', 'tripID' => $shipmentid, 'externalTripID' => '', 'tripType' => 'REGULAR', 'carrierInstructions' => $this->carrierInstructions
                , 'additionalConditions' => $additional_conditions, 'temperatureRegime' => $temperature_regime, 'timeForLoadingAndPenalty' => $time_for_loading_penality_rate];
        }
        // set KNOrgDetails
        if (sizeof($this->knOrgDetailsList) == 0) {
            $this->knOrgDetailsList = ['companyCode' => $company_code, 'branchCode' => $branch_code, 'departmentCode' => $department_code, 'physicalReceiver' => $physicalreceiver,
                'logicalReceiver' => $logicalreceiver, 'physicalSender' => $physicalsender, 'logicalSender' => $logicalsender];
        }
        // extract & set order parties info
        $this->extractOrderPartiesInfo($this->ci->carriertripnotificationmodel->getOrderParties($order_row_id));
        // set OrderInfo
        $this->orderInfoList = ['orderID' => $order_id, 'eXTOrderID' => $external_order_id, 'departmentCode' => $department_code, 'orderType' => $type_name, 'modeOfTransport' => $transport_mode, 'serviceType' => $service_id . ' - ' . $service_name, 'typeOfBusiness' => $this->typeOfBusiness(), 'deliveryTerms' => $delivery_term_id.' - '.$delivery_term_name, 'goodsValue' => $goods_value, 'currency' => $currency];
        // set Terms Of Trade
        //        $this->termOfTradeList = ['termsOfTradeIncoterm' => $incoterm_name, 'freightNameTerm' => $freight_term, 'freightName' => $freight_termname];
        $this->termOfTradeList = ['termsOfTradeIncoterm' => $incoterm, 'freightNameTerm' => $delivery_term_id, 'freightName' => $delivery_term_name];
        // set Start Location list

        $this->orderStartLocationList = ['stopSequence' => 0, 'address1' => $pickup_company, 'street' => $pickup_address1, 'city' => $pickup_city, 'state' => $pickup_address2, 'postal' => $pickup_pincode, 'country' => $this->getCountryMasterData($pickup_country, 'country_code'), 'timezone' => $this->timeZone, 'from' => $pickup_datetime, 'to' => $pickup_endtime, 'pickupInstructions' => $this->getPickupInstructions()];
        // set End Location list
        $this->orderEndLocationList = ['stopSequence' => 0, 'address1' => $delivery_company, 'street' => $delivery_address1, 'city' => $delivery_city, 'state' => $delivery_address2, 'postal' => $delivery_pincode, 'country' => $this->getCountryMasterData($delivery_country, 'country_code'), 'timezone' => $this->timeZone, 'from' => $delivery_datetime, 'to' => $drop_endtime, 'deliveryInstructions' => $this->getDeliveryInstructions()];
    }

    public function extractOrderPartiesInfo($orderParties)
    {
        $this->orderPartiesList = [];
        foreach ($orderParties as $orderParty) {
            $party_type = strtoupper($orderParty['party_type']);
            if ($party_type == 'CARRIER') {
                if (sizeof($this->carrierList) == 0) {
                    $this->carrierList = ['id' => $orderParty['code'], 'name' => $orderParty['name'], 'firstName' => $orderParty['name'], 'lastName' => '', 'countryCode' => $this->getCountryMasterData($orderParty['country']), 'contactNo' => $orderParty['mobile'], 'emailAddress' => $orderParty['email']];
                }
            } else {
                $this->orderPartiesList[] = ['partyID' => $orderParty['code'], 'partyName' => $orderParty['name'], 'partyType' => $party_type, 'firstName' => $orderParty['name'], 'lastName' => '', 'countryCode' => $this->getCountryMasterData($orderParty['country']), 'contactNo' => $orderParty['mobile'], 'emailAddress' => $orderParty['email']];
            }
        }
    }

    public function extractDriverAndVehicleInfo($driverAndVehicleInfo)
    {
        // vehicle info
        $register_number = $driverAndVehicleInfo['register_number'];
        $driver_id = $driverAndVehicleInfo['driver_id'];
        $vehicle_register_number = $driverAndVehicleInfo['vehicle_register_number'] ?? '';
        $truck_brand = $driverAndVehicleInfo['truck_brand'];
        $truck_weight = $driverAndVehicleInfo['truck_weight'];
        $weight_unit = $driverAndVehicleInfo['weight_unit'];
        $truck_volume = $driverAndVehicleInfo['truck_volume'];
        $volume_unit = $driverAndVehicleInfo['volume_unit'];
        $height = $driverAndVehicleInfo['height'];
        $height_unit = $driverAndVehicleInfo['height_unit'];
        $length = $driverAndVehicleInfo['length'];
        $length_unit = $driverAndVehicleInfo['length_unit'];
        $trucktype = $driverAndVehicleInfo['trucktype'];
        $breadth = $driverAndVehicleInfo['breadth'];
        $breadth_unit = $driverAndVehicleInfo['breadth_unit'];

        // driver info
        $driver_name = $driverAndVehicleInfo['driver_name'];
        $driver_contact_number = $driverAndVehicleInfo['driver_contact_number'];
        $driver_address1 = $driverAndVehicleInfo['driver_address1'];
        $driver_address2 = $driverAndVehicleInfo['driver_address2'];
        $street = $driverAndVehicleInfo['street'];
        $driver_state = $driverAndVehicleInfo['driver_state'];
        $driver_pincode = $driverAndVehicleInfo['driver_pincode'];
        $driver_country = $driverAndVehicleInfo['driver_country'];
        $driver_email = $driverAndVehicleInfo['driver_email'];
        $driving_licence_num = $driverAndVehicleInfo['driving_licence_num'] ?? '';

        // set vehicle info
        $this->vehicleInfoList = ['vehicleTypeCode' => $trucktype, 'vehicleModelCode' => $truck_brand, 'registrationNumber' => $vehicle_register_number, 'license' => $driving_licence_num, 'applicableForDangerousGoods' => '',
            'weightMin' => '0.0', 'weightMax' => $truck_weight, 'weightUOM' => $weight_unit, 'volumeMin' => '0.0', 'volumeMax' => $truck_volume, 'volumeUOM' => $volume_unit,
            'lengthMin' => '0.0', 'lengthMax' => $length, 'lengthUOM' => $length_unit, 'widthMin' => '0.0', 'widthMax' => $breadth, 'widthUOM' => $breadth_unit,
            'heightMin' => '0.0', 'heightMax' => $height, 'heightUOM' => $height_unit];

        // set Driver Info
        $this->driverInfoList = ['idNumber' => $driver_contact_number, 'address' => $driver_address1, 'street' => $street, 'city' => $driver_address2, 'state' => $driver_state, 'postal' => $driver_pincode, 'country' => $this->getCountryMasterData($driver_country, 'country_code'),
            'timezone' => '', 'firstName' => $driver_name, 'lastName' => '', 'countryCode' => $this->getCountryMasterData($driver_country), 'contactNo' => $driver_contact_number, 'emailAddress' => $driver_email];
    }

    public function extractTripCargoSummary()
    {
        $tripCargoSummary = $this->ci->carriertripnotificationmodel->getTripCargoSummary($this->getShiftId());
        $quantity = $tripCargoSummary['quantity'];
        $weight = $tripCargoSummary['weight'];
        $weight_unit = $tripCargoSummary['weight_unit'];
        $volume = $tripCargoSummary['volume'];
        $volume_unit = $tripCargoSummary['volume_unit'];
        $this->tripCargoSummaryList = ['totalQuantityValue' => (int) $quantity, 'totalQuantityUOM' => 'Numbers', 'totalVolumeValue' => (float) $volume, 'totalVolumeUOM' => $volume_unit, 'totalWeightValue' => (float) $weight, 'totalWeightUOM' => $weight_unit];
    }

    public function extractOrderCargoSummary($order_row_id)
    {
        // reset OrderCargoDetailsList to empty for each order iteration.
        $this->orderCargoDetailsList = [];
        // set Order Cargo Details
        $orderCargoDetails = $this->ci->carriertripnotificationmodel->getOrderCargoDetails($order_row_id);
        $isDangerousGoods = [];

        // order cargo summary
        $totalQuantity = [];
        $totalVolume = [];
        $TotalWeight = [];
        $quantityUOM = 'Number';
        $volumeUOM = '';
        $WeightUOM = '';
        foreach ($orderCargoDetails as $orderCargo) {
            $cargo_type = $orderCargo['cargo_type'];
            $dg_goods = $orderCargo['dg_goods'];
            $handling_unit = $orderCargo['handling_unit'] ?? '';
            $quantity = $orderCargo['quantity'];
            $length = $orderCargo['length'];
            $length_unit = $orderCargo['length_unit'];
            $width = $orderCargo['width'];
            $width_unit = $orderCargo['width_unit'];
            $height = $orderCargo['height'];
            $height_unit = $orderCargo['height_unit'];
            $weight = $orderCargo['weight'];
            $weight_unit = $orderCargo['weight_unit'];
            $volume = $orderCargo['volume'];
            $volume_unit = $orderCargo['volume_unit'];
            $stackable = $orderCargo['stackable'];
            $grounded = $orderCargo['grounded'];
            $splittable = $orderCargo['splittable'];
            $ldm = $orderCargo['ldm'];
            $ldm_uom = $orderCargo['ldm_uom'] ?? '';
            $dg_goods = $orderCargo['dg_goods'];
            $goods_description = $orderCargo['goods_description'];
            $volumetric_weight = $orderCargo['volumetric_weight'];
            $volweight_uom = $orderCargo['volweight_uom'];
            $second_weight = $orderCargo['second_weight'];
            // $order_id = $orderCargo['order_id'];
            $this->orderCargoDetailsList[] = ['cargoType' => $cargo_type, 'handlingUnit' => $handling_unit, 'quantity' => $quantity, 'lengthValue' => $length, 'lengthUOM' => $length_unit, 'widthValue' => $width, 'widthUOM' => $width_unit,
                'heightValue' => $height, 'heightUOM' => $height_unit, 'weightValue' => $second_weight, 'weightUOM' => $weight_unit, 'totalVolumeValue' => $volume, 'totalVolumeUOM' => $volume_unit, 'totalWeightValue' => $weight,
                'totalWeightUOM' => $height_unit, 'stackable' => $stackable, 'grounded' => $grounded, 'splittable' => $splittable, 'dangerousGoodsFlag' => $dg_goods, 'cargoDescription' => $goods_description, 'ldm' => $ldm, 'ldmUOM' => $ldm_uom, 'volumetricWeight' => $volumetric_weight, 'volumetricWeightUOM' => $volweight_uom];
            $isDangerousGoods[] = $dg_goods;

            // push data to generate order summary
            $totalQuantity[] = is_numeric($quantity) ? $quantity : 0;
            $totalVolume[] = is_numeric($volume) ? $volume : 0;
            $TotalWeight[] = is_numeric($weight) ? $weight : 0;

            $volumeUOM = $volume_unit;
            $WeightUOM = $weight_unit;
        }
        $totalDgSum = array_sum($isDangerousGoods);
        $totalDgSumFlag = (($totalDgSum > 0) ? 1 : 0);
        // set OrderCargoDetails Header
        $this->orderCargoDetailsHeaderList = ['cargoType' => '', 'dangerousGoodsFlag' => $totalDgSumFlag, 'totalPackagesOfDangerousGoods' => $totalDgSum];
        // set Order Cargo Summary
        $this->orderCargoSummaryList = ['totalQuantityValue' => array_sum($totalQuantity), 'totalQuantityUOM' => $quantityUOM, 'totalVolumeValue' => array_sum($totalVolume), 'totalVolumeUOM' => $volumeUOM, 'totalWeightValue' => array_sum($TotalWeight), 'totalWeightUOM' => $WeightUOM, 'dangerousGoodsFlag' => $totalDgSumFlag, 'totalPackagesOfDangerousGoods' => $totalDgSum];
    }

    public function encloseWithinManageRemarks($childTags): string
    {
        if ($childTags != '') {
            return '<ManageRemarks>' . $childTags . '</ManageRemarks>';
        }
        return '';
    }

    public function typeOfBusiness(): string
    {
        $typeOfBusiness = ['DOMESTIC', 'CROSSBORDER'];
        return $typeOfBusiness[$this->getTypeOfBusiness()];
    }

    public function getCountryMasterData($countryName, $fetch_field = ''): ?string
    {
        if (strlen(trim($countryName)) == 0) {
            return '';
        }
        $result = $this->ci->carriertripnotificationmodel->getCountryCodeBasedOnCountryName($countryName);
        return $fetch_field === '' ? $result['phone_code'] : ($result[$fetch_field] ?? '');
    }

    public function validateXml(string $xmlString)
    {
        libxml_use_internal_errors(true);
        $response = false;
        if (simplexml_load_string($xmlString)) {
            $response = $xmlString;
        }
        libxml_clear_errors();
        return $response;
    }

    public function dateFormatter(string $date): string
    {
        return empty($date) ? '' : date(self::DATE_FORMAT, strtotime($date));
    }
}
