<?php

use App\Libraries\XmlNode;

class CarrierDetails extends XmlNode
{
    public function __construct(array $carrierList = [])
    {
        parent::__construct(
            $carrierList,
            [
                'id' => 0,
                'name' => '',
                'firstName' => '',
                'lastName' => '',
                'countryCode' => '',
                'contactNo' => '',
                'emailAddress' => '',
            ]
        );
    }

    public function setId(string $id): void
    {
        $this->id = $id;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setCountryCode(string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    public function getCountryCode(): string
    {
        return $this->countryCode;
    }

    public function setContactNo(string $contactNo): void
    {
        $this->contactNo = $contactNo;
    }

    public function getContactNo(): string
    {
        return $this->contactNo;
    }

    public function setEmailAddress(string $emailAddress): void
    {
        $this->emailAddress = $emailAddress;
    }

    public function getEmailAddress(): string
    {
        return $this->emailAddress;
    }

    public function getXml(): string
    {
        return '<Carrier>
                    <PartyID>
                        <ID>' . $this->id . '</ID>
                         <Name>' . $this->name . '</Name>
                     </PartyID>
                    <ContactData>
                         <FirstName>' . $this->firstName . '</FirstName>
                         <LastName>' . $this->lastName . '</LastName>
                         <Phone>
                           <CountryCode>' . $this->countryCode . '</CountryCode>
                           <ContactNo>' . $this->contactNo . '</ContactNo>
                         </Phone>
                         <EmailAddress>' . $this->emailAddress . '</EmailAddress>
                     </ContactData>
                    </Carrier>';
    }
}
