<?php

use App\Libraries\XmlNode;

class DriverDetails extends XmlNode
{
    public function __construct(array $driverDetails = [])
    {
        parent::__construct(
            $driverDetails,
            [
                'idType' => '',
                'idNumber' => '',
                'address' => '',
                'street' => '',
                'city' => '',
                'state' => '',
                'postal' => '',
                'country' => '',
                'timezone' => '',
                'firstName' => '',
                'lastName' => '',
                'countryCode' => '',
                'contactNo' => '',
                'emailAddress' => '',
            ]
        );
    }

    public function setIdType(string $idType): void
    {
        $this->idType = $idType;
    }

    public function getIdType(): string
    {
        return $this->idType;
    }

    public function setIdNumber(string $idNumber): void
    {
        $this->idNumber = $idNumber;
    }

    public function getIdNumber(): string
    {
        return $this->idNumber;
    }

    public function setAddress(string $address): void
    {
        $this->address = $address;
    }

    public function getAddress(): string
    {
        return $this->address;
    }

    public function setStreet(string $street): void
    {
        $this->street = $street;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function setState(string $state): void
    {
        $this->state = $state;
    }

    public function getState(): string
    {
        return $this->state;
    }

    public function setPostal(string $postal): void
    {
        $this->postal = $postal;
    }

    public function getPostal(): string
    {
        return $this->postal;
    }

    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function setTimezone(string $timezone): void
    {
        $this->timezone = $timezone;
    }

    public function getTimezone(): string
    {
        return $this->timezone;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setCountryCode(string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    public function getCountryCode(): string
    {
        return $this->countryCode;
    }

    public function setContactNo(string $contactNo): void
    {
        $this->contactNo = $contactNo;
    }

    public function getContactNo(): string
    {
        return $this->contactNo;
    }

    public function setEmailAddress(string $emailAddress): void
    {
        $this->emailAddress = $emailAddress;
    }

    public function getEmailAddress(): string
    {
        return $this->emailAddress;
    }

    public function getXml(): string
    {
        return '<DriverDetails>
                <IDProof>
                     <IDType>' . $this->idType . '</IDType>
                     <IDNumber>' . $this->idNumber . '</IDNumber>
                 </IDProof>
                <Address>
                     <Name>' . $this->address . '</Name>
                     <Street>' . $this->street . '</Street>
                     <City>' . $this->city . '</City>
                     <State>' . $this->state . '</State>
                     <Postal>' . $this->postal . '</Postal>
                     <Country>' . $this->country . '</Country>
                     <Timezone>' . $this->timezone . '</Timezone>
                 </Address>
                    <ContactData>
                         <FirstName>' . $this->firstName . '</FirstName>
                         <LastName>' . $this->lastName . '</LastName>
                    <Phone>
                         <CountryCode>' . $this->countryCode . '</CountryCode>
                         <ContactNo>' . $this->contactNo . '</ContactNo>
                     </Phone>
                    <EmailAddress>' . $this->emailAddress . '</EmailAddress>
                 </ContactData>
             </DriverDetails>';
    }

}
