<?php

use App\Libraries\XmlNode;

class KNOrgDetails extends XmlNode
{
    public function __construct(array $knOrgDetails = [])
    {
        parent::__construct(
            $knOrgDetails,
            [
                'companyCode' => '',
                'branchCode' => '',
                'departmentCode' => '',
                'physicalReceiver' => '',
                'logicalReceiver' => '',
                'physicalSender' => '',
                'logicalSender' => '',
            ]
        );
    }

    public function setCompanyCode(string $companyCode): void
    {
        $this->companyCode = $companyCode;
    }

    public function getCompanyCode(): string
    {
        return $this->companyCode;
    }

    public function setBranchCode(string $branchCode): void
    {
        $this->branchCode = $branchCode;
    }

    public function getBranchCode(): string
    {
        return $this->branchCode;
    }

    public function setDepartmentCode(string $departmentCode): void
    {
        $this->departmentCode = $departmentCode;
    }

    public function getDepartmentCode(): string
    {
        return $this->departmentCode;
    }

    public function setPhysicalReceiver(string $physicalReceiver): void
    {
        $this->physicalReceiver = $physicalReceiver;
    }

    public function getPhysicalReceiver(): string
    {
        return $this->physicalReceiver;
    }

    public function setLogicalReceiver(string $logicalReceiver): void
    {
        $this->logicalReceiver = $logicalReceiver;
    }

    public function getLogicalReceiver(): string
    {
        return $this->logicalReceiver;
    }

    public function setPhysicalSender(string $physicalSender): void
    {
        $this->physicalSender = $physicalSender;
    }

    public function getPhysicalSender(): string
    {
        return $this->physicalSender;
    }

    public function setLogicalSender(string $logicalSender): void
    {
        $this->logicalSender = $logicalSender;
    }

    public function getLogicalSender(): string
    {
        return $this->logicalSender;
    }

    public function getXml(): string
    {
        return '<KNOrgDetails>
                 <CompanyCode>' . $this->companyCode . '</CompanyCode>
                 <BranchCode>' . $this->branchCode . '</BranchCode>
                 <PhysicalReceiver>' . $this->physicalReceiver . '</PhysicalReceiver>
                 <LogicalReceiver>' . $this->logicalReceiver . '</LogicalReceiver>
                 <PhysicalSender>' . $this->physicalSender . '</PhysicalSender>
                 <LogicalSender>' . $this->logicalSender . '</LogicalSender>
             </KNOrgDetails>';
    }
}
