<?php

use App\Libraries\XmlNode;

class ManageReferences extends XmlNode
{
    public function __construct(array $manageReferences = [])
    {
        parent::__construct(
            $manageReferences,
            [
                'refTypeCode' => '',
                'refTypeValue' => '',
            ]
        );
    }

    public function setRefTypeCode(string $refTypeCode): void
    {
        $this->refTypeCode = $refTypeCode;
    }

    public function getRefTypeCode(): string
    {
        return $this->refTypeCode;
    }

    public function setRefTypeValue(string $refTypeValue): void
    {
        $this->refTypeValue = $refTypeValue;
    }

    public function getRefTypeValue(): string
    {
        return $this->refTypeValue;
    }

    public function getXml(): string
    {
        return '<RefType>
                <Code>' . $this->refTypeCode . '</Code>
                <Value>' . $this->refTypeValue . '</Value>
             </RefType>';
    }

    private static function encloseWithinManageReferences(string $childTags): string
    {
        return '<ManageReferences>' . $childTags . '</ManageReferences>';
    }
}
