<?php

use App\Libraries\XmlNode;

class OrderCargoDetails extends XmlNode
{
    public function __construct(array $orderCargoDetails = [])
    {
        parent::__construct(
            $orderCargoDetails,
            [
                'cargoType' => '',
                'handlingUnit' => '',
                'quantity' => '',
                'lengthValue' => '',
                'lengthUOM' => '',
                'widthValue' => '',
                'widthUOM' => '',
                'heightValue' => '',
                'heightUOM' => '',
                'weightValue' => '',
                'weightUOM' => '',
                'totalVolumeValue' => '',
                'totalVolumeUOM' => '',
                'totalWeightValue' => '',
                'totalWeightUOM' => '',
                'stackable' => '',
                'grounded' => '',
                'splittable' => '',
                'dangerousGoodsFlag' => '',
                'cargoDescription' => '',
                'ldm' => 0.0,
                'ldmUOM' => '',
                'volumetricWeight' => 0.0,
                'volumetricWeightUOM' => '',
            ]
        );
    }

    public function __set(string $name, $value)
    {
        switch (strtolower($name)) {
            case 'lengthuom':
            case 'widthuom':
            case 'heightuom':
            case 'weightuom':
            case 'totalvolumeuom':
            case 'totalweightuom':
            case 'ldmuom':
            case 'volumetricweightuom':
                parent::__set($name, strtolower($value));
                break;

            default:
                parent::__set($name, $value);
        }
    }

    public function setCargoType(string $cargoType): void
    {
        $this->cargoType = $cargoType;
    }

    public function getCargoType(): string
    {
        return $this->cargoType;
    }

    public function setHandlingUnit(string $handlingUnit): void
    {
        $this->handlingUnit = $handlingUnit;
    }

    public function getHandlingUnit(): string
    {
        return $this->handlingUnit;
    }

    public function setQuantity(string $quantity): void
    {
        $this->quantity = $quantity;
    }

    public function getQuantity(): string
    {
        return $this->quantity;
    }

    public function setLengthValue(string $lengthValue): void
    {
        $this->lengthValue = $lengthValue;
    }

    public function getLengthValue(): string
    {
        return $this->lengthValue;
    }

    public function setLengthUOM(string $lengthUOM): void
    {
        $this->lengthUOM = $lengthUOM;
    }
    public function getLengthUOM(): string

    {
        return $this->lengthUOM;
    }

    public function setWidthValue(string $widthValue): void
    {
        $this->widthValue = $widthValue;
    }

    public function getWidthValue(): string
    {
        return $this->widthValue;
    }

    public function setWidthUOM(string $widthUOM): void
    {
        $this->widthUOM = $widthUOM;
    }

    public function getWidthUOM(): string
    {
        return $this->widthUOM;
    }

    public function setHeightValue(string $heightValue): void
    {
        $this->heightValue = $heightValue;
    }

    public function getHeightValue(): string
    {
        return $this->heightValue;
    }

    public function setHeightUOM(string $heightUOM): void
    {
        $this->heightUOM = $heightUOM;
    }

    public function getHeightUOM(): string
    {
        return $this->heightUOM;
    }

    public function setWeightValue(string $weightValue): void
    {
        $this->weightValue = $weightValue;
    }

    public function getWeightValue(): string
    {
        return $this->weightValue;
    }

    public function setWeightUOM(string $weightUOM): void
    {
        $this->weightUOM = $weightUOM;
    }

    public function getWeightUOM(): string
    {
        return $this->weightUOM;
    }

    public function setTotalVolumeValue(string $totalVolumeValue): void
    {
        $this->totalVolumeValue = $totalVolumeValue;
    }

    public function getTotalVolumeValue(): string
    {
        return $this->totalVolumeValue;
    }

    public function setTotalVolumeUOM(string $totalVolumeUOM): void
    {
        $this->totalVolumeUOM = $totalVolumeUOM;
    }

    public function getTotalVolumeUOM(): string
    {
        return $this->totalVolumeUOM;
    }

    public function setTotalWeightValue(string $totalWeightValue): void
    {
        $this->totalWeightValue = $totalWeightValue;
    }

    public function getTotalWeightValue(): string
    {
        return $this->totalWeightValue;
    }

    public function setTotalWeightUOM(string $totalWeightUOM): void
    {
        $this->totalWeightUOM = $totalWeightUOM;
    }

    public function getTotalWeightUOM(): string
    {
        return $this->totalWeightUOM;
    }

    public function setStackable(string $stackable): void
    {
        $this->stackable = $this->booleanToReadableString($stackable);
    }

    public function getStackable(): string
    {
        return $this->stackable;
    }

    public function setGrounded(string $grounded): void
    {
        $this->grounded = $this->booleanToReadableString($grounded);
    }

    public function getGrounded(): string
    {
        return $this->grounded;
    }

    public function setSplittable(string $splittable): void
    {
        $this->splittable = $this->booleanToReadableString($splittable);
    }

    public function getSplittable(): string
    {
        return $this->splittable;
    }

    public function setDangerousGoodsFlag(string $dangerousGoodsFlag): void
    {
        $this->dangerousGoodsFlag = $this->booleanToReadableString($dangerousGoodsFlag);
    }

    public function getDangerousGoodsFlag(): string
    {
        return $this->dangerousGoodsFlag;
    }

    public function setCargoDescription(string $cargoDescription): void
    {
        $this->cargoDescription = $cargoDescription;
    }

    public function getCargoDescription(): string
    {
        return $this->cargoDescription;
    }

    public function setLdm(string $ldm): void
    {
        $this->ldm = $ldm;
    }

    public function getLdm(): string
    {
        return $this->ldm;
    }

    public function setLdmUOM(string $ldmUOM): void
    {
        $this->ldmUOM = $ldmUOM;
    }

    public function getLdmUOM(): string
    {
        return $this->ldmUOM;
    }

    public function setVolumetricWeight(string $volumetricWeight): void
    {
        $this->volumetricWeight = $volumetricWeight;
    }

    public function getVolumetricWeight(): string
    {
        return $this->volumetricWeight;
    }

    public function setVolumetricWeightUOM(string $volumetricWeightUOM): void
    {
        $this->volumetricWeightUOM = $volumetricWeightUOM;
    }

    public function getVolumetricWeightUOM(): string
    {
        return $this->volumetricWeightUOM;
    }

    public function booleanToReadableString(bool $booleanValue): string
    {
        return (string)(int)$booleanValue;
    }

    public function getXml(): string
    {
        return '<Items>
                    <CargoType>' . $this->cargoType . '</CargoType>
                    <CargoDescription>' . $this->cargoDescription . '</CargoDescription>
                    <Quantity>' . $this->quantity . '</Quantity>
                    <HandlingUnit>' . $this->handlingUnit . '</HandlingUnit>
                    <Stackable>' . $this->stackable . '</Stackable>
                    <Grounded>' . $this->grounded . '</Grounded>
                    <Splittable>' . $this->splittable . '</Splittable>
                    <DangerousGoodsFlag>' . $this->dangerousGoodsFlag . '</DangerousGoodsFlag>
                    <Length>
                         <Value>' . $this->lengthValue . '</Value>
                         <UOM>' . $this->lengthUOM . '</UOM>
                     </Length>
                    <Width>
                         <Value>' . $this->widthValue . '</Value>
                         <UOM>' . $this->widthUOM . '</UOM>
                     </Width>
                    <Height>
                         <Value>' . $this->heightValue . '</Value>
                         <UOM>' . $this->heightUOM . '</UOM>
                     </Height>
                    <Weight>
                         <Value>' . $this->weightValue . '</Value>
                         <UOM>' . $this->weightUOM . '</UOM>
                     </Weight>
                    <ActualVolume>
                         <Value>' . $this->totalVolumeValue . '</Value>
                         <UOM>' . $this->totalVolumeUOM . '</UOM>
                     </ActualVolume>
                    <ActualWeight>
                         <Value>' . $this->totalWeightValue . '</Value>
                         <UOM>' . $this->totalWeightUOM . '</UOM>
                     </ActualWeight>
                     <VolumetricWeight>
                         <Value>' . $this->volumetricWeight . '</Value>
                         <UOM>' . $this->volumetricWeightUOM . '</UOM>
                     </VolumetricWeight>
                     <LDM>' . $this->ldm . '</LDM>
                </Items>';
    }

}
