<?php

use App\Libraries\XmlNode;

class OrderParties extends XmlNode
{
    public function __construct(array $orderParties = [])
    {
        parent::__construct(
            $orderParties,
            [
                'partyID' => '',
                'partyName' => '',
                'partyType' => '',
                'firstName' => '',
                'lastName' => '',
                'countryCode' => '',
                'contactNo' => '',
                'emailAddress' => '',
            ]
        );
    }

    public function setPartyID(string $partyID): void
    {
        $this->partyID = $partyID;
    }

    public function getPartyID(): string
    {
        return $this->partyID;
    }

    public function setPartyName(string $partyName): void
    {
        $this->partyName = $partyName;
    }

    public function getPartyName(): string
    {
        return $this->partyName;
    }

    public function setPartyType(string $partyType): void
    {
        $this->partyType = $partyType;
    }

    public function getPartyType(): string
    {
        return $this->partyType;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setCountryCode(string $countryCode): void
    {
        $this->countryCode = $countryCode;
    }

    public function getCountryCode(): string
    {
        return $this->countryCode;
    }

    public function setContactNo(string $contactNo): void
    {
        $this->contactNo = $contactNo;
    }

    public function getContactNo(): string
    {
        return $this->contactNo;
    }

    public function setEmailAddress(string $emailAddress): void
    {
        $this->emailAddress = $emailAddress;
    }

    public function getEmailAddress(): string
    {
        return $this->emailAddress;
    }

    public function getXml(): string
    {
        return '<PartyType>
                    <PartyID>
                         <ID>' . $this->partyID . '</ID>
                         <Name>' . $this->partyName . '</Name>
                     </PartyID>
                     <Type>' . $this->partyType . '</Type>
                     <ContactData>
                         <FirstName>' . $this->firstName . '</FirstName>
                         <LastName>' . $this->lastName . '</LastName>
                        <Phone>
                             <CountryCode>' . $this->countryCode . '</CountryCode>
                             <ContactNo>' . $this->contactNo . '</ContactNo>
                         </Phone>
                         <EmailAddress>' . $this->emailAddress . '</EmailAddress>
                     </ContactData>
                 </PartyType>';
    }

}
