<?php

use App\Libraries\XmlNode;

class Remarks extends XmlNode
{
    public function __construct(array $remarks = [])
    {
        parent::__construct(
            $remarks,
            [
                'remarkCode' => '',
                'remarkValue' => '',
            ]
        );
    }

    public function setRemarkCode(string $remarkCode): void
    {
        $this->remarkCode = $remarkCode;
    }

    public function getRemarkCode(): string
    {
        return $this->remarkCode;
    }

    public function setRemarkValue(string $remarkValue): void
    {
        $this->remarkValue = $remarkValue;
    }

    public function getRemarkValue(): string
    {
        return $this->remarkValue;
    }

    public function getXml(): string
    {
        return '<Remark>
                 <Value>' . $this->remarkValue . '</Value>
                </Remark>';
    }
}
