<?php

use App\Libraries\XmlNode;

class TermsOfTrade extends XmlNode
{
    public function __construct(array $termOfTrade = [])
    {
        parent::__construct(
            $termOfTrade,
            [
                'termsOfTradeIncoterm' => '',
                'freightNameTerm' => '',
                'freightName' => '',
            ]
        );
    }

    public function setTermsOfTradeIncoterm(string $termsOfTradeIncoterm): void
    {
        $this->termsOfTradeIncoterm = $termsOfTradeIncoterm;
    }

    public function getTermsOfTradeIncoterm(): string
    {
        return $this->termsOfTradeIncoterm;
    }

    public function setFreightNameTerm(string $freightNameTerm): void
    {
        $this->freightNameTerm = $freightNameTerm;
    }

    public function getFreightNameTerm(): string
    {
        return $this->freightNameTerm;
    }

    public function setFreightName(string $freightName): void
    {
        $this->freightName = $freightName;
    }

    public function getFreightName(): string
    {
        return $this->freightName;
    }

    public function getXml(): string
    {
        return '<TermsOfTrade>
                    <Incoterm>' . $this->termsOfTradeIncoterm . '</Incoterm>
                    <FreightName>
                         <Term>' . $this->freightNameTerm . '</Term>
                         <Name>' . $this->freightName . '</Name>
                    </FreightName>
                 </TermsOfTrade>';
    }
}
