<?php

use App\Libraries\XmlNode;

class TripCargoSummary extends XmlNode
{

    public function __construct(array $tripCargoSummary = [])
    {
        parent::__construct(
            $tripCargoSummary,
            [
                'totalQuantityValue' => 0,
                'totalQuantityUOM' => '',
                'totalVolumeValue' => 0,
                'totalVolumeUOM' => '',
                'totalWeightValue' => 0,
                'totalWeightUOM' => '',
            ]
        );
    }

    public function __set(string $name, $value)
    {
        switch (strtolower($name)) {
            case 'totalquantityuom':
            case 'totalvolumeuom':
            case 'totalweightuom':
                parent::__set($name, strtolower($value));
                break;

            default:
                parent::__set($name, $value);
        }
    }

    public function setTotalQuantityValue(int $totalQuantityValue): void
    {
        $this->totalQuantityValue = $totalQuantityValue;
    }

    public function getTotalQuantityValue(): int
    {
        return $this->totalQuantityValue;
    }

    public function setTotalQuantityUOM(string $totalQuantityUOM): void
    {
        $this->totalQuantityUOM = $totalQuantityUOM;
    }

    public function getTotalQuantityUOM(): string
    {
        return $this->totalQuantityUOM;
    }

    public function setTotalVolumeValue(float $totalVolumeValue): void
    {
        $this->totalVolumeValue = $totalVolumeValue;
    }

    public function getTotalVolumeValue(): float
    {
        return $this->totalVolumeValue;
    }

    public function setTotalVolumeUOM(string $totalVolumeUOM): void
    {
        $this->totalVolumeUOM = $totalVolumeUOM;
    }

    public function getTotalVolumeUOM(): string
    {
        return $this->totalVolumeUOM;
    }

    public function setTotalWeightValue(float $totalWeightValue): void
    {
        $this->totalWeightValue = $totalWeightValue;
    }

    public function getTotalWeightValue(): float
    {
        return $this->totalWeightValue;
    }

    public function setTotalWeightUOM(string $totalWeightUOM): void
    {
        $this->totalWeightUOM = $totalWeightUOM;
    }

    public function getTotalWeightUOM(): string
    {
        return $this->totalWeightUOM;
    }

    public function getXml(): string
    {
        return '<TripCargoSummary>
                <TotalQuantity>
                     <Value>' . $this->totalQuantityValue . '</Value>
                 </TotalQuantity>
                <TotalVolume>
                     <Value>' . $this->totalVolumeValue . '</Value>
                     <UOM>' . $this->totalVolumeUOM . '</UOM>
                 </TotalVolume>
                <TotalWeight>
                     <Value>' . $this->totalWeightValue . '</Value>
                     <UOM>' . $this->totalWeightUOM . '</UOM>
                 </TotalWeight>
              </TripCargoSummary>';
    }
}
