<?php

use App\Libraries\XmlNode;

class TripDetailsInfo extends XmlNode
{
    public function __construct(array $tripDetailsInfo = [])
    {
        parent::__construct(
            $tripDetailsInfo,
            [
                'action' => '',
                'tripID' => '',
                'externalTripID' => '',
                'tripType' => '',
                'carrierInstructions' => '',
                'additionalConditions' => '',
                'temperatureRegime' => '',
                'timeForLoadingAndPenalty' => '',
            ]
        );
    }

    public function setAction(string $action): void
    {
        $this->action = $action;
    }

    public function getAction(): string
    {
        return $this->action;
    }

    public function setTripID(string $tripID): void
    {
        $this->tripID = $tripID;
    }

    public function getTripID(): string
    {
        return $this->tripID;
    }

    public function setExternalTripID(string $externalTripID): void
    {
        $this->externalTripID = $externalTripID;
    }

    public function getExternalTripID(): string
    {
        return $this->externalTripID;
    }

    public function setTripType(string $tripType): void
    {
        $this->tripType = $tripType;
    }

    public function getTripType(): string
    {
        return $this->tripType;
    }

    public function getWrappedTripType(): string
    {
        return '<TripType>' . $this->tripType . '</TripType>';
    }

    public function setCarrierInstructions(string $carrierInstructions): void
    {
        $this->carrierInstructions = $carrierInstructions;
    }

    public function getCarrierInstructions(): string
    {
        return $this->carrierInstructions;
    }

    public function setAdditionalConditions(string $additionalConditions): void
    {
        $this->additionalConditions = $additionalConditions;
    }

    public function getAdditionalConditions(): string
    {
        return $this->additionalConditions;
    }

    public function setTemperatureRegime(string $temperatureRegime): void
    {
        $this->temperatureRegime = $temperatureRegime;
    }

    public function getTemperatureRegime(): string
    {
        return $this->temperatureRegime;
    }

    public function setTimeForLoadingAndPenalty(string $timeForLoadingAndPenalty): void
    {
        $this->timeForLoadingAndPenalty = $timeForLoadingAndPenalty;
    }

    public function getTimeForLoadingAndPenalty(): string
    {
        return $this->timeForLoadingAndPenalty;
    }

    public function getXml(): string
    {
        return
            '<Action>' . $this->action . '</Action>
               <TripID>' . $this->tripID . '</TripID>
               <ExternalTripID>' . $this->externalTripID . '</ExternalTripID>';
    }

    public function getWrappedCarrierInstructions($carrierInstructions): string
    {
        return '<CarrierInstructions>' . $carrierInstructions . '</CarrierInstructions>
               <TemperatureRegime>' . $this->temperatureRegime . '</TemperatureRegime>
               <TimeForLoadingAndPenalty>' . $this->timeForLoadingAndPenalty . '</TimeForLoadingAndPenalty>
               <AdditionalConditions>' . $this->additionalConditions . '</AdditionalConditions>';
    }
}
