<?php  defined('BASEPATH') OR exit('No direct script access allowed');
class Aconedimodel extends CI_Model
{

	function gettblrowdata($where,$select,$table,$limit,$start)
	{
		$result = array();
		$this->db->select($select);
		$this->db->from($table);
		$this->db->where($where);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$result = $res->row_array();
		}
		return $result;
	}
	function updatedata($table,$id,$data)
	{
		$this->db->where('id',$id);
		return $this->db->update($table,$data);
	}
	function insertTableData($tablename,$data)
	{
		$res = 0;
		$qry = $this->db->insert($tablename,$data);
		if($qry){
			$res = $this->db->insert_id();
		}
		return $res;
	}
	function getcompanycode($countryname){
		$country_code = "SG";
		$this->db->select("country_code");
		$this->db->from("tbl_country_master");
		$this->db->like("country_name",$countryname);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$country_code = $res->row()->country_code;
		}
		return $country_code;
	}

	public function getallorderdata($whr)
	{
		$this->db->select("o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.shipment_id,o.delivery_datetime,o.drop_endtime,o.pickup_company,o.delivery_company,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,o.transport_mode,o.vehicle_type,o.quantity,o.customer_id,o.vendor_id,o.pickup_custid,o.pickup_partyid,o.drop_custid,o.drop_partyid,o.trip_sts,o.status,o.createdon,o.updatedon,o.shipmentid,d.order_type,d.order_status,d.shipper_id,d.service,d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,d.lane_reference,d.distance,d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,d.department_code");
		$this->db->from("tb_orders o");
		$this->db->join("tb_order_details d","o.order_id=d.order_id","LEFT");
		$this->db->where($whr);
		$this->db->group_by('o.id');
		$chkorder = $this->db->get();
		return $chkorder;
	}


	public function getordertoedit($id)
	{
		$this->db->select("o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.shipment_id,o.delivery_datetime,o.drop_endtime,o.pickup_company,o.delivery_company,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,o.transport_mode,o.vehicle_type,o.quantity,o.customer_id,o.vendor_id,o.pickup_custid,o.pickup_partyid,o.drop_custid,o.drop_partyid,o.trip_sts,o.status,o.createdon,o.updatedon,o.shipmentid,d.order_type,d.order_status,d.shipper_id,d.service,d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,d.lane_reference,d.distance,d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,d.department_code");
		$this->db->from("tb_orders o");
		$this->db->join("tb_order_details d","o.order_id=d.order_id","LEFT");
		$this->db->where("o.id",$id);
		$this->db->limit(1);
		$chkorder = $this->db->get();
		return $chkorder;
	}
	function gettabledata($where,$select,$table)
	{
		$result = array();
		$this->db->select($select);
		$this->db->from($table);
		$this->db->where($where);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$result = $res->result_array();
		}
		return $result;
	}
	function getrevenues($order_id){
		$this->db->select("r.id,r.type,r.recipient_role,r.recipient_code,r.debtor_jfr,r.bu_jfr,r.amount,r.currency,r.exchange_rate,r.foreign_currency,r.remarks,p.name,p.code,p.customeridentifier,p.location_id,p.country,p.street,p.pincode,p.acon_debitor_code ");
		$this->db->from("tb_reveneus r");
		$this->db->join("tbl_party_master p", "r.recipient_code=p.code", "LEFT");
		$this->db->where("r.invoice_status", 1);
		$this->db->where("r.type", 0);
		$this->db->where("r.order_id", $order_id);
		$this->db->where("r.status", 1);
		$this->db->group_by("r.id");
		$revenues = $this->db->get();
		return $revenues;
	}
	function getcharges($revenueid){
		$this->db->select("c.*,c1.charge_code as chargecode");
		$this->db->from("tb_charges c");
		$this->db->join("tb_charge_codes c1", "c.charge_code=c1.id", "LEFT");
		$this->db->where("c.revenue_id", $revenueid);
		$this->db->where("c.status", 1);
		$getcharges = $this->db->get();
		return $getcharges;
	}
	function getparty($order_id){
		$this->db->select("p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.customeridentifier,p.fax,o.party_type");
		$this->db->from("tbl_party_master p");
		$this->db->join("tb_order_parties o", "p.id=o.party_id", "INNER");
		$this->db->where("o.order_id", $order_id);
		$this->db->where("o.status", 1);
		$this->db->where("p.status", 1);
		$this->db->group_by("o.party_type");
		$getparty = $this->db->get();
		return $getparty;
	}
	function checkrevenues($order_id){
		$this->db->select("r.debtor_jfr,p.name,p.code,p.acon_debitor_code,o.order_id,o.shipmentid");
		$this->db->from("tb_reveneus r");
		$this->db->join("tbl_party_master p", "r.recipient_code=p.code", "LEFT");
		$this->db->join("tb_orders o", "r.order_id=o.id", "LEFT");
		$this->db->where("r.invoice_status", 1);
		$this->db->where("r.type", 0);
		$this->db->where("r.order_id", $order_id);
		$this->db->where("r.status", 1);
		$getrevenues = $this->db->get();
		return $getrevenues;
	}
	function getallrevenues($where){
		$xborder_code = "";
		$xborder_cntry = "0";
		$company_code = $this->session->userdata('company_code');
		if(checkAccessConditions('RELATED_2_SG_MY', $company_code)){
			$this->db->select("xborder_code");
			$this->db->from("tb_xborder_country");
			$this->db->where("company_code",$company_code);
			$getxborder_cntry = $this->db->get();
			if($getxborder_cntry->num_rows() > 0){
				$xborder_code = $getxborder_cntry->row()->xborder_code;
			}
			if(strlen($xborder_code) >0){
				$xborder_cntry = 1;
			}
		}
		$this->db->select("r.id,r.type,r.order_id,r.recipient_role,r.recipient_code,r.debtor_jfr,r.bu_jfr,r.invoice_number,r.invoice_date,r.amount,r.currency,r.exchange_rate,r.foreign_currency,r.remarks,p.name,p.code,p.customeridentifier,p.location_id,p.country,p.street,p.pincode,p.acon_debitor_code ");
		$this->db->from("tb_reveneus r");
		$this->db->join("tbl_party_master p", "r.recipient_code=p.code AND r.recipient_name=p.name", "LEFT");
		if($xborder_cntry == "0"){
			$this->db->where("p.company_code", $company_code);
		}
		$this->db->where($where);
		$this->db->group_by("r.id");
		$revenues = $this->db->get();
		return $revenues;
	}
}
