<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Altovaordercreationmodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }

    public function getPickupDetails(int $pickupId): array
    {
        $customerDetails = $this->db->query("SELECT name,phone,state,street,location,pincode, address, email_id, code,country FROM tb_customers WHERE id=? AND status=1 LIMIT 1", [$pickupId]);
        if ($customerDetails->num_rows() > 0) {
            $customerData = [
                'name' => $customerDetails->row()->name,
                'party_id' => $customerDetails->row()->code,
                'address' => $customerDetails->row()->address,
                'pincode' => $customerDetails->row()->pincode,
                'country' => $customerDetails->row()->country,
                'street' => $customerDetails->row()->street,
                'city' => $customerDetails->row()->location,
                'state' => $customerDetails->row()->state,
                'phone' => $customerDetails->row()->phone,
                'email' => $customerDetails->row()->email_id
            ];
        }
        return $customerData ?? [];
    }

    public function getOrderType(int $order_type): string
    {
        $orderType = $this->db->query("SELECT type_name FROM tb_order_types WHERE status ='1' and id=?", [$order_type]);
        return $orderType->num_rows() > 0 ? $orderType->row()->type_name : "";
    }

    public function getOrderService(int $service): string
    {
        $getServicetype = $this->db->query("SELECT name FROM tb_service_master WHERE status ='1' and id=?", [$service]);
        return $getServicetype->num_rows() > 0 ? $getServicetype->row()->name : "";
    }

    public function getPartyType(int $partyType): object
    {
        $partyType = $this->db->select("name")->get_where("tbl_party_types", ["id" => $partyType], 1, 0);
        return $partyType->num_rows() > 0 ? $partyType : (object)[];
    }

    public function getPartyDetails(int $order_id): array
    {
        $partyDetails = $this->db->query(
            "SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code, p.location_id, p.address, p.country,p.state, p.street,p.house_number, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,a.country as pcountry,p.latitude,p.longitude FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 WHERE p.status=1 AND o.order_id= ? GROUP BY o.party_type",
            [$order_id]
        );
        return $partyDetails->num_rows() > 0 ? $partyDetails->result() : [];
    }

    public function getCargoDetails(int $order_id): array
    {
        $total_volume = $total_weight = $total_quantity = 0;
        $cargoDetails = $this->db->query(
            "SELECT p.handling_unit,p.length,p.cargo_id,p.width,
                p.height,p.weight,p.volume,p.quantity,p.quantity_type,p.cargo_content,p.second_weight,
				p.second_volume,p.scanned_quantity,p.ldm,p.volumetric_weight,
                o.cargo_type,
                o.handling_unit,o.weight_unit,o.volume_unit,o.length_unit,o.width_unit,
                o.height_unit,o.goods_description,o.marks_numbers,o.item_id,o.secondweight_uom,o.secondvolume_uom,
                o.grounded,o.stackable,o.splittable,o.dg_goods,o.volweight_uom, p.id as order_cargo_id
                FROM tb_order_cargodetails p LEFT OUTER JOIN `tb_cargo_details` o ON o.id=p.cargo_id
                WHERE p.status=1 AND p.order_id=? AND p.cargo_id!='' GROUP BY p.cargo_id",
            [$order_id]
        );

        if ($cargoDetails->num_rows() > 0) {
            foreach ($cargoDetails->result() as $cargo) {
                $volume = $cargo->volume ?? 1;
                $weight = $cargo->weight ?? 1;
                $inner_cargo_res = $this->common->gettbldata(
                    ["cargo_id" => $cargo->cargo_id],
                    "cargo_type,goods_description,quantity,length,length_unit,
						width,width_unit,height,height_unit,weight,weight_unit,volume,volume_unit",
                    "tb_inner_cargo",
                    0,
                    0
                );
                $total_volume += $volume;
                if (strtoupper($cargo->weight_unit) == "TON" || strtoupper($cargo->weight_unit) == "TONS") {
                    $weight = $cargo->weight * 1000;
                }
                $total_weight += $weight;
                $total_quantity += $cargo->quantity;
                $dgCargoDetails = $this->common->gettbldata(["order_id"=>$order_id,"order_cargo_id" => $cargo->order_cargo_id, "status" => 1], "*", "tb_order_dg_goods", 0, 0);
                $cargos[] = [
                    'handling_unit' => $cargo->handling_unit,
                    'length' => $cargo->length,
                    'cargo_id' => $cargo->cargo_id,
                    'width' => $cargo->width,
                    'height' => $cargo->height,
                    'weight' => $cargo->weight,
                    'volume' => $cargo->volume,
                    'quantity' => $cargo->quantity,
                    'quantity_type' => $cargo->quantity_type,
                    'cargo_content' => $cargo->cargo_content,
                    'second_weight' => $cargo->second_weight,
                    'second_volume' => $cargo->second_volume,
                    'scanned_quantity' => $cargo->scanned_quantity,
                    'ldm' => $cargo->ldm,
                    'volumetric_weight' => $cargo->volumetric_weight,
                    'cargo_type' => $cargo->cargo_type,
                    'weight_unit' => $cargo->weight_unit,
                    'volume_unit' => $cargo->volume_unit,
                    'length_unit' => $cargo->length_unit,
                    'width_unit' => $cargo->width_unit,
                    'height_unit' => $cargo->height_unit,
                    'goods_description' => $cargo->goods_description,
                    'marks_numbers' => $cargo->marks_numbers,
                    'item_id' => $cargo->item_id,
                    'secondweight_uom' => $cargo->secondweight_uom,
                    'secondvolume_uom' => $cargo->secondvolume_uom,
                    'grounded' => $cargo->grounded,
                    'stackable' => $cargo->stackable,
                    'splittable' => $cargo->splittable,
                    'dg_goods' => $cargo->dg_goods,
                    'volweight_uom' => $cargo->volweight_uom,
                    'inner_cargo' => $inner_cargo_res,
                    'dggoods' => (!empty($dgCargoDetails)) ? $dgCargoDetails : []

                ];
            }
        }
        return $cargos ?? [];
    }

    public function getValueAddedServices(int $order_id): array
    {
        $valueAddedServices = [];
        $getValueAddedServices = $this->db->query("SELECT oc.quantity,im.vas_id,im.vas_name FROM tb_order_vas oc,tb_vas_master im WHERE oc.order_id = ? AND im.id = oc.vas_id", [$order_id]);
        if ($getValueAddedServices->num_rows() > 0) {
            foreach ($getValueAddedServices->result() as $valueAddedService) {
                $vas_name = $valueAddedService->vas_name;
                $vas_id = $valueAddedService->vas_id;
                $quantity = $valueAddedService->quantity;
                $valueAddedServices[] = ['quantity' => $quantity, 'vas_id' => $vas_id, 'vas_name' => $vas_name];
            }
        }
        return $valueAddedServices;
    }

    public function getOrderReferences(int $order_id): array
    {
        $getorderReferences = $this->db->query("select reference_id,ref_value from tb_order_references where order_id =?", [$order_id]);
        if ($getorderReferences->num_rows() > 0) {
            foreach ($getorderReferences->result() as $references) {
                $orderReferences[] = ['reference_id' => $references->reference_id, 'ref_value' => $references->ref_value];
            }
        }
        return $orderReferences ?? [];
    }

    public function getPartyRefereces(string $partyId): array
    {
        $partyReferences = $this->db->query("SELECT tpr.name,tpr.value FROM tb_party_reference tpr LEFT OUTER JOIN tbl_party_master tpm ON tpm.id=tpr.partner_id WHERE tpm.code=? AND tpr.status='1'", [$partyId]);
        return $partyReferences->num_rows() > 0 ? $partyReferences->result_array() : [];
    }

    public function getDeliveryTermName(int $delivery_term_id): string
    {
        $getdelivery_term = $this->db->select("term_id,name")->get_where("tb_delivery_terms", ['term_id' => $delivery_term_id]);
        return $getdelivery_term->num_rows() > 0 ? $getdelivery_term->row()->name : "";
    }

    public function checkAltovaCustomer(int $order_id): int
    {
        $altovaCustomer = $this->db->query("SELECT tpr.`reference_type`,tpr.`name`,tpr.`value` FROM tb_orders o LEFT OUTER JOIN tb_customers tc ON tc.id=o.customer_id LEFT OUTER JOIN tbl_party_master tpm ON tc.code=tpm.code AND o.company_code=tpm.company_code LEFT OUTER JOIN `tb_party_reference` tpr ON tpm.id=tpr.partner_id WHERE o.id=? AND tpr.`status`=1 AND tpr.name='Send to Altova' AND UPPER(value) = 'Y'", [$order_id]);
        return $altovaCustomer->num_rows() ?? 0;
    }

    public function getOrderUserTimeZone(int $user_id): array
    {
        $orderUserTimeZone = $this->db->query("SELECT tc.country_name,tc.country_code,tc.cntry_timezone,tc.cntry_hrs,tc.currency,tc.phone_code FROM tb_users u JOIN tbl_country_master tc ON u.country_code=tc.country_code  WHERE u.id=?", [$user_id]);
        return $orderUserTimeZone->num_rows() > 0 ? $orderUserTimeZone->row_array() : [];
    }

    public function checkCustomerStatus(string $bookingId): int
    {
        $altovaCustomerStatus = $this->db->query("SELECT tpr.`reference_type`,tpr.`name`,tpr.`value` FROM tb_orders o LEFT OUTER JOIN tb_customers tc ON tc.id=o.customer_id LEFT OUTER JOIN tbl_party_master tpm ON tc.code=tpm.code LEFT OUTER JOIN `tb_party_reference` tpr ON tpm.id=tpr.partner_id WHERE o.order_id=? AND tpr.`status`=1 AND tpr.name='STATUS_XML_FORMAT' AND UPPER(value) = 'F'", [$bookingId]);
        return $altovaCustomerStatus->num_rows() ?? 0;
    }

    public function getOrderTripDetails(string $bookingId): array
    {
        $orderTripDetailsResult = $this->db->query(
            "SELECT o.id, o.order_id,o.user_id, o.company_code,o.branch_code, ttd.`truck_number`, ttd.`register_number`,ttt.`trucktype`, ttd.`truck_brand`,ttda.`name` AS drivername,ttda.`contact_num` AS drivernumber,ttda.`driver_national_identification_number`, ttda.driving_licence_num,o.shipmentid, o.vendor_id  FROM tb_orders o LEFT JOIN tb_shft_veh  tsv ON tsv.shft_id=o.shift_id AND tsv.status=1 LEFT JOIN tb_trips tt ON tt.shift_id = o.shift_id AND tt.status=1 LEFT JOIN `tb_trucks_data` ttd ON ttd.id=tsv.vehicle_id AND ttd.status=1 LEFT JOIN `tb_truck_drivers` ttda ON ttda.id = tt.driver_id AND ttda.status=1 LEFT JOIN  `tb_trucktypes` ttt ON ttt.id=ttd.`truck_type` AND ttt.status=1 WHERE o.order_id = ?",
            [$bookingId]
        );
        return $orderTripDetailsResult->num_rows() > 0 ? $orderTripDetailsResult->row_array() : [];
    }

    public function getOrderCarrier(string $vendor_id): array
    {
        $OrderCarrier = $this->db->query(
            "SELECT tpm.name,tpm.code,tpm.`email`,tpm.`mobile`,tpm.`location_id` AS city,tpm.address, tpm.country,tpm.state, tpm.street, tpm.pincode  FROM tb_vendors tv LEFT JOIN tbl_party_master tpm ON tv.code= tpm.code WHERE tv.id = ? AND tpm.status=1", [$vendor_id]
        );
        return $OrderCarrier->num_rows() > 0 ? $OrderCarrier->row_array() : [];
    }

    public function getOrderStatus(string $bookingId, string $statusCode): array
    {
        $orderStatusListResult = $this->db->query(
            "SELECT o.id,tss.id as statusrowid, o.order_id,o.user_id, o.company_code,o.branch_code,tss.status_code,tsm.`status_name`,tss.`stop_type`,tss.`latitude`,tss.`longitude`, tss.`loc_name`,tss.`next_stop_eta`,tss.`next_stop_duration`,tss.`createdon`,tss.reason AS statusdate,tss.status_stage FROM tb_orders o LEFT JOIN tb_stop_status tss ON tss.`shipment_id`=o.shift_id LEFT JOIN `tb_status_master` tsm ON tss.`status_code`=tsm.status_code AND tss.status_id=tsm.id WHERE o.id = ? AND tss.status_code = ? ",
            [$bookingId, $statusCode]
        );
        if ($orderStatusListResult->num_rows() > 0) {
            foreach ($orderStatusListResult->result_array() as $orders) {
                $orderStatusList[] = $orders;
            }
        }
        $orderStatusResult = $this->db->query("SELECT o.id, tos.id as statusrowid, o.order_id,o.company_code,o.branch_code,tos.status_code,tsm.`status_name`,tos.`latitude`,tos.`longitude`,tos.`createdon` AS statusdate FROM tb_orders o LEFT JOIN `tb_order_status` tos ON tos.order_id= o.id LEFT JOIN `tb_status_master` tsm ON tos.`status_code`=tsm.status_code  WHERE o.id = ? AND tos.`status_code` = ? ", [$bookingId, $statusCode]);
        if ($orderStatusResult->num_rows() > 0) {
            foreach ($orderStatusResult->result_array() as $orders) {
                $orderStatusList[] = $orders;
            }
        }

        return $orderStatusList ?? [];
    }

    public function getOrderReasonStatus(string $bookingId, string $statusrowid): array
    {
        $orderStatusListResult = $this->db->query(
            "SELECT o.id,tss.id as statusrowid, o.order_id,o.user_id, o.company_code,o.branch_code,tss.status_code,tsm.`status_name`,tss.`stop_type`,tss.`latitude`,tss.`longitude`, tss.`loc_name`,tss.`next_stop_eta`,tss.`next_stop_duration`,tss.`createdon`,tss.reason AS statusdate,tss.status_stage FROM tb_orders o LEFT JOIN tb_stop_status tss ON tss.`shipment_id`=o.shift_id LEFT JOIN `tb_status_master` tsm ON tss.`status_code`=tsm.status_code AND tss.status_id=tsm.id WHERE o.id = ? AND tss.id < ? ORDER BY tss.id DESC",
            [$bookingId, $statusrowid]
        );
        return $orderStatusListResult->num_rows() > 0 ? $orderStatusListResult->row_array() : [];
    }


}
