<?php

class Aquaticamodel extends CI_Model
{

    // old
    public function gettruckreportdata($userid, $custid, $countryuids, $fromdate, $todate, $ordtype, $carrier)
    {
        $result = array();
        $fromdate = date('Y-m-d', strtotime($fromdate));
        $todate = date('Y-m-d', strtotime($todate));
        $this->db->select("o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,o.company_code,o.branch_code,o.status as tripstatus,o.trip_sts,o.createdon,d.department_code,o.status,o.trip_sts,s.shipid,o.vendor_id, o.pickup_company, o.pickup_city, o.delivery_city,o.pickup_datetime");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_shipments s", "s.id=o.shipment_id", "LEFT");
        /* $this->db->join("tb_employee e","e.order_id=o.order_id","LEFT"); */
        if (count($carrier) > 0) {
            $this->db->where_in("o.vendor_id", $carrier);
        }
        if ($ordtype == 'pending' || $ordtype == 'ready') {
            $this->db->where("o.status", 1);
        } else if ($ordtype == 'active') {
            $this->db->where("o.status", 2);
            $this->db->where("o.trip_sts", 0);
        } else if ($ordtype == 'closed') {
            $this->db->where("o.status", 2);
            $this->db->where("o.trip_sts", 1);
        } else {
            $this->db->where("o.status !=", 0);
        }
        // $this->db->where("o.status !=",0);
        if (! empty($countryuids)) {
            $this->db->where_in("o.user_id", $countryuids);
        } else {
            $this->db->where("o.user_id", $userid);
        }
        if ($custid != "") {
            $this->db->where('o.customer_id', $custid);
        }
        // $this->db->where('o.createdon >=', $fromdate);
        // $this->db->where('o.createdon <=', $todate);
        $this->db->where("DATE_FORMAT(o.createdon,'%Y-%m-%d') >= '" . $fromdate . "'", NULL, FALSE);
        $this->db->where("DATE_FORMAT(o.createdon,'%Y-%m-%d') <= '" . $todate . "'", NULL, FALSE);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }
        return $result;
    }

    // new
    public function getshipmentreportdata($userid, $custid, $countryuids, $fromdate, $todate, $ordtype, $carrier)
    {
        $result = array();
        $fromdate = date('Y-m-d', strtotime($fromdate));
        $todate = date('Y-m-d', strtotime($todate));
        $this->db->select("o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,o.company_code,o.branch_code,o.status as tripstatus,o.trip_sts,o.createdon,d.department_code,o.status,o.trip_sts,s.shipid,o.vendor_id, o.pickup_company, o.pickup_city, o.delivery_city,o.pickup_datetime,o.goods_value,o.transport_mode");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_shipments s", "s.id=o.shipment_id", "LEFT");
        if (count($carrier) > 0) {
            $this->db->where_in("o.vendor_id", $carrier);
        }
        if ($ordtype == 'pending' || $ordtype == 'ready') {
            $this->db->where("o.status", 1);
        } else if ($ordtype == 'active') {
            $this->db->where("o.status", 2);
            $this->db->where("o.trip_sts", 0);
        } else if ($ordtype == 'closed') {
            $this->db->where("o.status", 2);
            $this->db->where("o.trip_sts", 1);
        } else {
            $this->db->where("o.status !=", 0);
        }
        if (! empty($countryuids)) {
            $this->db->where_in("o.user_id", $countryuids);
        } else {
            $this->db->where("o.user_id", $userid);
        }
        if ($custid != "") {
            $this->db->where('o.customer_id', $custid);
        }
        $this->db->where("DATE_FORMAT(o.createdon,'%Y-%m-%d') >= '" . $fromdate . "'", NULL, FALSE);
        $this->db->where("DATE_FORMAT(o.createdon,'%Y-%m-%d') <= '" . $todate . "'", NULL, FALSE);
        $this->db->where('o.shift_id !=', 0);
        $this->db->where('o.trip_id  !=', 0);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }
        return $result;
    }

    // new
    public function getsearchdata($userid, $custid, $country_userids, $where)
    {
        $result = array();
        $this->db->select("o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,o.company_code,o.branch_code,o.status as tripstatus,o.trip_sts,o.createdon,d.department_code,o.status,o.trip_sts,s.shipid,o.vendor_id, o.pickup_company, o.pickup_city, o.delivery_city,o.pickup_datetime");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_shipments s", "s.id=o.shipment_id", "LEFT");
        // userid verification
        if (! empty($countryuids)) {
            $this->db->where_in("o.user_id", $countryuids);
        } else {
            $this->db->where("o.user_id", $userid);
        }
        // customer id
        if ($custid != "") {
            $this->db->where('o.customer_id', $custid);
        }
        // orderid
        if ($where['order_id'] != '') {
            $booking_id = $where['order_id'];
            $this->db->like([
                'o.order_id' => $booking_id
            ]);
        }
        // status
        if ($where['status'] != '') {
            $status = $where['status'];
            if ($status == 'pending') {
                $this->db->where("o.status", 1);
            } else if ($status == 'active') {
                $this->db->where("o.status", 2);
                $this->db->where("o.trip_sts", 0);
            } else if ($status == 'closed') {
                $this->db->where("o.status", 2);
                $this->db->where("o.trip_sts", 1);
            } else {
                $this->db->where("o.status !=", 0);
            }
        }
        // carrierid
        if ($where['vendor_id'] != '') {
            $carrier = $where['vendor_id'];
            if (count($carrier) > 0) {
                $this->db->where_in("o.vendor_id", $carrier);
            }
        }
        $this->db->where('o.shift_id !=', 0);
        $this->db->where('o.trip_id  !=', 0);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }
        return $result;
    }

    // old
    public function getreferencedetails($id)
    {
        $getrefdetails = $this->db->query("SELECT ref_value FROM tb_order_references WHERE status='1' AND reference_id='DQ' AND order_id='" . $id . "' LIMIT 1");
        return $getrefdetails;
    }

    // new
    public function getreferenceorderdetails($id, $reference_id)
    {
        $getreforderdetails = $this->db->query("SELECT ref_value FROM tb_order_references WHERE status='1' AND reference_id='$reference_id' AND order_id='" . $id . "' LIMIT 1");
        return $getreforderdetails;
    }

    // old and not used
    public function getsupdetails($ordernum)
    {
        $getsupdetails = $this->db->query("select tps.createdon, te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = 11 AND
ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "' order by tps.id desc");
        return $getsupdetails;
    }

    // old and not used
    public function getcanceldetails($ordernum)
    {
        $getcandetails = $this->db->query("select tps.createdon,te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id in (6,7,8) AND ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "'order by tps.id desc");
        return $getcandetails;
    }

    // old
    public function getdelconsigdetails($ordernum)
    {
        $getdeldetails = $this->db->query(" select tps.createdon,te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = 3 AND tps.stop_type='D' AND ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "' order by tps.id desc");
        return $getdeldetails;
    }

    // new
    public function getdeliveryconsigdetails($ordernum, $status_id, $stop_type)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $getdeliverydetails = $this->db->query(" select convertToClientTZ(tps.createdon,'" . $curtz . "') as createdon,te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = '" . $status_id . "' AND tps.stop_type='" . $stop_type . "' AND ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "' order by tps.id desc");
        // $getdeliverydetails = $this->db->query(" select tps.createdon,te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = '".$status_id."' AND tps.stop_type='".$stop_type."' AND ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='".$ordernum."' order by tps.id desc");
        return $getdeliverydetails;
    }

    // new
    public function getpickupshipdateils($ordernum, $status_id)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        // $getpickdateils = $this->db->query("select convertToClientTZ(tps.createdon,'".$curtz."') as createdon from `tb_stop_status` tps,`tb_orders` o where tps.status_id = '".$status_id."' AND o.shift_id=tps.shipment_id AND o.order_id='".$ordernum."' order by tps.id desc");
        $getpickdateils = $this->db->query("select convertToClientTZ(tps.createdon,'" . $curtz . "') as createdon,convertToClientTZ(o.delivery_datetime,'" . $curtz . "') as estimate_d_date from `tb_stop_status` tps,`tb_orders` o where tps.status_id = '" . $status_id . "' AND o.shift_id=tps.shipment_id AND o.order_id='" . $ordernum . "' order by tps.id desc");
        // print_r($this->db->last_query());die();
        return $getpickdateils;
    }

    // new
    public function getlaststoptransdetails($order_id, $shipment_id)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $result = array();
        /* add in status_code='3000' */
        $getlaststatusdetails = $this->db->query("select sm.id,sm.status_name,tps.stop_type,tps.latitude,tps.longitude,tps.loc_name,tps.status_id, tps.status_code,tps.createdon from `tb_stop_status` tps,`tb_status_master` sm where sm.id=tps.status_id AND tps.shipment_id='" . $shipment_id . "' AND  tps.shipment_id !=0 AND tps.status_code='3000' order by tps.id desc LIMIT 1");
        if ($getlaststatusdetails->num_rows() > 0) {
            $result = $getlaststatusdetails;
        } else {
            $getlaststatusdetails = $this->db->query("select sm.id,sm.status_name,tps.stop_type,tps.latitude,tps.longitude,tps.loc_name,tps.status_id, tps.status_code,tps.createdon from `tb_stop_status` tps,`tb_status_master` sm where sm.id=tps.status_id AND tps.shipment_id='" . $shipment_id . "' AND  tps.shipment_id !=0 order by tps.id desc LIMIT 1");
            $result = $getlaststatusdetails;
        }
        return $result;
    }

    public function getorderdata($whr, $wherein, $other_checks, $general_array)
    {
        $orderTableCondition = array();
        if (! empty($whr)) {
            foreach ($whr as $key => $value) {
                $value = "'$value'";
                if ($key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key == "DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <=") {
                    $orderTableCondition[] = $key . $value;
                } else {
                    $orderTableCondition[] = $key . ' = ' . $value;
                }
            }
        }
        $orderTableCondition[] = 'o.status!=0';
        if (isset($wherein) && ! empty($wherein)) {
            if (isset($wherein['vendor_id']) && $wherein['vendor_id'] != "") {
                $vendorIds = implode(',', $wherein['vendor_id']);
                if ($vendorIds != '') {
                    $orderTableCondition[] = "o.vendor_id in ($vendorIds)";
                }
            }
        }
        if (isset($other_checks) && ! empty($other_checks)) {
            if (isset($other_checks['status_search']) && ! empty($other_checks['status_search'])) {
                $status_search = $other_checks['status_search'];
                if ($status_search == 'PENDING') {
                    $orderTableCondition[] = "o.trip_id = 0";
                } else if ($status_search == 'ACTIVE') {
                    $orderTableCondition[] = "o.trip_id!= 0";
                    $orderTableCondition[] = "o.trip_sts= 0";
                } else if ($status_search == 'CLOSED') {
                    $orderTableCondition[] = "o.trip_id!= 0";
                    $orderTableCondition[] = "o.trip_sts= 1";
                }
            }
        }
        $result = $country_userids = $subcusts = array();
        $status_search = $userid = $custid = $business_type = "";
        if (isset($general_array) && ! empty($general_array) && count($general_array) > 0) {
            $userid = $general_array['userid'];
            $custid = $general_array['custid'];
            $business_type = $general_array['business_type'];
            $country_userids = $general_array['country_userids'];
            $subcusts = $general_array['subcusts'];
        }

        if ($userid != '0' && $userid != '') {
            if (! empty($country_userids) && count($country_userids) > 0) {
                $countryuseridsArray = implode(',', $country_userids);
                if ($countryuseridsArray != '') {
                    $orderTableCondition[] = "o.user_id in ($countryuseridsArray)";
                }
            } else {
                $orderTableCondition[] = "o.user_id = '$userid' ";
            }
        }

        $orderTableWhere = implode(' AND ', $orderTableCondition);
        $getOrderIdsQuery = "select id as order_numbers,order_id from tb_orders o where o.id!=''  ";
        if ($orderTableWhere != '') {
            $getOrderIdsQuery .= " and $orderTableWhere";
        }

        $orderNumbers = $vendor_order_num = '';
        $dat = $this->db->query($getOrderIdsQuery);
        /* log_message('error','getOrderIdsQuery::'.$this->db->last_query().'------------->'); */
        if ($dat->num_rows() > 0) {
            $resultant = $dat->result_array();
            if (! empty($resultant) && sizeof($resultant) > 0) {
                foreach ($resultant as $eachOrdNum) {
                    $orderNumbers = $orderNumbers . $eachOrdNum['order_numbers'] . ',';
                    $vendor_order_num = $vendor_order_num . "'" . $eachOrdNum['order_id'] . "'" . ',';
                }
            }
            $orderNumbers = trim($orderNumbers, ',');
            $vendor_order_num = trim($vendor_order_num, ',');
        }
        /*
         * log_message('error','orderNumbers :: '.json_encode($orderNumbers).'------------->');
         * log_message('error','vendor_order_num :: '.json_encode($vendor_order_num).'------------->');
         */
        $company_code = $this->session->userdata("company_code");
        $curtz = $this->session->userdata("usr_tzone")['timezone'];

        $vendorCon = '';
        if ($orderNumbers != '') {
            $vendorCon = " and e.order_id in ($vendor_order_num)";
        }

        $vendor_sub = "(
                SELECT v.name,e.order_id FROM tb_vendors v inner join tb_employee e on e.vendor_id=v.id where e.order_id!='' $vendorCon
            ) as vendor_sub";

        $refCon = '';
        if ($orderNumbers != '') {
            $refCon = " and order_id in ($orderNumbers)";
        }

        $reference_sub = "(select order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
                SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                FROM tb_order_references ar where
                reference_id IN ('DQ','PO','BN','CTR','COI','LPC') and status='1'   $refCon
                group by order_id,reference_id
                ) as a
                group by order_id ) as reference_sub ";

        $cargoCon = '';
        if ($orderNumbers != '') {
            $cargoCon = " and c.order_id in ($orderNumbers)";
        }

        if ($company_code == 'AUKN') {
            $refNumColumn = "cargo_content_sub.ref_order_num,";
            /*
             * $cargo_sub = " (select order_id, cargo_content,ref_order_num,totwg,totqty,volumetric_weight,totvolume,scanned_quantity
             * from (
             * SELECT order_id,group_concat(cargo_content SEPARATOR '?????') as cargo_content, GROUP_CONCAT(ref_order_num) as ref_order_num,
             * sum(c.weight) as totwg,
             * sum(c.quantity) as totqty,
             * sum(c.volumetric_weight) as volumetric_weight,
             * sum(c.volume) as totvolume,
             * sum(c.scanned_quantity) as scanned_quantity
             * FROM tb_order_cargodetails c
             * left join tb_inner_cargo i on i.cargo_id= c.cargo_id
             * where c.status=1 and c.order_id>0 $cargoCon
             * group by c.order_id) as inner_cargo ) as cargo_content_sub";
             */
            $cargo_sub = " (select order_id, cargo_content,totwg,totqty,volumetric_weight,totvolume,cargo_order_count,inner_cargo.scanned_quantity,Group_concat(ref_order_num)  AS ref_order_num from (
                SELECT order_id,
                               Group_concat(cargo_content SEPARATOR '?????') AS cargo_content,
                                c.cargo_id,
                               Count(c.id)                                   AS cargo_order_count,
                               Sum(c.weight)                                 AS totwg,
                               Sum(c.quantity)                               AS totqty,
                               Sum(c.volumetric_weight)                      AS
                               volumetric_weight,
                               Sum(c.volume)                                 AS totvolume,
                               Sum(c.scanned_quantity)                       AS scanned_quantity
                        FROM   tb_order_cargodetails c
                        WHERE  c.status = 1
                               AND c.order_id > 0
                             $cargoCon
                        GROUP  BY c.order_id ) as inner_cargo
                        LEFT JOIN tb_inner_cargo i
                        ON i.cargo_id = inner_cargo.cargo_id
                        group by inner_cargo.order_id) as cargo_content_sub";
        } else {
            $refNumColumn = '';
            $cargo_sub = " (select order_id, cargo_content,totwg,totqty,volumetric_weight,totvolume,scanned_quantity from (
                    SELECT order_id,group_concat(cargo_content SEPARATOR '?????') as cargo_content,
                    sum(c.weight) as totwg,
                    sum(c.quantity) as totqty,
                    sum(c.volumetric_weight) as volumetric_weight,
                    sum(c.volume) as totvolume,
                    sum(c.scanned_quantity) as scanned_quantity
                    FROM tb_order_cargodetails c
                    where status=1 and order_id>0  $cargoCon group by order_id
                    ) as inner_cargo ) as cargo_content_sub";
        }

        $genCon = '';
        if ($orderNumbers != '') {
            $genCon = " and order_id in ($orderNumbers)";
        }

        $pickup_ship_sub = " ( select createdon,order_id,shipment_id from ( SELECT convertToClientTZ(createdon,'" . $curtz . "') as createdon,
        order_id,shipment_id  FROM tb_stop_status WHERE status_id=1 and order_id!=0  $genCon  order by order_id desc )
            as pickup_inner )
            as pickup_ship_sub
        ";
        /* log_message('error','pickup_ship_sub::'.$pickup_ship_sub.'------------->'); */

        $getstatus = "";
        if ($this->session->userdata('company_code') == "AUKN" && ($this->session->userdata('user_role_id') == '2' || $this->session->userdata('user_role_id') == '1')) {
            $getstatus = ",osd.status_date as scanned_date,om.status_date as manifestdated,a.createdon as accepted,t.createdon as transit,g.createdon as gateout,p.createdon as pickupdate,de.createdon as delivered_time";
        }
        $this->db->select($refNumColumn . "cargo_content_sub.cargo_content, cargo_content_sub.totwg, cargo_content_sub.totqty,
        cargo_content_sub.volumetric_weight,cargo_content_sub.totvolume,cargo_content_sub.scanned_quantity,
        reference_sub.reference_value as order_reference_value,vendor_sub.name as vendor_name,

        convertToClientTZ(o.delivery_datetime,'" . $curtz . "') as estimate_d_date,
        pickup_ship_sub.createdon as estimated_pickup_time,

        o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,
        o.pickup_address2 as shipper_state,o.delivery_address2 as consignee_state,o.delivery_pincode,o.pickup_pincode,
        o.transport_mode,o.goods_value,o.vendor_id,o.shipment_id,o.pickup_city,o.delivery_city,o.status,o.trip_sts,
        o.trip_id, o.shipmentid,o.createdon,d.consignment_note,
        o.shift_id,o.pickup_datetime,o.drop_endtime,o.delivery_datetime,d.num_of_pallets,pod.doc_type,pod.imgpath,pod.receiver_name,pod.createdon as pod_available,cust.name as customer_name,cust.code as customer_code" . $getstatus);
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_customers cust", "o.customer_id=cust.id", "LEFT");
        // $this->db->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        if (isset($general_array['company_code']) && $general_array['company_code'] == "AUKN") {
            $this->db->join('tb_vendors vendor_sub', 'vendor_sub.id=o.vendor_id', 'LEFT');
        } else {
            $this->db->join($vendor_sub, 'vendor_sub.order_id=o.order_id', 'LEFT');
        }

        $this->db->join($reference_sub, 'o.id = reference_sub.order_id', 'LEFT');
        $this->db->join($cargo_sub, 'o.id = cargo_content_sub.order_id', 'LEFT');

        $this->db->join($pickup_ship_sub, 'o.shift_id=pickup_ship_sub.shipment_id', 'LEFT');

        if ($this->session->userdata('company_code') == "AUKN" && ($this->session->userdata('user_role_id') == '2' || $this->session->userdata('user_role_id') == '1')) {
            $this->db->join("tb_order_status osd", "o.id=osd.order_id AND osd.status_code ='2491' AND osd.status ='1'", "LEFT");
            $this->db->join("tb_order_status om", "o.id=om.order_id AND om.status_code ='2492' AND om.status ='1'", "LEFT");
            $this->db->join("tb_stop_status a", "o.shift_id=a.shipment_id AND a.status_code ='0212' AND a.shipment_id!='0' AND a.status ='1'", "LEFT");
            $this->db->join("tb_stop_status t", "o.id=t.order_id AND t.status_code ='1550' AND t.status ='1'", "LEFT");
            $this->db->join("tb_stop_status g", "o.id=g.order_id AND g.status_code ='0191' AND g.status ='1'", "LEFT");
            $this->db->join("tb_stop_status p", "o.id=p.order_id AND p.status_code ='0500' AND p.status ='1'", "LEFT");
        }
        if ($this->session->userdata('company_code') == "AUKN") {
            $this->db->join("tb_stop_status de", "o.id=de.order_id AND de.status_code ='3000' AND de.status ='1'", "LEFT");
        }
        $this->db->join("tb_pod_uploads pod", "o.id=pod.order_id AND pod.doc_type ='3' AND pod.stop_type ='D' AND pod.status ='1'", "LEFT");
        $this->db->where("o.status !=", 0);
        if (isset($other_checks) && ! empty($other_checks)) {
            // shipper and consignee
            if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '') && isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                $s = $other_checks['shipper_name'];
                $c = $other_checks['consignee_name'];
                $this->db->join("tb_order_parties p", "p.order_id=o.id", "LEFT");
                $this->db->join("tbl_party_master pm", "pm.id=p.party_id", "LEFT");
                $this->db->where("((pm.name LIKE '%" . $s . "%' OR pm.mobile LIKE '%" . $s . "%' OR pm.code LIKE '%" . $s . "%') OR (pm.name LIKE '%" . $c . "%' OR pm.mobile LIKE '%" . $c . "%' OR pm.code LIKE '%" . $c . "%'))");
            } else if (isset($other_checks['consignee_name']) && ($other_checks['consignee_name'] != '')) {
                $c = $other_checks['consignee_name'];
                $this->db->join("tb_order_parties p", "p.order_id=o.id", "LEFT");
                $this->db->join("tbl_party_master pm", "pm.id=p.party_id", "LEFT");
                $this->db->where("(pm.name LIKE '%" . $c . "%' OR pm.mobile LIKE '%" . $c . "%' OR pm.code LIKE '%" . $c . "%')");
            } else if (isset($other_checks['shipper_name']) && ($other_checks['shipper_name'] != '')) {
                $s = $other_checks['shipper_name'];
                $this->db->join("tb_order_parties p", "p.order_id=o.id", "LEFT");
                $this->db->join("tbl_party_master pm", "pm.id=p.party_id", "LEFT");
                $this->db->where("(pm.name LIKE '%" . $s . "%' OR pm.mobile LIKE '%" . $s . "%' OR pm.code LIKE '%" . $s . "%')");
            }
        }

        if (isset($other_checks) && ! empty($other_checks)) {
            if (isset($other_checks['status_search']) && ! empty($other_checks['status_search'])) {
                $status_search = $other_checks['status_search'];
                if ($status_search == 'PENDING') {
                    $this->db->where("o.trip_id", 0);
                } else if ($status_search == 'ACTIVE') {
                    $this->db->where("o.trip_id !=", 0);
                    $this->db->where("o.trip_sts", 0);
                } else if ($status_search == 'CLOSED') {
                    $this->db->where("o.trip_id !=", 0);
                    $this->db->where("o.trip_sts", 1);
                    $closed_from = isset($other_checks['closed_from_date']) ? $other_checks['closed_from_date'] : "";
                    $closed_to = isset($other_checks['closed_to_date']) ? $other_checks['closed_to_date'] : "";
                    $cwhr = array();
                    if ($closed_from != "") {
                        $cwhr["DATE_FORMAT(de.createdon,'%Y-%m-%d') >="] = $closed_from;
                    }
                    if ($closed_to != "") {
                        $cwhr["DATE_FORMAT(de.createdon,'%Y-%m-%d') <="] = $closed_to;
                    }
                    if (! empty($cwhr)) {
                        $this->db->where($cwhr);
                    }
                } else if ($status_search == 'MANIFESTED') {
                    $this->db->join("tb_order_status os", "os.order_id=o.id", "LEFT");
                    $order_status_arr = array(
                        'os.status' => '1',
                        "os.status_code" => "2492"
                    );
                    $this->db->where($order_status_arr);
                }
            }
        }
        // lr_number
        if (isset($other_checks) && ! empty($other_checks)) {
            if (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '') && isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                $lr_val = $other_checks['lr_number'];
                $cust_ref_val = $other_checks['customer_reference_number'];
                $this->db->join('tb_order_references or', 'or.order_id=o.id', 'LEFT');
                if ($business_type == 'Customer') {
                    $this->db->where("(ref_value like '%" . $lr_val . "%' and or.reference_id='BN' and or.status='1') OR (ref_value like '%" . $cust_ref_val . "'  and or.reference_id='DQ' and or.status='1')");
                } else {
                    $this->db->where("(ref_value like '%" . $lr_val . "%' and or.reference_id='PO' and or.status='1') OR (ref_value like '%" . $cust_ref_val . "'  and or.reference_id='DQ' and or.status='1')");
                }
            } elseif (isset($other_checks['lr_number']) && ($other_checks['lr_number'] != '')) {
                $lr_val = $other_checks['lr_number'];
                $this->db->join('tb_order_references or', 'or.order_id=o.id', 'LEFT');
                if ($business_type == 'Customer') {
                    $this->db->where("(ref_value like '%" . $lr_val . "%' and or.reference_id='BN' and or.status='1')");
                } else {
                    $this->db->where("(ref_value like '%" . $lr_val . "%' and or.reference_id='PO' and or.status='1')");
                }
            } elseif (isset($other_checks['customer_reference_number']) && ($other_checks['customer_reference_number'] != '')) {
                $cust_ref_val = $other_checks['customer_reference_number'];
                $this->db->join('tb_order_references or', 'or.order_id=o.id', 'LEFT');
                $this->db->where("(ref_value like '%" . $cust_ref_val . "%' and or.reference_id='DQ' and or.status='1')");
            }
            // pickdatetime
            if (isset($other_checks['qbook_pickupdatetime']) && ($other_checks['qbook_pickupdatetime'] != '')) {
                $pickdatetime = date("Y-m-d", strtotime($other_checks['qbook_pickupdatetime']));
                $this->db->join('tb_stop_status tps', 'o.shift_id=tps.shipment_id');
                $this->db->where("(tps.status_id='10' and DATE_FORMAT(tps.createdon,'%Y-%m-%d') ='" . $pickdatetime . "') OR (DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') ='" . $pickdatetime . "')");
            }
        }

        /* container number */
        if (isset($other_checks) && ! empty($other_checks)) {
            if (isset($other_checks['container_num']) && ($other_checks['container_num'] != '')) {
                $container_num = $other_checks['container_num'];
                $this->db->join('tb_order_references or', 'or.order_id=o.id', 'LEFT');
                $this->db->where("(or.ref_value like '%" . $container_num . "%' and or.reference_id='CTR' and or.status='1')");
            }
        }

        if ($userid != '0') {
            if (! empty($country_userids) && count($country_userids) > 0) {
                $this->db->where_in("o.user_id", $country_userids);
            } else {
                $this->db->where("o.user_id", $userid);
            }
        }
        // custid
        if (! empty($subcusts) && count($subcusts) > 0) {
            $this->db->where_in("o.customer_id", $subcusts);
        } else {
            if ($custid != "") {
                $this->db->where('o.customer_id', $custid);
            }
        }
        // where checking
        $this->db->where($whr);
        // vendor id
        if (isset($wherein) && ! empty($wherein)) {
            if (isset($wherein['vendor_id']) && $wherein['vendor_id'] != "") {
                $this->db->where_in('o.vendor_id', $wherein['vendor_id']);
            }
        }
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        // print_r($this->db->last_query());die();

        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }

        return $result;
    }

    public function getpoduploads($order_id, $shift_id)
    {
        $getuploads = $this->db->query("SELECT ts.id,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.shipment_id = '$shift_id' AND ts.order_id='$order_id' AND dt.type_name='POD' GROUP BY ts.id");
        return $getuploads;
    }

    public function getEpodDoc($order_id, $shift_id)
    {
        $result = array();
        $this->db->select("imgpath,hash");
        $this->db->from("tb_pod_uploads pod");
        $this->db->join("tb_document_types dt", 'dt.id=pod.doc_type', 'LEFT');
        $this->db->where([
            "pod.shipment_id" => $shift_id
        ]);
        $this->db->where([
            "pod.order_id" => $order_id
        ]);
        $this->db->where([
            "dt.type_name" => 'POD'
        ]);
        $this->db->group_by('pod.id');
        $res = $this->db->get();
        // print_r($this->db->last_query());die();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getOrderDetails($general_array)
    {
        $result = $country_userids = $subcusts = array();
        $userid = $custid = $business_type = "";
        if (isset($general_array) && ! empty($general_array) && count($general_array) > 0) {
            $userid = $general_array['userid'];
            $custid = $general_array['custid'];
            $business_type = $general_array['business_type'];
            $country_userids = $general_array['country_userids'];
            $subcusts = $general_array['subcusts'];
        }
        $this->db->select("o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.goods_value,o.vendor_id,o.shipment_id,o.pickup_city,o.delivery_city,o.status,o.trip_sts,o.shift_id,o.trip_id, o.shipmentid,o.createdon,Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,SUM(Case When c.status = '1' Then c.volumetric_weight Else 0 End) as volumetric_weight,o.shift_id");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        $this->db->where("o.status !=", 0);
        if ($userid != '0') {
            if (! empty($country_userids) && count($country_userids) > 0) {
                $this->db->where_in("o.user_id", $country_userids);
            } else {
                $this->db->where("o.user_id", $userid);
            }
        }
        // custid
        if (! empty($subcusts) && count($subcusts) > 0) {
            $this->db->where_in("o.customer_id", $subcusts);
        } else {
            if ($custid != "") {
                $this->db->where('o.customer_id', $custid);
            }
        }
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }
        return $result;
    }

    public function getaurefnums($whr)
    {
        $result = array();
        $this->db->select("i.ref_order_num");
        $this->db->from("tb_order_cargodetails c");
        $this->db->join("tb_inner_cargo i", "c.cargo_id=i.cargo_id", "LEFT");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getauloadplanconnote($whr)
    {
        $result = array();
        $this->db->select("r.ref_value");
        $this->db->from("tb_order_references r");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
}
