<?php

class AuAwsModel extends CI_Model
{
    private $ci;
    private $orderBookingId=0;

    function __construct()
    {
        parent::__construct();
        $this->ci = &get_instance();
        $this->ci->load->helper(['user', 'Log']);
        $this->ci->load->model(['common']);
    }

    /**
     * @param $userName
     * @param $password
     * @return array
     */
    public function getCustomerData($userName, $password): array
    {
        $this->db->select("name");
        $this->db->from("tb_customers");
        $this->db->group_start();
        $this->db->or_where(["phone" => $userName, "email_id" => $userName, "code" => $userName]);
        $this->db->group_end();
        $this->db->where(["password" => $password, "status" => 1, "company_code" => "KNAU"]);
        $getCustomersData = $this->db->get();
        return (!empty($getCustomersData)) ? $getCustomersData->row_array() : [];
    }

    /**
     * Save the order
     *
     * @param array $data
     * @return bool
     */
    public function saveOrder(array $data): bool
    {
        if (empty($data['external_order_id'])) {
            return false;
        }
        $orderInsertData = [
            'external_order_id' => $data['external_order_id'],
            'goods_value' => $data['goods_value'],
            'currency' => $data['currency'],
            'shipper_id' => $data['shipper_id'],
            'pickup_custid' => $data['orderShipperId'],
            'pickup_partyid' => $data['pickupPartyId'],
            'drop_custid' => $data['orderConsigneeId'],
            'drop_partyid' => $data['dropPartyId'],
            'customer_id' => $data['customer_id'],
            'pickup_country' => $data['pickup_country'],
            'pickup_city' => $data['pickup_city'],
            'pickup_pincode' => $data['pickupPinCode'],
            'pickup_company' => $data['pickup_company'],
            'pickup_address1' => $data['pickup_address1'],
            'pickup_address2' => $data['pickup_address2'],
            'delivery_country' => $data['delivery_country'],
            'delivery_city' => $data['delivery_city'],
            'delivery_pincode' => $data['deliveryPinCode'],
            'delivery_company' => $data['delivery_company'],
            'delivery_address1' => $data['delivery_address1'],
            'delivery_address2' => $data['delivery_address2'],
            'quantity' => $data['quantity'],
            'volume' => $data['volume'],
            'weight' => $data['weight'],
            'pickup_datetime' => $data['pickup_dateTime'],
            'pickup_endtime' => $data['pickup_endTime'],
            'delivery_datetime' => $data['delivery_dateTime'],
            'drop_endtime' => $data['drop_endTime'],
            'company_code' => $data['company_code'],
            'branch_code' => $data['branch_code'],
            'product' => $data['product'],
            'status' => 1,
            'is_created' => 1,
            'createdon' => $data['created_on'],
            'transport_mode' => $data['OrderDetails']['ModeOfTransport'],
            'user_id' => $data['user_id'],
        ];
        /* transaction start */
        $this->db->trans_start();
        /* order insert */
        $orderId = $this->ci->common->insertTableData('tb_orders', $orderInsertData);
        if (empty($orderId)) {
            return $this->rollback("AU_AWS Order Create : Save order Trans status failed rollback");
        }
        $bookingId = generatebookingid(
            [
                "user_id" => $data['user_id'],
                "order_id" => $orderId,
                "country_code" => substr($data['company_code'], 0, 2),
                "company_code" => $data['company_code'],
            ]
        );
        $this->orderBookingId= $bookingId;
        $updateOrderId = $this->db->query(
            'UPDATE tb_orders SET order_id = ? WHERE id = ?',
            [$bookingId, $orderId]
        );
        if (!$updateOrderId) {
            return $this->rollback("AU_AWS Order Create : Booking id updating failed Trans status rollback");
        }
        $data['bookingRowId'] = $orderId;
        $data['bookingId'] = $bookingId;

        if (!$this->saveOrderDetails($data)) {
            return $this->rollback("AU_AWS Order Create : Save order Details failed Trans status rollback");
        }

        if (!$this->saveShipment($data)) {
            return $this->rollback("AU_AWS Order Create : Save Shipment failed Trans status rollback");
        }

        if (!$this->saveCargo($data)) {
            return $this->rollback("AU_AWS Order Create : Save Cargo failed Trans status rollback");
        }

        if (!$this->saveOrderReferences($data)) {
            return $this->rollback("AU_AWS Order Create : Save References failed Trans status rollback");
        }

        /* if (!$this->saveOrderPartys($data)) {
             return $this->rollback("AU_AWS Order Create : Save Order party types failed Trans status rollback");
         }*/

        if (!$this->saveInvolvedParties($data)) {
            return $this->rollback("AU_AWS Order Create : Involved parties types failed Trans status rollback");
        }
        $this->saveRemarks($data);
        $this->db->trans_commit();
        log_info("AU_AWS Order Create : Trans status success");
        return true;
    }

    /**
     * @return int
     */
    public function getOrderBookingId(): int
    {
        return $this->orderBookingId;
    }

    /**
     * roll back all data
     *
     * @param string $logMessage
     * @return bool
     */
    private function rollback(string $logMessage): bool
    {
        $this->db->trans_rollback();
        log_error($logMessage);
        return false;
    }

    /**
     * save order details
     *
     * @param array $orderData
     * @return bool
     */
    private function saveOrderDetails(array $orderData): bool
    {
        if (empty($orderData['bookingId'])) {
            log_error('AU_AWS Order Create : Save order details data unavailable.');
            return false;
        }
        $deliveryTerms = $data['OrderDetails']['DeliveryTerms'] ?? null;
        switch ($deliveryTerms) {
            case 'Shipper':
                $deliveryTermsId = 10;
                break;
            case 'Consignee':
                $deliveryTermsId = 12;
                break;
            default:
                $deliveryTermsId = 82;
        }
        $orderDetails = array(
            'service' => $orderData['serviceId'],
            'delivery_term' => $deliveryTermsId,
            'incoterm' => $orderData['inTerm'],
            'department_code' => $orderData['departmentCode'],
            'temperature_control' => '0',
            'valorance_insurance' => '0',
            'high_cargo_value' => '0',
            'customs_required' => '0',
            'order_row_id' => $orderData['bookingRowId'],
            'order_id' => $orderData['bookingId'],
            'createdon' => $orderData['created_on'],
            'shipper_id' => $orderData['shipperRowId'],
            'order_type' => $orderData['orderTypeRowId'],
            'order_status' => 'Pending',
            'status' => 1
        );
        $orderDetailsId = $this->ci->common->insertTableData('tb_order_details', $orderDetails);
        return !empty($orderDetailsId);
    }

    /**
     * save shipment's
     *
     * @param array $data
     * @return bool
     */
    private function saveShipment(array $data): bool
    {
        if (!isset($data['OrderDetails'])) {
            log_error("AU_AWS Order Create : save Shipment details data unavailable.");
            return false;
        }
        $shipment_id = $this->getShipmentId();
        $shipmentData = [
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $data['modeOfTransportName'] ?? '',
            'pickupcnt' => 1,
            'dropcnt' => 1,
            'unitspec' => 1,
            'insertusr' => $data['shipperId'] ?? 0,
            'carrier' => 0,
            'insertuserdate' => $data['created_on'],
            'enddate' => date('Y-m-d H:i:s', strtotime('+1 day')),
            'insdate' => $data['created_on'],
            'upddate' => $data['created_on'],
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $data['created_on'],
            'transport_mode' => $data['OrderDetails']['ModeOfTransport'],
            'domainname' => $data['KNOrgDetails']['BranchCode'],
            'company_code' => $data['KNOrgDetails']['CompanyCode'],
            'branch_code' => $data['KNOrgDetails']['BranchCode'],
            'product' => $data['OrderDetails']['OrderProductType'],
            'freight_term' => $data['OrderDetails']['TermsOfTrade']['FreightName']['Term'],
            'freight_termname' => $data['OrderDetails']['TermsOfTrade']['FreightName']['Name'],
            'incoterm' => $data['OrderDetails']['TermsOfTrade']['Incoterm'],
            'modeoftransport' => $data['modeOfTransportId'],
            'createdon' => $data['created_on']
        ];
        $shipmentRowId = $this->ci->common->insertTableData('tb_shipments', $shipmentData);
        if (!empty($shipmentRowId)) {
            $this->db->query(
                'UPDATE tb_orders SET shipment_id = ? WHERE id = ?',
                [$shipmentRowId, $data['bookingRowId']]
            );
        }
        return !empty($shipmentRowId);
    }

    /**
     * get shipment id
     *
     * @return string
     */
    public function getShipmentId(): string
    {
        return  'AU' . rand(0, time());
    }

    /**
     * save cargo's data
     *
     * @param array $data
     * @return bool
     */
    private function saveCargo(array $data): bool
    {
        if (!isset($data['OrderDetails']['OrderCargoDetails']['Items'])) {
            log_error('AU_AWS Order Create : save Cargo details data unavailable.');
            return false;
        }
        $cargos = $data['OrderDetails']['OrderCargoDetails']['Items'] ?? null;
        if (empty($cargos)) {
            return false;
        }
        foreach ($cargos as $cargo) {
            $cargoDetails = [];
            $orderCargoDetails = [];
            $orderCargoDetails['order_id'] = $data['bookingRowId'];
            $orderCargoDetails['handling_unit'] = $cargo['HandlingUnit'] ?? $cargos['HandlingUnit'];
            $orderCargoDetails['volumetric_weight'] = $data['OrderDetails']['OrderCargoSummary']['TotalVolume']['Value'];
            $orderCargoDetails['volweight_uom'] = $data['OrderDetails']['OrderCargoSummary']['TotalVolume']['UOM'];
            $orderCargoDetails['quantity'] = $cargo['Quantity'];
            $orderCargoDetails['volume'] = $cargo['ActualVolume']['Value'];
            $orderCargoDetails['quantity_type'] = $orderCargoDetails['cargo_content'] = $cargoDetails['cargo_type'] = $cargo['CargoType'] ?? $cargos['CargoType'];
            $cargoDetails['goods_description'] = $cargo['CargoDescription'] ?? $cargos['CargoDescription'];
            $cargoDetails['quantity'] = $cargo['Quantity'] ?? $cargos['Quantity'];
            $orderCargoDetails['length'] = $cargoDetails['length'] = $cargo['Length']['Value'] ?? $cargos['Length']['Value'];
            $cargoDetails['length_unit'] = $cargo['Length']['UOM'] ?? $cargos['Length']['UOM'];
            $orderCargoDetails['width'] = $cargoDetails['width'] = $cargo['Width']['Value'] ?? $cargos['Width']['Value'];
            $cargoDetails['width_unit'] = $cargo['Width']['UOM'] ?? $cargos['Width']['UOM'];
            $cargoDetails['height'] = $cargo['Height']['Value'] ?? $cargos['Height']['Value'];
            $cargoDetails['height_unit'] = $cargo['Height']['UOM'] ?? $cargos['Height']['UOM'];
            $orderCargoDetails['second_weight'] = $cargoDetails['weight'] = $cargo['ActualWeight']['Value'] ?? $cargos['ActualWeight']['Value'];
            $cargoDetails['weight_unit'] = $cargo['ActualWeight']['UOM'] ?? $cargos['ActualWeight']['UOM'];
            $cargoDetails['stackable'] = $cargo['Stackable'] ?? $cargos['Stackable'] ? 1 : 0;
            $cargoDetails['splittable'] = $cargo['Splittable'] ?? $cargos['Splittable'] ? 1 : 0;
            $cargoDetails['createdby'] = $data['user_id'];
            $cargoDetails['volumetric_weight'] = '';
            $cargoDetails['volweight_uom'] = '';
            $cargoDetails['createdon'] = $data['created_on'];
            $orderCargoDetails['ldm'] = $cargoDetails['ldm'] = $cargo['LDM'] ?? $cargos['LDM'];
            $orderCargoDetails['weight'] = $cargoDetails['second_weight'] = $cargo['Weight']['Value'] ?? $cargos['Weight']['Value'];
            $cargoDetails['secondweight_uom'] = $cargo['Weight']['UOM'] ?? $cargos['Weight']['UOM'];
            $cargoDetails['second_volume'] = $cargo['ActualVolume']['Value'] ?? $cargos['ActualVolume']['Value'];
            $cargoDetails['secondvolume_uom'] = $cargo['ActualVolume']['UOM'] ?? $cargos['ActualVolume']['UOM'];
            $orderCargoDetails['cargo_id'] = 0;
            $cargoRowId = $this->ci->common->insertTableData('tb_cargo_details', $cargoDetails);
            if (!empty($cargoRowId)) {
                $orderCargoDetails['cargo_id'] = $cargoRowId;
                $orderCargoRowId = $this->ci->common->insertTableData('tb_order_cargodetails', $orderCargoDetails);
            }
            if (empty($cargoRowId) || empty($orderCargoRowId)) {
                return false;
            }
        }
        return true;
    }

    /**
     * save order references
     *
     * @param array $orderData
     * @return bool
     */
    private function saveOrderReferences(array $orderData): bool
    {
        $orderReferences = $orderData['OrderDetails']['ManageReferences']['RefType'] ?? null;
        $driverInstructions = $orderData['OrderDetails']['OrderStartLocation']['DriverInstructions'] ?? null;

        if (empty($orderReferences)) {
            log_error('AU_AWS Order Create : save References details data unavailable.');
            return false;
        }
        foreach ($orderReferences as $reference) {
            $insert = ['order_id' => $orderData['bookingRowId'], 'reference_id' => $reference['Code'], 'ref_value' => $reference['Value'], 'createdon' => $orderData['created_on']];
            $orderReferencesRowId = $this->ci->common->insertTableData('tb_order_references', $insert);
            if (empty($orderReferencesRowId)) {
                return false;
            }
        }
        if (!empty($driverInstructions)) {
            $savePickupDetails = $this->db->query(
                'INSERT INTO tb_order_references(
  					order_id,
					reference_id,
					ref_value,
					status,
					createdon
                         )
                          VALUES(?, ?, ?, ?, ?)',
                [
                    $orderData['bookingRowId'],
                    'ORD_PIKINST',
                    $orderData['OrderDetails']['OrderStartLocation']['DriverInstructions'],
                    1,
                    $orderData['created_on'],
                ]
            );

            if (!$savePickupDetails) {
                return false;
            }
        }
        return true;
    }

    /**
     * save involved parties
     *
     * @param array $data
     * @return bool
     */
    private function saveInvolvedParties(array $data): bool
    {
        $OrderParties = $data['OrderDetails']['OrderParties']['PartyType'] ?? [];
        if (empty($OrderParties)) {
            log_error('AU_AWS Order Create : save Involved Parties details data unavailable.');
            return false;
        }
        foreach ($OrderParties as $partyType) {
            switch ($partyType['Type']) {
                case 'SHIPPER':
                    $partyRowId = $data['shipperRowId'];
                    $partyId = $data['shipperTypeId'];
                    break;
                case 'CONSIGNEE':
                    $partyRowId = $data['consigneeRowId'];
                    $partyId = $data['consigneeTypeId'];
                    break;
                case 'CUSTOMER':
                    $partyRowId = $data['customerRowId'];
                    $partyId = $data['customerTypeId'];
                    break;
                default:
                    $partyRowId = 0;
                    $partyId = 0;
            }

            $insert = [
                'order_id' => $data['bookingRowId'],
                'order_number' => $data['bookingId'],
                'party_type' => $partyId,
                'party_id' => $partyRowId,
                'createdon' => $data['created_on'],
                'status' => 1
            ];
            $partiesRowId = $this->ci->common->insertTableData('tb_order_parties', $insert);
            if (empty($partiesRowId)) {
                return false;
            }
        }
        return true;
    }

    /**
     * save remarks
     *
     * @param array $data
     */
    private function saveRemarks(array $data): void
    {
        $remarks = $data['OrderDetails']['ManageRemarks']['Remark'] ?? null;
        if (empty($remarks)) {
            log_error('AU_AWS Order Create : save Remarks details data unavailable.');
            return;
        }
        foreach ($data['OrderDetails']['ManageRemarks']['Remark'] as $remark) {
            $this->db->query(
                'INSERT INTO tb_order_remarks(
  					order_id,
					remark_id,
					description
                         )
                          VALUES(?, ?, ?)',
                [
                    $data['bookingRowId'],
                    $data['user_id'],
                    $remark['Value'] ?? '',
                ]
            );
        }
    }

    private function saveOrderPartices(array $data): bool
    {
        if (!isset($data['shipper_id'], $data['pickup_custid'])) {
            log_error('AU_AWS Order Create : save OrderPartices details data unavailable.');
            return false;
        }
        $insert = [];
        $insert['order_id'] = $data['bookingRowId'];
        $insert['user_id'] = $data['user_id'];
        $insert['status'] = 1;
        /* shipper address */
        $insert = [
            'party_master_id' => $data['shipperRowId'],
            'location_id' => $data['pickup_city'],
            'street' => $data['pickup_address1'],
            'state' => $data['pickup_address2'],
            'address' => $data['pickup_company'],
            'pincode' => $data['pickupPinCode'],
            'country' => $data['pickup_country'],
        ];
        $shipperPartyAddress = $this->ci->common->insertTableData('tbl_orderparty_address', $insert);
        /* delivery delivery */
        $insert = [
            'party_master_id' => $data['consigneeRowId'],
            'location_id' => $data['delivery_city'],
            'street' => $data['delivery_address1'],
            'state' => $data['delivery_address2'],
            'address' => $data['delivery_company'],
            'pincode' => $data['deliveryPinCode'],
            'country' => $data['delivery_country'],
        ];
        $consigneePartyAddress = $this->ci->common->insertTableData('tbl_orderparty_address', $insert);
        return (!empty($shipperPartyAddress) && !empty($consigneePartyAddress));
    }
}
