<?php

/**
 * Class Aucustreportmodel
 *
 * @property CI_DB_mysqli_driver $db
 */
class Aucustreportmodel extends CI_Model
{
	function __construct()
	{
		parent::__construct(); 
	}

	public function gettodayscompletedorders($custids,$date){
		$result = array();
		$cdate = date('Y-m-d H:i:s');
		$curtz = "Australia/Sydney";
		$date = $cdate;
		$ydate =  date('Y-m-d',strtotime("-2 days"));
		$subQuery1 = "(select order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
            SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                FROM tb_order_references ar where  
                reference_id IN ('DQ','CTR','COI') AND status=1              
                group by order_id,reference_id
                ) as a
                group by order_id ) as reference_inner ";
        
		$this->db->select("reference_inner.reference_value as reference_value,o.id as order_row_id,o.order_id,o.delivery_datetime,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address2,o.delivery_address2,o.goods_value,o.goods_value,o.transport_mode,o.customer_id,o.vendor_id, Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,SUM(Case When c.status = '1' Then c.scanned_quantity Else 0 End) as tot_scanned_qty,v.name as vendor_name,d.latitude as dlat,d.longitude as dlng,d.loc_name as dlocname, convertToClientTZ(d.createdon,'" . $curtz . "') as delivered_date,pod2.id as podid,pod2.stop_type,pod2.imgpath,pod2.latitude as epodlat,pod2.longitude as epodlng,convertToClientTZ(pod2.createdon,'".$curtz."') as epod_avail,pod2.receiver_name");
		$this->db->from( "tb_orders o" );
		$this->db->join( "tb_order_cargodetails c", "o.id=c.order_id AND c.status='1'", "LEFT" );
		$this->db->join("tb_vendors v", "v.id=o.vendor_id AND v.status='1'", "LEFT");
		$this->db->join( "tb_stop_status d", "o.id=d.order_id AND d.status_code ='3000' AND d.status ='1'", "LEFT" );
		$this->db->join( "tb_pod_uploads pod2", "o.id=pod2.order_id AND pod2.stop_type ='D' AND pod2.doc_type='3' AND pod2.status ='1'", "LEFT" );
		$this->db->join( $subQuery1, 'o.id = reference_inner.order_id', 'LEFT' );
		$this->db->where_in('o.customer_id',$custids);
		if($date != ""){
			$ddate = date( 'Y-m-d', strtotime( $date ) );
			$whr["DATE_FORMAT(d.createdon,'%Y-%m-%d') >="] = $ydate;
			$whr["DATE_FORMAT(d.createdon,'%Y-%m-%d') <="] = $ddate;
			$this->db->where($whr);
		}
		$this->db->where( "o.status !=", 0 );
		$this->db->group_by( "o.id" );
		$this->db->order_by( "o.createdon", 'DESC' );
		$qry = $this->db->get();
		if($qry->num_rows() >0){
			$result = $qry->result_array();
		} 
		return $result;
	}
	public function getaurefnums($whr)
    {
        $result = array();
        $this->db->select("i.ref_order_num");
        $this->db->from("tb_order_cargodetails c");
        $this->db->join("tb_inner_cargo i", "c.cargo_id=i.cargo_id", "LEFT");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getauloadplanconnote($whr)
    {
        $result = array();
        $this->db->select("r.ref_value");
        $this->db->from("tb_order_references r");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

     public function getcompletedordersdatabydates($whr,$custid,$curtz,$searchids){
		$result = array();
		$subQuery1 = "(select order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
            SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                FROM tb_order_references ar where  
                reference_id IN ('DQ','CTR','COI') AND status=1              
                group by order_id,reference_id
                ) as a
                group by order_id ) as reference_inner ";
        
		$this->db->select("reference_inner.reference_value as reference_value,o.id as order_row_id,o.order_id,o.delivery_datetime,o.pickup_company,o.delivery_company,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address2,o.delivery_address2,o.goods_value,o.goods_value,o.transport_mode,o.customer_id,o.vendor_id, Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,SUM(Case When c.status = '1' Then c.scanned_quantity Else 0 End) as tot_scanned_qty,v.name as vendor_name,d.latitude as dlat,d.longitude as dlng,d.loc_name as dlocname, convertToClientTZ(d.createdon,'" . $curtz . "') as delivered_date,pod2.id as podid,pod2.stop_type,pod2.imgpath,pod2.latitude as epodlat,pod2.longitude as epodlng,convertToClientTZ(pod2.createdon,'".$curtz."') as epod_avail,pod2.receiver_name");
		$this->db->from( "tb_orders o" );
		$this->db->join( "tb_order_cargodetails c", "o.id=c.order_id AND c.status='1'", "LEFT" );
		$this->db->join("tb_vendors v", "v.id=o.vendor_id AND v.status='1'", "LEFT");
		$this->db->join( "tb_stop_status d", "o.id=d.order_id AND d.status_code ='3000' AND d.status ='1'", "LEFT" );
		$this->db->join( "tb_pod_uploads pod2", "o.id=pod2.order_id AND pod2.stop_type ='D' AND pod2.doc_type='3' AND pod2.status ='1'", "INNER" );
		$this->db->join( $subQuery1, 'o.id = reference_inner.order_id', 'INNER' );
		$this->db->where('o.customer_id',$custid);
		if(!empty($searchids)){
			$this->db->where_in("o.order_id",$searchids);
		}
		/*if($date != ""){
			$ddate = date( 'Y-m-d', strtotime( $date ) );
			$whr["DATE_FORMAT(d.createdon,'%Y-%m-%d') "] = $ddate;
			$this->db->where($whr);
		}*/
		$this->db->where( "o.status !=", 0 );
		$this->db->where( $whr);
		$this->db->group_by( "o.id" );
		$this->db->order_by( "o.createdon", 'DESC' );
		$qry = $this->db->get();
		if($qry->num_rows() >0){
			$result = $qry->result_array();
		} 
		return $result;
	}

	public function getcompletedorderids($user_id, $custid, $searchTerm,$whr){

        $company_code = $this->session->userdata('company_code');
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where("status !=", 0);
        $this->db->like("order_id", $searchTerm);
        if (! empty($custid)) {
            $this->db->where_in("customer_id", $custid);
        } else {
            $permission = checkuserpermissions();
            if (in_array("orders", $permission)) {
                $company_code = $this->session->userdata('company_code');
                $this->db->where("company_code", $company_code);
            } else {
                $this->db->where("user_id", $user_id);
            }
        }
        if($whr != ""){
        	$this->db->where($whr);
        }
        $this->db->order_by("createdon", 'DESC');
        $chkqry = $this->db->get();

        return $chkqry;
    
	}

}
