<?php defined('BASEPATH') or exit('No direct script access allowed');


class Aulabelmodel extends CI_Model
{
    
    public function getcargodetails($whr)
    {
        $select = 'o.id,c.quantity,c.cargo_type,c.weight,o.cargo_content,o.order_id,o.qr_code,o.cargo_id,l.bar_code,l.createdon';
        $result = array();
        $this->db->select($select);
        $this->db->from("tb_order_cargodetails o");
        $this->db->join("tb_cargo_details c", "o.cargo_id=c.id ", "INNER");
        $this->db->join("tb_orders r", "o.order_id=r.id ", "INNER");
        $this->db->join("tb_order_cargo_labels l", "l.cargo_id=o.cargo_id ", "INNER");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
    
    public function routingdetils($whr)
    {
        $select = 'p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type';
        $result = array();
        $this->db->select($select);
        $this->db->from("tbl_party_master p");
        $this->db->join("tb_order_parties o", "p.id=o.party_id AND o.status=1 ", "INNER");
        $this->db->join("tb_orders r", "o.order_id=r.id ", "INNER");
        $this->db->where($whr);
        $this->db->group_by("o.party_type");
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
    
    public function getcargolabelsorted($order_id): array
    {
        $this->db->select('cd.id');
        $this->db->from('tb_order_cargodetails as cd');
        $this->db->join('tb_order_cargo_labels as cl',
            'cl.order_id = cd.order_id AND cl.cargo_id = cd.cargo_id', 'LEFT');
        $this->db->where(['cd.order_id'=>$order_id,'cd.status'=>1,'cl.status'=>1]);
        $this->db->order_by('cl.bar_code', 'asc');
        $this->db->group_by('cd.id');
        $res = $this->db->get();

        return  $res->result_array();
    }

    public function count_labels($where){
        $select = 'count(id) as count_barcodes';
        $result = array();
        $this->db->select($select);
        $this->db->from("tb_order_cargo_labels");
        $this->db->where($where);
       // $this->db->group_by("o.party_type");
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }
    
    public function count_cargos($where){

        $select = "SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty";
        $result = array();
        $this->db->select($select);
        $this->db->from( "tb_orders r" );
        $this->db->join( "tb_order_cargodetails c", "r.id=c.order_id", "LEFT" );
        $this->db->where($where);
       // $this->db->group_by("o.party_type");
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    public function get_barcodes($whr){
        $select = 'bar_code';
        $result = array();
        $this->db->select($select);
        $this->db->from("tb_order_cargo_labels");
        $this->db->where($whr);
       // $this->db->group_by("o.party_type");
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function get_apimissing_orders()
    {
        $from_date=$logdate = date('Y-m-d',strtotime("-1 days"));;
        $to_date=$logdate = date('Y-m-d');
        $result = array();
        $where='o.company_code="AUKN" AND DATE_FORMAT(o.pickup_datetime,"%Y-%m-%d") >='.'"'. $from_date.'"'.'
        AND DATE_FORMAT(o.pickup_datetime,"%Y-%m-%d") <='.'"'. $to_date.'"'.'and (orbn.ref_value ="" OR orbn.ref_value IS null OR o.shift_id=0 OR o.shift_id IS null)';
        $this->db->select('o.id,orbn.ref_value AS job_id,o.vendor_id,o.user_id,o.company_code,o.branch_code,o.shift_id');
        $this->db->from('tb_orders as o');
        $this->db->join('tb_order_references as orbn', 'orbn.order_id=o.id AND orbn.reference_id="BN"', 'LEFT');
        $this->db->join('tb_vendors as v', 'v.id=o.vendor_id', 'LEFT');
        $this->db->where($where);
        $this->db->like('v.name', 'BONDS');
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
    
    public function get_apimissing_border_orders():array
    {
        $from_date = date("Y-m-d",strtotime("-1 days"));
        $to_date= date("Y-m-d");
        $result = array();
        $this->db->select("o.id,o.vendor_id,o.user_id,o.company_code,o.branch_code,o.shift_id,b.response");
        $this->db->from("tb_orders as o");
        $this->db->join("tb_vendors as v", "v.id=o.vendor_id", "LEFT");
        $this->db->join("tb_bexedi as b", "o.id=b.order_id", "LEFT");
        $this->db->where("o.company_code", "AUKN");
        $this->db->where("DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=", $from_date);
        $this->db->where("DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <=", $to_date);
        $this->db->group_start();
        $this->db->or_where("o.shift_id IS null");
        $this->db->or_where("o.shift_id",0);
        $this->db->or_where("b.response IS null");
        $this->db->group_end();
        $this->db->like("v.name", "BORDER");
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    /**
     * @param $orderId
     * @param $cargoId
     * @return array
     */
    public function getCargoLabelData($orderId,$cargoId): array
    {
        $result=[];
        $this->db->select('cl.bar_code,cd.scanned_quantity');
        $this->db->from('tb_order_cargo_labels as cl');
        $this->db->join('tb_order_cargodetails as cd', 'cl.order_id = cd.order_id
        AND cl.cargo_id = cd.cargo_id', 'INNER');
        $this->db->where(
            ['cl.order_id'=>$orderId,
            'cl.cargo_id' =>$cargoId,
            'cd.status'=>1,
            'cl.status'=>1]);
        $this->db->group_by("cd.id");
        $getOrderCargoData = $this->db->get();
        if ($getOrderCargoData->num_rows() > 0) {
            $result = $getOrderCargoData->row_array();
        }
        return $result;
    }

    /**
     * @param $cargoId
     * @param $limit
     * @return array
     */
    public function getLabelBarcodes($cargoId, $limit):array
    {
        $this->db->select("bar_code");
        $this->db->from("tb_order_cargo_labels");
        $this->db->where(["cargo_id" => $cargoId, "status" => 1]);
        $this->db->order_by('bar_code', 'asc');
        $this->db->limit($limit);
        $res = $this->db->get();
        if(!empty($res->num_rows()) && $res->num_rows() > 1){
            return $res->result_array();
        }else{
            return (!empty($res->num_rows()) ? $res->row_array() : []);
        }

    }

    public function getPartyData($orderId, $partyType): array
    {
        $this->db->select(
            ' p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type, pt.id'
        );
        $this->db->from('tbl_party_master as p');
        $this->db->join('tb_order_parties as o', 'p.id=o.party_id AND o.status=1', 'INNER');
        $this->db->join('tbl_party_types as pt', 'pt.id=o.party_type AND o.status=1', 'INNER');
        $this->db->where(['p.status' => 1, 'o.order_id' => $orderId, 'pt.name' => $partyType]);
        $this->db->group_by('o.party_type');
        $getPartyData = $this->db->get();
        return (!empty($getPartyData->num_rows()) ? $getPartyData->row_array() : []);
    }

    public function getRoutingDetails(string $orderId, $partyType): array
    {
        $getPartyDetails = $this->getPartyData($orderId, $partyType);
        return (!empty($getPartyDetails) ? [
            'id' => $getPartyDetails['id'],
            'name' => $getPartyDetails['name'],
            'phone' => $this->getConsigneeMobileNum($orderId),
            'email' => $getPartyDetails['email'],
            'fax' => $getPartyDetails['fax'],
            'party_id' => $getPartyDetails['code']
        ] : []);
    }

    public function getCargoData($cargoDetailId, $orderId): array
    {
        $sql = 'SELECT `c`.`quantity`, `c`.`cargo_type`, `c`.`weight`, `oc`.`cargo_content`, `oc`.`order_id`, `oc`.`qr_code`, `oc`.`cargo_id`, `dr`.`ref_value` as `delivery_ins`, `l`.`bar_code`, `l`.`createdon`, `o`.`delivery_datetime` as `delivery_date`, `o`.`pickup_datetime` as `pickup_date`, `o`.`pickup_company` as `pickup`, `o`.`delivery_company` as `delivery`, `o`.`pickup_address1`, `o`.`delivery_address1`, `o`.`pickup_address2`, `o`.`delivery_address2`, `o`.`pickup_city`, `o`.`delivery_city`, `o`.`pickup_country`, `o`.`delivery_country`, `o`.`pickup_pincode`, `o`.`delivery_pincode`, `o`.`vendor_id`, `o`.`order_id` as `shipmentNumber`, `o`.`user_id`, `v`.`name` as `vendorName`, `d`.`consignment_note`, `ctr`.`ref_value` as `containerNumber`
                FROM `tb_order_cargodetails` as `oc`
                INNER JOIN `tb_order_cargo_labels` as `l` ON `oc`.`cargo_id`=`l`.`cargo_id`
                INNER JOIN `tb_cargo_details` as `c` ON `oc`.`cargo_id`=`c`.`id`
                LEFT JOIN `tb_order_references` as `dr`
                    ON `oc`.`order_id`=`dr`.`order_id` and `dr`.`reference_id` = "ORD_DLVINST"
                LEFT JOIN `tb_order_references` as `ctr` ON `oc`.`order_id`=`ctr`.`order_id` and `ctr`.`reference_id` = "CTR"
                LEFT JOIN `tb_orders` as `o` ON `o`.`id`=`oc`.`order_id`
                LEFT JOIN `tb_vendors` as `v` ON `v`.`id`=`o`.`vendor_id`
                LEFT JOIN `tb_order_details` as `d` ON `o`.`id`=`d`.`order_row_id`
                WHERE `oc`.`id` = ?
                AND (`o`.`order_id` = ?
                OR `o`.`id` = ?)';

        $getCargoData = $this->db->query($sql, [$cargoDetailId, $orderId, $orderId]);
        return (!empty($getCargoData->num_rows()) ? $getCargoData->row_array() : []);
    }

    public function getConsigneeMobileNum(string $orderId): string
    {
        $this->db->select('phoneNum');
        $this->db->from('tb_orders as o');
        $this->db->join('tb_order_references as r', 'o.id=r.order_id and  r.reference_id= "COI"', 'LEFT');
        $this->db->join('tb_au_label_consignee_mobile_num as al', 'al.storeCode=r.ref_value AND o.status IN (1,2)', 'LEFT');
        $this->db->where('o.id', $orderId);
        $this->db->or_where('o.order_id', $orderId);

        $getPartyData = $this->db->get();
        if (empty($getPartyData->num_rows())) {
            return '';
        }
        return ($getPartyData->row_array()['phoneNum']) ?: '';
    }
}
