<?php

namespace App\Models;

class BillingmodelGetroletypelistInput
{
    /**
     * @var int
     */
    private $userId;

    /**
     * @var string
     */
    private $companyCode;

    /**
     * @var string
     */
    private $type;

    public function __construct(int $userId, string $companyCode, string $type)
    {
        $CI = &get_instance();
        $this->userId = $userId;
        $this->companyCode = $CI->db->escape_str($companyCode);
        $this->type = $CI->db->escape_str($type);
    }

    /**
     * @return int
     */
    public function getUserId(): int
    {
        return $this->userId;
    }

    /**
     * @return string
     */
    public function getCompanyCode(): string
    {
        return $this->companyCode;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }
}
