<?php

class Blowhornorderstatusmodel extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    public function getblowhormOrderList(): array
    {
        $this->db->select('`o`.`id`, `o`.`order_id`, `tor`.`ref_value`');
        $this->db->from('tb_orders o');
        $this->db->join('tb_order_references tor', 'o.id=tor.order_id AND tor.reference_id="AWB"');
        $this->db->join('tb_vendors tv', 'o.vendor_id =tv.id AND tv.name="BLOWHORN"');
        $this->db->where('o.user_id', '244');
        $this->db->where('o.trip_sts !=', 1);
        $this->db->group_by('o.id');
        $this->db->order_by("o.id", 'DESC');
        $queryResult = $this->db->get();
        return $queryResult->num_rows() > 0 ? $queryResult->result_array() : [];
    }

    public function getPendingOrderList(int $orderid): int
    {
        $getResult = $this->db->query("SELECT order_id FROM tb_stop_status WHERE order_id=? AND stop_type= ? AND status_id=? GROUP BY order_id", [$orderid, "D", 1]);
        return $getResult->num_rows() > 0 ? 1 : 0;
    }

    public function getOrderID(string $orderAWB): array
    {
        $this->db->select('`o`.`id`,o.order_id');
        $this->db->from('tb_orders o');
        $this->db->join('tb_order_references tor', 'o.id=tor.order_id AND tor.reference_id="AWB"');
        $this->db->where('o.user_id', '244');
        $this->db->where('tor.ref_value', $orderAWB);
        $queryResult = $this->db->get();
        return $queryResult->num_rows() > 0 ? $queryResult->result_array() : [];
    }

    public function getOrderAWBNumber(int $orderId): array
    {
        $this->db->select('tor.ref_value');
        $this->db->from('tb_orders o');
        $this->db->join('tb_order_references tor', 'o.id=tor.order_id AND tor.reference_id="AWB"');
        $this->db->where('o.user_id', '244');
        $this->db->where('o.id', $orderId);
        $queryResult = $this->db->get();
        return $queryResult->num_rows() > 0 ? $queryResult->row_array() : [];
    }
}
