<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Bpartners extends CI_Model
{
    function gettblrowdata($where, $select, $table, $limit, $start)
    {
        $result = [];
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    function updatedata($table, $id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update($table, $data);
    }

    function getpartnerdata($uid, $obsolete_add, $whr, $company_code, $findPartyTypes)
    {
        $fields = [
            'id',
            'name',
            'customeridentifier',
            'location_id',
            'division_name',
            'sub_district',
            'street',
            'street_2',
            'house_number',
            'building',
            'country',
            'state',
            'branch_code',
            'pincode',
            'code',
            'customer_code',
            'acon_debitor_code',
            'kn_login_account',
            'offering_type',
            'carrier_grade',
            'party_types',
            'party_type_id'
        ];
        $this->db->select($fields);
        $this->db->from("tbl_party_master");


        if (isset($whr['name'])) {
            $this->db->like('name', $whr['name']);
            unset($whr['name']);
        }


        if ($obsolete_add == 1) {
            $this->db->where($whr);
        } else {
            $this->db->where($whr);
        }

        /*get data based on party type selection in dropdown
            Description: By search Party Name: getting all branches party ids by based on company code then search in the party master table
        */
        $partyTypeIds = [];
        $partyIds = '';
        if (!empty($findPartyTypes)) {
            $partyName = $findPartyTypes;
            $getPartyTypes = $this->db->query("SELECT id,name,status FROM tbl_party_types where company_code='" . $company_code . "' and status=1 and name='" . $partyName . "'");
            if ($getPartyTypes->num_rows() > 0) {
                foreach ($getPartyTypes->result() as $partner) {
                    $partyTypeIds[] = $partner->id;
                }
            }
            if (!empty($partyTypeIds)) {
                foreach ($partyTypeIds as $value) {
                    $partyIds .= " find_in_set($value, party_types) OR find_in_set($value, party_type_id) OR ";
                }
                $where_condition = rtrim($partyIds, "OR ");

                $this->db->where("(" . $where_condition . ")");
            } else {
                $this->db->where("party_type_id", $partyId);
            }
        }

        $permission = checkuserpermissions();
        /*if (in_array("businesspartners", $permission)) {
            $this->db->where("company_code", $company_code);
        } else {
            $this->db->where("user_id", $uid);
        }*/
        $this->db->where("company_code", $company_code);
        $this->db->where("user_id", $uid);
        $this->db->where("parent_id", 0);
        $this->db->where("status", 1);
        $this->db->order_by("id", "DESC");
        /*$carrier_ids = [];
        $getPartyTypes = $this->db->query("SELECT id,name,status FROM tbl_party_types where company_code='" . $company_code . "' and status=1 and name='Carrier'");
        if ($getPartyTypes->num_rows() > 0) {
            foreach ($getPartyTypes->result() as $partner) {
                $carrier_ids[] = $partner->id;
            }
        }
        $permission = checkuserpermissions();
        $this->db->group_start();
        $this->db->where('company_code', $company_code);
        $this->db->where('user_id', $uid);
        $this->db->where("status", 1);
        $this->db->where_not_in('party_types', $carrier_ids);
        $this->db->where_not_in('party_type_id', $carrier_ids);
        $this->db->group_end();
        $this->db->or_group_start();
        $this->db->where('company_code', $company_code);
        $this->db->where("status", 1);
        $this->db->group_start();
        $this->db->where_in('party_types', $carrier_ids);
        $this->db->or_where_in('party_type_id', $carrier_ids);
        $this->db->group_end();
        $this->db->group_end();
        $this->db->where("parent_id", 0);
        $this->db->where("status", 1);
        $this->db->order_by("id", "DESC");*/
        log_message("error","Qry:".$this->db->last_query());
        return $this->db->get();
    }

    public function getcustprofile($id)
    {
        $whr = ['c.partner_id' => $id, 'cl.status' => 1];
        $this->db->select("cl.*,cp.cust_profile_id");
        $this->db->from("tb_customer_profile_list cl");
        $this->db->join('tb_customers c', 'c.id=cl.party_id', 'left');
        $this->db->join('tb_customer_profile cp', 'cp.id=cl.cp_id', 'left');
        // $this->db->where('c.partner_id',$id);
        $this->db->where($whr);
        $this->db->limit(1);
        $res = $this->db->get();
        $result = $res->row_array();
        return $result;
    }

    public function getvendorprofile($id)
    {
        $whr = ['v.code' => $id, 'vl.status' => 1];
        $this->db->select("vl.*,vp.vend_profile_id");
        $this->db->from("tb_vendor_profile_list vl");
        $this->db->join('tb_vendors v', 'v.code=vl.profile_id', 'left');
        $this->db->join('tb_vendor_profile vp', 'vp.id=vl.vp_id', 'left');
        //$this->db->where('v.code',$id);
        $this->db->where($whr);
        $this->db->limit(1);
        $res = $this->db->get();
        $result = $res->row_array();
        return $result;
    }

    function getpartytypes($uid, $company_code)
    {
        $this->db->select("id,name,description");
        $this->db->from("tbl_party_types");
        $permission = checkuserpermissions();
        if (in_array("businesspartners", $permission)) {
            $this->db->where("company_code", $company_code);
        } else {
            $this->db->where("user_id", $uid);
        }
        $this->db->where_in("name", ['Customer', 'Shipper', 'Carrier', 'NOTIFY_PARTY', 'Consignee', 'Port', 'In Transit', 'xDock', 'Border', 'Yard', 'PICKUP', 'DELIVERY']);
        $this->db->where("status", 1);
        $this->db->group_by('name');
        return $this->db->get();
    }

    function getreftypes()
    {
        $this->db->select("id,name,description");
        $this->db->from("tb_reference_types");
        $this->db->where("status", 1);
        return $this->db->get();
    }

    function getpartnercontacts($userids)
    {
        $this->db->select("*");
        $this->db->from("tbl_partner_contacts");
        $this->db->where_in("partner_id", $userids);
        $this->db->where("status", 1);
        return $this->db->get();
    }


    function gettbldata($where, $select, $table, $limit, $start)
    {
        $result = [];
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        if ($table == 'tb_shipment_locations') {
            $this->db->order_by('id', 'ASC');
        }
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    function insertTableData($tablename, $data)
    {
        $res = 0;
        $qry = $this->db->insert($tablename, $data);
        if ($qry) {
            $res = $this->db->insert_id();
        }
        return $res;
    }

    function getcmpcategory($type)
    {
        $this->db->select("id,code,name,type");
        $this->db->from("tb_company_category");
        $this->db->where("type", $type);
        $this->db->where("status", 1);
        return $this->db->get();
    }

    function getcategoryname($id)
    {
        $name = "";
        $this->db->select("name");
        $this->db->from("tb_company_category");
        $this->db->where("id", $id);
        $this->db->where("status", 1);
        $dt = $this->db->get();
        if ($dt->num_rows() > 0) {
            $name = $dt->row()->name;
        }
        return $name;
    }

    function getidncmp()
    {
        $this->db->select("id,company_code");
        $this->db->from("tbl_party_master");
        return $this->db->get();
    }

    function chkpartytype($partytypesary, $partyname)
    {
        $this->db->select("id");
        $this->db->from("tbl_party_types");
        $this->db->where_in("id", $partytypesary);
        $this->db->where("name", $partyname);
        return $this->db->get();
    }

    function getlatlngs($ship_id, $location)
    {
        $res = $this->db->query('select l.locationname,l.city,l.latitude,l.longitude,l.address,s.pickupestimate,s.pickupplanned,s.deliveryestimate,s.deliveryplan FROM tb_shipment_stops s,tb_shipment_locations l WHERE s.shipment_id="' . $ship_id . '" AND s.location=l.locationid AND s.shipment_id=l.shipment_id AND s.location="' . $location . '" LIMIT 1');
        return $res;
    }

    function getshipmenttbldata($table, $table2, $where, $select, $limit, $start)
    {
        $result = [];
        $intransit = $this->getintransitshipdata();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->join($table2, 's.customer_id=c.id', 'LEFT');
        $this->db->where($where);
        if (count($intransit) > 0) {
            $this->db->where_not_in("s.id", $intransit);
        }
        /*if($table == 'tb_shifts' || $table == 'tb_employee'){*/
        $this->db->order_by('startdate', 'DESC');
        /*}*/
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    function getcountrycode($uid)
    {
        $countryphonecode = 91;
        $this->db->select("c.phone_code");
        $this->db->from("tbl_country_master c");
        $this->db->join('tb_users u', 'u.country_code = c.country_code', 'left');
        $this->db->where("u.id", $uid);
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $countryphonecode = $res->row()->phone_code;
        }
        return $countryphonecode;
    }

    function getchildpartnerid($contactid)
    {
        $childpartnerid = 0;
        $this->db->select("child_partnerid");
        $this->db->from("tbl_partner_contacts");
        $this->db->where("id", $contactid);
        $this->db->where("child_partnerid !=", 0);
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $childpartnerid = $res->row()->child_partnerid;
        }
        return $childpartnerid;
    }

    public function getpartytypenamesbyids($ids, $company_code, $uid)
    {
        $data = [];
        if (!empty($ids)) {
            $this->db->select("name");
            $this->db->from("tbl_party_types");
            $this->db->where_in('id', $ids);
            $this->db->where('status', '1');
            $res = $this->db->get();
            if ($res->num_rows() > 0) {
                foreach ($res->result() as $bp) {
                    $data[] = strtoupper($bp->name);
                }
            }
        }
        return $data;
    }


    public function getPartyTypeNamesByIdAndCompanyCode($ids, $company_code)
    {
        $data = [];
        if (!empty($ids)) {
            $this->db->select("name");
            $this->db->from("tbl_party_types");
            $this->db->where_in('id', $ids);
            $this->db->where('status', 1);
            $res = $this->db->get();
            if ($res->num_rows() > 0) {
                foreach ($res->result() as $businessPartners) {
                    $data[] = strtoupper($businessPartners->name);
                }
            }
        }
        log_message("error","Qry11:".$this->db->last_query());
        return $data;
    }

    function getPartyTypeByName($party_type, $company_code, $branch_code)
    {
        $data = '';
        $party_type_array = [];
        $party_type_array = explode(",", $party_type);

        if ((count($party_type_array) > 1) && ((in_array("Carrier", $party_type_array)) || (in_array("Border", $party_type_array)) || (in_array("Delivery", $party_type_array)) || (in_array("In transit", $party_type_array)) || (in_array("Notify_Party", $party_type_array)) || (in_array("Pickup", $party_type_array)) || (in_array("Port", $party_type_array)) || (in_array("X dock", $party_type_array)) || (in_array("Yard", $party_type_array)))) {
            $data = 'nodata';
        } else {
            $dataIds = [];
            for ($i = 0; $i < count($party_type_array); $i++) {
                $party_name = trim($party_type_array[$i]);
                if ((!empty($party_name)) && (!empty($company_code)) && (!empty($branch_code))) {
                    $this->db->select("id");
                    $this->db->from("tbl_party_types");
                    $this->db->where("company_code", $company_code);
                    $this->db->where("branch_code", $branch_code);
                    $this->db->where("name", $party_name);
                    $this->db->group_by('name');
                    $res = $this->db->get();
                    if ($res->num_rows() > 0) {
                        foreach ($res->result() as $type) {
                            $dataIds[] = $type->id;
                        }
                    }
                }
            }
            $data = implode(",", $dataIds);
        }
        return $data;
    }

    function getServiceForMDTExcel($service_id, $company_code, $branch_code)
    {
        $service_row_id = 0;
        $whr = "status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "' AND ( service_id LIKE '" . $service_id . "' OR name LIKE '" . $service_id . "')";
        $whr1 = "status ='1'  AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))) AND ( service_id LIKE '" . $service_id . "' OR name LIKE '" . $service_id . "')";
        $whr3 = "status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)) AND ( service_id LIKE '" . $service_id . "' OR name LIKE '" . $service_id . "')";
        $this->db->select("id");
        $this->db->from("tb_service_master");
        $this->db->where($whr);
        $qry = $this->db->get();
        if ($qry->num_rows() > 0) {
            $this->db->select("id");
            $this->db->from("tb_service_master");
            $this->db->where($whr1);
            $qry1 = $this->db->get();
            if ($qry1->num_rows() > 0) {
                $service_row_id = $qry1->row()->id;
            } else {
                $this->db->select("id");
                $this->db->from("tb_service_master");
                $this->db->where($whr3);
                $qry2 = $this->db->get();
                if ($qry2->num_rows() > 0) {
                    $service_row_id = $qry2->row()->id;
                }
            }
        } else {
            $this->db->select("id");
            $this->db->from("tb_service_master");
            $this->db->where($whr3);
            $qry3 = $this->db->get();
            if ($qry3->num_rows() > 0) {
                $service_row_id = $qry3->row()->id;
            }
        }
        return $service_row_id;
    }

    public function getEbookingRef(): int
    {
        $post = $this->input->post(null, true);
        $partnerid = $post['partner_id'] ?? 0;
        $checkEbookingRefQuery = $this->db->query(
            "SELECT * FROM `tb_party_reference` AS tpr
        JOIN `tbl_party_master` AS tpm ON tpm.id = tpr.partner_id
        JOIN `tb_customers` AS tbc ON tbc.code = tpm.code
        WHERE tpr.partner_id = ? AND tpr.name= ? AND tpr.status = ?",
            [$partnerid, "eBooking",1]
        );
        return $checkEbookingRefQuery->num_rows();
    }

    public function getEbookingMenu(): bool
    {
        $customer_id = $this->session->userdata('cust_id');
        $getEBookingMenuQuery = $this->db->query(
            "SELECT * FROM `tb_party_reference` AS tpr
            JOIN `tbl_party_master` AS tpm ON tpm.id = tpr.partner_id
            JOIN `tb_customers` AS tbc ON tbc.code = tpm.code
            WHERE ((UPPER(tpr.value) = ? || UPPER(tpr.value) = ? ) AND tpr.name= ?
			AND tbc.id = '$customer_id'
            AND tpr.status = ?) ",
            ['N', 'NO', 'eBooking',1]
        );
        if ($getEBookingMenuQuery->num_rows() > 0) {
            return false;
        } else {
            return true;
        }
    }

    public function checkDeliveryNoteForAchievaOrders(array $data): int
    {
        $checkDeliveryNote = $this->db->query("SELECT r.id FROM tb_order_references r,tb_orders o WHERE r.reference_id LIKE ? AND r.ref_value = ? AND r.status =? AND r.order_id=o.id AND o.status > ? AND o.user_id = ?", ['DQ', $data['deliveryNote'], 1, 0, $data['userId']]);
        return $checkDeliveryNote->num_rows();
    }
}
