<?php

class Bufaorderdisplaymodel extends CI_Model
{

    public function getOrdersData($limit = 0, $offset = 0, $where=[])
    {
        if (empty($where)) {
            return [];
        }
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $branchCode = $this->session->userdata('branch_code');
        $whereConditionValues[] = [0, 3];
        $whereConditionValues[] = $branchCode;
        $sql = "SELECT
              `o`.`id`,
              `o`.`order_id`,
              CONVERT_TZ( `o`.`pickup_datetime`, 'UTC', '" . $timeZone . "') AS 'pickup_datetime',
              CONVERT_TZ( `o`.`delivery_datetime`, 'UTC',  '" . $timeZone . "') AS 'delivery_datetime',
              `o`.`pickup_company`,
              `o`.`shift_id`,
              `o`.`trip_sts`,
              `o`.`pickup_company`,
              `o`.`delivery_company`,
              `o`.`delivery_company`,
              sum(`ocd`.`quantity`) AS 'quantity',
              `r1`.`ref_value`  AS 'Tracking_no',
              `r2`.`ref_value`  AS 'Salog_creator_name',
              `r3`.`ref_value`  AS 'XSR',
              CONVERT_TZ(`s1`.`createdon`, 'UTC', '" . $timeZone . "') AS 'Real_pickup_time',
              CONVERT_TZ(`s2`.`createdon`, 'UTC',  '" . $timeZone . "') AS 'Real_drop_time',
              if(`pup`.`order_id` != 'NULL', 'YES','') AS 'pup',
              if(`pod`.`order_id` != 'NULL', 'YES','') AS 'pod' ";
        $sql .= "
            FROM
              `tb_orders` `o`
              LEFT JOIN `tb_order_cargodetails` `ocd` ON `o`.`id` = `ocd`.`order_id`
              LEFT JOIN `tb_users` `u` ON `o`.`user_id` = `u`.`id`
              LEFT JOIN `tbl_country_master` `c` ON `u`.`country_code` = `c`.`country_code`
              LEFT JOIN `tb_order_references` `r1` ON `o`.`id` = `r1`.`order_id` AND `r1`.`reference_id` = 'DQ'
              LEFT JOIN `tb_order_references` `r2` ON `o`.`id` = `r2`.`order_id` AND `r2`.`reference_id` = 'SAC'
              LEFT JOIN `tb_order_references` `r3` ON `o`.`id` = `r3`.`order_id` AND `r3`.`reference_id` = 'XSR'
              LEFT JOIN `tb_stop_status` `s1` ON `o`.`id` = `s1`.`order_id` AND `s1`.`status_code` = '0500'
              LEFT JOIN `tb_stop_status` `s2` ON `o`.`id` = `s2`.`order_id` AND `s2`.`status_code` = '3000'
              LEFT JOIN `tb_pod_uploads` `pup` ON `o`.`id` = `pup`.`order_id`AND `pup`.`doc_type` IS NOT NULL AND `pup`.`doc_type` = '4'
              LEFT JOIN `tb_pod_uploads` `pod` ON `o`.`id` = `pod`.`order_id`AND `pod`.`doc_type` IS NOT NULL AND `pod`.`doc_type` = '3' ";
        if (isset($where['customer_name']) && !empty($where['customer_name'])) {
            $sql .= "    LEFT JOIN `tb_customers` `cu` ON `o`.`customer_id` = `cu`.`id` ";
        }

        $sql .= "   WHERE `o`.`status` NOT IN ? AND `o`.`branch_code`= ? AND `o`.`company_code` = 'CNKN'";
        if (isset($where['from_date']) && $where['from_date'] != "") {
            $whereConditionValues[] = $where['from_date'];
            $sql .= " AND DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') >= ?";
        }
        if (isset($where['to_date']) && $where['to_date'] != "") {
            $whereConditionValues[] = $where['to_date'];
            $sql .= " AND DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') <= ?";
        }
        if (isset($where['customer_name']) && !empty($where['customer_name'])) {
            $whereConditionValues[] = $where['customer_name'];
            $sql .= " AND `cu`.`name` IN ?";
        }
        $sql .= " GROUP BY `ocd`.`order_id` ORDER BY `o`.`id` DESC";
        if ($limit > 0) {
            $sql .= " LIMIT " . $offset . "," . $limit;
        }
        $query = $this->db->query($sql, $whereConditionValues);
        return  $query ? $query->result_array() : [];
    }

    public function getCountOfOrderWithStatusException(array $where): int
    {
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');

        if (empty($where)) {
            return 0;
        }
        $this->db->select("count(DISTINCT (o.id)) AS count_orders");
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status sts", "o.id = sts.order_id", "LEFT");
        if (isset($where['customer_name']) && $where['customer_name'] != "") {
            $this->db->join("tb_customers cu", "cu.id = o.customer_id", "LEFT");
        }
        $this->db->where_in("sts.status_code", "0501,0502,0503,0504, 0505");
        $this->db->where_not_in("o.status", [0, 3]);
        $this->db->where("o.company_code", $companyCode);
        $this->db->where("o.branch_code", $branchCode);
        if (isset($where['customer_name']) && !empty($where['customer_name'])) {
            $this->db->where_in("cu.name", $where['customer_name']);
        }
        if (isset($where['from_date']) && $where['from_date'] != "") {
            $this->db->where("DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') >=", $where['from_date']);
        }
        if (isset($where['to_date']) && $where['to_date'] != "") {
            $this->db->where("DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') <=", $where['to_date']);
        }
        $ordersWithoutStatusException = $this->db->get();
        return $ordersWithoutStatusException->num_rows() > 0 ? $ordersWithoutStatusException->row()->count_orders : 0;
    }

    public function getCountOfOrder( array $where): int
    {
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        if (empty($where)) {
            return 0;
        }
        $this->db->select("count(DISTINCT (o.id)) AS count_orders");
        $this->db->from("tb_orders o");
        $this->db->join("tb_employee emp", "o.order_id = emp.order_id", "LEFT");
        if (isset($where['customer_name']) && !empty($where['customer_name'])) {
            $this->db->join("tb_customers cu", "cu.id = o.customer_id", "LEFT");
        }
        $this->db->where_not_in("o.status", [0, 3]);
        $this->db->where("o.company_code", $companyCode);
        $this->db->where("o.branch_code", $branchCode);
        if (isset($where['customer_name']) && !empty($where['customer_name'])) {
            $this->db->where_in("cu.name", $where['customer_name']);
        }
        if (isset($where['from_date']) && $where['from_date'] != "") {
            $this->db->where("DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') >=", $where['from_date']);
        }
        if (isset($where['to_date']) && $where['to_date'] != "") {
            $this->db->where("DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') <=", $where['to_date']);
        }
        $ordersCount = $this->db->get();
        return $ordersCount->num_rows() > 0 ? $ordersCount->row()->count_orders : 0;
    }

    public function searchCustomers(string $searchTerm): array
    {

        if (strlen($searchTerm) < 3) {
            return [];
        }
        $sql = "SELECT DISTINCT(name)
                    FROM   tb_customers
                    WHERE company_code = ?
                      AND name LIKE CONCAT('%', ?, '%')
                      AND status = 1
                    ORDER  BY id DESC
                    LIMIT  10";
        $query = $this->db->query($sql, ['CNKN', $searchTerm]);
        return $query ? $query->result_array() : [];
    }

    public function getCountOfOrderWithDifferentStatuses(array $where): array
    {
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        if (empty($where)) {
            return [];
        }
        $this->db->select("o.id,o.trip_sts,o.shift_id,o.trip_id");
        $this->db->from("tb_orders o");
        $this->db->join("tb_employee emp", "o.order_id = emp.order_id", "LEFT");
        if (isset($where['customer_name']) && $where['customer_name'] != "") {
            $this->db->join("tb_customers cu", "cu.id = o.customer_id", "LEFT");
        }
        $this->db->where_not_in("o.status", [0, 3]);
        $this->db->where("o.company_code", $companyCode);
        $this->db->where("o.branch_code", $branchCode);
        if (isset($where['customer_name']) && !empty($where['customer_name'])) {
            $this->db->where_in("cu.name", $where['customer_name']);
        }
        if (isset($where['from_date']) && $where['from_date'] != "") {
            $this->db->where("DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') >=", $where['from_date']);
        }
        if (isset($where['to_date']) && $where['to_date'] != "") {
            $this->db->where("DATE_FORMAT(`o`.`pickup_datetime`,'%Y-%m-%d') <=", $where['to_date']);
        }
        $OrderStatuses = $this->db->get();
        return $response = ($OrderStatuses->num_rows() > 0) ? $OrderStatuses->result_array() : [];
    }

    public function getOrdersReport(): array
    {
        $sql = "SELECT
               `o`.`id`,
               `o`.`shift_id`,
               DATE_FORMAT(convertToClientTZ(`o`.`pickup_datetime` , c.cntry_timezone) , '%d-%m-%Y') AS 'early_pickup_date',
               DATE_FORMAT(convertToClientTZ(`o`.`pickup_datetime` , c.cntry_timezone) , '%H:%i') AS 'early_pickup_time',
              `o`.`pickup_company`,
              `o`.`pickup_city`,
              `o`.`quantity`,
              (SELECT SUM(quantity) FROM tb_orders WHERE shift_id=o.shift_id AND status !=0 AND shift_id > 0  group by shift_id) AS trip_quantity,
              (SELECT GROUP_CONCAT(
                concat(r.reference_id, ' - ', r.ref_value) SEPARATOR '?????'
              ) FROM tb_order_references r
                        WHERE r.order_id = o.id AND reference_id IN ('SAC','SAD','REM','AWB') AND status = 1) AS order_references,
            cu.name as customer_name,
            v.name as carrier_name,
            v.mobile as carrier_mobile,
            DATE_FORMAT(convertToClientTZ(s.createdon, c.cntry_timezone) , '%d-%m-%Y %H:%i') AS 'pickup_time',
            DATE_FORMAT(convertToClientTZ(s1.createdon, c.cntry_timezone) , '%d-%m-%Y %H:%i') AS 'status_2400',
            td.register_number,
            tt.trucktype as vehicle_type,
            tdr.name as driver_name,
            tdr.contact_num as driver_mobile,
            tdr.driver_national_identification_number as driver_id
            FROM
              `tb_orders` `o`
              LEFT JOIN `tb_order_details` `od` ON `o`.`id` = `od`.`order_row_id`
              LEFT JOIN `tb_users` `u` ON `o`.`user_id` = `u`.`id`
              LEFT JOIN `tbl_country_master` `c` ON `u`.`country_code` = `c`.`country_code`
              LEFT JOIN `tb_branch_master` `bm` ON `o`.`branch_code` = `bm`.`branch_code`
              LEFT JOIN `tb_customers` `cu` ON `o`.`customer_id` = `cu`.`id`
              LEFT JOIN `tb_vendors` `v` ON `o`.`vendor_id` = `v`.`id`
              LEFT JOIN `tb_stop_status` `s` ON `o`.`id` = `s`.`order_id` AND `s`.`status_code` = '0500' AND `s`.`status` = 1
              LEFT JOIN `tb_stop_status` `s1` ON `o`.`id` = `s1`.`order_id` AND `s1`.`status_code` = '2400' AND `s1`.`status` = 1
              LEFT JOIN tb_trips tp on tp.id=o.trip_id
              LEFT JOIN tb_trucks_data td on td.id=tp.vehicle_id
              LEFT JOIN tb_trucktypes tt on tt.id=td.truck_type
              LEFT JOIN tb_truck_drivers tdr on tdr.id=tp.driver_id
            WHERE cu.code IN ? AND `o`.`created_source` = ? AND `o`.`status` != ? AND MONTH(`o`.`createdon`) = MONTH(now()) AND YEAR(`o`.`createdon`) = YEAR(now())  GROUP BY o.id ORDER BY o.shift_id,o.id DESC";
        $query = $this->db->query($sql, [['1004573268', '1000466462'], 5, 0]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCargoDetails(array $orderRowIds = []): array
    {
        if (empty($orderRowIds)) {
            return [];
        }
        $this->db->select('ocd.order_id,CONCAT(cd.length,"cm"," ",cd.width,"cm"," ",cd.height,"cm") as cargo');
        $this->db->from("tb_cargo_details cd");
        $this->db->join('tb_order_cargodetails ocd', 'cd.id= ocd.cargo_id', 'LEFT');
        $this->db->where_in('ocd.order_id', $orderRowIds);
        $this->db->where('ocd.status', 1);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $eachRow) {
            $results[$eachRow['order_id']][] = $eachRow['cargo'];
        }
        return $results ?? [];
    }
}
