<?php
class Cabmodel extends CI_Model
{
    public function getTableData($table, $whr, $select)
    {
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($whr);
        $res = $this->db->get();
        return $res->result_array();
    }

    public function getslasummary($post)
    {
        $where = " where tr.trip_status = 1 ";
        if($this->session->userdata("business_type")=="Carrier"){
            $uid = $this->session->userdata("id");
            $where .= " and tr.vendor_id = '$uid' ";
        }else {
            if (isset($post['user_id']) && $post['user_id'] > 0) {
                $where .= " and tr.user_id = '" . $post['user_id'] . "' ";
            } else {
                $where .= " and tr.user_id = '" . $this->session->userdata('user_id') . "' ";
            }
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['driver_search']) && trim($post['driver_search']) != "") {
            $getlocid = $this->getDriversBySearch($post['driver_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.driver_id IN (" . $dd . ")";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }
        if (isset($post['zone_search']) && $post['zone_search'] != "") {
            $getlocid = $this->getTripsByZoneSearch($post['zone_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzz[] = $ld['id'];
                }
                $zs = implode(",", $zzz);
            } else {
                $zs = 0;
            }
            $where .= " and tr.trip_id IN (" . $zs . ")";
        }
        if (isset($post['shift_search'])) {
            if (($key = array_search("", $post['shift_search'])) !== false) {
                unset($post['shift_search'][$key]);
            }
            if (!empty($post['shift_search'])) {
                $getlocid = $this->getTripsByShiftSearch($post['shift_search']);
                if (count($getlocid) > 0) {
                    foreach ($getlocid as $ld) {
                        $ddd[] = $ld['id'];
                    }
                    $dd = implode(",", $ddd);
                } else {
                    $dd = 0;
                }
                $where .= " and tr.trip_id IN (" . $dd . ")";
            }
        }

        $query = "select t.register_number,t.id,SUM(IFNULL(t.truck_capacity,0)) as tcapacity,SUM(tr.attended_emp) as attended_emp,count(tr.trip_id) as tripcount,SUM(tr.trip_distance) as tripdist,SUM(IF(tr.trip_type = 0, 1, 0)) AS regulartrip,SUM(IF(tr.trip_type = 1, 1, 0)) AS returntrip,SUM(IF(tr.trip_type = 2, 1, 0)) AS emptytrip,SUM(IF(tr.trip_type = 0, tr.trip_distance, 0)) as regdist,SUM(IF(tr.trip_type = 1, tr.trip_distance, 0)) as returndist,SUM(IF(tr.trip_type = 2, tr.trip_distance, 0)) as emptydist from tb_trip_summary as tr, tb_truck_drivers as us,tb_trucks_data t " . $where . " AND tr.vehicle_id=t.id AND us.id = tr.driver_id GROUP BY tr.vehicle_id";
        return $this->db->query($query);
    }

    public function getslareports($post, $limit, $offset)
    {
        $where = " where tr.trip_status = 1 ";
        if($this->session->userdata("business_type")=="Carrier"){
            $uid = $this->session->userdata("id");
            $where .= " and tr.vendor_id = '$uid' ";
        }else {
            if (isset($post['user_id']) && $post['user_id'] > 0) {
                $where .= " and tr.user_id = '" . $post['user_id'] . "' ";
            } else {
                $where .= " and tr.user_id = '" . $this->session->userdata('user_id') . "' ";
            }
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['driver_search']) && trim($post['driver_search']) != "") {
            $getlocid = $this->getDriversBySearch($post['driver_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.driver_id IN (" . $dd . ")";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }

        if (isset($post['zone_search']) && trim($post['zone_search']) != "") {
            $getlocid = $this->getTripsByZoneSearch($post['zone_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzz[] = $ld['id'];
                }
                $zs = implode(",", $zzz);
            } else {
                $zs = 0;
            }
            $where .= " and tr.trip_id IN (" . $zs . ")";
        }
        if (isset($post['shift_search'])) {
            if (($key = array_search("", $post['shift_search'])) !== false) {
                unset($post['shift_search'][$key]);
            }
            if (!empty($post['shift_search'])) {
                $getlocid = $this->getTripsByShiftSearch($post['shift_search']);
                if (count($getlocid) > 0) {
                    foreach ($getlocid as $ld) {
                        $ddd[] = $ld['id'];
                    }
                    $dd = implode(",", $ddd);
                } else {
                    $dd = 0;
                }
                $where .= " and tr.trip_id IN (" . $dd . ")";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $query = "select t.register_number,IFNULL(t.truck_capacity,0) as tcapacity,tr.trip_id,convertToClientTZ(tr.start_time,'".$curtz."') as start_time,convertToClientTZ(tr.end_time,'".$curtz."') as end_time,tr.trip_distance,tr.attended_emp,tr.trip_type,us.name,us.contact_num,tp.act_splace,tp.act_eplace,tp.splace,(select ish.etime from tb_trips it,tb_shifts ish where it.id=tr.trip_id and ish.id=it.shift_id) as dvrlate from tb_trip_summary as tr, tb_truck_drivers as us,tb_trucks_data t,tb_trips tp " . $where . " AND tr.vehicle_id=t.id AND us.id = tr.driver_id and tr.trip_id=tp.id order by tr.createdon DESC";
        if ($limit > 0) {
            $query .= " limit " . $offset . "," . $limit;
        }
        return $this->db->query($query);
    }

    public function getshiftreports($post, $limit, $offset)
    {
        $where = " where tr.trip_status = 1 ";
        $businessType = $this->session->userdata("business_type");
        if ($businessType == "Carrier") {
            $uid = $this->session->userdata("id");
            $where .= " and tr.vendor_id = '$uid' ";
        } elseif ($businessType == "Customer") {
            $customerId = $this->session->userdata("cust_id");
            $where .= " and s.customer_id = '$customerId' ";
        } else {
            if (isset($post['user_id']) && $post['user_id'] > 0) {
                $where .= " and tr.user_id = '" . $post['user_id'] . "' ";
            } else {
                $where .= " and tr.user_id = '" . $this->session->userdata('user_id') . "' ";
            }
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }

        if (isset($post['type_search']) && !empty(trim($post['type_search']))) {
            $getlocid = $this->getTripsByTypeSearch($post['type_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzzs[] = $ld['id'];
                }
                $ts = implode(",", $zzzs);
            } else {
                $ts = 0;
            }
            $where .= " and tr.trip_id IN (" . $ts . ")";
        }

        if (isset($post['shift_search']) && $post['shift_search'] != "") {

            if (!empty($post['shift_search'])) {
                $dd = $post['shift_search'];
                //$where .= " AND trip.shift_id=$dd ";
                $where .= " AND s.shipmentid='$dd' ";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if ($businessType == "Customer") {
            $query = "select trip.shift_id,t.register_number,IFNULL(t.truck_capacity,0) as tcapacity,tr.trip_id,convertToClientTZ(tr.start_time,'" . $curtz . "') as start_time,convertToClientTZ(tr.end_time,'" . $curtz . "') as end_time,us.name,us.contact_num,(select ish.etime from tb_trips it,tb_shifts ish where it.id=tr.trip_id and ish.id=it.shift_id) as dvrlate from tb_trip_summary as tr, tb_truck_drivers as us,tb_trucks_data t,tb_trips trip,tb_shifts s " . $where . " AND s.id=trip.shift_id AND tr.vehicle_id=t.id AND us.id = tr.driver_id AND trip.id = tr.trip_id order by tr.createdon DESC";
        } else {
            $query = "select trip.shift_id,t.register_number,IFNULL(t.truck_capacity,0) as tcapacity,tr.trip_id,convertToClientTZ(tr.start_time,'" . $curtz . "') as start_time,convertToClientTZ(tr.end_time,'" . $curtz . "') as end_time,us.name,us.contact_num,(select ish.etime from tb_trips it,tb_shifts ish where it.id=tr.trip_id and ish.id=it.shift_id) as dvrlate from tb_trip_summary as tr, tb_truck_drivers as us,tb_trucks_data t,tb_trips trip " . $where . " AND tr.vehicle_id=t.id AND us.id = tr.driver_id AND trip.id = tr.trip_id order by tr.createdon DESC";
        }
        if ($limit > 0) {
            $query .= " limit " . $offset . "," . $limit;
        }
        
        return $this->db->query($query);
    }

    public function getDriversBySearch($driver)
    {
        $result = array();
        $this->db->select('id');
        if (is_numeric($driver)) {
            $this->db->like('contact_num', $driver);
        } else {
            $this->db->like('name', $driver);
        }
        $res = $this->db->get('tb_truck_drivers');
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getVehiclesBySearch($vehicle)
    {
        $result = array();
        $this->db->select('t.id');
        $this->db->from('tb_trip_summary s');
        $this->db->join('tb_trucks_data t', 's.vehicle_id=t.id', 'INNER');
        $this->db->like('t.register_number', $vehicle);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        log_message("error","Inn:".$this->db->last_query());
        return $result;
    }

    public function getTripsByZoneSearch($zone)
    {
        $result = array();
        $shift  = array();
        $this->db->select('s.id');
        $this->db->from('tb_shifts s');
        $this->db->join('tb_shift_zones z', 's.zone_id=z.id', 'INNER');
        $this->db->where('z.id', $zone);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $rw) {
                array_push($shift, $rw->id);
            }
        }
        $this->db->select('id');
        $this->db->from('tb_trips');
        if (!empty($shift)) {
            $this->db->where_in('shift_id', $shift);
        } else {
            $this->db->where('shift_id', 0);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getTripsByShiftSearch($shift)
    {
        $result = array();
        $this->db->select('id');
        $this->db->from('tb_trips');
        if (is_array($shift) && !empty($shift)) {
            $this->db->where_in('shift_id', $shift);
        } else {
            $this->db->where('shift_id', $shift);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getTripsByTypeSearch($shifttype)
    {
        $result = array();
        $this->db->select('t.id');
        $this->db->from('tb_trips t');
        $this->db->join('tb_shifts s', 't.shift_id=s.id', 'INNER');
        $this->db->where('s.trip_type', $shifttype);
        $this->db->group_by('t.id');
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getTripsByShiftStartSearch($shift)
    {
        $res = array();
        $this->db->select('t.id');
        $this->db->from('tb_trips t');
        $this->db->join('tb_shifts s', 't.shift_id=s.id', 'INNER');
        $this->db->where('s.startdate', $shift);
        $res = $this->db->get();
        return $res;
    }

    public function getuserbytrip($whr)
    {
        $result = array();
        $this->db->select("s.user_id");
        $this->db->from("tb_trips t");
        $this->db->join("tb_shifts s", "t.shift_id=s.id", "INNER");
        $this->db->where($whr);
        $this->db->limit(1);
        $result = $this->db->get();
        return $result;
    }

    public function getempsummary($post)
    {
        $empid = "";
        $chkdt = "";
        $where = " where tr.trip_status = 1 ";
        if($this->session->userdata("business_type")=="Carrier"){
            $uid = $this->session->userdata("id");
            $where .= " and tr.vendor_id = '$uid' ";
        }else {
            if (isset($post['user_id']) && $post['user_id'] > 0) {
                $where .= " and e.user_id = '" . $post['user_id'] . "' ";
            } else {
                $where .= " and e.user_id = '" . $this->session->userdata('user_id') . "' ";
            }
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
            $chkdt .= " and date(stime) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
            $chkdt .= " and date(stime) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['emp_search']) && trim($post['emp_search']) != "") {
            $enam = trim($post['emp_search']);
            $where .= " and e.order_id LIKE '%" . $enam . "%' ";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }
        if (isset($post['zone_search']) && $post['zone_search'] != "") {
            $getlocid = $this->getTripsByZoneSearch($post['zone_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzz[] = $ld['id'];
                }
                $zs = implode(",", $zzz);
            } else {
                $zs = 0;
            }
            $where .= " and tr.trip_id IN (" . $zs . ")";
        }
        if (isset($post['shift_search'])) {
            if (($key = array_search("", $post['shift_search'])) !== false) {
                unset($post['shift_search'][$key]);
            }
            if (!empty($post['shift_search'])) {
                $getlocid = $this->getTripsByShiftSearch($post['shift_search']);
                if (count($getlocid) > 0) {
                    foreach ($getlocid as $ld) {
                        $ddd[] = $ld['id'];
                    }
                    $dd = implode(",", $ddd);
                } else {
                    $dd = 0;
                }
                $where .= " and tr.trip_id IN (" . $dd . ")";
            }
        }

        $query = "select tr.trip_id,count(us.employee_id) as attendcount,SUM( IF( us.emp_late > 0, 1, 0 ) ) AS delaycnt,e.id,e.name,e.phone,e.pickup,e.`drop`,e.shipment_weight,e.shipment_volume,e.ship_type from tb_trip_summary as tr, tb_trip_employee as us,tb_employee e " . $where . " AND tr.trip_id=us.trip_id AND us.employee_id=e.id AND us.status=1 $empid GROUP BY us.employee_id";
        return $this->db->query($query);
    }

    public function getempreports($post, $limit, $offset)
    {
        $empid = "1";
        $where = " where tr.trip_status = 1 ";
        if($this->session->userdata("business_type")=="Carrier"){
            $uid = $this->session->userdata("id");
            $where .= " and tr.vendor_id = '$uid' ";
        }else {
            if (isset($post['user_id']) && $post['user_id'] > 0) {
                $where .= " and e.user_id = '" . $post['user_id'] . "' ";
            } else {
                $where .= " and e.user_id = '" . $this->session->userdata('user_id') . "' ";
            }
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['emp_search']) && trim($post['emp_search']) != "") {
            $enam = trim($post['emp_search']);
            $where .= " AND e.order_id LIKE '%" . $enam . "%' ";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }
        if (isset($post['zone_search']) && trim($post['zone_search']) != "") {
            $getlocid = $this->getTripsByZoneSearch($post['zone_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzz[] = $ld['id'];
                }
                $zs = implode(",", $zzz);
            } else {
                $zs = 0;
            }
            $where .= " and tr.trip_id IN (" . $zs . ")";
        }
        if (isset($post['shift_search'])) {
            if (($key = array_search("", $post['shift_search'])) !== false) {
                unset($post['shift_search'][$key]);
            }
            if (!empty($post['shift_search'])) {
                $getlocid = $this->getTripsByShiftSearch($post['shift_search']);
                if (count($getlocid) > 0) {
                    foreach ($getlocid as $ld) {
                        $ddd[] = $ld['id'];
                    }
                    $dd = implode(",", $ddd);
                } else {
                    $dd = 0;
                }
                $where .= " and tr.trip_id IN (" . $dd . ")";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $query = "select * from(select e.assoc_id,tr.trip_id,convertToClientTZ(tr.start_time,'".$curtz."') as start_time,convertToClientTZ(tr.end_time,'".$curtz."') as end_time,us.check_in,us.status,e.shipment_weight,e.shipment_volume, us.driver_late,IFNULL((select (IFNULL(us.driver_late,0) - IFNULL(t2.emp_late,0)) as tt from tb_trip_employee t2 where t2.id = us.id - 1 AND us.trip_id=t2.trip_id),0) as driverlate,us.emp_late,e.name as ename,e.phone,e.ship_type,dr.name,dr.contact_num from tb_trip_summary as tr, tb_trip_employee as us,tb_employee e, tb_truck_drivers as dr " . $where . " AND tr.trip_id=us.trip_id AND us.employee_id=e.id AND us.status=1 AND dr.id=tr.driver_id ORDER BY tr.trip_id DESC) T where $empid";
        /*log_message("error",json_encode($query));*/
        if ($limit > 0) {
            $query .= " limit " . $offset . "," . $limit;
        }
        return $this->db->query($query);
    }

    public function getTripsByEmpSearch($emp)
    {
        $result = array();
        $this->db->select('t.trip_id as id');
        $this->db->from('tb_trip_employee t');
        $this->db->join('tb_employee e', 't.employee_id=e.id', 'INNER');
        if (is_numeric($emp)) {
            $this->db->like('e.assoc_id', $emp);
        } else {
            $this->db->like('e.name', $emp);
        }
        $res    = $this->db->get();
        $result = $res->result_array();
        return $result;
    }

    public function getvehicleshifts($whr)
    {
        $sts = $whr['status'];
        $uid = $whr['user_id'];
        $res = $this->db->query("(select `s`.`id` , `s`.`stime` , `s`.`etime` , `s`.`splace` , `s`.`eplace` , `s`.`trip_type` ,`s`.`empshift_start` , `td`.`register_number` , `t`.`status`,t.id as tripid from tb_trips t,tb_shifts s,tb_trucks_data td where s.user_id=$uid and s.status=$sts and t.status=1 and t.shift_id=s.id and t.vehicle_id=td.id) UNION ( select `s`.`id` , `s`.`stime` , `s`.`etime` , `s`.`splace` , `s`.`eplace` , `s`.`trip_type` ,`s`.`empshift_start` , `sv`.`register_number`,0 as `status`,0 as `tripid` from tb_shifts s,tb_shft_veh sv where s.user_id=$uid and s.status=$sts and sv.shft_id=s.id and sv.status=1 )");
        /*log_message('error',$this->db->last_query());*/
        /*echo $this->db->last_query();exit;*/
        return $res;
    }

    public function dashbsearch($post, $uid)
    {
        $whradm = " ($uid) ";
		if($this->session->userdata('business_type') == 'Country Admin'){
            if(count($this->session->userdata('country_user_ids'))>0){
                $users  = implode(",", $this->session->userdata('country_user_ids'));
                $whradm = " ($users) ";
            }
        }
        $twhere   =  $lwhere   = "";
        if ($post['fromdate_search'] != "") {
            $twhere .= " and date(t.createdon) >= '" . $post['fromdate_search'] . "' ";
            $lwhere .= " and date(t.created_on) >= '" . $post['fromdate_search'] . "' ";
        }
        if ($post['todate_search'] != "") {
            $twhere .= " and date(t.createdon) <= '" . $post['todate_search'] . "' ";
            $lwhere .= " and date(t.created_on) <= '" . $post['todate_search'] . "' ";
        }
        $lib = $this->db->query("SELECT t.id FROM tb_orders t WHERE t.trip_id!=0 AND t.trip_sts=0 AND t.user_id IN $whradm ");
        $data['livecabcount'] = $lib->num_rows();
        $data['latecabcount'] = $data['tripdistance'] = $data['totaltrips'] = $data['ontimetrips'] = 0;
        $data['latecabsbottom'] = array();
        $latecabsbottom = $this->db->query("SELECT vendor_id,SUM(st) AS dst, COUNT(st) AS ast,name FROM (SELECT t.vendor_id,IF(t.ship_delay>0,'0','1') AS st,v.name FROM tb_trip_summary t,tb_vendors v WHERE t.vendor_id=v.id AND t.user_id IN $whradm $twhere) T GROUP BY vendor_id ORDER BY dst DESC limit 4");
        if($latecabsbottom->num_rows()>0){
            $data['latecabsbottom'] = $latecabsbottom->result_array();
        }
        $ontimetrips = $this->db->query("SELECT count(s.id) as tottrip,SUM(IFNULL(s.trip_distance,0)) as dist,SUM(IF(s.ship_delay>0,1,0)) AS delays,SUM(IF(s.ship_delay<=0,1,0)) AS ontime
            FROM tb_trips p
            JOIN tb_trip_summary s ON p.id = s.trip_id
            JOIN tb_shifts h ON  p.shift_id = h.id
            JOIN tb_trucks_data d  ON p.vehicle_id = d.id
            JOIN tb_vendor_vehicles vv ON vv.vehicle_id = d.id
            JOIN tb_vendors v ON v.id = vv.vendor_id
             WHERE  p.status = 0 AND s.user_id IN $whradm and DATE_FORMAT( s.end_time, '%H.%i' ) > h.etime and p.trip_type != 2");
        if($ontimetrips->num_rows()>0){
            $data['ontimetrips'] = $ontimetrips->row()->ontime;
            $data['latecabcount'] = $ontimetrips->row()->delays;
            $data['tripdistance'] = $ontimetrips->row()->dist;
            $data['totaltrips'] = $ontimetrips->row()->tottrip;
        }
        return $data;
    }

    public function getunfinishtrips()
    {
        $curtime = date('H.i');
        $curdt   = date('Y-m-d');
        $this->db->select("t.id,t.vehicle_id,t.shift_id,t.driver_id,t.start_imei,t.stime as tripstart,s.stime,s.etime");
        $this->db->from("tb_trips t");
        $this->db->join("tb_shifts s", "t.shift_id=s.id", "INNER");
        $this->db->where("t.status", 1);
        $this->db->where("DATE(t.stime)", $curdt);
        $this->db->where("(s.etime+1) <", $curtime);
        $this->db->group_by("t.id");
        $this->db->order_by("t.id", "DESC");
        $res = $this->db->get();
        return $res;
    }

    public function getemppriority($emp_id, $shftvehid, $priority)
    {
        $result           = array();
        $result['status'] = 'fail';
        $res              = array();
        $curdate          = date('Y-m-d H:i:s');
        $this->db->select("ve.priority");
        $this->db->from("tb_shft_veh_emp ve");
        $this->db->join("tb_shft_veh v", "v.id=ve.shft_veh_id", "INNER");
        $this->db->where("ve.status", 1);
        $this->db->where("v.id", $shftvehid);
        $this->db->where("ve.shft_veh_id", $shftvehid);
        $this->db->where("ve.priority <", $priority);
        $this->db->order_by("ve.priority", "DESC");
        $this->db->limit(1);
        $res1 = $this->db->get();
        if ($res1->num_rows() > 0) {
            $spriority = $res1->row()->priority;
            $change1   = $this->db->set(array('priority' => $priority, 'updated_on' => $curdate))->where(array('shft_veh_id' => $shftvehid, 'priority' => $spriority))->update('tb_shft_veh_emp');
            /*log_message('error',"3".$this->db->last_query());*/
            $change2 = $this->db->set(array('priority' => $spriority, 'updated_on' => $curdate))->where(array('emp_id' => $emp_id, 'shft_veh_id' => $shftvehid))->update('tb_shft_veh_emp');
            /*log_message('error',"4".$this->db->last_query());*/
            $result['status'] = 'success';
        }
        return $result;
    }

    public function custdashbsearch($post, $uid)
    {
        $whr = "";
        $custid = $this->session->userdata('cust_id');
        $data['totalshipments'] = 0;
        $data['openshipscount'] = 0;
        $data['closeshipscount'] = 0;
        $data['liveshipscount'] = 0;
        $data['totcabcount'] = 0;
        $data['ontimetrips'] = array();
        if($custid != ""){
                $slawhere = $lwhere = "";
            if ($post['fromdate_search'] != "") {
                $slawhere .= " and date(p.created_on) >= '" . $post['fromdate_search'] . "' ";
                $lwhere .= " and date(t.created_on) >= '" . $post['fromdate_search'] . "' ";
            }
            if ($post['todate_search'] != "") {
                $slawhere .= " and date(p.created_on) <= '" . $post['todate_search'] . "' ";
                $lwhere .= " and date(t.created_on) <= '" . $post['todate_search'] . "' ";
            }
            $qry = $this->db->query("select SUM(t.id) AS cnt,SUM(IF(t.status = '1', 1, 0 )) AS scnt,SUM(IF(t.status = '0', 1, 0 )) AS ccnt FROM tb_shifts t where t.customer_id=$custid $lwhere");
            $data['totalshipments'] = $qry->row()->cnt;
            $data['openshipscount']   = $qry->row()->scnt;
            $data['closeshipscount']   = $qry->row()->ccnt;
            $this->db->select('t.id');
            $this->db->where("t.shift_id=e.id");
            $this->db->where('t.status', 1);
            if($post['fromdate_search']!=""){
                $this->db->where('date(t.created_on)',$post['fromdate_search']);
            }
            if($post['todate_search']!=""){
                $this->db->where('date(t.created_on)',$post['todate_search']);
            }
            $this->db->where('e.customer_id', 1);
            $this->db->group_by('t.vehicle_id');
            $data['liveshipscount'] = $this->db->query("SELECT t.id FROM tb_trips t,tb_shifts s WHERE t.shift_id=s.id AND t.status=1 AND s.status=1 AND s.customer_id='$custid'")->num_rows();
            $data['totcabcount'] = $data['liveshipscount'];
            $ontimetrips = array();
            $ontimetrips1 = $this->db->query("SELECT count(p.id) AS ontime FROM tb_trips p, tb_trip_summary s, tb_shifts h WHERE p.id = s.trip_id AND p.shift_id = h.id AND p.status =0 AND h.customer_id = $custid and DATE_FORMAT( s.end_time, '%H.%i' ) <= h.etime $slawhere");
            if($ontimetrips1->num_rows()>0){
                $ontimetrips = $ontimetrips1->row_array();
            }
            $data['ontimetrips'] = isset($ontimetrips['ontime']) ? $ontimetrips['ontime'] : 0;
            $totaltrips = array();
            $totaltrips1 = $this->db->query("select count(p.id) as tottrip from tb_trips p,tb_trip_summary s, tb_shifts h where p.id=s.trip_id AND p.shift_id = h.id AND p.status=0 AND h.customer_id = $custid $slawhere");
            if($totaltrips1->num_rows()>0){
                $totaltrips = $totaltrips1->row_array();
            }
            $data['totaltrips'] = isset($totaltrips['tottrip']) ? $totaltrips['tottrip'] : 0;
            $data['delaytrips'] = ($data['totaltrips'] - $data['ontimetrips']);
        }
        return $data;
    }

    public function getshipreports($post, $limit, $offset)
    {
        $empid = "1";
        $where = " where tr.trip_status = 1 ";
        if (isset($post['user_id']) && $post['user_id'] > 0) {
            $where .= " and e.customer_id = '" . $post['user_id'] . "' ";
        } else {
            $where .= " and e.customer_id = 1"; //'" . $this->session->userdata('user_id') . "' ";
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['emp_search']) && trim($post['emp_search']) != "") {
            $enam = trim($post['emp_search']);
            if (is_numeric($enam)) {
                $empid = "assoc_id =" . $enam . " ";
            } else {
                $empid = "ename LIKE '%" . $enam . "%' ";
            }
            $getlocid = $this->getTripsByEmpSearch($enam);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.trip_id IN (" . $dd . ")";
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }
        if (isset($post['zone_search']) && trim($post['zone_search']) != "") {
            $getlocid = $this->getTripsByZoneSearch($post['zone_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzz[] = $ld['id'];
                }
                $zs = implode(",", $zzz);
            } else {
                $zs = 0;
            }
            $where .= " and tr.trip_id IN (" . $zs . ")";
        }

        if (isset($post['shift_search'])) {
            if (($key = array_search("", $post['shift_search'])) !== false) {
                unset($post['shift_search'][$key]);
            }
            if (!empty($post['shift_search'])) {
                $getlocid = $this->getTripsByShiftSearch($post['shift_search']);
                if (count($getlocid) > 0) {
                    foreach ($getlocid as $ld) {
                        $ddd[] = $ld['id'];
                    }
                    $dd = implode(",", $ddd);
                } else {
                    $dd = 0;
                }
                $where .= " and tr.trip_id IN (" . $dd . ")";
            }
        }

        $query = "select * from(select e.assoc_id,tr.trip_id,tr.start_time,tr.end_time,us.check_in,us.status,e.shipment_weight,e.shipment_volume,
        us.driver_late,IFNULL((select (IFNULL(us.driver_late,0) - IFNULL(t2.emp_late,0)) as tt from tb_trip_employee t2 where t2.id = us.id - 1 AND us.trip_id=t2.trip_id),0) as driverlate,us.emp_late,e.name as ename,e.phone,e.ship_type,dr.name,dr.contact_num from tb_trip_summary as tr, tb_trip_employee as us,tb_employee e, tb_truck_drivers as dr " . $where . " AND tr.trip_id=us.trip_id AND us.employee_id=e.id AND us.status=1 AND dr.id=tr.driver_id ORDER BY tr.trip_id DESC) T where $empid";
        if ($limit > 0) {
            $query .= " limit " . $offset . "," . $limit;
        }
        return $this->db->query($query);
    }

    public function getshipsummary($post)
    {
        $empid = "";
        $chkdt = "";
        $where = " where tr.trip_status = 1 ";
        if (isset($post['user_id']) && $post['user_id'] > 0) {
            $where .= " and e.customer_id = '" . $post['user_id'] . "' ";
        } else {
            $where .= " and e.customer_id = 1"; //'" . $this->session->userdata('user_id') . "' ";
        }
        if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
            $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
            $chkdt .= " and date(stime) >= '" . $post['fromdate_search'] . "' ";
        }
        if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
            $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
            $chkdt .= " and date(stime) <= '" . $post['todate_search'] . "' ";
        }
        if (isset($post['emp_search']) && trim($post['emp_search']) != "") {
            $enam = trim($post['emp_search']);
            if (is_numeric($enam)) {
                $empid = " and e.assoc_id =" . $enam . " ";
            } else {
                $empid = " and e.name LIKE '%" . $enam . "%' ";
            }
        }
        if (isset($post['vehicle_search']) && trim($post['vehicle_search']) != "") {
            $getlocid = $this->getVehiclesBySearch($post['vehicle_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.vehicle_id IN (" . $dd . ")";
        }
        if (isset($post['zone_search']) && $post['zone_search'] != "") {
            $getlocid = $this->getTripsByZoneSearch($post['zone_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $zzz[] = $ld['id'];
                }
                $zs = implode(",", $zzz);
            } else {
                $zs = 0;
            }
            $where .= " and tr.trip_id IN (" . $zs . ")";
        }
        if (isset($post['shift_search'])) {
            if (($key = array_search("", $post['shift_search'])) !== false) {
                unset($post['shift_search'][$key]);
            }
            if (!empty($post['shift_search'])) {
                $getlocid = $this->getTripsByShiftSearch($post['shift_search']);
                if (count($getlocid) > 0) {
                    foreach ($getlocid as $ld) {
                        $ddd[] = $ld['id'];
                    }
                    $dd = implode(",", $ddd);
                } else {
                    $dd = 0;
                }
                $where .= " and tr.trip_id IN (" . $dd . ")";
            }
        }
        $query = "select tr.trip_id,count(us.employee_id) as attendcount,SUM( IF( us.emp_late > 0, 1, 0 ) ) AS delaycnt,e.id,e.name,e.phone,e.pickup,e.`drop`,e.shipment_weight,e.shipment_volume,e.ship_type from tb_trip_summary as tr, tb_trip_employee as us,tb_employee e " . $where . " AND tr.trip_id=us.trip_id AND us.employee_id=e.id AND us.status=1 $empid GROUP BY us.employee_id";
        return $this->db->query($query);
    }
}
