<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;
/**
 * Model for tb_cargo_details. Houses information for cargo on orders.
 *
 * Is linked to an order in tb_orders through the tb_order_cargodetails table.
 */
class Cargo_details extends Table
{
    const TABLE = "tb_cargo_details";

    const CARGOTYPE_ID_COL = "cargotype_id";
    const CARGO_TYPE_COL = "cargo_type";
    const CREATEDBY_COL = "createdby";
    const CREATEDON_COL = "createdon";
    const DG_GOODS_COL = "dg_goods";
    const GOODS_DESCRIPTION_COL = "goods_description";
    const GROUNDED_COL = "grounded";
    const HANDLINGUNIT_ID_COL = "handlingunit_id";
    const HANDLING_UNIT_COL = "handling_unit";
    const HEIGHT_COL = "height";
    const HEIGHT_UNIT_COL = "height_unit";
    const ID_COL = "id";
    const ITEM_ID_COL = "item_id";
    const LDM_COL = "ldm";
    const LDM_UOM_COL = "ldm_uom";
    const LENGTH_COL = "length";
    const LENGTH_UNIT_COL = "length_unit";
    const MARKS_NUMBERS_COL = "marks_numbers";
    const QUANTITY_COL = "quantity";
    const SECONDVOLUME_UOM_COL = "secondvolume_uom";
    const SECONDWEIGHT_UOM_COL = "secondweight_uom";
    const SECOND_VOLUME_COL = "second_volume";
    const SECOND_WEIGHT_COL = "second_weight";
    const SPLITTABLE_COL = "splittable";
    const STACKABLE_COL = "stackable";
    const STATUS_COL = "status";
    const UPDATEDBY_COL = "updatedby";
    const UPDATEDON_COL = "updatedon";
    const VOLUMETRIC_WEIGHT_COL = "volumetric_weight";
    const VOLUME_COL = "volume";
    const VOLUME_UNIT_COL = "volume_unit";
    const VOLWEIGHT_UOM_COL = "volweight_uom";
    const WEIGHT_COL = "weight";
    const WEIGHT_UNIT_COL = "weight_unit";
    const WIDTH_COL = "width";
    const WIDTH_UNIT_COL = "width_unit";

    public $cargo_type; // varchar(60)	NULL=YES
    public $cargotype_id; // int(11)	NULL=YES
    public $createdby; // varchar(60)	NULL=YES
    public $createdon; // timestamp	YES
    public $dg_goods; // tinyint(1)	NULL=NO
    public $goods_description; // varchar(200)	NULL=YES
    public $grounded; // tinyint(1)	NULL=NO
    public $handling_unit; // varchar(160)	NULL=YES
    public $handlingunit_id; // int(11)	NULL=YES
    public $height; // decimal(10,2)	NULL=YES
    public $height_unit; // varchar(60)	NULL=YES
    public $id; // int(30)	NULL=NO
    public $item_id; // int(11)	NULL=YES
    public $ldm; // decimal(10,3)	NULL=YES
    public $ldm_uom; // varchar(20)	NULL=YES
    public $length; // decimal(10,2)	NULL=YES
    public $length_unit; // varchar(60)	NULL=YES
    public $marks_numbers; // varchar(50)	NULL=YES
    public $quantity; // int(11)	NULL=YES
    public $second_volume; // decimal(10,3)	NULL=YES
    public $second_weight; // decimal(10,3)	NULL=YES
    public $secondvolume_uom; // varchar(22)	NULL=YES
    public $secondweight_uom; // varchar(22)	NULL=YES
    public $splittable; // tinyint(1)	NULL=NO
    public $stackable; // tinyint(1)	NULL=YES
    public $status; // tinyint(4)	NULL=NO
    public $updatedby; // varchar(60)	NULL=YES
    public $updatedon; // timestamp	NULL=NO
    public $volume; // decimal(10,3)	NULL=YES
    public $volume_unit; // varchar(60)	NULL=YES
    public $volumetric_weight; // decimal(10,2)	NULL=YES
    public $volweight_uom; // varchar(20)	NULL=YES
    public $weight; // decimal(10,2)	NULL=YES
    public $weight_unit; // varchar(60)	NULL=YES
    public $width; // decimal(10,2)	NULL=YES
    public $width_unit; // varchar(60)	NULL=YES
}
