<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Carriercommonmodel extends CI_Model
{
    function getOrderUserTimeZone(int $user_id): array
    {
        $orderUserTimeZone = $this->db->query("SELECT tc.country_name,tc.country_code,tc.cntry_timezone,tc.cntry_hrs,tc.currency,tc.phone_code FROM tb_users u JOIN tbl_country_master tc ON u.country_code=tc.country_code  WHERE u.id=?", [$user_id]);
        return $orderUserTimeZone->num_rows() > 0 ? $orderUserTimeZone->row_array() : [];
    }

    function getShipmentCarrier(int $shipmentNumber): array
    {
        $vendor_id = 0;
        $getCarrier = $this->db->query("SELECT vendor_id FROM tb_orders WHERE shift_id=?", [$shipmentNumber]);
        if ($getCarrier->num_rows() > 0) {
            $vendor_id = $getCarrier->row()->vendor_id;
        } else {
            $checkCarrier = $this->db->query("SELECT carrier_id FROM tb_shft_veh  WHERE shft_id=?", [$shipmentNumber]);
            if ($checkCarrier->num_rows() > 0) {
                $vendor_id = $checkCarrier->row()->carrier_id;
            }
        }
        $vendordetails = $this->db->query(
            "SELECT tv.id,tv.partyid,tv.code,tv.name AS companyname,
			tv.address,tpm.partyindetifier AS party_id,tpm.`street_2`,tpm.`street_3`,tpm.`street`,tpm.`location_id`,
			tpm.`state`,tpm.`mobile`,tpm.`email`,tpm.pincode,tpm.country,tpm.id as partnerid FROM tb_vendors tv LEFT OUTER JOIN tbl_party_master tpm ON tv.code=tpm.code WHERE tv.id=? and tpm.status=1  and tv.status=1", [$vendor_id]
        );
        return $vendordetails->num_rows() > 0 ? $vendordetails->row_array() : [];
    }

    function getShipmentStops(int $shipmentNumber, int $phoneCode): array
    {
        $shipmentPickup = $shipmentDrop = $shipmentPickids = $shipmentDropids = [];
        $shipmentStopsRes = $this->db->query("SELECT o.`pickup_custid`,o.`drop_custid` FROM tb_shiporder_stops  tss LEFT OUTER JOIN tb_employee te ON te.stop_id=tss.id LEFT OUTER JOIN tb_orders o ON o.order_id=te.order_id WHERE tss.status = '1' AND tss.shipment_id= ?", [$shipmentNumber]);
        if ($shipmentStopsRes->num_rows() > 0) {
            foreach ($shipmentStopsRes->result_array() as $stops) {
                if ($stops['pickup_custid'] != "") {
                    array_push($shipmentPickids, $stops['pickup_custid']);
                }
                if ($stops['drop_custid'] != "") {
                    array_push($shipmentDropids, $stops['drop_custid']);
                }
            }
            $pickupId = $shipmentPickids[0];
            $dropID = end($shipmentDropids);
        }
        if ($pickupId) {
            $shipmentPickup = $this->common->gettblrowdata(["code" => $pickupId], "id,name,code,location_id as city, address,state,country,pincode,email,mobile,street,street_2,street_3", "tbl_party_master", 0, 0);
            if (empty($shipmentPickup)) {
                $shipmentPickup = $this->common->gettblrowdata(["customeridentifier" => $pickupId], "id,name,code,location_id as city, address,state,country,pincode,email,mobile,street,street_2,street_3", "tbl_party_master", 0, 0);
            }
            $shipmentPickup['phone_code'] = $phoneCode;
        }
        if ($dropID) {
            $shipmentDrop = $this->common->gettblrowdata(["code" => $dropID], "id,name,code,location_id as city, address,state,country,pincode,email,mobile,street,street_2,street_3", "tbl_party_master", 0, 0);
            if (empty($shipmentDrop)) {
                $shipmentDrop = $this->common->gettblrowdata(["customeridentifier" => $dropID], "id,name,code,location_id as city, address,state,country,pincode,email,mobile,street,street_2,street_3", "tbl_party_master", 0, 0);
            }
            $shipmentDrop['phone_code'] = $phoneCode;
        }
        return [
            "pickup" => $shipmentPickup,
            "delivery" => $shipmentDrop
        ];
    }

    function getshipmentVehicleInfo(int $shipmentNumber): array
    {
        $vehicleInfo = [];
        $getShipmentVehicle = $this->db->query("SELECT `carrier_id`,`vehicle_id` FROM tb_shft_veh WHERE shft_id=? AND status=1", [$shipmentNumber]);
        if ($getShipmentVehicle->num_rows() > 0) {
            $vehicle_id = $getShipmentVehicle->row()->vehicle_id ?? 0;
            $vehicleInfo = $this->common->gettblrowdata(["id" => $vehicle_id], "*", "tb_trucks_data", 0, 0);
        }
        return $vehicleInfo;
    }

    function getshipmentAssignDeiver(int $shipmentNumber): array
    {
        $this->db->select("ttd.name,ttd.contact_num,ttd.driving_licence_num,ttd.city,ttd.`email`,ttd.`address1`,ttd.`address2`,ttd.`street`,ttd.`state`,ttd.`pincode`,ttd.`country`");
        $this->db->from("tb_shft_veh tsv");
        $this->db->join("tbl_assigned_drivers tad", "tsv.vehicle_id=tad.vehicle_id", "INNER");
        $this->db->join("tb_truck_drivers ttd", "tad.driver_id = ttd.id", "INNER");
        $this->db->where("tsv.status", 1);
        $this->db->where("tad.status", 1);
        $this->db->where("ttd.status", 1);
        $this->db->where("tsv.shft_id", $shipmentNumber);
        $this->db->order_by('ttd.id', 'DESC');
        $this->db->limit(1);
        $getShipmentDriver = $this->db->get();
        return $getShipmentDriver->num_rows() > 0 ? $getShipmentDriver->row_array() : [];
    }

    function getPartyMasterDetails(int $orderId, string $patryType = ""): array
    {
        $this->db->select("tpm.id, tpm.code, tpm.name, tpm.street, tpm.street_2,tpm.street_3, tpm.email,tpm.mobile,tpm.location_id AS city, tpm.address,tpm.country,tpm.state,tpm.pincode,tpt.name");
        $this->db->from("`tb_order_parties` top");
        $this->db->join("tbl_party_master tpm", "top.party_id=tpm.id", "INNER");
        $this->db->join("`tbl_party_types` tpt", "top.party_type= tpt.id", "INNER");
        $this->db->where("top.order_id", $orderId);
        $this->db->where("top.status", 1);
        $this->db->where("UPPER(tpt.name)", $patryType);
        $partyMasterDetails = $this->db->get();
        return $partyMasterDetails->num_rows() > 0 ? $partyMasterDetails->row_array() : [];
    }

    public function getCarrierEDIDetails(int $carrierID): array
    {
        $carrierEDIDetails = $this->db->query(
            "SELECT tbp.value AS editype,tpe.edi_url,tta.name AS ediname,tet.`name` AS ediservice,tpe.`user_name`,tpe.`password`,tpe.authentication FROM tb_vendors tv LEFT JOIN tbl_party_master tpm ON tv.code=tpm.code LEFT JOIN tb_party_reference  tbp ON  tbp.`partner_id`=tpm.id AND tbp.name='EDI_TYPE' AND tbp.status=1 LEFT JOIN tbl_partner_ediapi tpe ON  tpe.`partner_id`=tpm.id AND tpe.status=1 LEFT  JOIN `tbl_edi_types` tet ON tpe.type=tet.id LEFT JOIN `tbl_txn_actions` tta ON tpe.`transaction_action`=tta.id  WHERE tv.id = ? AND tta.name='Shipment'",
            [$carrierID]
        );
        return $carrierEDIDetails->num_rows() > 0 ? $carrierEDIDetails->result_array() : [];
    }

    public function getPartyAdditionalContacts(int $partnerId): array
    {
        $partyContacts = $this->db->query(
            "SELECT * FROM tbl_partner_contacts where partner_id= ?",
            [$partnerId]
        );
        return $partyContacts->num_rows() > 0 ? $partyContacts->result_array() : [];
    }

    public function getShipmentLegOrderDetails(int $shipmentNumber): array
    {
        $this->db->select("o.id as orderno,o.*,tod.*");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details tod", "o.id=tod.order_row_id");
        $this->db->join("`tb_employee` te", "te.order_id= o.order_id");
        $this->db->where("te.shift_id", $shipmentNumber);
        $orderDetails = $this->db->get();
        return $orderDetails->num_rows() > 0 ? $orderDetails->result_array() : [];
    }

    public function getAdditionalcontacts(int $orderId, string $carrierReference): array
    {
        $carrierAdditionalinfo = [];
        $getCarrierReferences = $this->db->query("select reference_id, ref_value from tb_order_references where order_id = ? and reference_id = ? and status=1", [$orderId, $carrierReference]);
        if ($getCarrierReferences->num_rows() > 0) {
            foreach ($getCarrierReferences->result_array() as $references) {
                $referencesvalues = explode(",", $references['ref_value']);
                $carrierAdditionalinfo[] = [
                    "name" => $referencesvalues[0] ?? "",
                    "street" => "",
                    "city" => "",
                    "state" => "",
                    "zipcode" => "",
                    "fax" => "",
                    "country" => "",
                    "phone" => $referencesvalues[1] ?? "",
                    "email" => $referencesvalues[2] ?? ""
                ];
            }
        }
        return $carrierAdditionalinfo ?? [];
    }

    public function getOrderCargoSummary(int $order_id): array
    {
        $this->db->select(
            "o.weight, o.gross_weight_uom, o.chargeable_weight, o.chargeable_weight_uom, GROUP_CONCAT(`cx`.weight_unit) AS weight_unit, `cx`.secondweight_uom, `cx`.secondvolume_uom, SUM(CASE WHEN c.status = '1' THEN c.second_weight ELSE 0 END) AS second_weight, SUM(CASE WHEN c.status = '1' THEN c.second_volume ELSE 0 END) AS second_volume,  TRUNCATE(SUM(CASE WHEN c.status = '1' THEN (CASE WHEN `cx`.`weight_unit` IN ('G', 'Gms', 'gms', 'grm') THEN c.weight/1000 ELSE (CASE WHEN `cx`.`weight_unit` IN ('Kg', 'kg') THEN c.weight ELSE
(CASE WHEN `cx`.`weight_unit` IN ('Tons', 'tons') THEN c.weight * 1000 ELSE CASE WHEN o.company_code ='AUKN' THEN c.weight ELSE 0 END END) END) END) ELSE 0 END), 3) AS totwg, SUM(CASE WHEN c.status = '1' THEN c.volume ELSE 0 END) AS totvol, SUM(CASE WHEN c.status = '1' THEN c.quantity ELSE 0 END) AS totqty, SUM(CASE WHEN c.status = '1' THEN c.scanned_quantity ELSE 0 END) AS tot_scanned_qty"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_cargodetails c", "o.id=c.order_id");
        $this->db->join("tb_cargo_details cx", "c.cargo_id=cx.id");
        $this->db->where("o.id", $order_id);
        $orderCargoDetails = $this->db->get();
        return $orderCargoDetails->num_rows() > 0 ? $orderCargoDetails->row_array() : [];
    }


}
