<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property CI_DB_mysqli_prod_driver $db
 */
class Common extends CI_Model
{
    public function gettblrowdata($where, $select, $table, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        if ($table == 'tb_consolidation_rules' || $table == 'salog_inbound_history') {
            $this->db->order_by('id', 'DESC');
        }
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->row_array();
            }
        }
        return $result;
    }

    public function getdateandtime($datetime)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $dateandtime = getdatetimebytimezone($curtz, $datetime, DFLT_TZ);
        $date_time = $dateandtime['datetime'];
        $date_time = date('d-m-Y H:i:s', strtotime($date_time));

        return $date_time;

    }

    public function chkOrderinfoBygateoutdate($ord, $curtz)
    {
        $ci = &get_instance();
        $res = array();
        $gateoutdate = "";
        if ($ord != "") {
            $sql = "SELECT createdon FROM tb_stop_status WHERE order_id='" . $ord . "' and status_code='3000' ORDER BY id DESC LIMIT 1";
            $query = $ci->db->query($sql);
            if ($query->num_rows() > 0) {
                $res = $query->row_array();
                $gateoutdate = $res['createdon'];
            }
        }

        return $gateoutdate;
    }

    public function gettbldata($where, $select, $table, $limit, $start, $objFlag = false)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        if ($table == 'tb_shipment_locations' || $table == 'tb_shifts') {
            $this->db->order_by('id', 'ASC');
        }
        
        if ($table == 'tbl_country_master') {
            $this->db->distinct();
            $this->db->order_by('currency', 'ASC');
        }
        
        if ($table == 'tb_orders') {
            $this->db->order_by('id', 'ASC');
        }
        if (($table = 'tb_branch_master') || ($table = 'tb_company_master') || ($table = 'tb_department_master') || ($table = 'tb_users') || ($table = 'tb_customers') || ($table = 'tb_products_master')) {
            $this->db->order_by('id', 'DESC');
        }
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = ($objFlag) ? $res->result() : $res->result_array();
            }
        }
        return $result;
    }

    public function gettbldata_where_in($where, $where_in, $select, $table, $limit = 0, $start = 0)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where_in($where_in['col'], $where_in['arr']);
        $this->db->where($where);

        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
            }
        }

        return $result;
    }

    public function getjointbldata($table, $table2, $where, $where1, $select, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->join($table2, $where, "INNER");
        $this->db->where($where1);
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function insertTableData($tablename, $data)
    {
        $res = 0;
        $qry = $this->db->insert($tablename, $data);
        $res = $this->db->insert_id();
        if ($qry) {
            $res = $this->db->insert_id();
        }
        return $res;
    }

    public function insertbulk($tablename, $data)
    {
        return $this->db->insert_batch($tablename, $data);
    }

    public function updatetbledata($tablename, $set, $whr)
    {
        $upd = $this->db->set($set)->where($whr)->update($tablename);
        return true;
    }

    public function updatetbledata_where_in(string $table, array $set, array $where_in, array $where = array())
    {
        $this->db->where_in($where_in['col'], $where_in['arr']);
        if (!empty($where)) {
            $this->db->where($where);
        }

        return $this->db->update($table, $set);
    }

    public function get_last_insert_id($table_name)
    {
        $this->db->select_max('id', 'max');
        $query = $this->db->get($table_name);
        if ($query->num_rows() == 0) {
            return 1;
        }
        $max = $query->row()->max;
        return $max == 0 ? 1 : $max + 1;
    }

    public function getlatlngs($ship_id, $location)
    {
        $res = $this->db->query('select l.locationname,l.city,l.latitude,l.longitude,l.address,s.pickupestimate,s.pickupplanned,s.deliveryestimate,s.deliveryplan FROM tb_shipment_stops s,tb_shipment_locations l WHERE s.shipment_id="' . $ship_id . '" AND s.location=l.locationid AND s.shipment_id=l.shipment_id AND s.location="' . $location . '" LIMIT 1');
        return $res;

    }

    private function getintransitshipdata(): array
    {
        $result = [];
        $this->db->select("s.id");
        $this->db->from("tb_shifts s");
        $this->db->join("tb_trips t", 's.id=t.shift_id', 'INNER');
        $this->db->where(["s.status" => 1, "t.status" => 1]);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $re) {
                $result[] = $re->id;
            }
        }
        return $result;
    }

    public function getintransitshipmenttbldata($table, $table2, $where, $select, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table, 'tb_shft_veh v', 'tbl_assigned_drivers a', 'tb_truck_drivers td');
        $this->db->join("tb_trips t", 's.id=t.shift_id', 'INNER');
        $this->db->join($table2, 's.customer_id=c.id', 'LEFT');
        $this->db->join('tb_shft_veh v', 's.id=v.shft_id AND v.status =1', 'LEFT');
        $this->db->join('tbl_assigned_drivers a', 'v.vehicle_id=a.vehicle_id AND a.status =1', 'LEFT');
        $this->db->join('tb_truck_drivers td', 'a.driver_id= td.id', 'LEFT');
        $this->db->where($where);
        /*if($table == 'tb_shifts' || $table == 'tb_employee'){*/
        $this->db->group_by('s.shipmentid');
        $this->db->order_by('startdate', 'DESC');
        /*}*/
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getordertbldata($table, $table2, $where, $select, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->join($table2, 's.customer_id=c.id', 'LEFT JOIN');
        $this->db->where($where);
        /*if($table == 'tb_shifts' || $table == 'tb_employee'){*/
        $this->db->order_by('pickup_datetime', 'DESC');
        /*}*/
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getsubusertbldata($where, $select, $table, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->join('tb_users', 'tb_user_logins.user_id = tb_users.id');
        $this->db->order_by('tb_user_logins.id', 'DESC');
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function gettblrowdatasubusers($where, $select, $table, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        if ($table == 'tb_user_logins') {
            $this->db->join('tb_users', 'tb_user_logins.user_id = tb_users.id');
        }
        $this->db->where($where);
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    public function getorderpartydata($where)
    {
        $result = array();
        $res = $this->db->query(
            "SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.partyindetifier,p.code, p.location_id, p.address, p.country,p.state, p.street, p.pincode, p.kn_login_account, o.party_type, a.party_master_id, a.location_id as plocation_id,a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,a.country as pcountry,p.street_2,p.street_3 FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 WHERE p.status=1 $where GROUP BY o.party_type"
        );
        if ($res->num_rows() > 0) {
            $result = $res->result();
        }
        return $result;
    }
    
    


    public function getknloginorders($where, $limit, $start, $flag=0)
    {
        $result = array();
        $this->db->select("o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.shipment_id,o.delivery_datetime,o.drop_endtime,o.pickup_company as pickup,o.delivery_company as delivery,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,o.transport_mode,o.vehicle_type,o.quantity,o.weight,o.customer_id,o.vendor_id,o.modeoftransport,o.pickup_custid,o.pickup_partyid,o.drop_custid,o.drop_partyid,o.trip_sts,o.shift_id,o.trip_id,o.status,o.order_status,o.createdon,o.updatedon,o.shipmentid,d.order_type,d.shipper_id,d.service,d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,d.lane_reference,d.distance,d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,d.department_code,d.docs_received_datetime,d.docs_sent_datetime,d.consignment_note");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->where($where);
        if ($flag === 1) {
            $this->db->where_in('o.is_created', [0, 1, 2]);
        } elseif ($flag === 0) {
            $this->db->where_in('o.is_created', [0, 1]);
        }
        $this->db->group_by('o.id');
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $chkorder = $this->db->get();
        if ($chkorder->num_rows() > 0) {
            $result = $chkorder->result();
        }
        return $result;
    }

    public function getknloginorderstatus($where, $limit, $start)
    {
        $this->db->select("o.id,o.order_id,o.pickup_city,o.delivery_city,o.company_code,o.branch_code,o.modeoftransport,o.shift_id,o.trip_id,o.shipmentid,d.id as stid,d.latitude,d.longitude,d.loc_name,d.status_code,d.createdon,d.driver_id");
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status d", "o.id=d.order_id", "INNER");
        $this->db->where($where);
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $checkstopStatusorder = $this->db->get();
        $stopStatus = $checkstopStatusorder->num_rows() > 0 ? $checkstopStatusorder->result() : [];

        $this->db->select("o.id,o.order_id,o.pickup_city,o.delivery_city,o.company_code,o.branch_code,o.modeoftransport,o.shift_id,o.trip_id,o.shipmentid,d.id as stid,d.latitude,d.longitude,'' AS loc_name,d.status_code,d.status_date as createdon,'' AS driver_id");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_status d", "o.id=d.order_id", "INNER");
        $this->db->where($where);
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $checkorderstopStatus = $this->db->get();
        $orderstopStatus = $checkorderstopStatus->num_rows() > 0 ? $checkorderstopStatus->result() : [];

        $allStatus = array_merge($stopStatus, $orderstopStatus);
        return $allStatus ?? [];
    }

    public function getpartiesbyorder($id)
    {
        $result = array();
        $resultqry = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.partyindetifier,p.code, p.location_id, p.address, p.country,p.state, p.street, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,a.country as pcountry FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
        if ($resultqry->num_rows() > 0) {
            $result = $resultqry->result();
        }
        return $result;
    }

    public function getcustspecs($where = array(), $whr = array())
    {
        $result = array();
        $this->db->select("cp.id,c.code,c.name,c.company_code,c.branch_code");
        $this->db->from("tb_custaprl_cols cp");
        $this->db->join("tb_customers c", "cp.cust_id=c.id", "LEFT");
        if (!empty($where)) {
            $this->db->where($where);
        }
        if (!empty($whr)) {
            $this->db->where($whr);
        }
        $this->db->where('cp.status', 1);
        $this->db->where('cp.cust_id >', 0);
        $this->db->where('c.status', 1);
        $this->db->order_by('id', 'DESC');
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    public function getorderlistspecs($where = array(), $whr = array())
    {
        $user_id = $this->session->userdata('user_id');
        $childid = $this->session->userdata('childid');
        $result = array();
        $this->db->select("*");
        $this->db->from("tb_orderlist_spec_cols");
        if (!empty($where)) {
            $this->db->where($where);
        }
        if (!empty($whr)) {
            $this->db->where($whr);
        }
        if ($childid != '' || $childid != 0) {
            $this->db->where('childid', $childid);
        } else {
            $this->db->where('childid', 0);
        }
        $this->db->where('is_active', 1);
        $this->db->where('user_id =', $user_id);
        // $this->db->order_by('id','DESC');
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    public function getorderbyvozonum($where)
    {
        $result = array();
        $this->db->select("o.id,o.order_id,o.user_id,o.shift_id,o.trip_id,o.plat,o.plng,o.dlat,o.dlng,r.ref_value");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "o.id=r.order_id", "INNER");
        if (!empty($where)) {
            $this->db->where($where);
        }
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    public function getordcontainernum($where)
    {
        $result = array();
        $this->db->select("o.id,o.order_id,o.quantity,o.weight,o.volume");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "o.id=r.order_id", "INNER");
        if (!empty($where)) {
            $this->db->where($where);
        }
        $this->db->limit(1);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->row_array();
        }
        return $result;
    }

    public function orderpartydatabytype($where)
    {
        $result = array();
        $res = $this->db->query("SELECT p.id,p.name, p.mobile, p.email,p.partyindetifier,p.customeridentifier,p.code, p.location_id, p.address, p.country,p.state, p.street, p.pincode,p.fax,p.vat_reg_no,a.name as partytype FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1 INNER JOIN tbl_party_types a ON a.id=o.party_type AND a.status=1 WHERE p.status=1 $where GROUP BY o.party_type");
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }

    public function getordids($where)
    {
        /*get order ids with reference value and reference id*/
        $result = array();
        $this->db->select("order_id");
        $this->db->from("tb_order_references");
        $this->db->where('reference_id', $where['refid']);
        $this->db->like('ref_value', $where['refvals']);
        $this->db->where('status', 1);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    /**
     * get order ids,invoice number  with invoice number
     *
     *
     * @param array where
     * @param string select
     * @return    Array
     * @author    Developer Name external.pach.b@kuehne-nagel.com
     * @date      28-05-2021 18:09:00
     * @change    Europe
     */
    public function getordid($select, $where)
    {
        $result = array();
        $this->db->select($select);
        $this->db->distinct();
        $this->db->from("tb_reveneus");
        $this->db->where('currency', $where['currency']);
        $this->db->like('invoice_number', $where['invoice_number']);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    /**
     * get the delhivery carrier status list
     *
     *
     *
     * @param Integer Order Id
     * @return    Array
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function getdelhiverystatusreport($ord)
    {
        $result = array();
        /*$qry = "SELECT t.order_id,t.status_name,t.status_type,t.status_code,t.pickup_date,t.destination,t.returned_date,t.dispatch_count,t.invoice_amount,t.charged_weight,s.scan_type,if(s.scan_val!='Manifested' AND s.scan_instruction='Shipment details manifested','Manifested',s.scan_val) as scan_val,if(s.scan_val='Manifested' OR s.scan_instruction='Shipment details manifested',s.scan_datetime,'') as manifested_date,if((s.scan_val='In Transit' OR s.scan_instruction='Pickup completed'),s.scan_datetime,'') as pickedup_date,if(s.scan_val='Dispatched',s.scan_datetime,'') as dispatch_dates, s.scan_status_time,s.scan_instruction,if(s.call_duration>0,s.call_duration,0) as FECallDate FROM `tb_uniqlo_order_tracking` t,tb_uniqlo_order_scans s WHERE t.order_id=s.order_id AND t.order_id=$ord GROUP BY CONCAT(s.scan_type,',',s.scan_val,',',s.order_id) ORDER BY s.order_id,s.scan_datetime";*/
        $qry = "SELECT s.order_id,s.scan_val,s.scan_status_code,t.reverse_ntransit,t.dispatch_count,t.invoice_amount,t.charged_weight,s.scan_type, s.scan_status_time,s.scan_instruction,s.call_duration FROM tb_uniqlo_order_scans s LEFT JOIN `tb_uniqlo_order_tracking` t ON s.order_id=t.order_id AND s.order_id=$ord WHERE s.order_id=$ord AND s.status=1 GROUP BY s.id ORDER BY s.scan_datetime ASC";
        $getresult = $this->db->query($qry);
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    /**
     * get the order reference list
     *
     *
     *
     * @param Integer Order Id
     * @return    Object
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      30-03-2021 11:50:00+05.30
     * @change    Asia
     */
    public function getallorderreferences($ord)
    {
        $result = $this->db->query("SELECT group_concat(reference_id,' - ',ref_value) as reference_id FROM tb_order_references WHERE order_id=$ord AND status=1");
        return $result;
    }

    public function getorderlistcolumns($user_id, $childid)
    {
        $result = array();
        $this->db->select("osc.id,osc.ord_id,osc.Username, osc.created_date, osc.delivery_note, osc.salog_ref, osc.pickup, osc.delivery, osc.trip_no, osc.other_status,osc.Stoppage,osc.pickup_date, osc.estimated_delivery_date, osc.delivery_date, osc.mode_of_transport, osc.total_packages, osc.billing_status, osc.actual_weight, osc.weight, osc.actual_volume,osc.assigned_to, osc.volume,osc.company_code, osc.branch_code, osc.from_source, osc.status");
        $this->db->from("tb_orderlist_spec_cols osc");
        $this->db->join("tb_users u", "osc.user_id = u.id", "LEFT");
        $where = "osc.user_id = $user_id and osc.childid = $childid and osc.is_active = 1 ";
        $this->db->where($where);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    public function gettbllastrowdata($where, $select, $table, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->row_array();
            }
        }
        return $result;
    }

    public function gettbldataorderby($where, $select, $table, $column, $type)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->order_by($column, $type);
        $res = $this->db->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
            }
        }
        return $result;
    }

    public function getactivetripids($whr, $cid)
    {
        $result = array();
        $this->db->select("t.id,s.splace,s.eplace,s.shipmentid");
        $this->db->from("tb_trips t");
        $this->db->join("tb_shifts s", "t.shift_id=s.id", "LEFT");
        $where = "t.shift_id=s.id AND t.status=1 AND s.customer_id=$cid AND s.status=1 ";
        $this->db->where($where);
        if (!empty($whr)) {
            $this->db->where($whr);
        }
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    public function getvehicledata($select, $table, $where)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->join('tb_orders o', 'o.trip_id = tr.id', 'LEFT');
        $this->db->join('tb_trucks_data td', 'td.id = tr.vehicle_id', 'LEFT');
        $this->db->where($where);
        $this->db->group_by('tr.id');
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->row_array();
            }
        }
        return $result;
    }

    public function carriergetactivetripids($whr, $cid)
    {
        $result = array();
        $this->db->select("t.id,s.splace,s.eplace,s.shipmentid");
        $this->db->from("tb_trips t");
        $this->db->join("tb_shifts s", "t.shift_id=s.id", "LEFT");
        $where = "t.shift_id=s.id AND t.status=1 AND s.vendor_id=$cid AND s.status=1 ";
        $this->db->where($where);
        if (!empty($whr)) {
            $this->db->where($whr);
        }
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    public function getgpslocationbyorder($vehicle_id, $currentdate)
    {
        $result = array();
		$vehicle = $this->db->escape($vehicle_id);
        $this->db->select(
            "td.latitude,td.longitude,td.trailer_latitude,td.trailer_longitude,td.receivedon,td.speed,td.battery,td.imei as mobileimei,td.trailer_imei as mobiletrailerimei,td.fuel,td.bearing,td.azimuth,td.key_exist,td.inouts, o.shipmentid as shipmentid,o.order_id as orderId,o.trip_id as tripid"
        );
        $this->db->from("tb_trips tr");
        $this->db->join("tb_orders o", "o.trip_id = tr.id", "LEFT");
        $this->db->join("tb_trucks_data td", "td.id = tr.vehicle_id", "LEFT");
        $this->db->join("tb_stop_status s", "s.order_id =o.id AND s.trip_id =tr.id", "LEFT");
        $where = "td.id=$vehicle AND tr.status=1 AND s.status_code='0212' AND o.pickup_datetime <= '" . $currentdate . "' AND TIMESTAMPDIFF(HOUR, '" . $currentdate . "', o.pickup_datetime) <= 2 ";
        $this->db->where($where);
        $this->db->group_by('tr.id');
        $this->db->limit(1);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    function chkTripGPSByOrdertrip($vehicle_id, $currentdate)
    {
        $res = array();
        if ($vehicle_id != "") {

            $sql = "SELECT updated_on, o.shipmentid as shipmentid,o.order_id FROM tb_trips tr LEFT JOIN tb_orders o ON o.trip_id = tr.id LEFT JOIN tb_trucks_data td ON td.id = tr.vehicle_id LEFT JOIN tb_stop_status s ON s.order_id =o.id AND s.trip_id =tr.id WHERE td.id=$vehicle_id AND tr.status=1 AND s.status_code='0212' AND o.pickup_datetime <= '" . $currentdate . "' AND TIMESTAMPDIFF(HOUR, '" . $currentdate . "', o.pickup_datetime) <= 2 ORDER BY updated_on DESC LIMIT 1";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $res = $query->row_array();
            }
        }
        return $res;
    }

    /**
     * It will check Shippeotoken validation and retrieving auth_token
     *
     *
     * @param constant shippeotokenvalidity
     * @return    Array
     * @author    Developer Name external.pach.b@kuehne-nagel.com
     * @date      15-06-2021 13:21:00
     * @change    Europe
     */
    public function shippeotoken($shippeotokenvalidity)
    {
        $currentdate = date("Y-m-d");

        $result = array();
        $this->db->select("auth_token");
        $this->db->from("tb_auth_tokens");
        $where = "token_for='Shippeo' AND TIMESTAMPDIFF(DAY, updated_on, '" . $currentdate . "') > $shippeotokenvalidity";
        $this->db->where($where);
        $this->db->limit(1);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->row_array();
        }
        return $result;
    }

    function chkShftvehhistory($shft_id, $user_id)
    {
        $res = array();
        if ($shft_id != "") {
            $sql = "SELECT td.name FROM tb_shft_veh_history svh LEFT JOIN tb_truck_drivers td ON td.id = svh.driver_id WHERE svh.shft_id = ? AND svh.user_id= ? ORDER BY svh.id DESC LIMIT 1";
            $query = $this->db->query($sql, [$shft_id, $user_id]);
            if ($query->num_rows() > 0) {
                $res = $query->row_array();
            }
        }
        return $res;
    }

    public function getCustReportSettings(array $where, array $whr): array
    {
        $result = array();
        $this->db->select("crs.id,crs.name,crs.company_code,crs.branch_code");
        $this->db->from("tb_custom_report_settings crs");
        if (!empty($where)) {
            $this->db->where($where);
        }
        if (!empty($whr)) {
            $this->db->where($whr);
        }
        $this->db->where('crs.status', 1);
        $this->db->order_by('crs.id', 'DESC');
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }
    public function deleteStatus($idArray, $tableName)
    {
        $this->db->where_in('id', $idArray);
        $this->db->where('status',1);
        $query=$this->db->update($tableName,['status' => 0]);
        echo $query ? 'success' : 'failed';
    }

    public function getPartyReferences(int $partyid): array
    {
        $partyReferences = [];
        $partyref = $this->db->query("SELECT tpr.* from tb_customers tc left outer join tbl_party_master tpm on tpm.code= tc.code left outer join tb_party_reference tpr on tpm.id= tpr.partner_id WHERE tc.id= ? and tc.status=1 and tpm.status=1 and tpr.status=1", [$partyid]);
        $partyReferences = $partyref->result_array();

        return $partyReferences;
    }

    public function getOrderDQPOReferences($orderId): array
    {
        $orderDQPOReferences = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=? AND reference_id IN ? AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1", [$orderId, ['DQ', 'PO']]);
        return $orderDQPOReferences->num_rows() > 0 ? $orderDQPOReferences->result() : [];
    }
    public function getOrderReferenceCount(int $orderId): int
    {
        $references = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id = ? AND ((reference_id = 'OT' AND ref_value='PUP') OR (reference_id = 'XSR' AND ref_value!='') AND status=1)", [$orderId]);
        return $references->num_rows() ?? 0;
    }

    public function getShipmentIds(array $whereCompanyCode, array $whereBranchCode, array $whereCarrierId): array
    {
        $shipmentIds = $this->db->query("SELECT ts.id AS shiftid  FROM tb_trips tt INNER JOIN tb_shifts ts ON tt.shift_id=ts.id where tt.is_carrier_edi_sent = ? AND tt.status = ? AND ts.company_code IN ? AND ts.vendor_id IN ? AND ts.branch_code IN ? ", [0, 1, $whereCompanyCode, $whereCarrierId, $whereBranchCode]);
        return $shipmentIds->num_rows() > 0 ? $shipmentIds->result_array() : [];
    }

    public function getWheelsEyeOrderVehicles(): array
    {
        $getResult = $this->db->query("SELECT o.id, o.order_id AS orderid, o.shipmentid ,o.wlatitude AS latitude, o.wlongitude AS longitude, o.trip_sts, truck.bearing, truck.register_number, truck.fuel, truck.trailer_imei,driver.name
            FROM tb_orders o
            INNER JOIN tb_trips trips ON trips.id = o.trip_id
            INNER JOIN tb_trucks_data truck ON truck.id = trips.vehicle_id
            INNER JOIN tb_truck_drivers driver ON driver.id = trips.driver_id
            WHERE o.trip_sts = ? AND o.trip_id > ? AND o.status > ? AND o.wlatitude !='' AND o.wlongitude !='' GROUP BY o.trip_id",[0,0,0]);
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function carrierEDIDetails($vendor_id): array
    {
        $carrierEDIDetails = $this->db->query(
            "SELECT tbp.value AS editype,tpe.edi_url,tta.name AS ediname,tet.`name` AS ediservice,tpe.`user_name`,tpe.`password` FROM tb_vendors tv JOIN tbl_party_master tpm ON tv.code=tpm.code JOIN tb_party_reference  tbp ON  tbp.`partner_id`=tpm.id AND tbp.name='EDI_TYPE' AND tbp.status=1 JOIN tbl_partner_ediapi tpe ON  tpe.`partner_id`=tpm.id AND tpe.status=1 JOIN `tbl_edi_types` tet ON tpe.type=tet.id JOIN `tbl_txn_actions`tta ON tpe.`transaction_action`=tta.id AND tta.name='Shipment' WHERE tv.id= ?",
            [$vendor_id]
        );
        return $carrierEDIDetails->num_rows() > 0 ? $carrierEDIDetails->row_array() : [];
    }
    public function fetchRecordsByCustomQry(string $sqlQuery = "", array $bindParams = [], $multipleRecords = true): array {
        $getResult = $this->db->query($sqlQuery,$bindParams);
        $recordsCount = (int)$getResult->num_rows();
        if ($multipleRecords === true) {
            $result = $recordsCount > 0 ? $getResult->result_array(): [];
        } else {
            $result = $recordsCount === 1 ? $getResult->row_array(): [];
        }
        return $result;
    }

    public function getCarrierOrderlistColumns(int $carrierId): array
    {
        $result = [];
        $this->db->select("osc.s_no,osc.ord_id,osc.created_date,osc.salog_ref, osc.pickup, osc.delivery,osc.pickup_date, osc.total_packages, osc.actual_weight,osc.actual_volume, osc.status, osc.deliverycity, osc.pod");
        $this->db->from("tb_orderlist_spec_cols osc");
        $where = "osc.carrier_id = $carrierId and osc.is_active = 1 ";
        $this->db->where($where);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        return $result;
    }

    public function checkDocumentSentType(string $order_id): int
    {
        $documentTypes = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT JOIN tb_order_references tor ON o.id=tor.order_id LEFT JOIN tb_vendors tv ON tv.id=o.vendor_id LEFT JOIN `tbl_party_master` tpm ON tpm.code=tv.code LEFT JOIN `tb_party_reference` tpr ON tpr.`partner_id`=tpm.id WHERE (o.order_id= ? OR tor.ref_value = ?) AND tpr.name='Carrier POD To Roadlog' AND tpr.value='Y'  AND tpr.status=?", [$order_id, $order_id, 1]);
        return $documentTypes->num_rows() > 0 ? 1 : 0;
    }

    public function getRoadlogOrderDetails(int $orderRowId): array
    {
        $timezoneData = $this->session->userdata("usr_tzone");
        $timezone = $timezoneData['timezone'];
        $pickupDate = $deliveryDate = date('Y-m-d H:i:s');
        $pickupDate = getdatetimebytimezone($timezone, $pickupDate, DFLT_TZ)['datetime'];
        $this->load->model('Roadlogtosalogmodel');
        $orderStatusData = $this->Roadlogtosalogmodel->getPickupAndDeliveryStatuses($orderRowId);
        foreach ($orderStatusData as $eachStatusData) {
            if ($eachStatusData['status_code'] == '0500') {
                $pickupDate = $eachStatusData['createdon'];
            }
            if ($eachStatusData['status_code'] == '2300') {
                $deliveryDate = $eachStatusData['createdon'];
            }
            $bookingId = $eachStatusData['order_id'];
            $shiftId = $eachStatusData['shift_id'];
            $tripId = $eachStatusData['trip_id'];
            $user_id = $eachStatusData['user_id'];
        }
        if ($timezone == "") {
            $timezone = $this->getUsersTimezone($user_id);
        }
        $countryHours = $timezoneData['hrs'];
        return [
            'shipment_id' => $shiftId ?? 0,
            'trip_id' => $tripId ?? 0,
            'order_id' => $bookingId ?? '',
            'curtz' => $timezone,
            'hrs' => $countryHours,
            'web' => getdatetimebytimezone($timezone, $pickupDate, DFLT_TZ)['datetime'],
            'status_code' => '0500',
            'ord_id' => $orderRowId,
            'driver_id' => '',
            'stop_id' => '',
            'deliveryDate' => $deliveryDate,
            'timezone' => $timezone
        ];
    }

    public function getUsersTimezone(int $user_id): string
    {
        $countryTimeZone = $this->db->query("SELECT tcm.cntry_timezone FROM tbl_country_master tcm LEFT JOIN tb_users tu ON tu.country_code=tcm.country_code WHERE tu.id = ? AND tcm.status= ? LIMIT 1", [$user_id, 1]);
        return $countryTimeZone->num_rows() > 0 ? $countryTimeZone->row()->cntry_timezone : "Asia/Singapore";
    }
    
    public function getjointbllastrowdata($table1, $table2, $joinCondition, $where, $select, $start, $limit, $orderBy = '')
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table1);
        $this->db->join($table2, $joinCondition, 'inner');
        $this->db->where($where);
        
        if (!empty($orderBy)) {
            $this->db->order_by($orderBy);
        }
        if ($limit > 0) {
            $this->db->limit($limit, $start);
        }
        $res = $this->db->get();
        if ($res && $res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }
    
    public function checkOrganization(string $organizationId): string
	{
		$getOrganizationID = $this->db->query(
			"select id from tb_company_master where company_code=? and status=?",
			[$organizationId, 1]
		);
		return $getOrganizationID->num_rows() > 0 ? $getOrganizationID->row()->id : 0;
	}

	public function checkBusinessEntity(string $businessEntityValue, string $organizationId): array
	{
		$getBusinessEntity = $this->db->query(
			"select id from tb_branch_master where company_code=? and branch_code=? and status=?",
			[$organizationId, $businessEntityValue, 1]
		);
		return $getBusinessEntity->num_rows() > 0 ? $getBusinessEntity->row_array() : [];
	}
    
    public function checkPartyTypeCrossRef(string $organization, string $businessEntity, string $domain, string $partyType, string $partyName): string
    {
        $checkPartyType = $this->db->select("destination")->get_where("tb_party_type_xref", ['org_name' => $organization, 'business_entity_value' => $businessEntity, 'domain' => $domain, 'party_type' => $partyType, 'source' => $partyName], 1, 0);
        
        if ($checkPartyType->num_rows() == 0) {
            $checkPartyType = $this->db->select("destination")->get_where("tb_party_type_xref", ['org_name' => $organization, 'business_entity_value' => $businessEntity, 'domain' => $domain, 'party_type' => $partyType, 'source' => 'ALL'], 1, 0);
            
        }
        return $checkPartyType->num_rows() > 0 ? $checkPartyType->row()->destination : "";
    }
    
    public function getCount($where, $table)
    {
        return $this->db->where($where)->from($table)->count_all_results();
    }
    
    public function getIVReferences($ord)
    {
        $query = $this->db->query("
            SELECT GROUP_CONCAT(ref_value ORDER BY id DESC) AS reference_ids
            FROM tb_order_references
            WHERE order_id = ?
              AND reference_id = 'IV'
              AND status = 1
        ", [$ord]);
        
        $row = $query->row();
    
        if (!$row || empty($row->reference_ids)) {
            return [
                'firstRecord'  => '',
                'otherRecords' => ''
            ];
        }
    
        $references = explode(',', $row->reference_ids);
    
        $firstRecord = $references[0] ?? '';
    
        $remaining = array_slice($references, 1);
        $otherRecords = !empty($remaining) ? implode(',', $remaining) : '';
    
        return [
            'firstRecord'  => $firstRecord,
            'otherRecords' => $otherRecords
        ];
    }

}
