<?php

defined('BASEPATH') or exit('No direct script access allowed');

class CustomReportModel extends CI_Model
{
    public function getCustomReportDataByCompanycode(string $companyCode, string $branchCode): array
    {
        $this->db->select('id,name');
        $this->db->from('tb_custom_report_settings');
        $this->db->where(['company_code' => $companyCode, 'branch_code' => $branchCode, 'status' => 1]);
        $this->db->order_by("name", "asc");
        $result = $this->db->get()->result_array();
        return $result;
    }

    public function getCustomReportData(int $reportId): object
    {
        $this->db->select('*');
        $this->db->from('tb_custom_report_settings');
        $this->db->where('id', $reportId);
        $result = $this->db->get()->row();
        return $result;
    }

}
