<?php

class Customerpiechartmodel extends CI_Model
{

    public function getPendingOrders(array $where): int
    {
        $this->db->select("COUNT(*) as orders_count");
        $this->db->from("tb_orders o");
        $this->db->where("o.company_code", $where['companyCode']);
        $wherePending = "(`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0)";
        $this->db->where($wherePending);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("status !=", 0);
        $this->db->where("YEAR(o.`createdon`)", $where['currentYear']);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row()->orders_count : 0;
    }

    public function getActiveOrders(array $where): int
    {
        $this->db->select("COUNT(*) as orders_count");
        $this->db->from("tb_orders o");
        $this->db->where("o.company_code", $where['companyCode']);
        $wherePending = "(o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0))";
        $this->db->where($wherePending);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.trip_sts ", 0);
        $this->db->where("status !=", 0);
        $this->db->where("YEAR(o.`createdon`)", $where['currentYear']);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row()->orders_count : 0;
    }

    public function getOrdersbyModeofTransport(array $where): array
    {
        $this->db->select("`transport_mode`, COUNT(*) AS order_count");
        $this->db->from("tb_orders o");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("status !=", 0);
        $this->db->where("YEAR(o.`createdon`)", $where['currentYear']);
        $this->db->group_by('o.transport_mode');
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getDeliveryTypeOrder(array $where): array
    {
        $this->db->select("(CASE WHEN o.`drop_endtime`<tss.`createdon` THEN 'Delayed' ELSE 'OnTime' END) AS OrderType, COUNT(*) AS order_count");
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status tss", "o.id = tss.order_id", "INNER");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.status !=", 0);
        $this->db->where("tss.stop_type", "D");
        $this->db->where("tss.status_id", 281);
        $this->db->where("YEAR(o.`createdon`)", $where['currentYear']);
        $this->db->group_by('OrderType');
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getPodNotAvailableOrders(array $yearInfo, array $where): array
    {
        $this->db->select("(CASE WHEN tpd.doc_type=3  THEN 'POD' ELSE 'NOPOD' END) AS PODtype,COUNT(*) AS order_count");
        $this->db->from("tb_orders o");
        $this->db->join("tb_pod_uploads tpd", "tpd.order_id=o.id", "INNER");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.status !=", 0);
        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }

        if ($yearInfo['currentweek'] != 0) {
            $this->db->where("WEEK(o.createdon)", $yearInfo['currentweek']);
        }

        $this->db->group_by('PODtype');
        $getResult = $this->db->get();

        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getDelayedOrders(array $yearInfo, array $where, string $type): array
    {
        if ($type == "D") {
            $this->db->select("(CASE WHEN o.`drop_endtime`<tss.`createdon` THEN 'Delayed' ELSE 'OnTime' END) AS OrderType, COUNT(*) AS order_count");
            $statusId = "281";
        } else {
            $this->db->select("(CASE WHEN o.`pickup_endtime`<tss.`createdon` THEN 'Delayed' ELSE 'OnTime' END) AS OrderType, COUNT(*) AS order_count");
            $statusId = "285";
        }
        $this->db->from("tb_orders o");
        $this->db->join("tb_stop_status tss", "`o`.`id` = `tss`.`order_id`", "INNER");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.status !=", 0);
        $this->db->where("tss.stop_type", $type);
        $this->db->where("tss.status_id", $statusId);

        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }

        if ($yearInfo['currentweek'] != 0) {
            $this->db->where("WEEK(o.createdon)", $yearInfo['currentweek']);
        }

        $this->db->group_by('OrderType');
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getLineAreaChartOrders(array $yearInfo, array $where): array
    {
        $this->db->select("WEEK(createdon) AS Weeks, (CASE WHEN trip_sts=1 THEN 'Completed' ELSE 'Pending' END) AS orderstatus, COUNT(*) AS ordercount");
        $this->db->from("tb_orders o");
        $this->db->where("o.company_code", $where['companyCode']);
        if (in_array($where['businessType'], ["Country Admin", "Truck_Owner"]) && !empty($where['userIds'])) {
            $this->db->where_in("o.user_id", $where['userIds']);
        }
        if ($where['businessType'] == "Customer" && $where['customerId'] > 0) {
            $this->db->where_in("o.customer_id", $where['customerId']);
        }
        if ($where['businessType'] == "Carrier" && $where['vendorId'] > 0) {
            $this->db->where_in("o.vendor_id", $where['vendorId']);
        }
        $this->db->where("o.status !=", 0);
        if ($yearInfo['currentYear'] != 0) {
            $this->db->where("YEAR(o.createdon)", $yearInfo['currentYear']);
        }

        if ($yearInfo['currentMonth'] != 0) {
            $this->db->where("MONTH(o.createdon)", $yearInfo['currentMonth']);
        }
        $this->db->group_by('WEEK(createdon),orderstatus');
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getCompanyBranchDepartmentCodesList(): array
    {
        $this->db->select("tcm.company_code,tbm.branch_code,tdm.department_code");
        $this->db->from("tb_company_master tcm");
        $this->db->join("tb_branch_master tbm", "tcm.company_code = tbm.company_code", "INNER");
        $this->db->join("tb_department_master tdm", "tbm.branch_code = tdm.branch_code", "INNER");
        $this->db->where("status", 1);
        $this->db->order_by("company_code", "ASC");
        $companyCodes = $this->db->get();
        return $companyCodes->num_rows() > 0 ? $companyCodes->result_array() : [];
    }

    public function getCo2missionData(int $userid, array $searchData): array
    {
        $whereCondition = $this->getWhereCondition($userid, $searchData);
        $co2EmissionDetails = $this->db->query("SELECT COUNT(*) AS shipmentcount, SUM(`order_actual_weight`) AS totalweight, ROUND(SUM( (CASE WHEN actual_travel_distance = 0 THEN planned_travel_distance ELSE actual_travel_distance END)),3) AS distance, SUM(`co2eqkg_ttw`) AS co2eqkgttw FROM `tb_co2_orders` WHERE " . $whereCondition);
        return $co2EmissionDetails->num_rows() > 0 ? $co2EmissionDetails->row_array() : [];
    }

    private function getWhereCondition(int $userid, array $searchData): string
    {
        $whereCondition = "";
        if (!empty($searchData)) {
            $fromDate = $searchData['fromDate'] ?? "";
            $toDate = $searchData['toDate'] ?? "";
            $customerid = $searchData['customerid'] ?? "0";
            if ($fromDate != "") {
                $whereCondition .= " DATE(`order_created_date`) >= '" . $fromDate . "'";
            }
            if ($toDate != "") {
                $whereCondition .= " AND DATE(`order_created_date`) <= '" . $toDate . "'";
            }

            if ($customerid != "0") {
                $whereCondition .= " AND customer_id = '" . $customerid . "'";
            }
        } else {
            $whereCondition .= "user_id  = " . $userid;
            $prevFrom = date('Y-m-d', strtotime("-6 months"));
            $currentTo = date('Y-m-d');
            $whereCondition .= " AND DATE(`order_created_date`) >=  '" . $prevFrom . "'";
            $whereCondition .= " AND DATE(`order_created_date`) <= '" . $currentTo . "'";
        }
        return $whereCondition ?? "";
    }

    public function getCustomersList(int $userid, string $company_code, string $branch_code): array
    {
        $this->db->select("tc.id,tc.name");
        $this->db->from("tb_customers tc");
        $this->db->join("tbl_party_master tpm", "tpm.code = tc.code", "INNER");
        $this->db->where("tc.status", 1);
        $this->db->where("tpm.status", 1);
        $this->db->where("tc.user_id", $userid);
        $this->db->where("tc.company_code", $company_code);
        $this->db->where("tc.branch_code", $branch_code);
        $this->db->group_by('tc.id');
        $this->db->order_by("tc.name", "ASC");
        $customerDetails = $this->db->get();
        return $customerDetails->num_rows() > 0 ? $customerDetails->result_array() : [];
    }

    public function getEmissionchartData(int $userid, array $searchData): array
    {
        $whereCondition = $this->getWhereCondition($userid, $searchData);
        $this->db->select("DATE_FORMAT(order_created_date, '%b %Y') AS months,ROUND(SUM(CASE WHEN actual_travel_distance =0 THEN planned_travel_distance ELSE actual_travel_distance END),3) AS totaldistance, SUM(co2eqkg_ttw) AS Emission");
        $this->db->from("tb_co2_orders");
        $this->db->where($whereCondition);
        $this->db->group_by('MONTH(order_created_date)');
        $emisssionData = $this->db->get();


        return $emisssionData->num_rows() > 0 ? $emisssionData->result_array() : [];
    }

    public function getLaneWiseReport(int $userid, array $searchData): array
    {
        $whereCondition = "";
        if (!empty($searchData)) {
            $fromDate = $searchData['fromDate'] ?? "";
            $toDate = $searchData['toDate'] ?? "";
            $customerid = $searchData['customerid'] ?? "0";
            if ($fromDate != "") {
                $whereCondition .= " DATE(tco.`order_created_date`) >= '" . $fromDate . "'";
            }
            if ($toDate != "") {
                $whereCondition .= " AND DATE(tco.`order_created_date`) <= '" . $toDate . "'";
            }

            if ($customerid != "0") {
                $whereCondition .= " AND tco.customer_id = '" . $customerid . "'";
            }
        } else {
            $whereCondition .= "tco.user_id  = " . $userid;
            $prevFrom = date('Y-m-d', strtotime("-6 months"));
            $currentTo = date('Y-m-d');
            $whereCondition .= " AND DATE(tco.`order_created_date`) >=  '" . $prevFrom . "'";
            $whereCondition .= " AND DATE(tco.`order_created_date`) <= '" . $currentTo . "'";
        }
        $this->db->select("o.`pickup_city`,o.`delivery_city`, CONCAT(o.`pickup_city`,' - ',o.`delivery_city`) AS citylane, COUNT(tco.id) AS laneOrdercount");
        $this->db->from("`tb_co2_orders` tco");
        $this->db->join("tb_orders o", "tco.order_id=o.id", "INNER");
        $this->db->where($whereCondition);
        $this->db->group_by('o.`pickup_city`,o.`delivery_city`');
        $this->db->order_by('laneOrdercount', 'DESC');
        $this->db->limit(5);
        $laneWiseReport = $this->db->get();

        return $laneWiseReport->num_rows() > 0 ? $laneWiseReport->result_array() : [];
    }
}
