<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customerprofilemodel extends CI_Model
{
    function __construct()
    {
      parent::__construct();
    }

    function getcustomerprofiledata($whr, $where){
        $result = array();
        $this->db->select('id,cust_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_customer_profile');
        $this->db->like($whr);
       $this->db->where($where);
        $this->db->order_by('id','DESC');
        $cust_profile_instance = $this->db->get();
        if($cust_profile_instance->num_rows() > 0) {
         $result = $cust_profile_instance ->result_array();
        }
        return $result;
    }

    function editdata($id,$company_code,$branch_code)
    {
        $result = array();
        $this->db->select('id,cust_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_customer_profile');
        $this->db->where('id', $id);
        $this->db->where('company_code', $company_code);
        if($company_code != 'RUKN') {
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->limit('1');
        $edit = $this->db->get();
        if($edit->num_rows() > 0) {
            $result = $edit->row_array();
        }
        return $result;
    }

    function viewdata($id,$company_code,$branch_code)
    {
        $result = array();
        $this->db->select('id,cust_profile_id,name,description,company_code,branch_code,user_id,status');
        $this->db->from('tb_customer_profile');
        $this->db->where('id', $id);
        $this->db->where('company_code', $company_code);
        if($company_code != 'RUKN') {
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->limit('1');
        $view = $this->db->get();
        if($view->num_rows() > 0) {
            $result = $view->row_array();
        }
        return $result;
    }

    function selectlist($select, $table, $whr)
    {
        $result = array();
        $this->db->select($select);
        $this->db->like($whr);
        $this->db->from($table);
        $res = $this->db->get();
        if($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result;
    }


    function getprofilelistdata($wherein)
    {
        $result = array();
        $this->db->select('c.name,c.phone,c.code,c.street,c.pincode,c.email_id,cp.id as customer_profile_list_id,c.id as party_id')->from('tb_customer_profile_list cp');
        $this->db->join('tb_customers c','c.id = cp.party_id','LEFT');
        $this->db->where_in('cp.id',$wherein);
        $this->db->where('cp.status',1);
        $this->db->group_by('cp.id');
        $this->db->order_by('cp.id','DESC');
        $query = $this->db->get();
        if($query->num_rows() > 0) {
            $result = $query->result_array();
        }
        return $result;
    }

    function updatelistmodule($tbl,$data,$wherein){
        $this->db->where_in('id',$wherein);
        $this->db->update($tbl,$data);
        return true;
    }


    function profilelistbyid($id, $company_code, $branch_code)
    {
        $result = array();

        $this->db->select('c.name,c.phone,c.code,c.street,c.pincode,c.email_id,cp.id as customer_profile_list_id,c.id as party_id')->from('tb_customer_profile_list cp');
        $this->db->join('tb_customers c','c.id = cp.party_id','LEFT');
        $this->db->join('tb_customer_profile p','p.id=cp.cp_id','LEFT');
        $this->db->where('cp.cp_id',$id);
        if($company_code == 'RUKN') {
            $this->db->where('p.company_code',$company_code);
        } else {
            $this->db->where('p.company_code',$company_code);
            $this->db->where('p.branch_code',$branch_code);
        }
        $this->db->where('cp.status',1);
        $this->db->group_by('cp.id');
        $this->db->order_by('cp.id','DESC');
        $query = $this->db->get();
        if($query->num_rows() > 0) {
            $result = $query->result_array();
        }
        return $result;
    }

    public function getCustomerPopupList(int $userId): array
    {
        $query = $this->db->query("SELECT id,name,phone,email_id,code,street,pincode FROM tb_customers WHERE user_id = ? AND status = ? ORDER BY id DESC ", [$userId, '1']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function fetchCustomerOrdersByStatus(string $selectMainColumns, string $whereCondition, array $bindParams, int $limit, int $offset, string $orderBy = ''): array {
        $limitOffset = "";
        if ($limit > 0) {
            $limitOffset = "LIMIT {$limit} ";
            if ($offset > 0) {
                $limitOffset = "LIMIT {$limit} OFFSET {$offset} ";
            }
        }
        $getResults = $this->db->query("SELECT {$selectMainColumns} FROM tb_orders o LEFT JOIN tb_customers c ON o.customer_id = c.id WHERE {$whereCondition} GROUP BY o.order_id DESC {$orderBy} {$limitOffset}", $bindParams);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }

    public function getTripInfo(int $tripId): array {
        $getResult = $this->db->query("SELECT id, vehicle_id, start_imei FROM tb_trips WHERE id = ? ORDER BY id DESC LIMIT 1",[$tripId]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getTruckInfo(int $vehicleId): array {
        $getResult = $this->db->query("SELECT latitude,longitude FROM tb_trucks_data WHERE id = ? AND latitude !='' AND longitude !='' LIMIT ?",[$vehicleId, 1]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getPodDocsInfo(string $timeZone, int $shiftId): array {
        $getResult = $this->db->query("SELECT id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon, ?) as createdon FROM tb_pod_uploads WHERE shipment_id = ? AND doc_type = ? AND `status` = ? LIMIT ? ",[$timeZone, $shiftId, 3, 1, 1]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getStopStatusInfo(string $timeZone, int $shiftId): array {
        $getResults = $this->db->query("SELECT ts.id,COALESCE(ts.latitude,'') AS latitude,COALESCE(ts.longitude,'') AS longitude,COALESCE(ts.loc_name,'') AS loc_name,ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,?) as createdon,sm.status_name,COALESCE(ss.startdate,'') AS startdate,COALESCE(ss.enddate, '') AS enddate
                FROM tb_stop_status ts
                LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
                LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
                WHERE ts.shipment_id = ? AND ts.order_id > ?
                GROUP BY ts.id ORDER BY ts.createdon ASC",[$timeZone, $shiftId, 0]);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }

    public function getPODUploadedDocuments(int $orderId, string $timeZone = 'Asia/Singapore', $source = 'D' ): array {
        $getResult = $this->db->query("SELECT id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,?) as createdon
            FROM tb_pod_uploads
            WHERE stop_type = ? AND doc_type = ? AND order_id = ? AND status = ? ORDER BY id DESC LIMIT ?
            ", [$timeZone, $source, 3, $orderId, 1, 1]);
        return (int) $getResult->num_rows() === 1 ? $getResult->row_array() : [];
    }
    public function getCustIdsAndParentId(int $customerRowId)
    {
        $query = $this->db->query("SELECT id, parent_id FROM tb_customers WHERE id = ? ORDER BY id DESC LIMIT 1", [$customerRowId]);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $custIds = $row->id;
            $parentId = $row->parent_id;
            if ($parentId == 0) {
                $custIdsQuery = $this->db->query("SELECT GROUP_CONCAT(id) AS ids FROM tb_customers WHERE parent_id = ?", [$custIds]);
                if ($custIdsQuery->num_rows() > 0) {
                    $row = $custIdsQuery->row();
                    if($row->ids != null) {
                        $custIds = $row->ids . "," . $custIds;
                    }
                }
            }
            return $custIds ;
        }
    }
}
