<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;
use SVKAPI\v1\Model\OrderParty;
use App\Models\Traits\CacheTrait;

class Customers_model extends Table {

    use CacheTrait;

    const TABLE = "tb_customers";

    const ID_COL = "id";
    const NAME_COL = "name";
    const PHONE_COL = "phone";
    const LOCATION_COL = "location";
    const ADDRESS_COL = "address";
    const PINCODE_COL = "pincode";
    const CODE_COL = "code";
    const COUNTRY_COL = "country";
    const STATE_COL = "state";
    const STREET_COL = "street";
    const FAX_COL = "fax";
    const IMG_COL = "img";
    const EMAIL_ID_COL = "email_id";
    const PASSWORD_COL = "password";
    const USER_ID_COL = "user_id";
    const PARTNER_ID_COL = "partner_id";
    const STATUS_COL = "status";
    const GCM_ID_COL = "gcm_id";
    const CREATEDON_COL = "createdon";
    const UPDATEDON_COL = "updatedon";
    const LAT_COL = "lat";
    const LNG_COL = "lng";
    const IMEI_COL = "imei";
    const CID_COL = "cid";
    const PARENT_ID_COL = "parent_id";
    const COMPANY_CODE_COL = "company_code";
    const BRANCH_CODE_COL = "branch_code";
    const INVOLVED_PARTY_COL = "involved_party";
    const KN_LOGIN_COL = "kn_login";
    const ONLINE_COL = "online";
    const TARIFFTYPE_COL = "Tarifftype";
    const SENDTO_KNLOGIN_COL = "sendto_knlogin";
    const PARTYID_COL = "partyid";
    const QUOTE_MODULE_ID_COL = "quote_module_id";


    /**
     * Searching customer by provided API Order Party and additional params
     *
     *
     * @param OrderParty $party
     * @param int $userId
     * @param array $codes [ex. company_code, branch_code, department_code]
     * @return array|null
     */
    public function find_by_party(OrderParty $party, int $userId, array $codes) : ?array
    {
        $conditions = [
            'tb_customers.name' => $party->get_party_name(),
            'tb_customers.code' => $party->get_party_id(),
            'tb_customers.user_id' => $userId,
            'tbl_party_types.name' => 'Customer',
        ];
        isset($codes['company_code']) && $conditions['tb_customers.company_code'] = $codes['company_code'];
        isset($codes['branch_code']) && $conditions['tb_customers.branch_code'] = $codes['branch_code'];
        isset($codes['department_code']) && $conditions['tbl_party_master.department_code'] = $codes['department_code'];

        $cache = $this->_getCache($conditions);
        if (!empty($cache)) {
            return $cache;
        }

        $result = $this->base_query($conditions)
            ->select([
                'tb_customers.id',
                'tb_customers.name',
                'tb_customers.code',
                'tbl_party_master.id AS party_id',
                'tbl_party_master.party_type_id',
            ])
            ->join('tbl_party_master', 'tb_customers.partner_id = tbl_party_master.id', 'INNER')
            ->join('tbl_party_types', 'tbl_party_master.party_type_id = tbl_party_types.id', 'INNER')
            ->limit(1)
            ->get();
        $row = $result->row_array();
        $this->_setCache($conditions, $row);

        return $row;
    }

    public function checkMapReferenceForCustomer(int $customerRowId): array
    {
        $this->db->select("r.value");
        $this->db->from("tb_party_reference r");
        $this->db->join("tbl_party_master m", "r.partner_id = m.id", "LEFT");
        $this->db->join("tbl_party_types t", "t.id = m.party_type_id", "INNER");
        $this->db->join("tb_customers c", "c.code = m.code", "INNER");
        $this->db->where(" c.id = '" . $customerRowId . "' AND c.company_code = m.company_code AND t.name = 'Customer' AND r.name  = 'Show Map' AND m.status = 1 AND r.status = 1");
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getSpecificPermissionsByUser(int $customerRowId, string $keyValue): array
    {
        if ($this->session->userdata("business_type") === "Customer" && NULL !== $this->session->userdata("sub_cust") && !empty($this->session->userdata("sub_cust")))
        {
            $customerRowId = $this->session->userdata("cust_id");
        }
        $query = $this->db->query("
            SELECT r.value FROM tb_party_reference r
            LEFT JOIN tbl_party_master m ON (r.partner_id = m.id)
            INNER JOIN tbl_party_types t ON (t.id = m.party_type_id)
            INNER JOIN tb_customers c ON (c.code = m.code AND c.company_code = m.company_code)
            WHERE c.id = ? AND t.name = ? AND r.name  = ? AND m.status = ? AND r.status = ? AND LOWER(r.value) IN ?
            ", [$customerRowId, 'Customer', $keyValue, 1, 1, ['n','no']]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
}