<?php

class DeliveryDocumentModel extends CI_Model
{
    public function getOrderPartyData(array $partyTypes, int $orderRowId = 0, array $orderIds = []): array
    {
        if ($orderRowId == 0 && empty($orderIds)) {
            return [];
        }
        $this->db->select("pt.name as party_type,p.name,o.order_id");
        $this->db->from("tbl_party_master p");
        $this->db->join("tb_order_parties o", "p.id=o.party_id", "INNER");
        $this->db->join("tbl_party_types pt", "pt.id=o.party_type", "INNER");
        $this->db->where_in("pt.name", $partyTypes);
        if (!empty($orderIds)) {
            $this->db->where_in("o.order_id", $orderIds);
        } else {
            $this->db->where("o.order_id", $orderRowId);
        }
        $this->db->where("p.status", 1);
        $this->db->where("o.status", 1);
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            if (!empty($orderIds)) {
                foreach ($getResult->result_array() as $orderPartyData) {
                    $data[$orderPartyData['order_id']][strtolower($orderPartyData['party_type'])] = $orderPartyData['name'];
                }
            } else {
                foreach ($getResult->result_array() as $orderPartyData) {
                    $data[strtolower($orderPartyData['party_type'])] = $orderPartyData['name'];
                }
            }
        }
        return $data ?? [];
    }

    public function getVehicleData(int $orderRowId = 0, array $orderIds = []): array
    {
        if ($orderRowId == 0 && empty($orderIds)) {
            return [];
        }
        $this->db->select("td.register_number,tt.trucktype,o.id");
        $this->db->from("tb_trucks_data td");
        $this->db->join("tb_trips t", "t.vehicle_id=td.id", "INNER");
        $this->db->join("tb_orders o", "o.trip_id=t.id", "INNER");
        $this->db->join("tb_trucktypes tt", "tt.id=td.truck_type", "INNER");
        if (!empty($orderIds)) {
            $this->db->where_in("o.id", $orderIds);
        } else {
            $this->db->where("o.id", $orderRowId);
        }
        $this->db->where("td.status", 1);
        if (!empty($orderIds)) {
            $getResult = $this->db->get();
            foreach ($getResult->result_array() as $eachRow) {
                $results[$eachRow['id']] = $eachRow;
            }
            return $results ?? [];
        } else {
            $this->db->limit(1);
            $getResult = $this->db->get();
            return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
        }
    }

    public function getCargoDetails(int $orderRowId = 0, array $orderIds = []): array
    {
        if ($orderRowId == 0 && empty($orderIds)) {
            return [];
        }
        $this->db->select('cd.weight,cd.weight_unit,cd.volume,cd.volume_unit ,cd.quantity,cd.goods_description,ocd.order_id');
        $this->db->from("tb_cargo_details cd");
        $this->db->join('tb_order_cargodetails ocd', 'cd.id= ocd.cargo_id', 'LEFT');
        if (!empty($orderIds)) {
            $this->db->where_in('ocd.order_id', $orderIds);
        } else {
            $this->db->where('ocd.order_id', $orderRowId);
        }
        $this->db->where('ocd.status', 1);
        $getResult = $this->db->get();

        if (!empty($orderIds)) {
            foreach ($getResult->result_array() as $eachRow) {
                $results[$eachRow['order_id']][] = $eachRow;
            }
            return $results ?? [];
        } else {
            return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
        }
    }

    public function getOrderData(int $orderRowId): array
    {
        $this->db->select(
            "o.id,o.order_id,o.pickup_datetime,o.pickup_endtime, o.delivery_datetime,o.drop_endtime, o.pickup_company,o.delivery_company, o.pickup_country,  o.delivery_country, o.pickup_city,o.delivery_city,o.pickup_pincode,o.delivery_pincode,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.transport_mode,o.company_code,o.branch_code,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,group_concat(r.reference_id,' - ',r.ref_value) as order_references,CONCAT(s.service_id, '-', s.name) as service"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "o.id=r.order_id ", "LEFT");
        $this->db->join("tb_order_details od", "o.id=od.order_row_id", "LEFT");
        $this->db->join("tb_service_master s", "od.service=s.id", "LEFT");
        $this->db->where("o.id", $orderRowId);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getOrderTransportMode(string $transportModeCode): string
    {
        $this->db->select("CONCAT(code, '-', name) as transport_mode");
        $this->db->from("tb_transportmode");
        $this->db->where("code", $transportModeCode);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row()->transport_mode : '';
    }

    public function getMilestoneStatuses(int $shiftId, string $timeZone): array
    {
        $this->db->select("ts.latitude,ts.longitude,ts.loc_name,ts.status_code,convertToClientTZ(ts.createdon,'{$timeZone}') as createdon,sm.status_name");
        $this->db->from("tb_stop_status ts");
        $this->db->join("tb_status_master sm", "sm.id=ts.status_id", "LEFT");
        $this->db->where("ts.shipment_id", $shiftId);
        $this->db->where("ts.status", 1);
        $this->db->group_by("ts.status_code");
        $this->db->order_by("ts.id ASC");
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getManifestId(int $orderId): string
    {
        $this->db->select("ref_value");
        $this->db->from("tb_order_references");
        $this->db->where("order_id", $orderId);
        $this->db->where("reference_id", "MN");
        $this->db->where("status", 1);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->row()->ref_value : '';
    }

    public function getCustomStatuses(string $carrierName, string $level, string $companyCode): array
    {
        $this->db->select("status_code,status_name");
        $this->db->from("external_edi_status_master");
        $this->db->where("edi_name", $carrierName);
        $this->db->where("impact_level", $level);
        $this->db->where("company_code", $companyCode);
        $this->db->where("status", 1);
        $this->db->order_by("id ASC");
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getStopStatusOrderIds(): array
    {
        $orderIds = [];
        $query = $this->db->query(
            "SELECT
              DISTINCT(order_id)
            FROM
              `tb_stop_status`
            WHERE
              order_id > ?
              AND status_code = ?
              AND updatedon > DATE_SUB(NOW(), INTERVAL 1 HOUR)
              AND status = ?
            ",
            [0, '2300', 1]
        );
        foreach ($query->result_array() as $eachRow) {
            $orderIds[] = $eachRow['order_id'];
        }
        return $orderIds;
    }

    public function getOrdersDataWithIds(array $orderIds = []): array
    {
        if (empty($orderIds)) {
            return [];
        }
        $sql = "SELECT
              `o`.`id`,
              `o`.`order_id`,
              `o`.`pickup_datetime`,
              `o`.`pickup_endtime`,
              `o`.`delivery_datetime`,
              `o`.`drop_endtime`,
              `o`.`pickup_company`,
              `o`.`delivery_company`,
              `o`.`pickup_country`,
              `o`.`delivery_country`,
              `o`.`pickup_city`,
              `o`.`delivery_city`,
              `o`.`pickup_pincode`,
              `o`.`delivery_pincode`,
              `o`.`pickup_address1`,
              `o`.`delivery_address1`,
              `o`.`pickup_address2`,
              `o`.`delivery_address2`,
              `o`.`transport_mode`,
              `o`.`company_code`,
              `o`.`branch_code`,
              `o`.`trip_sts`,
              `o`.`shift_id`,
              `o`.`trip_id`,
              `o`.`shipmentid`,
              CONCAT(s.service_id, '-', s.name) as service,
              (SELECT GROUP_CONCAT(
                r.reference_id, ' - ', r.ref_value
              ) FROM tb_order_references r
                        WHERE r.order_id = o.id) AS order_references,
              `c`.`cntry_timezone`,
            bm.email_id as branch_email_id,
            cu.email_id as customer_email_id
            FROM
              `tb_orders` `o`
              LEFT JOIN `tb_order_details` `od` ON `o`.`id` = `od`.`order_row_id`
              LEFT JOIN `tb_service_master` `s` ON `od`.`service` = `s`.`id`
              LEFT JOIN `tb_users` `u` ON `o`.`user_id` = `u`.`id`
              LEFT JOIN `tbl_country_master` `c` ON `u`.`country_code` = `c`.`country_code`
              LEFT JOIN `tb_branch_master` `bm` ON `o`.`branch_code` = `bm`.`branch_code`
              LEFT JOIN `tb_customers` `cu` ON `o`.`customer_id` = `cu`.`id`
            WHERE
              `o`.`id` IN ? AND o.status != ? AND o.company_code != ? ";
        $query = $this->db->query($sql, [$orderIds, 0, 'INKN']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getMilestoneStatusesByShiftIds(array $shiftIds): array
    {
        if (empty($shiftIds)) {
            return [];
        }
        $this->db->select("ts.order_id,ts.latitude,ts.longitude,ts.loc_name,ts.status_code,convertToClientTZ(ts.createdon, c.cntry_timezone) as createdon,sm.status_name");
        $this->db->from("tb_stop_status ts");
        $this->db->join("tb_status_master sm", "sm.id=ts.status_id", "LEFT");
        $this->db->join("tb_orders o", "ts.order_id=o.id", "LEFT");
        $this->db->join("tb_users u", "o.user_id=u.id", "LEFT");
        $this->db->join("tbl_country_master c", "u.country_code=c.country_code", "LEFT");
        $this->db->where_in("ts.shipment_id", $shiftIds);
        $this->db->where("ts.status", 1);
        $this->db->where("sm.customer_view", 1);
        $this->db->group_by("ts.status_code,ts.order_id");
        $this->db->order_by("ts.order_id,ts.id ASC");
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $milestoneStatuses) {
                $data[$milestoneStatuses['order_id']][] = $milestoneStatuses;
            }
        }
        return $data ?? [];
    }

    public function getPodUploadsWithDetailsByOrderIds(array $orderIds): array
    {
        $query = $this->db->query(
            "SELECT
                pu.id,
                pu.latitude, pu.longitude, pu.stop_id, pu.stop_type,pu.receiver_name,
                pu.createdby, pu.createdon, pu.imgpath, pu.hash,pu.order_id as order_row_id,
                dt.type_name,
                e.address, e.pickup, e.drop, e.order_id
            FROM tb_pod_uploads pu
                LEFT JOIN tb_document_types dt ON dt.id=pu.doc_type
                LEFT JOIN tb_employee e ON e.id = pu.stop_detail_id
            WHERE pu.order_id IN ? AND pu.status=1
            ORDER BY pu.createdon",
            [$orderIds]
        );
        foreach ($query->result() as $row) {
            $results[$row->order_row_id][] = $row;
        }
        return $results ?? [];
    }

    public function getOrderTransportModeByCodes(array $transportModeCodes): array
    {
        $this->db->select("CONCAT(code, '-', name) as transport_mode,code");
        $this->db->from("tb_transportmode");
        $this->db->where_in("code", $transportModeCodes);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $row) {
            $results[$row['code']] = $row['transport_mode'];
        }
        return $results ?? [];
    }

    public function getManifestIdByOrderIds(array $orderIds): array
    {
        $this->db->select("ref_value,order_id");
        $this->db->from("tb_order_references");
        $this->db->where_in("order_id", $orderIds);
        $this->db->where("reference_id", "MN");
        $this->db->where("status", 1);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $row) {
            $results[$row['order_id']] = $row['ref_value'];
        }
        return $results ?? [];
    }

    public function checkShowCarrierCondition(array $orderIds): array
    {
        $this->db->select("o.order_id,pr.value");
        $this->db->from("tbl_party_master p");
        $this->db->join("tb_order_parties o", "p.id=o.party_id", "INNER");
        $this->db->join("tbl_party_types pt", "pt.id=o.party_type", "INNER");
        $this->db->join("tb_party_reference pr", "pr.partner_id = p.id", "INNER");
        $this->db->join("tb_reference_types rt", "rt.id = pr.reference_type", "INNER");
        $this->db->where("pt.name", "Customer");
        $this->db->where_in("o.order_id", $orderIds);
        $this->db->where("p.status", 1);
        $this->db->where("o.status", 1);
        $this->db->where("pr.status", 1);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $orderPartyData) {
            $data[$orderPartyData['order_id']] = $orderPartyData['value'];
        }
        return $data ?? [];
    }

    public function getQueuedRecordsForEmail(): array
    {
        $this->db->select("order_id,file_name,email_ids,is_email_body,email_body");
        $this->db->from("delivery_documents_email_queue");
        $this->db->where("is_sent", 0);
        $this->db->order_by("id ASC");
        $this->db->limit(100);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getReferencesByBookingIds(array $bookingIds): array
    {
        $this->db->select("o.order_id,o.company_code,o.branch_code,GROUP_CONCAT( r.reference_id, ' - ', r.ref_value separator ' ' ) as reference");
        $this->db->from("tb_order_references  r");
        $this->db->join("tb_orders o", "r.order_id=o.id", "INNER");
        $this->db->where_in("r.reference_id", ['DQ', 'PO']);
        $this->db->where_in("o.order_id", $bookingIds);
        $this->db->where("r.status", 1);
        $this->db->group_by("o.order_id");
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $eachOrderReferences) {
            $data[$eachOrderReferences['order_id']]['reference'] = $eachOrderReferences['reference'];
            $data[$eachOrderReferences['order_id']]['companyCode'] = $eachOrderReferences['company_code'];
            $data[$eachOrderReferences['order_id']]['branchCode'] = $eachOrderReferences['branch_code'];
        }
        return $data ?? [];
    }

    public function getOrderCustomerName(int $orderRowId, string $bookingId): array
    {
        if ($orderRowId > 0) {
            $query = $this->db->query("SELECT c.name,o.order_id FROM tb_customers c,tb_orders o WHERE o.customer_id = c.id AND o.id = ?", [$orderRowId]);
            $result = $query->num_rows() > 0 ? $query->row_array() : [];
            if (!empty($result)) {
                $data[$result['order_id']]['customerName'] = $result['name'];
            }
            return $data ?? [];
        }
        if ($bookingId !== "") {
            $query = $this->db->query("SELECT c.name,o.id FROM tb_customers c,tb_orders o WHERE o.customer_id = c.id AND o.order_id = ?", [$bookingId]);
            $orderRowId = $query->num_rows() > 0 ? $query->row()->id : 0;
            $customerName = $query->num_rows() > 0 ? $query->row()->name : "";
            if ($orderRowId > 0) {
                $referenceQuery = $this->db->query("SELECT  r.ref_value FROM tb_order_references r WHERE r.order_id = ? AND r.reference_id = ? AND r.status = ?", [$orderRowId, 'DQ', 1]);
                $queryResult = $referenceQuery->num_rows() > 0 ? $referenceQuery->result_array() : [];
                $reference = "";
                $i = 1;
                foreach ($queryResult as $eachRow) {
                    if ($i > 1) {
                        $reference .= ", ";
                    }
                    $reference .= "DQ" . $i . ":" . $eachRow['ref_value'];
                    $i++;
                }
            }
        }
        $data[$bookingId]['reference'] = $reference ?? "";
        $data[$bookingId]['customerName'] = $customerName ?? "";
        return $data;
    }

    public function getCustomersForEpodDocuments(): array
    {
        $this->db->select("c.id");
        $this->db->from("tb_party_reference r");
        $this->db->join("tbl_party_master m", "r.partner_id = m.id", "LEFT");
        $this->db->join("tbl_party_types t", "t.id = m.party_type_id", "INNER");
        $this->db->join("tb_customers c", "c.code = m.code", "INNER");
        $this->db->join("tb_branch_master bm", "bm.branch_code = m.branch_code", "LEFT");
        $this->db->where("c.company_code = m.company_code AND t.name = 'Customer' AND r.name  = 'ePOD' AND m.status = 1 AND r.status = 1");
        $this->db->where_in("r.value", ['Y', 'Yes', 'YES', 'yes']);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $row) {
            $customerIds[] = $row["id"];
        }
        return $customerIds ?? [];
    }

    public function getStopStatusOrderIdsByCustomerIds($customerIds): array
    {
        $orderIds = [];
        $query = $this->db->query(
            "SELECT
              DISTINCT(ts.order_id)
            FROM
              tb_stop_status ts
            LEFT JOIN tb_orders o ON ts.order_id = o.id
            WHERE
              ts.order_id > ?
              AND ts.status_code = ?
              AND ts.updatedon > DATE_SUB(NOW(), INTERVAL 1 HOUR)
              AND ts.status = ?
              AND o.customer_id IN ?
              AND o.status != ?
            ",
            [0, '2300', 1, $customerIds, 0]
        );
        foreach ($query->result_array() as $eachRow) {
            $orderIds[] = $eachRow['order_id'];
        }
        return $orderIds;
    }

    public function getOrdersDataWithePODIds(array $orderIds = []): array
    {
        if (empty($orderIds)) {
            return [];
        }
        $sql = "SELECT
              `o`.`id`,
              `o`.`order_id`,
              `o`.`pickup_datetime`,
              `o`.`pickup_endtime`,
              `o`.`delivery_datetime`,
              `o`.`drop_endtime`,
              `o`.`pickup_company`,
              `o`.`delivery_company`,
              `o`.`pickup_country`,
              `o`.`delivery_country`,
              `o`.`pickup_city`,
              `o`.`delivery_city`,
              `o`.`pickup_pincode`,
              `o`.`delivery_pincode`,
              `o`.`pickup_address1`,
              `o`.`delivery_address1`,
              `o`.`pickup_address2`,
              `o`.`delivery_address2`,
              `o`.`transport_mode`,
              `o`.`company_code`,
              `o`.`branch_code`,
              `o`.`trip_sts`,
              `o`.`shift_id`,
              `o`.`trip_id`,
              `o`.`shipmentid`,
              CONCAT(s.service_id, '-', s.name) as service,
              (SELECT GROUP_CONCAT(
                r.reference_id, ' - ', r.ref_value
              ) FROM tb_order_references r
                        WHERE r.order_id = o.id) AS order_references,
              `c`.`cntry_timezone`,
            bm.email_id as branch_email_id,
            cu.email_id as customer_email_id
            FROM
              `tb_orders` `o`
              LEFT JOIN `tb_order_details` `od` ON `o`.`id` = `od`.`order_row_id`
              LEFT JOIN `tb_service_master` `s` ON `od`.`service` = `s`.`id`
              LEFT JOIN `tb_users` `u` ON `o`.`user_id` = `u`.`id`
              LEFT JOIN `tbl_country_master` `c` ON `u`.`country_code` = `c`.`country_code`
              LEFT JOIN `tb_branch_master` `bm` ON `o`.`branch_code` = `bm`.`branch_code`
              LEFT JOIN `tb_customers` `cu` ON `o`.`customer_id` = `cu`.`id`
            WHERE
              `o`.`id` IN ? AND o.status != ? ";
        $query = $this->db->query($sql, [$orderIds, 0]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function selectExistingRecords(array $uniqueBookingIds): array
    {
        $this->db->select("order_id");
        $this->db->from("delivery_documents_email_queue");
        $this->db->where_in("order_id", $uniqueBookingIds);
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $row) {
            $existingRecords[] = $row["order_id"];
        }
        return $existingRecords ?? [];
    }

    public function getCustomerCodeByBookingIds(array $bookingIds): array
    {
        $this->db->select("o.order_id,c.code");
        $this->db->from("tb_customers c");
        $this->db->join("tb_orders o", "o.customer_id=c.id", "INNER");
        $this->db->where_in("o.order_id", $bookingIds);
        $this->db->where("c.status", 1);
        $this->db->group_by("o.order_id");
        $getResult = $this->db->get();
        foreach ($getResult->result_array() as $eachOrderReferences) {
            $data[$eachOrderReferences['order_id']]['customerCode'] = $eachOrderReferences['code'];
        }
        return $data ?? [];
    }
}
